/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.dingtalk.api.message;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.dingtalk.api.core.response.Response;
import com.jeecg.dingtalk.api.core.util.ApiUrls;
import com.jeecg.dingtalk.api.core.util.HttpUtil;
import com.jeecg.dingtalk.api.message.vo.FileMessage;
import com.jeecg.dingtalk.api.message.vo.ImageMessage;
import com.jeecg.dingtalk.api.message.vo.LinkMessage;
import com.jeecg.dingtalk.api.message.vo.MarkdownMessage;
import com.jeecg.dingtalk.api.message.vo.Message;
import com.jeecg.dingtalk.api.message.vo.SuperMessage;
import com.jeecg.dingtalk.api.message.vo.TextMessage;
import com.jeecg.dingtalk.api.message.vo.VoiceMessage;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdtMessageAPI {
    private static final Logger logger = LoggerFactory.getLogger(JdtMessageAPI.class);

    private static <T extends SuperMessage> Response<String> sendMessage(Message<T> message, String accessToken, String logText) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2?access_token=%s", accessToken);
        logger.info("[" + logText + "] params:{}", new Object[]{JSON.toJSONString(message)});
        JSONObject originResponse = HttpUtil.sendPost(url, JSON.toJSONString(message));
        Response<String> response = new Response<String>(originResponse);
        if (response.isSuccess()) {
            String task_id = originResponse.getString("task_id");
            response.setResult(task_id);
        }
        logger.info("[" + logText + "] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<String> sendTextMessage(Message<TextMessage> message, String accessToken) {
        return JdtMessageAPI.sendMessage(message, accessToken, "MSG_SEND_TEXT_MESSAGE");
    }

    public static Response<String> sendImageMessage(Message<ImageMessage> message, String accessToken) {
        return JdtMessageAPI.sendMessage(message, accessToken, "MSG_SEND_IMAGE_MESSAGE");
    }

    public static Response<String> sendVoiceMessage(Message<VoiceMessage> message, String accessToken) {
        return JdtMessageAPI.sendMessage(message, accessToken, "MSG_SEND_VOICE_MESSAGE");
    }

    public static Response<String> sendFileMessage(Message<FileMessage> message, String accessToken) {
        return JdtMessageAPI.sendMessage(message, accessToken, "MSG_SEND_FILE_MESSAGE");
    }

    public static Response<String> sendLinkMessage(Message<LinkMessage> message, String accessToken) {
        return JdtMessageAPI.sendMessage(message, accessToken, "MSG_SEND_LINK_MESSAGE");
    }

    public static Response<String> sendMarkdownMessage(Message<MarkdownMessage> message, String accessToken) {
        return JdtMessageAPI.sendMessage(message, accessToken, "MSG_SEND_MARKDOWN_MESSAGE");
    }

    public static Response<JSONObject> recallMessage(int agent_id, String msg_task_id, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/message/corpconversation/recall?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("agent_id", (Object)agent_id);
        body.put("msg_task_id", (Object)msg_task_id);
        Response<JSONObject> response = HttpUtil.post(url, body.toJSONString(), new Type[0]);
        logger.info("[MSG_RECALL_MESSAGE] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }
}

