/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.dingtalk.api.department;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.dingtalk.api.core.response.Response;
import com.jeecg.dingtalk.api.core.util.ApiUrls;
import com.jeecg.dingtalk.api.core.util.HttpUtil;
import com.jeecg.dingtalk.api.core.util.JdtTypes;
import com.jeecg.dingtalk.api.department.vo.Department;
import com.jeecg.dingtalk.api.department.vo.DeptParentResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdtDepartmentAPI {
    private static final Logger logger = LoggerFactory.getLogger(JdtDepartmentAPI.class);

    public static Response<Integer> create(Department department, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/department/create?access_token=%s", accessToken);
        Response originResponse = HttpUtil.post(url, JSON.toJSONString((Object)department), new Type[0]);
        Response<Integer> response = new Response<Integer>(originResponse);
        if (response.isSuccess()) {
            Integer dept_id = ((JSONObject)originResponse.getResult()).getInteger("dept_id");
            response.setResult(dept_id);
        }
        logger.info("[DEPART_CREATE] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<JSONObject> update(Department department, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/department/update?access_token=%s", accessToken);
        Response<JSONObject> response = HttpUtil.post(url, JSON.toJSONString((Object)department), new Type[0]);
        logger.info("[DEPART_UPDATE] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<JSONObject> delete(int dept_id, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/department/delete?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("dept_id", (Object)dept_id);
        Response<JSONObject> response = HttpUtil.post(url, body.toJSONString(), new Type[0]);
        logger.info("[DEPART_DELETE] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static List<Response<JSONObject>> batchDeletePseudo(Collection<Integer> deptIds, String accessToken) {
        ArrayList<Response<JSONObject>> list = new ArrayList<Response<JSONObject>>();
        for (Integer deptId : deptIds) {
            list.add(JdtDepartmentAPI.delete(deptId, accessToken));
        }
        return list;
    }

    public static Response<List<Department>> listByRoot(String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/department/listsub?access_token=%s", accessToken);
        Response<List<Department>> response = HttpUtil.post(url, "", JdtTypes.List_Department);
        logger.info("[DEPART_LIST_ROOT_SUB] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<List<Department>> listByParentId(int dept_id, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/department/listsub?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("dept_id", (Object)dept_id);
        Response<List<Department>> response = HttpUtil.post(url, body.toJSONString(), JdtTypes.List_Department);
        logger.info("[DEPART_LIST_SUB_BY_PARENT_ID] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<Department> getUserById(String dept_id, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/department/get?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("dept_id", (Object)dept_id);
        Response<Department> response = HttpUtil.post(url, body.toJSONString(), new Type[]{Department.class});
        logger.info("[DEPART_GET_BY_ID] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<List<Integer>> getListSubId(int dept_id, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/department/listsubid?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("dept_id", (Object)dept_id);
        Response originResponse = HttpUtil.post(url, body.toJSONString(), new Type[0]);
        Response<List<Integer>> response = new Response<List<Integer>>(originResponse);
        if (response.isSuccess()) {
            List dept_id_list = ((JSONObject)originResponse.getResult()).getJSONArray("dept_id_list").toJavaList(Integer.class);
            response.setResult(dept_id_list);
        }
        logger.info("[DEPART_GET_LIST_SUB_ID] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<List<DeptParentResponse>> getListParentByUser(String userid, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/department/listparentbyuser?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("userid", (Object)userid);
        Response originResponse = HttpUtil.post(url, body.toJSONString(), new Type[0]);
        Response<List<DeptParentResponse>> response = new Response<List<DeptParentResponse>>(originResponse);
        if (response.isSuccess()) {
            List parent_list = ((JSONObject)originResponse.getResult()).getJSONArray("parent_list").toJavaList(DeptParentResponse.class);
            response.setResult(parent_list);
        }
        logger.info("[DEPART_GET_LIST_PARENT_BY_USER] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<List<Integer>> getListParentByDept(String dept_id, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/department/listparentbydept?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("dept_id", (Object)dept_id);
        Response originResponse = HttpUtil.post(url, body.toJSONString(), new Type[0]);
        Response<List<Integer>> response = new Response<List<Integer>>(originResponse);
        if (response.isSuccess()) {
            List parent_id_list = ((JSONObject)originResponse.getResult()).getJSONArray("parent_id_list").toJavaList(Integer.class);
            response.setResult(parent_id_list);
        }
        logger.info("[DEPART_GET_LIST_PARENT_BY_DEPT] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static List<Department> listAll(String accessToken) {
        ArrayList<Department> all = new ArrayList<Department>();
        JdtDepartmentAPI.listAllGetChildren(1, accessToken, all);
        return all;
    }

    private static void listAllGetChildren(int parentDepId, String accessToken, List<Department> all) {
        List<Department> departments;
        Response<List<Department>> response = JdtDepartmentAPI.listByParentId(parentDepId, accessToken);
        if (response.isSuccess() && (departments = response.getResult()).size() != 0) {
            all.addAll(departments);
            for (Department department : departments) {
                JdtDepartmentAPI.listAllGetChildren(department.getDept_id(), accessToken, all);
            }
        }
    }
}

