/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.sqlparser.AbstractSqlProcessor;
import org.jeecgframework.minidao.sqlparser.impl.util.v49.JSqlCountSqlParser49;
import org.jeecgframework.minidao.sqlparser.impl.util.v49.JSqlParserSelectInfoUtil49;
import org.jeecgframework.minidao.sqlparser.impl.util.v49.JSqlRemoveSqlOrderBy49;
import org.jeecgframework.minidao.sqlparser.impl.util.v49.JSqlServerPagesHelper49;
import org.jeecgframework.minidao.sqlparser.impl.vo.SelectSqlInfo;

public class JsqlparserSqlProcessor49
implements AbstractSqlProcessor {
    protected static JSqlCountSqlParser49 jsqlCountSqlParser = new JSqlCountSqlParser49();
    protected static JSqlServerPagesHelper49 jsqlServerPagesHelper = new JSqlServerPagesHelper49();
    protected static JSqlRemoveSqlOrderBy49 jsqlRemoveSqlOrderBy = new JSqlRemoveSqlOrderBy49();

    @Override
    public String getSqlServerPageSql(String sql, MiniDaoPage miniDaoPage) {
        int page = miniDaoPage.getPage();
        int rows = miniDaoPage.getRows();
        int beginNum = (page - 1) * rows;
        String pageSql = jsqlServerPagesHelper.convertToPageSql(sql);
        pageSql = pageSql.replace(String.valueOf(Long.MIN_VALUE), String.valueOf(beginNum));
        pageSql = pageSql.replace(String.valueOf(Long.MAX_VALUE), String.valueOf(rows));
        return pageSql;
    }

    @Override
    public String getCountSql(String sql) {
        return jsqlCountSqlParser.getSmartCountSql(sql);
    }

    @Override
    public String removeOrderBy(String sql) {
        if (sql == null) {
            return null;
        }
        try {
            sql = jsqlRemoveSqlOrderBy.removeOrderBy(sql);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        return sql;
    }

    @Override
    public List<Map<String, Object>> parseSqlFields(String parsedSql) {
        ParenthesedSelect parenthesedSelect;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            parenthesedSelect = (ParenthesedSelect)CCJSqlParserUtil.parse((String)parsedSql, parser -> parser.withSquareBracketQuotation(true));
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        SetOperationList setOperationList = parenthesedSelect.getSetOperationList();
        List selects = setOperationList.getSelects();
        for (Select value : selects) {
            PlainSelect select = (PlainSelect)value;
            List<String> tableAndColumns = JsqlparserSqlProcessor49.getTableAndColumns(select);
            JsqlparserSqlProcessor49.getMapFiled(list, tableAndColumns);
            FromItem fromItem = select.getFromItem();
            while (fromItem instanceof ParenthesedSelect) {
                PlainSelect subSelect = ((ParenthesedSelect)fromItem).getPlainSelect();
                List<String> tableAndColumnsSub = JsqlparserSqlProcessor49.getTableAndColumns(subSelect);
                JsqlparserSqlProcessor49.getMapFiled(list, tableAndColumnsSub);
                fromItem = subSelect.getFromItem();
            }
        }
        return list;
    }

    @Override
    public String addOrderBy(String sql, String field, boolean isAsc) {
        Statement statement = null;
        try {
            statement = CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        if (statement instanceof Select) {
            Select selectBody = (Select)statement;
            List orderByElements = selectBody.getOrderByElements();
            OrderByElement orderByElement = new OrderByElement();
            orderByElement.setExpression((Expression)new Column(field));
            orderByElement.setAsc(isAsc);
            if (orderByElements != null && !orderByElements.isEmpty()) {
                long existsCount = orderByElements.stream().filter(orderByEl -> {
                    Expression expression = orderByEl.getExpression();
                    if (expression instanceof Column) {
                        Column column = (Column)expression;
                        return column.getColumnName().equalsIgnoreCase(field);
                    }
                    return false;
                }).count();
                if (existsCount == 0L) {
                    orderByElements.add(orderByElement);
                }
            } else {
                selectBody.setOrderByElements(Collections.singletonList(orderByElement));
            }
            sql = selectBody.toString();
        }
        return sql;
    }

    private static void getMapFiled(List<Map<String, Object>> list, List<String> tableAndColumns) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        for (String str : tableAndColumns) {
            if ("*".equals(str)) continue;
            map.put(str, str);
        }
        list.add(map);
    }

    private static List<String> getTableAndColumns(PlainSelect plain) {
        List selectItems = plain.getSelectItems();
        ArrayList<String> items = new ArrayList<String>();
        if (selectItems != null) {
            for (SelectItem selectItem : selectItems) {
                Expression expression = selectItem.getExpression();
                if (expression instanceof AllTableColumns) {
                    AllTableColumns allTableColumns = (AllTableColumns)expression;
                    items.add(allTableColumns.toString());
                    continue;
                }
                String columnName = "";
                Alias alias = selectItem.getAlias();
                if (expression instanceof CaseExpression) {
                    columnName = alias.getName();
                } else if (expression instanceof LongValue || expression instanceof StringValue || expression instanceof DateValue || expression instanceof DoubleValue) {
                    columnName = Objects.nonNull(alias.getName()) ? alias.getName() : expression.getASTNode().jjtGetValue().toString();
                } else if (expression instanceof TimeKeyExpression) {
                    columnName = alias.getName();
                } else if (alias != null) {
                    columnName = alias.getName();
                } else {
                    SimpleNode node = expression.getASTNode();
                    Object value = node.jjtGetValue();
                    if (value instanceof Column) {
                        columnName = ((Column)value).getColumnName();
                    } else if (value instanceof Function) {
                        columnName = value.toString();
                    } else {
                        columnName = String.valueOf(value);
                        columnName = columnName.replace("'", "");
                        columnName = columnName.replace("\"", "");
                        columnName = columnName.replace("`", "");
                    }
                }
                columnName = columnName.replace("'", "");
                columnName = columnName.replace("\"", "");
                columnName = columnName.replace("`", "");
                items.add(columnName);
            }
        }
        return items;
    }

    @Override
    public Map<String, SelectSqlInfo> parseAllSelectTable(String selectSql) throws JSQLParserException {
        return JSqlParserSelectInfoUtil49.parseAllSelectTable(selectSql);
    }

    @Override
    public SelectSqlInfo parseSelectSqlInfo(String selectSql) throws JSQLParserException {
        return JSqlParserSelectInfoUtil49.parseSelectSqlInfo(selectSql);
    }
}

