/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.modules.redis.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.annotation.Resource;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jeecg.common.modules.redis.config.JeecgRedisCacheTtls;
import org.jeecg.common.modules.redis.receiver.RedisReceiver;
import org.jeecg.common.modules.redis.writer.JeecgRedisCacheWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@EnableCaching
@Configuration
public class RedisConfig
extends CachingConfigurerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisConfig.class);
    @Resource
    private LettuceConnectionFactory lettuceConnectionFactory;
    @Resource
    private JeecgRedisCacheTtls redisCacheProperties;
    private static volatile Jackson2JsonRedisSerializer<Object> cachedJacksonSerializer;

    @Bean
    public RedisTemplate<String, Object> redisTemplate(LettuceConnectionFactory lettuceConnectionFactory) {
        long startTime = System.currentTimeMillis();
        Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer = RedisConfig.getJacksonSerializer();
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)lettuceConnectionFactory);
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setValueSerializer(jackson2JsonRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashValueSerializer(jackson2JsonRedisSerializer);
        redisTemplate.afterPropertiesSet();
        long endTime = System.currentTimeMillis();
        log.info(" --- redis config init ---\uff0c\u8017\u65f6: {}ms", (Object)(endTime - startTime));
        return redisTemplate;
    }

    @Bean
    public CacheManager cacheManager(LettuceConnectionFactory factory) {
        Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer = RedisConfig.getJacksonSerializer();
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofHours(6L));
        RedisCacheConfiguration redisCacheConfiguration = config.serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(jackson2JsonRedisSerializer));
        JeecgRedisCacheWriter writer = new JeecgRedisCacheWriter((RedisConnectionFactory)factory, Duration.ofMillis(50L));
        HashMap<String, RedisCacheConfiguration> initialCaches = new HashMap<String, RedisCacheConfiguration>();
        initialCaches.put("sys:cache:dictTable", RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(10L)).disableCachingNullValues().serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(jackson2JsonRedisSerializer)));
        initialCaches.put("test:demo", RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(5L)).disableCachingNullValues());
        initialCaches.put("pluginMall::rankingList", RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofHours(24L)).disableCachingNullValues());
        initialCaches.put("pluginMall::queryPageList", RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofHours(24L)).disableCachingNullValues());
        initialCaches.put("flow:runtimeData", RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofDays(365L)).disableCachingNullValues());
        Map<String, Long> cacheTtls = this.redisCacheProperties.getCacheTtls();
        if (cacheTtls != null && !cacheTtls.isEmpty()) {
            cacheTtls.forEach((cacheName, ttl) -> {
                log.debug("\u81ea\u5b9a\u4e49\u7f13\u5b58\u914d\u7f6e\uff0ccacheKey:{}, \u7f13\u5b58\u79d2\u6570:{}", cacheName, ttl);
                initialCaches.put((String)cacheName, RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(ttl)).disableCachingNullValues().serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer)));
            });
        }
        RedisConfigCacheManager cacheManager = new RedisConfigCacheManager(writer, redisCacheConfiguration, initialCaches);
        cacheManager.setTransactionAware(true);
        return cacheManager;
    }

    @Bean
    public RedisMessageListenerContainer redisContainer(RedisConnectionFactory redisConnectionFactory, RedisReceiver redisReceiver, MessageListenerAdapter commonListenerAdapter) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((MessageListener)commonListenerAdapter, (Topic)new ChannelTopic("jeecg_redis_topic"));
        return container;
    }

    @Bean
    MessageListenerAdapter commonListenerAdapter(RedisReceiver redisReceiver) {
        MessageListenerAdapter messageListenerAdapter = new MessageListenerAdapter((Object)redisReceiver, "onMessage");
        messageListenerAdapter.setSerializer(RedisConfig.jacksonSerializer());
        return messageListenerAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Jackson2JsonRedisSerializer<Object> getJacksonSerializer() {
        if (cachedJacksonSerializer != null) return cachedJacksonSerializer;
        Class<RedisConfig> clazz = RedisConfig.class;
        synchronized (RedisConfig.class) {
            if (cachedJacksonSerializer != null) return cachedJacksonSerializer;
            cachedJacksonSerializer = RedisConfig.jacksonSerializer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cachedJacksonSerializer;
        }
    }

    private static Jackson2JsonRedisSerializer<Object> jacksonSerializer() {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        return jackson2JsonRedisSerializer;
    }

    public static class RedisConfigCacheManager
    extends RedisCacheManager {
        private static final RedisSerializationContext.SerializationPair<Object> DEFAULT_PAIR = RedisSerializationContext.SerializationPair.fromSerializer(RedisConfig.jacksonSerializer());
        private static final CacheKeyPrefix DEFAULT_CACHE_KEY_PREFIX = cacheName -> cacheName + "::";

        public RedisConfigCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCaches) {
            super(cacheWriter, defaultCacheConfiguration, initialCaches, true);
        }

        protected RedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
            int lastIndexOf = name.lastIndexOf(35);
            if (lastIndexOf > -1) {
                String ttl = name.substring(lastIndexOf + 1);
                Duration duration = Duration.ofSeconds(Long.parseLong(ttl));
                cacheConfig = cacheConfig.entryTtl(duration);
                cacheConfig = cacheConfig.computePrefixWith(DEFAULT_CACHE_KEY_PREFIX).serializeValuesWith(DEFAULT_PAIR);
                String cacheName = name.substring(0, lastIndexOf);
                return super.createRedisCache(cacheName, cacheConfig);
            }
            cacheConfig = cacheConfig.computePrefixWith(DEFAULT_CACHE_KEY_PREFIX).serializeValuesWith(DEFAULT_PAIR);
            return super.createRedisCache(name, cacheConfig);
        }
    }
}

