/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.airag.flow.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.LiteFlowMethodEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.rag.query.router.QueryRouter;
import dev.langchain4j.service.TokenStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jeecg.common.util.AssertUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.airag.common.handler.AIChatParams;
import org.jeecg.modules.airag.common.handler.IAIChatHandler;
import org.jeecg.modules.airag.common.vo.LlmPlugin;
import org.jeecg.modules.airag.common.vo.MessageHistory;
import org.jeecg.modules.airag.flow.b.b;
import org.jeecg.modules.airag.flow.context.JeecgFlowContext;
import org.jeecg.modules.airag.flow.vo.flow.config.FlowNode;
import org.jeecg.modules.airag.flow.vo.flow.config.FlowNodeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="llm")
public class e
extends org.jeecg.modules.airag.flow.component.a.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    @Autowired
    IAIChatHandler aiChatHandler;

    @LiteflowMethod(value=LiteFlowMethodEnum.PROCESS, nodeType=NodeTypeEnum.COMMON)
    public void a(NodeComponent component) {
        List historyMessages;
        a.info("\u8282\u70b9\u5f00\u59cb-llm");
        JeecgFlowContext contextBean = e.e(component);
        FlowNodeConfig flowNodeConfig = e.c(component);
        List<FlowNodeConfig.NodeParam> inputParams = flowNodeConfig.getInputParams();
        if (oConvertUtils.isObjectEmpty(flowNodeConfig.getOptions())) {
            throw new org.jeecg.modules.airag.flow.d.a(flowNodeConfig.getNodeId(), flowNodeConfig.getText(), "\u8282\u70b9\u914d\u7f6e\u9519\u8bef");
        }
        JSONObject options = JSONObject.parseObject((String)JSONObject.toJSONString(flowNodeConfig.getOptions()));
        a collatedParams = this.a(component, inputParams);
        String messagesOpStr = options.getString("messages");
        List messages = JSONArray.parseArray((String)messagesOpStr, MessageHistory.class);
        AssertUtils.assertNotEmpty((String)"LLM\u8282\u70b9\u81f3\u5c11\u914d\u7f6e\u4e00\u6761\u7528\u6237\u6d88\u606f", (Object)messages);
        Object historyMessageObj = contextBean.getRequestData("history");
        if (historyMessageObj instanceof List && oConvertUtils.isObjectNotEmpty((Object)(historyMessages = (List)historyMessageObj))) {
            messages.addAll(0, historyMessages);
        }
        List<ChatMessage> chatMessages = this.a(messages, collatedParams);
        try {
            this.a(options.getJSONObject("model"), collatedParams.a, contextBean, flowNodeConfig, chatMessages);
        }
        catch (Exception e2) {
            if (e2.getMessage().contains("timeout")) {
                throw new org.jeecg.modules.airag.flow.d.a(flowNodeConfig.getNodeId(), flowNodeConfig.getText(), "llm request timeout");
            }
            throw e2;
        }
    }

    private void a(JSONObject modelOption, QueryRouter queryRouter, JeecgFlowContext contextBean, FlowNodeConfig flowNodeConfig, List<ChatMessage> chatMessages) {
        if (!modelOption.containsKey((Object)"modeId") || oConvertUtils.isEmpty((Object)modelOption.containsKey((Object)"modeId"))) {
            throw new org.jeecg.modules.airag.flow.d.a(flowNodeConfig.getNodeId(), flowNodeConfig.getText(), "\u8bf7\u9009\u62e9\u6a21\u578b");
        }
        String modelId = modelOption.getString("modeId");
        AIChatParams aiParams = e.a(modelOption, queryRouter, flowNodeConfig);
        aiParams.setCurrentHttpRequest(contextBean.getHttpRequest());
        if (flowNodeConfig.isSteam()) {
            TokenStream tokenStream = this.aiChatHandler.chat(modelId, chatMessages, aiParams);
            AtomicBoolean isThinking = new AtomicBoolean(false);
            b channel = contextBean.getFlowMsgBus().a(flowNodeConfig.getNodeId());
            tokenStream.onPartialResponse(resMessage -> {
                if ("<think>".equals(resMessage)) {
                    isThinking.set(true);
                    resMessage = "> ";
                }
                if ("</think>".equals(resMessage)) {
                    isThinking.set(false);
                    resMessage = "\n\n";
                }
                if (isThinking.get() && null != resMessage && resMessage.contains("\n")) {
                    resMessage = "\n> ";
                }
                channel.a((String)resMessage);
            }).onCompleteResponse(responseMessage -> {
                AiMessage aiMessage = responseMessage.aiMessage();
                FinishReason finishReason = responseMessage.finishReason();
                String respText = aiMessage.text();
                if (!FinishReason.STOP.equals((Object)finishReason) && null != finishReason) {
                    if (FinishReason.LENGTH.equals((Object)finishReason)) {
                        a.error("\u8c03\u7528\u6a21\u578b\u5f02\u5e38:\u4e0a\u4e0b\u6587\u957f\u5ea6\u8d85\u8fc7\u9650\u5236:{}", (Object)responseMessage.tokenUsage());
                        channel.b("\n\u4e0a\u4e0b\u6587\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u8bf7\u8c03\u6574\u6a21\u578b\u6700\u5927Tokens");
                    } else {
                        a.error("\u8c03\u7528\u6a21\u578b\u5f02\u5e38:" + respText);
                        if (respText.contains("insufficient Balance")) {
                            respText = "\u5927\u8bed\u8a00\u6a21\u578b\u8d26\u53f7\u4f59\u989d\u4e0d\u8db3!";
                        }
                        channel.b(respText);
                    }
                }
                List<FlowNodeConfig.NodeParam> outputParams = flowNodeConfig.getOutputParams();
                FlowNodeConfig.NodeParam outputParam = outputParams.get(0);
                contextBean.setContextData(flowNodeConfig.getNodeId(), outputParam.getField(), respText);
                channel.a();
            }).onError(error -> {
                a.error(error.getMessage(), error);
                String errMsg = error.getMessage();
                if (errMsg != null && errMsg.contains("timeout")) {
                    errMsg = "\u5f53\u524d\u7528\u6237\u8f83\u591a\uff0c\u6392\u961f\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01";
                    channel.a(errMsg);
                } else {
                    errMsg = "\u8c03\u7528\u5927\u6a21\u578b\u63a5\u53e3\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7\u3002";
                    for (Map.Entry<String, String> entry : IAIChatHandler.MODEL_ERROR_MAP.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (!error.getMessage().contains(key)) continue;
                        errMsg = value;
                    }
                    channel.b(errMsg);
                }
                channel.a();
            }).start();
        } else {
            String response = this.aiChatHandler.completions(modelId, chatMessages, aiParams);
            List<FlowNodeConfig.NodeParam> outputParams = flowNodeConfig.getOutputParams();
            FlowNodeConfig.NodeParam outputParam = outputParams.get(0);
            contextBean.setContextData(flowNodeConfig.getNodeId(), outputParam.getField(), response);
        }
    }

    private static AIChatParams a(JSONObject modelOption, QueryRouter queryRouter, FlowNodeConfig flowNodeConfig) {
        String pluginsOption;
        JSONObject options = JSONObject.parseObject((String)JSONObject.toJSONString(flowNodeConfig.getOptions()));
        Integer historyNum = oConvertUtils.getInt((Object)options.getInteger("history"), (int)3);
        AIChatParams aiChatParams = new AIChatParams();
        aiChatParams.setQueryRouter(queryRouter);
        aiChatParams.setMaxMsgNumber(historyNum);
        JSONObject modelParams = modelOption.getJSONObject("params");
        if (null != modelParams) {
            Integer maxTokens;
            Double frequencyPenalty;
            Double presencePenalty;
            Double topP;
            Double temperature = modelParams.getDouble("temperature");
            if (null != temperature) {
                aiChatParams.setTemperature(temperature);
            }
            if (null != (topP = modelParams.getDouble("topP"))) {
                aiChatParams.setTopP(topP);
            }
            if (null != (presencePenalty = modelParams.getDouble("presencePenalty"))) {
                aiChatParams.setPresencePenalty(presencePenalty);
            }
            if (null != (frequencyPenalty = modelParams.getDouble("frequencyPenalty"))) {
                aiChatParams.setFrequencyPenalty(frequencyPenalty);
            }
            if (null != (maxTokens = modelParams.getInteger("maxTokens"))) {
                aiChatParams.setMaxTokens(maxTokens);
            }
        }
        if (oConvertUtils.isNotEmpty((Object)(pluginsOption = options.getString("plugins")))) {
            ArrayList<String> pluginIds = new ArrayList<String>();
            JSONArray pluginArray = JSONArray.parseArray((String)pluginsOption);
            pluginArray.stream().filter(Objects::nonNull).map(o -> (LlmPlugin)JSONObject.parseObject((String)o.toString(), LlmPlugin.class)).forEach(plugin -> {
                if (plugin.getCategory().equals("mcp") || plugin.getCategory().equals("plugin")) {
                    pluginIds.add(plugin.getPluginId());
                }
            });
            if (oConvertUtils.isNotEmpty(pluginIds)) {
                aiChatParams.setPluginIds(pluginIds);
            }
        }
        return aiChatParams;
    }

    private a a(NodeComponent component, List<FlowNodeConfig.NodeParam> inputParams) {
        JeecgFlowContext contextBean = e.e(component);
        QueryRouter queryRouter = null;
        HashMap<String, Object> messageReplaceMap = new HashMap<String, Object>();
        ArrayList<String> images = new ArrayList<String>();
        for (FlowNodeConfig.NodeParam inputParam : inputParams) {
            Object inputData = contextBean.getContextData(inputParam.getNodeId(), inputParam.getField());
            if (oConvertUtils.isEmpty(inputData)) continue;
            FlowNode paramFlowNode = e.a(component, inputParam.getNodeId());
            if (null != paramFlowNode && "knowledge".equalsIgnoreCase(paramFlowNode.getType())) {
                queryRouter = (QueryRouter)contextBean.getContextData(paramFlowNode.getId(), "queryRouter");
                continue;
            }
            boolean isImage = e.a(component, inputParam);
            if (isImage) {
                if (inputData instanceof List) {
                    List imageList = (List)inputData;
                    if (!oConvertUtils.isObjectNotEmpty((Object)imageList)) continue;
                    images.addAll(imageList);
                    continue;
                }
                if (!(inputData instanceof String)) continue;
                if (((String)inputData).contains(",")) {
                    String[] imageArray = ((String)inputData).split(",");
                    if (!oConvertUtils.isObjectNotEmpty((Object)imageArray)) continue;
                    images.addAll(Arrays.asList(imageArray));
                    continue;
                }
                images.add((String)inputData);
                continue;
            }
            String placeholder = "{{" + inputParam.getName() + "}}";
            messageReplaceMap.put(placeholder, inputData);
        }
        return new a(queryRouter, messageReplaceMap, images);
    }

    protected static boolean a(NodeComponent component, FlowNodeConfig.NodeParam param) {
        block5: {
            FlowNodeConfig properties;
            block4: {
                FlowNode paramFlowNode = e.a(component, param.getNodeId());
                if (null == paramFlowNode) {
                    return false;
                }
                properties = paramFlowNode.getProperties();
                if (!"start".equalsIgnoreCase(paramFlowNode.getType())) break block4;
                List<FlowNodeConfig.NodeParam> beginNodeInputParams = properties.getInputParams();
                if (null == beginNodeInputParams) break block5;
                for (FlowNodeConfig.NodeParam inputParam : beginNodeInputParams) {
                    if (!inputParam.getField().equalsIgnoreCase(param.getField()) || !"picture".equalsIgnoreCase(inputParam.getType())) continue;
                    return true;
                }
                break block5;
            }
            if (oConvertUtils.isNotEmpty(properties.getOutputParams())) {
                for (FlowNodeConfig.NodeParam outputParam : properties.getOutputParams()) {
                    if (!outputParam.getField().equalsIgnoreCase(param.getField()) || !"picture".equalsIgnoreCase(param.getType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List<ChatMessage> a(List<MessageHistory> messages, a collatedInputParams) {
        Map<String, Object> messageReplaceMap = collatedInputParams.b;
        AtomicInteger userCount = new AtomicInteger(0);
        List<ChatMessage> chatMessages = messages.stream().filter(Objects::nonNull).filter(message -> oConvertUtils.isNotEmpty((Object)message.getContent()) || "tool".equalsIgnoreCase(message.getRole())).map(message -> {
            String content = message.getContent();
            if (oConvertUtils.isNotEmpty((Object)content)) {
                for (String placeholder : messageReplaceMap.keySet()) {
                    content = content.replace(placeholder, messageReplaceMap.get(placeholder).toString());
                }
            }
            if ("system".equalsIgnoreCase(message.getRole())) {
                return new SystemMessage(content);
            }
            if ("user".equalsIgnoreCase(message.getRole())) {
                ArrayList<TextContent> contents = new ArrayList<TextContent>();
                List<MessageHistory.ImageHistory> images = message.getImages();
                if (oConvertUtils.isObjectNotEmpty(images) && !images.isEmpty()) {
                    contents.addAll(images.stream().map(imageHistory -> {
                        if (oConvertUtils.isNotEmpty((Object)imageHistory.getUrl())) {
                            return ImageContent.from((URI)imageHistory.getUrl());
                        }
                        return ImageContent.from((String)imageHistory.getBase64Data(), (String)imageHistory.getMimeType());
                    }).collect(Collectors.toList()));
                }
                contents.add(TextContent.from((String)content));
                userCount.getAndIncrement();
                return UserMessage.from(contents);
            }
            if ("ai".equalsIgnoreCase(message.getRole())) {
                if (oConvertUtils.isObjectNotEmpty(message.getToolExecutionRequests())) {
                    List toolRequests = message.getToolExecutionRequests().stream().map(toolReq -> ToolExecutionRequest.builder().id(toolReq.getId()).name(toolReq.getName()).arguments(toolReq.getArguments()).build()).collect(Collectors.toList());
                    return AiMessage.from((String)content, toolRequests);
                }
                return new AiMessage(content);
            }
            if ("tool".equalsIgnoreCase(message.getRole())) {
                ToolExecutionRequest recreatedRequest = ToolExecutionRequest.builder().id(message.getContent()).name("unknown").arguments("{}").build();
                return ToolExecutionResultMessage.from((ToolExecutionRequest)recreatedRequest, (String)message.getToolExecutionResult());
            }
            return new AiMessage(content);
        }).collect(Collectors.toList());
        chatMessages = this.a(chatMessages);
        AssertUtils.assertGt((String)"LLM\u8282\u70b9\u81f3\u5c11\u914d\u7f6e\u4e00\u6761\u7528\u6237\u6d88\u606f", (Number)userCount.get(), (Number)0);
        if (oConvertUtils.isObjectNotEmpty(collatedInputParams.c)) {
            for (int i2 = chatMessages.size() - 1; i2 >= 0; --i2) {
                ChatMessage message2 = chatMessages.get(i2);
                if (!ChatMessageType.USER.equals((Object)message2.type())) continue;
                UserMessage lastUserMessage = (UserMessage)message2;
                List<ImageContent> imageContents = this.aiChatHandler.buildImageContents(collatedInputParams.c);
                ArrayList<ImageContent> contents = new ArrayList<ImageContent>(lastUserMessage.contents());
                contents.addAll(imageContents);
                chatMessages.set(i2, (ChatMessage)UserMessage.from(contents));
                break;
            }
        }
        return chatMessages;
    }

    private List<ChatMessage> a(List<ChatMessage> chatMessages) {
        ArrayList<ChatMessage> validatedMessages = new ArrayList<ChatMessage>();
        boolean previousMessageHasToolCalls = false;
        for (ChatMessage message : chatMessages) {
            if (message instanceof ToolExecutionResultMessage) {
                if (!previousMessageHasToolCalls) {
                    a.warn("\u68c0\u6d4b\u5230\u5b64\u7acb\u7684\u5de5\u5177\u6267\u884c\u7ed3\u679c\u6d88\u606f\uff0c\u5df2\u8fc7\u6ee4\u3002\u6d88\u606f\u5185\u5bb9: {}", (Object)message);
                    continue;
                }
                validatedMessages.add(message);
                previousMessageHasToolCalls = false;
                continue;
            }
            if (message instanceof AiMessage) {
                AiMessage aiMessage = (AiMessage)message;
                previousMessageHasToolCalls = aiMessage.toolExecutionRequests() != null && !aiMessage.toolExecutionRequests().isEmpty();
                validatedMessages.add(message);
                continue;
            }
            validatedMessages.add(message);
            previousMessageHasToolCalls = false;
        }
        return validatedMessages;
    }

    private static class a {
        public final QueryRouter a;
        public final Map<String, Object> b;
        public final List<String> c;

        public a(QueryRouter queryRouter, Map<String, Object> messageReplaceMap, List<String> images) {
            this.a = queryRouter;
            this.b = messageReplaceMap;
            this.c = images;
        }
    }
}

