/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.lock.client;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedissonLockClient {
    private static final Logger log = LoggerFactory.getLogger(RedissonLockClient.class);
    @Autowired
    private RedissonClient redissonClient;

    public RLock getLock(String lockKey) {
        return this.redissonClient.getLock(lockKey);
    }

    public boolean tryLock(String lockName, long expireSeconds) {
        return this.tryLock(lockName, 0L, expireSeconds);
    }

    public boolean tryLock(String lockName, long waitTime, long expireSeconds) {
        RLock rLock = this.getLock(lockName);
        boolean getLock = false;
        try {
            getLock = rLock.tryLock(waitTime, expireSeconds, TimeUnit.SECONDS);
            if (getLock) {
                log.info("\u83b7\u53d6\u9501\u6210\u529f,lockName={}", (Object)lockName);
            } else {
                log.info("\u83b7\u53d6\u9501\u5931\u8d25,lockName={}", (Object)lockName);
            }
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u5f0f\u9501\u5f02\u5e38\uff0clockName=" + lockName, (Throwable)e);
            getLock = false;
        }
        return getLock;
    }

    public RLock lock(String lockKey) {
        RLock lock = this.getLock(lockKey);
        lock.lock();
        return lock;
    }

    public RLock lock(String lockKey, long leaseTime) {
        RLock lock = this.getLock(lockKey);
        lock.lock(leaseTime, TimeUnit.SECONDS);
        return lock;
    }

    public void unlock(String lockName) {
        this.redissonClient.getLock(lockName).unlock();
    }
}

