/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonParser {
    public static List<Object> parseJsonArrayToList(String json) {
        if (json == null || json.trim().isEmpty()) {
            return new ArrayList<Object>();
        }
        String trimmed = json.trim();
        if (!trimmed.startsWith("[") || !trimmed.endsWith("]")) {
            throw new IllegalArgumentException("Input is not a valid JSON array");
        }
        String content = trimmed.substring(1, trimmed.length() - 1).trim();
        if (content.isEmpty()) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        List<String> elements = JsonParser.splitJsonElements(content);
        for (String element : elements) {
            result.add(JsonParser.parseJsonValue(element.trim()));
        }
        return result;
    }

    private static List<String> splitJsonElements(String content) {
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int braceDepth = 0;
        int bracketDepth = 0;
        boolean inString = false;
        char stringChar = '\"';
        boolean escapeNext = false;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (escapeNext) {
                current.append(c);
                escapeNext = false;
                continue;
            }
            if (c == '\\') {
                escapeNext = true;
                current.append(c);
                continue;
            }
            if (!inString) {
                if (c == ',') {
                    if (braceDepth == 0 && bracketDepth == 0) {
                        elements.add(current.toString());
                        current = new StringBuilder();
                        continue;
                    }
                } else if (c == '{') {
                    ++braceDepth;
                } else if (c == '}') {
                    --braceDepth;
                } else if (c == '[') {
                    ++bracketDepth;
                } else if (c == ']') {
                    --bracketDepth;
                } else if (c == '\"' || c == '\'') {
                    inString = true;
                    stringChar = c;
                }
            } else if (c == stringChar) {
                inString = false;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            elements.add(current.toString());
        }
        return elements;
    }

    private static Object parseJsonValue(String jsonValue) {
        if (jsonValue == null || jsonValue.isEmpty()) {
            return null;
        }
        String trimmed = jsonValue.trim();
        if ("null".equalsIgnoreCase(trimmed)) {
            return null;
        }
        if ("true".equalsIgnoreCase(trimmed)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmed)) {
            return false;
        }
        if (JsonParser.isQuotedString(trimmed)) {
            return JsonParser.parseString(trimmed);
        }
        if (JsonParser.isNumber(trimmed)) {
            return JsonParser.parseNumber(trimmed);
        }
        if (trimmed.startsWith("{")) {
            return JsonParser.parseJsonObject(trimmed);
        }
        if (trimmed.startsWith("[")) {
            return JsonParser.parseJsonArray(trimmed);
        }
        try {
            return JsonParser.parseNumber(trimmed);
        }
        catch (NumberFormatException e) {
            return trimmed;
        }
    }

    private static Map<String, Object> parseJsonObject(String json) {
        if (!json.startsWith("{") || !json.endsWith("}")) {
            throw new IllegalArgumentException("Invalid JSON object: " + json);
        }
        String content = json.substring(1, json.length() - 1).trim();
        if (content.isEmpty()) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List<String> pairs = JsonParser.splitJsonPairs(content);
        for (String pair : pairs) {
            String[] keyValue = JsonParser.splitKeyValue(pair.trim());
            if (keyValue.length != 2) continue;
            String key = JsonParser.parseString(keyValue[0].trim());
            Object value = JsonParser.parseJsonValue(keyValue[1].trim());
            result.put(key, value);
        }
        return result;
    }

    private static List<Object> parseJsonArray(String json) {
        if (!json.startsWith("[") || !json.endsWith("]")) {
            throw new IllegalArgumentException("Invalid JSON array: " + json);
        }
        String content = json.substring(1, json.length() - 1).trim();
        if (content.isEmpty()) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        List<String> elements = JsonParser.splitJsonElements(content);
        for (String element : elements) {
            result.add(JsonParser.parseJsonValue(element.trim()));
        }
        return result;
    }

    private static List<String> splitJsonPairs(String content) {
        ArrayList<String> pairs = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int braceDepth = 0;
        int bracketDepth = 0;
        boolean inString = false;
        char stringChar = '\"';
        boolean escapeNext = false;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (escapeNext) {
                current.append(c);
                escapeNext = false;
                continue;
            }
            if (c == '\\') {
                escapeNext = true;
                current.append(c);
                continue;
            }
            if (!inString) {
                if (c == ',') {
                    if (braceDepth == 0 && bracketDepth == 0) {
                        pairs.add(current.toString());
                        current = new StringBuilder();
                        continue;
                    }
                } else if (c == '{') {
                    ++braceDepth;
                } else if (c == '}') {
                    --braceDepth;
                } else if (c == '[') {
                    ++bracketDepth;
                } else if (c == ']') {
                    --bracketDepth;
                } else if (c == '\"' || c == '\'') {
                    inString = true;
                    stringChar = c;
                }
            } else if (c == stringChar) {
                inString = false;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            pairs.add(current.toString());
        }
        return pairs;
    }

    private static String[] splitKeyValue(String pair) {
        int colonIndex = -1;
        boolean inString = false;
        char stringChar = '\"';
        boolean escapeNext = false;
        for (int i = 0; i < pair.length(); ++i) {
            char c = pair.charAt(i);
            if (escapeNext) {
                escapeNext = false;
                continue;
            }
            if (c == '\\') {
                escapeNext = true;
                continue;
            }
            if (!inString) {
                if (c == ':') {
                    colonIndex = i;
                    break;
                }
                if (c != '\"' && c != '\'') continue;
                inString = true;
                stringChar = c;
                continue;
            }
            if (c != stringChar) continue;
            inString = false;
        }
        if (colonIndex == -1) {
            throw new IllegalArgumentException("Invalid key-value pair: " + pair);
        }
        return new String[]{pair.substring(0, colonIndex), pair.substring(colonIndex + 1)};
    }

    private static String parseString(String str) {
        if (!JsonParser.isQuotedString(str)) {
            return str;
        }
        char quoteChar = str.charAt(0);
        String content = str.substring(1, str.length() - 1);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '\\' && i + 1 < content.length()) {
                char next = content.charAt(i + 1);
                switch (next) {
                    case '\"': {
                        result.append('\"');
                        ++i;
                        break;
                    }
                    case '\'': {
                        result.append('\'');
                        ++i;
                        break;
                    }
                    case '\\': {
                        result.append('\\');
                        ++i;
                        break;
                    }
                    case '/': {
                        result.append('/');
                        ++i;
                        break;
                    }
                    case 'b': {
                        result.append('\b');
                        ++i;
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        ++i;
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        ++i;
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        ++i;
                        break;
                    }
                    case 'u': {
                        if (i + 5 < content.length()) {
                            String hex = content.substring(i + 2, i + 6);
                            try {
                                int codePoint = Integer.parseInt(hex, 16);
                                result.append((char)codePoint);
                                i += 5;
                            }
                            catch (NumberFormatException e) {
                                result.append(c);
                            }
                            break;
                        }
                        result.append(c);
                        break;
                    }
                    default: {
                        result.append(c);
                    }
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    /*
     * Exception decompiling
     */
    private static Object parseNumber(String numStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isQuotedString(String str) {
        return str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'");
    }

    private static boolean isNumber(String str) {
        int i;
        if (str == null || str.isEmpty()) {
            return false;
        }
        String trimmed = str.trim();
        if (trimmed.isEmpty()) {
            return false;
        }
        char firstChar = trimmed.charAt(0);
        if (firstChar != '-' && firstChar != '+' && !Character.isDigit(firstChar)) {
            return false;
        }
        boolean hasDecimalPoint = false;
        boolean hasExponent = false;
        boolean hasDigit = false;
        int n = i = firstChar == '-' || firstChar == '+' ? 1 : 0;
        while (i < trimmed.length()) {
            char c = trimmed.charAt(i);
            if (c >= '0' && c <= '9') {
                hasDigit = true;
            } else if (c == '.') {
                if (hasDecimalPoint || hasExponent) {
                    return false;
                }
                hasDecimalPoint = true;
            } else if (c == 'e' || c == 'E') {
                if (hasExponent || !hasDigit) {
                    return false;
                }
                hasExponent = true;
                hasDigit = false;
            } else if (c == '+' || c == '-') {
                char prev;
                char c2 = prev = i > 0 ? trimmed.charAt(i - 1) : (char)'\u0000';
                if (prev != 'e' && prev != 'E') {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return hasDigit;
    }

    public static void main(String[] args) {
        String json1 = "[{\"name\":\"John\",\"age\":30}, {\"name\":\"Jane\",\"age\":25}]";
        List<Object> result1 = JsonParser.parseJsonArrayToList(json1);
        System.out.println("Test 1 Result: " + result1);
        String json2 = "[{\"name\":\"John\",\"scores\":[85,90,78],\"address\":{\"city\":\"NY\",\"zip\":10001}}]";
        List<Object> result2 = JsonParser.parseJsonArrayToList(json2);
        System.out.println("Test 2 Result: " + result2);
        String json3 = "[123, 45.67, \"hello\", true, false, null]";
        List<Object> result3 = JsonParser.parseJsonArrayToList(json3);
        System.out.println("Test 3 Result: " + result3);
        String json4 = "[\"Line1\\nLine2\", \"Quote:\\\"Hello\\\"\", \"Backslash:\\\\\"]";
        List<Object> result4 = JsonParser.parseJsonArrayToList(json4);
        System.out.println("Test 4 Result: " + result4);
    }
}

