/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.view;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.jeecgframework.poi.word.WordExportUtil;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.view.AbstractView;

@Controller(value="jeecgTemplateWordView")
public class JeecgTemplateWordView
extends AbstractView {
    private static final String CONTENT_TYPE = "application/msword";

    public JeecgTemplateWordView() {
        this.setContentType(CONTENT_TYPE);
    }

    public boolean isIE(HttpServletRequest request) {
        return request.getHeader("USER-AGENT").toLowerCase().indexOf("msie") > 0 || request.getHeader("USER-AGENT").toLowerCase().indexOf("rv:11.0") > 0;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object codedFileName = "\u4e34\u65f6\u6587\u4ef6.docx";
        if (model.containsKey("fileName")) {
            codedFileName = (String)model.get("fileName") + ".docx";
        }
        codedFileName = this.isIE(request) ? URLEncoder.encode((String)codedFileName, "UTF8") : new String(((String)codedFileName).getBytes("UTF-8"), "ISO-8859-1");
        response.setHeader("content-disposition", "attachment;filename=" + (String)codedFileName);
        XWPFDocument document = WordExportUtil.exportWord07((String)((String)model.get("url")), (Map)((Map)model.get("map")));
        ServletOutputStream out = response.getOutputStream();
        document.write((OutputStream)out);
        out.flush();
    }
}

