/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.oss;

import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.a.a;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component(value="jimuMinioConfig")
@ConfigurationProperties(prefix="jeecg.minio")
@ConditionalOnProperty(value={"jeecg.uploadType"}, havingValue="minio", matchIfMissing=true)
public class JimuMinioConfig {
    private static final Logger log = LoggerFactory.getLogger(JimuMinioConfig.class);
    private String minioUrl;
    private String minioName;
    private String minioPass;
    private String bucketName;

    @Bean
    public JimuMinioConfig initJimuMinio() {
        if (OkConvertUtils.isNotEmpty(this.minioUrl)) {
            if (!this.minioUrl.startsWith("http")) {
                this.minioUrl = "http://" + this.minioUrl;
            }
            if (!this.minioUrl.endsWith("/")) {
                this.minioUrl = this.minioUrl.concat("/");
            }
        }
        try {
            a.setMinioUrl(this.minioUrl);
            a.setMinioName(this.minioName);
            a.setMinioPass(this.minioPass);
            a.setBucketName(this.bucketName);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            log.error("[JimuReport] \u52a0\u8f7d\u4e0a\u4f20\u914d\u7f6e\u5931\u8d25\uff0cMinio\u7248\u672c\u4e0d\u5339\u914d\uff0c\u8bf7\u5347\u7ea7Minio\u4f9d\u8d56\u52308.0.3+", (Throwable)noClassDefFoundError);
        }
        return new JimuMinioConfig();
    }

    public String getMinioUrl() {
        return this.minioUrl;
    }

    public String getMinioName() {
        return this.minioName;
    }

    public String getMinioPass() {
        return this.minioPass;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setMinioUrl(String minioUrl) {
        this.minioUrl = minioUrl;
    }

    public void setMinioName(String minioName) {
        this.minioName = minioName;
    }

    public void setMinioPass(String minioPass) {
        this.minioPass = minioPass;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof JimuMinioConfig)) {
            return false;
        }
        JimuMinioConfig jimuMinioConfig = (JimuMinioConfig)o2;
        if (!jimuMinioConfig.canEqual(this)) {
            return false;
        }
        String string = this.getMinioUrl();
        String string2 = jimuMinioConfig.getMinioUrl();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getMinioName();
        String string4 = jimuMinioConfig.getMinioName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getMinioPass();
        String string6 = jimuMinioConfig.getMinioPass();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getBucketName();
        String string8 = jimuMinioConfig.getBucketName();
        return !(string7 == null ? string8 != null : !string7.equals(string8));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JimuMinioConfig;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        String string = this.getMinioUrl();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getMinioName();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getMinioPass();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getBucketName();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        return n3;
    }

    public String toString() {
        return "JimuMinioConfig(minioUrl=" + this.getMinioUrl() + ", minioName=" + this.getMinioName() + ", minioPass=" + this.getMinioPass() + ", bucketName=" + this.getBucketName() + ")";
    }
}

