/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.locale;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;

public class JimuLocaleInterceptor
implements HandlerInterceptor {
    private final LocaleResolver localeResolver;

    public JimuLocaleInterceptor(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Locale locale = this.localeResolver.resolveLocale(request);
        LocaleContextHolder.setLocale((Locale)locale);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LocaleContextHolder.resetLocaleContext();
    }
}

