/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.firewall.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jeecg.modules.jmreport.common.constant.JmConst;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.e;
import org.jeecg.modules.jmreport.common.util.wrapper.BodyReaderHttpServletRequestWrapper;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.config.firewall.interceptor.enums.JimuLowCodeUrlsEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuLowCodeModeInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JimuLowCodeModeInterceptor.class);
    public static final String LOW_CODE_MODE_DEV = "dev";
    public static final String LOW_CODE_MODE_PROD = "prod";
    public static final String LOW_CODE_MODE_PRODSF = "prodsf";
    @Resource
    private JmReportBaseConfig jmReportBaseConfig;
    @Resource
    private JmReportTokenClient jmReportTokenClient;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.jmReportBaseConfig == null) {
            this.jmReportBaseConfig = JimuSpringContextUtils.getBean(JmReportBaseConfig.class);
        }
        if (this.jmReportTokenClient == null) {
            this.jmReportTokenClient = JimuSpringContextUtils.getBean(JmReportTokenClient.class);
        }
        if (this.jmReportBaseConfig.getFirewall() != null && LOW_CODE_MODE_PROD.equals(this.jmReportBaseConfig.getFirewall().getLowCodeMode())) {
            Object object;
            String[] stringArray;
            String string = request.getRequestURI().substring(request.getContextPath().length());
            log.info("\u4f4e\u4ee3\u7801\u6a21\u5f0f\uff0c\u62e6\u622a\u8bf7\u6c42\u8def\u5f84\uff1a" + string);
            if (JimuLowCodeUrlsEnum.JIMU_QURESTSQL.getUrl().equals(string) && (stringArray = this.getQueryParams((BodyReaderHttpServletRequestWrapper)((Object)(object = new BodyReaderHttpServletRequestWrapper(request))))).containsKey("jmViewFirstLoad")) {
                return true;
            }
            object = this.jmReportTokenClient.getUsername();
            stringArray = this.jmReportTokenClient.getRoles(request);
            boolean bl = e.a(stringArray, JmConst.allowDevRoles);
            if ("admin".equals(object) || bl) {
                return true;
            }
            this.returnErrorMessage(response, "\u53d1\u5e03\u6a21\u5f0f");
            return false;
        }
        if (this.jmReportBaseConfig.getFirewall() != null && LOW_CODE_MODE_PRODSF.equals(this.jmReportBaseConfig.getFirewall().getLowCodeMode())) {
            BodyReaderHttpServletRequestWrapper bodyReaderHttpServletRequestWrapper;
            SortedMap<String, String> sortedMap;
            String string = request.getRequestURI().substring(request.getContextPath().length());
            if (JimuLowCodeUrlsEnum.JIMU_QURESTSQL.getUrl().equals(string) && (sortedMap = this.getQueryParams(bodyReaderHttpServletRequestWrapper = new BodyReaderHttpServletRequestWrapper(request))).containsKey("jmViewFirstLoad")) {
                return true;
            }
            log.info("\u4f4e\u4ee3\u7801\u6a21\u5f0f\uff0c\u62e6\u622a\u8bf7\u6c42\u8def\u5f84\uff1a" + string);
            this.returnErrorMessage(response, "\u53d1\u5e03\u5b89\u5168\u6a21\u5f0f");
            return false;
        }
        return true;
    }

    private void returnErrorMessage(HttpServletResponse response, String content) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter printWriter = null;
        try {
            printWriter = response.getWriter();
            Result<Object> result = Result.error("\u5f53\u524d\u79ef\u6728\u5e73\u53f0\u6a21\u5f0f\u4e3a\uff0c" + content + "\u4e0d\u5141\u8bb8\u4f7f\u7528\u5728\u7ebf\u914d\u7f6e\uff01\uff01");
            printWriter.print(JSON.toJSON(result));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private SortedMap<String, String> getQueryParams(BodyReaderHttpServletRequestWrapper request) {
        String string;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (RequestMethod.POST.name().equals(request.getMethod()) && OkConvertUtils.isNotEmpty(string = request.getBody())) {
            JSONObject jSONObject = JSON.parseObject((String)string);
            for (String string2 : jSONObject.keySet()) {
                String string3 = jSONObject.getString(string2);
                treeMap.put(string2, string3);
            }
        }
        return treeMap;
    }
}

