/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component(value="jimuSpringContextUtils")
public class JimuSpringContextUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(JimuSpringContextUtils.class);
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        JimuSpringContextUtils.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest httpServletRequest = null;
        try {
            httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        catch (Exception exception) {
            log.warn("\u83b7\u53d6 HttpServletRequest \u4f1a\u8bdd\u5f02\u5e38\uff1a{}", (Object)exception.getMessage());
        }
        return httpServletRequest;
    }

    public static String getOrigin() {
        HttpServletRequest httpServletRequest = JimuSpringContextUtils.getHttpServletRequest();
        return httpServletRequest.getHeader("Origin");
    }

    public static Object getBean(String name) {
        return JimuSpringContextUtils.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)JimuSpringContextUtils.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)JimuSpringContextUtils.getApplicationContext().getBean(name, clazz);
    }
}

