SELECT jrc.*
FROM (
      SELECT jrc.ID, jrc.NAME, jrc.SOURCE_TYPE as type
      FROM jimu_report_category jrc
      WHERE jrc.DEL_FLAG = 1 AND jrc.SOURCE_TYPE = 'report'
      <#if (jimuReport.name)?? && jimuReport.name?length gt 0>
          /* 名称 */
          and jrc.NAME  like  :jimuReport.name
      </#if>
      ORDER BY jrc.update_time DESC
 ) jrc
UNION ALL
SELECT jr.*
FROM (
      SELECT jr.ID, jr.NAME, jr.TYPE
      FROM jimu_report jr
      WHERE jr.DEL_FLAG = 1 AND jr.TEMPLATE = 0
      <#if ( jimuReport.name )?? && jimuReport.name?length gt 0>
          /* 名称 */
          and jr.NAME like :jimuReport.name
      </#if>
      <#if ( jimuReport.createBy )?? && jimuReport.createBy?length gt 0>
          /* 创建人 */
          and jr.CREATE_BY = :jimuReport.createBy
      </#if>
      <#if ( jimuReport.tenantId )?? && jimuReport.tenantId?length gt 0>
          /* 租户标识 */
          and jr.tenant_id = :jimuReport.tenantId
      </#if>
      ORDER BY jr.update_time DESC
 ) jr
