/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jeecg.modules.jmreport.common.constant.ErrorCode;
import org.jeecg.modules.jmreport.common.expetion.JimuAlertException;
import org.jeecg.modules.jmreport.common.expetion.JimuDbConnectException;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.expetion.JimuSqlInjectionException;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class JimuGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(JimuGlobalExceptionHandler.class);

    @ExceptionHandler(value={JimuReportException.class})
    public Result<?> handleJimuReportException(JimuReportException e2) {
        log.error(e2.getMessage(), (Throwable)e2);
        return Result.error(e2.getMessage());
    }

    @ExceptionHandler(value={JimuDbConnectException.class})
    public Result<?> handleJimuDbConnectException(JimuDbConnectException e2) {
        log.error("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff1a {}", (Object)e2.getMessage());
        log.debug("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 , \u8be6\u7ec6\u65e5\u5fd7\uff1a", (Throwable)e2);
        return Result.error(e2.getMessage());
    }

    @ExceptionHandler(value={JimuSqlInjectionException.class})
    public Result<?> handleJimuSqlInjectionException(JimuSqlInjectionException e2) {
        log.error("SQL\u6267\u884c\u5931\u8d25\uff0c\u5b58\u5728\u6ce8\u5165\u98ce\u9669\uff1a {}", (Object)e2.getMessage());
        log.debug("SQL\u6267\u884c\u5931\u8d25\uff0c\u5b58\u5728\u6ce8\u5165\u98ce\u9669\uff1a", (Throwable)e2);
        return Result.error(e2.getMessage());
    }

    @ExceptionHandler(value={JimuAlertException.class})
    public static Result openException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json; charset=utf-8");
        Result result = JimuGlobalExceptionHandler.resolveException(ex, request.getRequestURI());
        response.setStatus(result.getCode().intValue());
        return result;
    }

    private static Result resolveException(Exception ex, String path) {
        ErrorCode errorCode = ErrorCode.d;
        int n2 = HttpStatus.INTERNAL_SERVER_ERROR.value();
        String string = ex.getMessage();
        String string2 = ex.getClass().getSuperclass().getName();
        String string3 = ex.getClass().getName();
        if (string3.contains("JimuAlertException")) {
            n2 = HttpStatus.OK.value();
            errorCode = ErrorCode.c;
        }
        return JimuGlobalExceptionHandler.buildBody(ex, errorCode, path, n2);
    }

    private static Result buildBody(Exception exception, ErrorCode resultCode, String path, int httpStatus) {
        String string = exception.getMessage();
        if (resultCode == null) {
            resultCode = ErrorCode.d;
        }
        int n2 = resultCode.getCode();
        Result<Object> result = Result.error(n2, string);
        log.error("==> \u9519\u8bef:{} exception: {}", result, (Object)exception);
        return result;
    }
}

