/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.codec;

import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.NoLicenseInstalledException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.util.codec.DigestHandler;
import org.jeecg.common.util.codec.c.a;
import org.jeecg.common.util.codec.exceptions.LicContentLoadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Digest {
    private static final Logger log = LoggerFactory.getLogger(Digest.class);
    private static final String[] MSG = new String[]{new String(Base64.decodeBase64((byte[])"LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSBDZXJ0aWZpY2F0ZSBoYXMgYmVlbiBpbnN0YWxsZWQgLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ==".getBytes()), StandardCharsets.UTF_8), new String(Base64.decodeBase64((byte[])"LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSBDZXJ0aWZpY2F0ZSBpbnN0YWxsZWQgc3VjY2Vzc2Z1bGx5IC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0=".getBytes()), StandardCharsets.UTF_8), new String(Base64.decodeBase64((byte[])"LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSBDZXJ0aWZpY2F0ZSBmaWxlIGRvZXMgbm90IGV4aXN0IC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0=".getBytes()), StandardCharsets.UTF_8), new String(Base64.decodeBase64((byte[])"LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSBDZXJ0aWZpY2F0ZSBpbnN0YWxsYXRpb24gZmFpbGVkIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0=".getBytes()), StandardCharsets.UTF_8), new String(Base64.decodeBase64((byte[])"LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSAlcyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0t".getBytes()), StandardCharsets.UTF_8)};
    private static a licenseManager;
    private static boolean installSuccess;

    public Digest(String licPath) {
        this.install(licPath);
    }

    private void install(String licPath) {
        try {
            if (null != licenseManager) {
                System.out.println(MSG[0]);
                return;
            }
            DigestHandler digestHandler = null;
            String string = System.getProperty("user.dir") + File.separator + "config" + File.separator;
            File file = new File(string);
            try {
                digestHandler = file.exists() ? new DigestHandler(string, DigestHandler.LicType.b) : new DigestHandler("", DigestHandler.LicType.b);
            }
            catch (LicContentLoadException licContentLoadException) {
                // empty catch block
            }
            if (null == digestHandler) {
                if (file.exists()) {
                    try {
                        digestHandler = new DigestHandler(string, DigestHandler.LicType.a);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (digestHandler == null && StringUtils.isNotBlank((CharSequence)licPath)) {
                        digestHandler = new DigestHandler(licPath, DigestHandler.LicType.a);
                    }
                } else {
                    digestHandler = new DigestHandler(licPath, DigestHandler.LicType.a);
                }
            }
            licenseManager = new a(digestHandler);
            licenseManager.c();
            LicenseContent licenseContent = licenseManager.e();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            installSuccess = true;
            System.out.println(MSG[1]);
            System.out.println(MessageFormat.format(new String(Base64.decodeBase64((String)"VGhlIHZhbGlkaXR5IHBlcmlvZCBvZiB0aGUgY2VydGlmaWNhdGUgaXPvvJp7MH0gLSB7MX0="), StandardCharsets.UTF_8), simpleDateFormat.format(licenseContent.getNotBefore()), simpleDateFormat.format(licenseContent.getNotAfter())));
        }
        catch (IOException iOException) {
            installSuccess = false;
            System.out.println(MSG[2]);
            Runtime.getRuntime().halt(0);
        }
        catch (Exception exception) {
            installSuccess = false;
            System.out.println(MSG[3]);
            if (exception instanceof LicenseContentException || exception instanceof NoLicenseInstalledException) {
                System.out.println(String.format(MSG[4], exception.getMessage()));
            }
            Runtime.getRuntime().halt(0);
        }
    }

    public void unInstall() {
        if (installSuccess) {
            try {
                licenseManager.c();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean verify() {
        try {
            if (null != licenseManager && installSuccess) {
                licenseManager.b();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            if (exception instanceof LicenseContentException || exception instanceof NoLicenseInstalledException) {
                System.out.println(String.format(MSG[4], exception.getMessage()));
            }
            return false;
        }
    }

    public static Integer getConsumerAmount() {
        try {
            if (null != licenseManager && installSuccess) {
                LicenseContent licenseContent = licenseManager.b();
                return licenseContent.getConsumerAmount() + 5;
            }
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof LicenseContentException || exception instanceof NoLicenseInstalledException) {
                System.out.println(String.format(MSG[4], exception.getMessage()));
            }
            return null;
        }
    }
}

