/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.graphreport.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportHead;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportItem;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportTemplet;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportTempletItem;
import org.jeecg.modules.online.graphreport.mapper.OnlGraphreportHeadMapper;
import org.jeecg.modules.online.graphreport.service.IOnlGraphreportApiService;
import org.jeecg.modules.online.graphreport.service.IOnlGraphreportHeadService;
import org.jeecg.modules.online.graphreport.service.IOnlGraphreportItemService;
import org.jeecg.modules.online.graphreport.service.IOnlGraphreportTempletItemService;
import org.jeecg.modules.online.graphreport.service.IOnlGraphreportTempletService;
import org.jeecg.modules.online.graphreport.util.GraphreportUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OnlGraphreportApiServiceImpl
extends ServiceImpl<OnlGraphreportHeadMapper, OnlGraphreportHead>
implements IOnlGraphreportApiService {
    @Autowired
    private IOnlGraphreportHeadService headService;
    @Autowired
    private IOnlGraphreportItemService itemService;
    @Autowired
    private IOnlGraphreportTempletService templetService;
    @Autowired
    private IOnlGraphreportTempletItemService templetItemService;

    @Override
    public Result<?> getTempletChartsData(String id) {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        OnlGraphreportTemplet templet = (OnlGraphreportTemplet)this.templetService.getById((Serializable)((Object)id));
        if (templet == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        resultMap.put("templet", templet);
        List<OnlGraphreportTempletItem> templetItems = this.templetItemService.selectByMainId(id);
        Iterator<OnlGraphreportTempletItem> iterator = templetItems.iterator();
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> group = null;
        Integer groupNum = null;
        String groupStyle = null;
        String groupTxt = null;
        while (iterator.hasNext()) {
            OnlGraphreportTempletItem templetItem = iterator.next();
            if (groupNum == null || !templetItem.getGroupNum().equals(groupNum)) {
                if (group != null) {
                    groups.add(this.getGroupMap(groupNum, groupStyle, groupTxt, group));
                }
                group = new ArrayList<Map<String, Object>>();
                groupNum = templetItem.getGroupNum();
                groupStyle = templetItem.getGroupStyle();
                groupTxt = templetItem.getGroupTxt();
            }
            String code = templetItem.getGraphreportCode();
            OnlGraphreportHead head = this.headService.queryByCode(code);
            String graphreportType = templetItem.getGraphreportType();
            if (!"normal".equals(graphreportType)) {
                head.setGraphType(graphreportType);
            }
            Map<String, Object> chartMap = this.queryChartDataSource(head, null);
            group.add(chartMap);
        }
        groups.add(this.getGroupMap(groupNum, groupStyle, groupTxt, group));
        resultMap.put("groups", groups);
        return Result.ok(resultMap);
    }

    private Map<String, Object> getGroupMap(int groupNum, String groupStyle, String groupTxt, List<?> group) {
        HashMap<String, Object> groupMap = new HashMap<String, Object>();
        groupMap.put("groupNum", groupNum);
        groupMap.put("groupStyle", groupStyle);
        groupMap.put("groupTxt", groupTxt);
        groupMap.put("charts", group);
        return groupMap;
    }

    @Override
    public Map<String, Object> queryChartDataSource(OnlGraphreportHead head, String paramString) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("head", head);
        List<OnlGraphreportItem> items = this.itemService.selectByMainId(head.getId());
        resultMap.put("items", items);
        String dataType = "sql";
        if (dataType.equals(head.getDataType())) {
            String sql = head.getCgrSql();
            String conditionSql = GraphreportUtil.getSplicingConditionSql(sql, paramString);
            List<Map<?, ?>> listMap = this.headService.executeSelete(conditionSql);
            resultMap.put("data", listMap);
        }
        return resultMap;
    }
}

