/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.graphreport.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.util.BrowserUtils;
import org.jeecg.modules.online.graphreport.entity.OnlGraphreportHead;
import org.jeecg.modules.online.graphreport.service.IOnlGraphreportApiService;
import org.jeecg.modules.online.graphreport.service.IOnlGraphreportHeadService;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/online/graphreport/api"})
public class OnlGraphreportApiController {
    @Autowired
    private IOnlGraphreportHeadService headService;
    @Autowired
    private IOnlGraphreportApiService apiService;

    @GetMapping(value={"/getTempletAllData"})
    public Result<?> getTempletAllData(@RequestParam(name="id", required=true) String id) {
        return this.apiService.getTempletChartsData(id);
    }

    @GetMapping(value={"/getChartsData"})
    public Result<?> getChartsData(@RequestParam(name="id", required=true) String id, @RequestParam(value="params") String paramString) {
        OnlGraphreportHead head = (OnlGraphreportHead)this.headService.getById((Serializable)((Object)id));
        if (head == null) {
            return Result.error((String)"\u5b9e\u4f53\u4e0d\u5b58\u5728");
        }
        return Result.ok(this.apiService.queryChartDataSource(head, paramString));
    }

    @GetMapping(value={"/getChartsDataByCode"})
    public Result<?> getChartsDataByCode(@RequestParam(name="code", required=true) String code, @RequestParam(value="params") String paramString) {
        OnlGraphreportHead head = this.headService.queryByCode(code);
        if (head == null) {
            return Result.error((String)"\u5b9e\u4f53\u4e0d\u5b58\u5728");
        }
        return Result.ok(this.apiService.queryChartDataSource(head, paramString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/exportXls"})
    public void exportXls(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = request.getParameter("name");
        String dataSourceString = URLDecoder.decode(request.getParameter("dataSource"), "UTF-8");
        String entitysString = URLDecoder.decode(request.getParameter("entitys"), "UTF-8");
        if (StringUtils.isEmpty((String)dataSourceString) || StringUtils.isEmpty((String)entitysString)) {
            throw new Exception("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\uff08dataSource\u3001entitys\uff09");
        }
        if (StringUtils.isEmpty((String)name)) {
            name = "ExportExecel";
        }
        JSONArray entitysJson = JSONObject.parseArray((String)entitysString);
        JSONArray dataSourceJson = JSONObject.parseArray((String)dataSourceString);
        ArrayList<ExcelExportEntity> entityList = new ArrayList<ExcelExportEntity>();
        for (int i = 0; i < entitysJson.size(); ++i) {
            JSONObject entity = entitysJson.getJSONObject(i);
            String key = entity.getString("key");
            String alias = entity.getString("alias");
            entityList.add(new ExcelExportEntity(alias, (Object)key, 30));
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < dataSourceJson.size(); ++i) {
            JSONObject data = dataSourceJson.getJSONObject(i);
            Iterator iterator = data.keySet().iterator();
            HashMap<String, String> map = new HashMap<String, String>();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = data.getString(key);
                map.put(key, value);
            }
            list.add(map);
        }
        ServletOutputStream out = null;
        try {
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(name, name), entityList, list);
            String browse = BrowserUtils.checkBrowse((HttpServletRequest)request);
            if ("MSIE".equalsIgnoreCase(browse.substring(0, 4))) {
                response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(name, "UTF-8") + ".xls");
            } else {
                String newtitle = new String(name.getBytes("UTF-8"), "ISO8859-1");
                response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
            }
            out = response.getOutputStream();
            workbook.write((OutputStream)out);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (Exception exception) {}
        }
    }
}

