/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.config.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.modules.online.config.exception.DBException;
import org.jeecg.modules.online.config.service.DbTableHandleI;
import org.jeecg.modules.online.config.service.impl.DbTableMysqlHandleImpl;
import org.jeecg.modules.online.config.service.impl.DbTableOracleHandleImpl;
import org.jeecg.modules.online.config.service.impl.DbTablePostgresHandleImpl;
import org.jeecg.modules.online.config.service.impl.DbTableSQLServerHandleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableUtil {
    private static final Logger log = LoggerFactory.getLogger(DbTableUtil.class);
    public static final String DB_TYPE_MYSQL = "MYSQL";
    public static final String DB_TYPE_ORACLE = "ORACLE";
    public static final String DB_TYPE_POSTGRESQL = "POSTGRESQL";
    public static final String DB_TYPE_SQLSERVER = "SQLSERVER";
    public static String DB_TYPE = "";

    public static DbTableHandleI getTableHandle() throws SQLException, DBException {
        String dbType;
        DbTableHandleI dbTableHandle = null;
        switch (dbType = DbTableUtil.getDatabaseType()) {
            case "MYSQL": {
                dbTableHandle = new DbTableMysqlHandleImpl();
                break;
            }
            case "ORACLE": {
                dbTableHandle = new DbTableOracleHandleImpl();
                break;
            }
            case "SQLSERVER": {
                dbTableHandle = new DbTableSQLServerHandleImpl();
                break;
            }
            case "POSTGRESQL": {
                dbTableHandle = new DbTablePostgresHandleImpl();
                break;
            }
        }
        return dbTableHandle;
    }

    public static Connection getConnection() throws SQLException {
        DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
        return dataSource.getConnection();
    }

    public static String getDatabaseType() throws SQLException, DBException {
        DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
        return DbTableUtil.getDatabaseType(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDatabaseType(DataSource dataSource) throws SQLException, DBException {
        block10: {
            if ("".equals(DB_TYPE)) {
                try (Connection connection = dataSource.getConnection();){
                    DatabaseMetaData md = connection.getMetaData();
                    String dbType = md.getDatabaseProductName().toLowerCase();
                    if (dbType.indexOf("mysql") >= 0) {
                        DB_TYPE = DB_TYPE_MYSQL;
                        break block10;
                    }
                    if (dbType.indexOf("oracle") >= 0) {
                        DB_TYPE = DB_TYPE_ORACLE;
                        break block10;
                    }
                    if (dbType.indexOf("sqlserver") >= 0 || dbType.indexOf("sql server") >= 0) {
                        DB_TYPE = DB_TYPE_SQLSERVER;
                        break block10;
                    }
                    if (dbType.indexOf("postgresql") >= 0) {
                        DB_TYPE = DB_TYPE_POSTGRESQL;
                        break block10;
                    }
                    throw new DBException("\u6570\u636e\u5e93\u7c7b\u578b:[" + dbType + "]\u4e0d\u8bc6\u522b!");
                }
            }
        }
        return DB_TYPE;
    }

    public static String getDatabaseType(Connection connection) throws SQLException, DBException {
        if ("".equals(DB_TYPE)) {
            DatabaseMetaData md = connection.getMetaData();
            String dbType = md.getDatabaseProductName().toLowerCase();
            if (dbType.indexOf("mysql") >= 0) {
                DB_TYPE = DB_TYPE_MYSQL;
            } else if (dbType.indexOf("oracle") >= 0) {
                DB_TYPE = DB_TYPE_ORACLE;
            } else if (dbType.indexOf("sqlserver") >= 0 || dbType.indexOf("sql server") >= 0) {
                DB_TYPE = DB_TYPE_SQLSERVER;
            } else if (dbType.indexOf("postgresql") >= 0) {
                DB_TYPE = DB_TYPE_POSTGRESQL;
            } else {
                throw new DBException("\u6570\u636e\u5e93\u7c7b\u578b:[" + dbType + "]\u4e0d\u8bc6\u522b!");
            }
        }
        return DB_TYPE;
    }

    public static String getDataType(Session session) throws SQLException, DBException {
        return DbTableUtil.getDatabaseType();
    }

    public static String getTableName(String tableName, String dataBaseType) {
        switch (tableName) {
            case "ORACLE": {
                return tableName.toUpperCase();
            }
            case "POSTGRESQL": {
                return tableName.toLowerCase();
            }
        }
        return tableName;
    }

    public static Boolean judgeTableIsExit(String tableName) {
        Connection conn = null;
        ResultSet rs = null;
        try {
            String[] types = new String[]{"TABLE"};
            conn = DbTableUtil.getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            String dataBaseType = dbMetaData.getDatabaseProductName().toUpperCase();
            String tableNamePattern = DbTableUtil.getTableName(tableName, dataBaseType);
            rs = dbMetaData.getTables(null, null, tableNamePattern, types);
            if (rs.next()) {
                log.info("\u6570\u636e\u5e93\u8868\uff1a\u3010" + tableName + "\u3011\u5df2\u5b58\u5728");
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Map<String, Object> getColumnMap(List<Map<String, Object>> queryForList) {
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        for (int i = 0; i < queryForList.size(); ++i) {
            columnMap.put(queryForList.get(i).get("column_name").toString(), queryForList.get(i));
        }
        return columnMap;
    }

    public static String getDialect() throws SQLException, DBException {
        String databaseType = DbTableUtil.getDatabaseType();
        return DbTableUtil.getDialect(databaseType);
    }

    public static String getDialect(String databaseType) throws SQLException, DBException {
        String dialect = "org.hibernate.dialect.MySQL5InnoDBDialect";
        switch (databaseType) {
            case "SQLSERVER": {
                dialect = "org.hibernate.dialect.SQLServerDialect";
                break;
            }
            case "POSTGRESQL": {
                dialect = "org.hibernate.dialect.PostgreSQLDialect";
                break;
            }
            case "ORACLE": {
                dialect = "org.hibernate.dialect.OracleDialect";
                break;
            }
        }
        return dialect;
    }

    public static String translatorToDbField(String fileName) {
        return fileName;
    }
}

