/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.config.util;

import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgform.entity.OnlCgformField;
import org.jeecg.modules.online.config.exception.DBException;
import org.jeecg.modules.online.config.model.CgformConfigModel;
import org.jeecg.modules.online.config.model.DataBaseConfig;
import org.jeecg.modules.online.config.service.DbTableHandleI;
import org.jeecg.modules.online.config.util.ColumnMeta;
import org.jeecg.modules.online.config.util.DbTableUtil;
import org.jeecg.modules.online.config.util.FreemarkerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableProcess {
    private static final Logger log = LoggerFactory.getLogger(DbTableProcess.class);
    private static final String tpl_url = "org/jeecg/modules/online/config/engine/tableTemplate.ftl";
    private static DbTableHandleI dbTableHandle;

    public DbTableProcess() throws SQLException, DBException {
        dbTableHandle = DbTableUtil.getTableHandle();
    }

    public static void createTable(CgformConfigModel model) throws IOException, TemplateException, HibernateException, SQLException, DBException {
        String dbType = DbTableUtil.getDatabaseType();
        String xml = FreemarkerHelper.parseTemplate(tpl_url, DbTableProcess.getRootMap(model, dbType));
        log.info(xml);
        HashMap<String, Object> settings = new HashMap<String, Object>();
        DataBaseConfig dbconfig = model.getDbConfig();
        settings.put("hibernate.connection.driver_class", dbconfig.getDriverClassName());
        settings.put("hibernate.connection.url", dbconfig.getUrl());
        settings.put("hibernate.connection.username", dbconfig.getUsername());
        settings.put("hibernate.connection.password", dbconfig.getPassword());
        settings.put("hibernate.show_sql", true);
        settings.put("hibernate.format_sql", true);
        settings.put("hibernate.dialect", DbTableUtil.getDialect(dbType));
        settings.put("hibernate.hbm2ddl.auto", "create");
        settings.put("hibernate.connection.autocommit", false);
        settings.put("hibernate.current_session_context_class", "thread");
        StandardServiceRegistry registry = new StandardServiceRegistryBuilder().applySettings(settings).build();
        MetadataSources ms = new MetadataSources((ServiceRegistry)registry);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xml.getBytes());
        ms.addInputStream((InputStream)xmlInputStream);
        Metadata metadata = ms.buildMetadata();
        SchemaExport dbExport = new SchemaExport();
        dbExport.create(EnumSet.of(TargetType.DATABASE), metadata);
        ((InputStream)xmlInputStream).close();
        List exceptionList = dbExport.getExceptions();
        for (Exception exception : exceptionList) {
            SQLSyntaxErrorException e;
            if ("java.sql.SQLSyntaxErrorException".equals(exception.getCause().getClass().getName()) ? "42000".equals((e = (SQLSyntaxErrorException)exception.getCause()).getSQLState()) : "com.microsoft.sqlserver.jdbc.SQLServerException".equals(exception.getCause().getClass().getName())) continue;
            throw new DBException(exception.getMessage());
        }
    }

    public List<String> updateTable(CgformConfigModel model) throws DBException, SQLException {
        String dataType = DbTableUtil.getDatabaseType();
        String tableName = DbTableUtil.getTableName(model.getTableName(), dataType);
        String alterSql = "alter table  " + tableName + " ";
        ArrayList<String> alterList = new ArrayList<String>();
        try {
            Map<String, ColumnMeta> dbMetaCol = this.getDbMetaColumns(null, tableName);
            Map<String, ColumnMeta> configCol = this.getConfigColumns(model);
            Map<String, String> newAndOldFieldMap = this.getNewAndOldFieldName(model.getColumns());
            for (String columnName : configCol.keySet()) {
                ColumnMeta cgFormColumnMeta;
                if (!dbMetaCol.containsKey(columnName)) {
                    ColumnMeta cgFormColumnMeta2 = configCol.get(columnName);
                    String oldFieldName = newAndOldFieldMap.get(columnName);
                    if (newAndOldFieldMap.containsKey(columnName) && dbMetaCol.containsKey(oldFieldName)) {
                        ColumnMeta dataColumnMeta = dbMetaCol.get(oldFieldName);
                        String changeSql = dbTableHandle.getReNameFieldName(cgFormColumnMeta2);
                        if ("SQLSERVER".equals(dataType)) {
                            alterList.add(changeSql);
                        } else {
                            alterList.add(alterSql + changeSql);
                        }
                        String oldFieldSql = this.getUpdateOldFieldSql(columnName, cgFormColumnMeta2.getColumnId());
                        alterList.add(oldFieldSql);
                        if (!dataColumnMeta.equals(cgFormColumnMeta2)) {
                            alterList.add(alterSql + this.getUpdateColumnSql(cgFormColumnMeta2, dataColumnMeta));
                            if ("POSTGRESQL".equals(dataType)) {
                                alterList.add(alterSql + this.getUpdateSpecialSql(cgFormColumnMeta2, dataColumnMeta));
                            }
                        }
                        if ("SQLSERVER".equals(dataType) || dataColumnMeta.equalsComment(cgFormColumnMeta2)) continue;
                        alterList.add(this.getCommentSql(cgFormColumnMeta2));
                        continue;
                    }
                    alterList.add(alterSql + this.getAddColumnSql(cgFormColumnMeta2));
                    if ("SQLSERVER".equals(dataType) || !StringUtils.isNotEmpty((String)cgFormColumnMeta2.getComment())) continue;
                    alterList.add(this.getCommentSql(cgFormColumnMeta2));
                    continue;
                }
                ColumnMeta dataColumnMeta = dbMetaCol.get(columnName);
                if (!dataColumnMeta.equalsByDataType(cgFormColumnMeta = configCol.get(columnName), dataType)) {
                    alterList.add(alterSql + this.getUpdateColumnSql(cgFormColumnMeta, dataColumnMeta));
                }
                if ("SQLSERVER".equals(dataType) || dataColumnMeta.equalsComment(cgFormColumnMeta)) continue;
                alterList.add(this.getCommentSql(cgFormColumnMeta));
            }
            for (String columnName : dbMetaCol.keySet()) {
                if (configCol.containsKey(columnName.toLowerCase()) || newAndOldFieldMap.containsValue(columnName.toLowerCase())) continue;
                alterList.add(alterSql + this.getDropColumnSql(columnName));
            }
        }
        catch (SQLException e1) {
            throw new RuntimeException();
        }
        log.info(((Object)alterList).toString());
        return alterList;
    }

    private static Map<String, Object> getRootMap(CgformConfigModel model, String dataType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (OnlCgformField field : model.getColumns()) {
            field.setDbDefaultVal(DbTableProcess.judgeIsNumber(field.getDbDefaultVal()));
        }
        map.put("entity", model);
        map.put("dataType", dataType);
        return map;
    }

    private Map<String, ColumnMeta> getDbMetaColumns(String schemaName, String tableName) throws SQLException {
        HashMap<String, ColumnMeta> columnMap = new HashMap<String, ColumnMeta>();
        Connection conn = null;
        try {
            conn = DbTableUtil.getConnection();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        DatabaseMetaData dbMetaData = conn.getMetaData();
        ResultSet rs = dbMetaData.getColumns(null, schemaName, tableName, "%");
        while (rs.next()) {
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setTableName(tableName);
            String columnName = rs.getString("COLUMN_NAME").toLowerCase();
            columnMeta.setColumnName(columnName);
            String typeName = rs.getString("TYPE_NAME");
            int decimalDigits = rs.getInt("DECIMAL_DIGITS");
            String colunmType = dbTableHandle.getMatchClassTypeByDataType(typeName, decimalDigits);
            columnMeta.setColunmType(colunmType);
            int columnSize = rs.getInt("COLUMN_SIZE");
            columnMeta.setColumnSize(columnSize);
            columnMeta.setDecimalDigits(decimalDigits);
            String isNullable = rs.getInt("NULLABLE") == 1 ? "Y" : "N";
            columnMeta.setIsNullable(isNullable);
            String comment = rs.getString("REMARKS");
            columnMeta.setComment(comment);
            String columnDef = rs.getString("COLUMN_DEF");
            String fieldDefault = DbTableProcess.judgeIsNumber(columnDef) == null ? "" : DbTableProcess.judgeIsNumber(columnDef);
            columnMeta.setFieldDefault(fieldDefault);
            log.info("getColumnMetadataFormDataBase --->COLUMN_NAME:" + columnName.toUpperCase() + " TYPE_NAME :" + typeName + " DECIMAL_DIGITS:" + decimalDigits + " COLUMN_SIZE:" + columnSize);
            columnMap.put(columnName, columnMeta);
        }
        return columnMap;
    }

    private Map<String, ColumnMeta> getConfigColumns(CgformConfigModel model) {
        HashMap<String, ColumnMeta> columnMap = new HashMap<String, ColumnMeta>();
        List<OnlCgformField> fieldList = model.getColumns();
        for (OnlCgformField field : fieldList) {
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setTableName(model.getTableName().toLowerCase());
            columnMeta.setColumnId(field.getId());
            columnMeta.setColumnName(field.getDbFieldName().toLowerCase());
            columnMeta.setColumnSize(field.getDbLength());
            columnMeta.setColunmType(field.getDbType());
            columnMeta.setIsNullable(field.getDbIsNull() == 1 ? "Y" : "N");
            columnMeta.setComment(field.getDbFieldTxt());
            columnMeta.setDecimalDigits(field.getDbPointLength());
            columnMeta.setFieldDefault(DbTableProcess.judgeIsNumber(field.getDbDefaultVal()));
            columnMeta.setPkType(model.getJformPkType() == null ? "UUID" : model.getJformPkType());
            columnMeta.setOldColumnName(field.getDbFieldNameOld() != null ? field.getDbFieldNameOld().toLowerCase() : null);
            log.info("getColumnMetadataFormCgForm ---->COLUMN_NAME:" + field.getDbFieldName().toLowerCase() + " TYPE_NAME:" + field.getDbType().toLowerCase() + " DECIMAL_DIGITS:" + field.getDbPointLength() + " COLUMN_SIZE:" + field.getDbLength());
            columnMap.put(field.getDbFieldName().toLowerCase(), columnMeta);
        }
        return columnMap;
    }

    private Map<String, String> getNewAndOldFieldName(List<OnlCgformField> fieldList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (OnlCgformField field : fieldList) {
            map.put(field.getDbFieldName(), field.getDbFieldNameOld());
        }
        return map;
    }

    private String getDropColumnSql(String fieldName) {
        return dbTableHandle.getDropColumnSql(fieldName);
    }

    private String getUpdateColumnSql(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) throws DBException {
        return dbTableHandle.getUpdateColumnSql(cgformcolumnMeta, datacolumnMeta);
    }

    private String getUpdateSpecialSql(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) {
        return dbTableHandle.getSpecialHandle(cgformcolumnMeta, datacolumnMeta);
    }

    private String getReNameFieldName(ColumnMeta columnMeta) {
        return dbTableHandle.getReNameFieldName(columnMeta);
    }

    private String getAddColumnSql(ColumnMeta columnMeta) {
        return dbTableHandle.getAddColumnSql(columnMeta);
    }

    private String getCommentSql(ColumnMeta columnMeta) {
        return dbTableHandle.getCommentSql(columnMeta);
    }

    private String getUpdateOldFieldSql(String columnName, String id) {
        return "update cgform_field set old_field_name= '" + columnName + "' where id='" + id + "'";
    }

    private int updateFieldName(String columnName, String id, Session session) {
        return session.createSQLQuery("update cgform_field set old_field_name= '" + columnName + "' where id='" + id + "'").executeUpdate();
    }

    private static String judgeIsNumber(String text) {
        block3: {
            if (StringUtils.isNotEmpty((String)text)) {
                try {
                    Double.valueOf(text);
                }
                catch (Exception e) {
                    if (text.startsWith("'") && text.endsWith("'")) break block3;
                    text = "'" + text + "'";
                }
            }
        }
        return text;
    }

    public String dropIndex(String indexName, String tableName) {
        return dbTableHandle.dropIndexs(indexName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getIndexInfo(String tbname) throws SQLException {
        Connection conn = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            conn = DbTableUtil.getConnection();
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getIndexInfo(null, null, tbname, false, false);
            ResultSetMetaData md = rs.getMetaData();
            while (rs.next()) {
                String index_name = rs.getString("INDEX_NAME");
                if (oConvertUtils.isEmpty((Object)index_name)) {
                    index_name = rs.getString("index_name");
                }
                if (!oConvertUtils.isNotEmpty((Object)index_name)) continue;
                list.add(index_name);
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return list;
    }
}

