/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgreport.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.util.oConvertUtils;

public class SqlUtil {
    public static final String DATABSE_TYPE_MYSQL = "mysql";
    public static final String DATABSE_TYPE_POSTGRE = "postgresql";
    public static final String DATABSE_TYPE_ORACLE = "oracle";
    public static final String DATABSE_TYPE_SQLSERVER = "sqlserver";
    public static final String MYSQL_SQL = "select * from ( {0}) sel_tab00 limit {1},{2}";
    public static final String POSTGRE_SQL = "select * from ( {0}) sel_tab00 limit {2} offset {1}";
    public static final String ORACLE_SQL = "select * from (select row_.*,rownum rownum_ from ({0}) row_ where rownum <= {1}) where rownum_>{2}";
    public static final String SQLSERVER_SQL = "select * from ( select row_number() over(order by tempColumn) tempRowNumber, * from (select top {1} tempColumn = 0, {0}) t ) tt where tempRowNumber > {2}";
    public static final String MYSQL_ALLTABLES_SQL = "select distinct table_name from information_schema.columns where table_schema = {0}";
    public static final String POSTGRE__ALLTABLES_SQL = "SELECT distinct c.relname AS  table_name FROM pg_class c";
    public static final String ORACLE__ALLTABLES_SQL = "select distinct colstable.table_name as  table_name from user_tab_cols colstable";
    public static final String SQLSERVER__ALLTABLES_SQL = "select distinct c.name as  table_name from sys.objects c";
    public static final String MYSQL_ALLCOLUMNS_SQL = "select column_name from information_schema.columns where table_name = {0} and table_schema = {1}";
    public static final String POSTGRE_ALLCOLUMNS_SQL = "select table_name from information_schema.columns where table_name = {0}";
    public static final String ORACLE_ALLCOLUMNS_SQL = "select column_name from all_tab_columns where table_name ={0}";
    public static final String SQLSERVER_ALLCOLUMNS_SQL = "select name from syscolumns where id={0}";

    public static String getFullSql(String sql, Map params) {
        StringBuilder sqlB = new StringBuilder();
        sqlB.append("SELECT t.* FROM ( ");
        sqlB.append(sql + " ");
        sqlB.append(") t ");
        if (params != null && params.size() >= 1) {
            sqlB.append("WHERE 1=1  ");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = String.valueOf(it.next());
                String value = String.valueOf(params.get(key));
                if (!oConvertUtils.isNotEmpty((Object)value)) continue;
                sqlB.append(" AND ");
                sqlB.append(" " + key + value);
            }
        }
        return sqlB.toString();
    }

    public static String getCountSql(String sql, Map params) {
        String querySql = SqlUtil.getFullSql(sql, params);
        querySql = "SELECT COUNT(*) COUNT FROM (" + querySql + ") t2";
        return querySql;
    }

    public static String jeecgCreatePageSql(String sql, Map params, int page, int rows) {
        String dbTypeUrl = "jdbc:mysql://127.0.0.1:3306/jeecg-boot?characterEncoding=UTF-8&useUnicode=true&useSSL=false";
        int beginNum = (page - 1) * rows;
        Object[] sqlParam = new String[]{sql, beginNum + "", rows + ""};
        if (dbTypeUrl.indexOf(DATABSE_TYPE_MYSQL) != -1) {
            sql = MessageFormat.format(MYSQL_SQL, sqlParam);
        } else if (dbTypeUrl.indexOf(DATABSE_TYPE_POSTGRE) != -1) {
            sql = MessageFormat.format(POSTGRE_SQL, sqlParam);
        } else {
            int beginIndex = (page - 1) * rows;
            int endIndex = beginIndex + rows;
            sqlParam[2] = Integer.toString(beginIndex);
            sqlParam[1] = Integer.toString(endIndex);
            if (dbTypeUrl.indexOf(DATABSE_TYPE_ORACLE) != -1) {
                sql = MessageFormat.format(ORACLE_SQL, sqlParam);
            } else if (dbTypeUrl.indexOf(DATABSE_TYPE_SQLSERVER) != -1) {
                sqlParam[0] = sql.substring(SqlUtil.getAfterSelectInsertPoint(sql));
                sql = MessageFormat.format(SQLSERVER_SQL, sqlParam);
            }
        }
        return sql;
    }

    public static String jeecgCreatePageSql(String dbTypeUrl, String dbKey, String sql, Map params, int page, int rows) {
        sql = SqlUtil.getFullSql(sql, params);
        int beginNum = (page - 1) * rows;
        Object[] sqlParam = new String[]{sql, beginNum + "", rows + ""};
        String databaseType = "";
        if (DATABSE_TYPE_MYSQL.equalsIgnoreCase(databaseType)) {
            sql = MessageFormat.format(MYSQL_SQL, sqlParam);
        } else if (DATABSE_TYPE_POSTGRE.equalsIgnoreCase(databaseType)) {
            sql = MessageFormat.format(POSTGRE_SQL, sqlParam);
        } else {
            int beginIndex = (page - 1) * rows;
            int endIndex = beginIndex + rows;
            sqlParam[2] = Integer.toString(beginIndex);
            sqlParam[1] = Integer.toString(endIndex);
            if (DATABSE_TYPE_ORACLE.equalsIgnoreCase(databaseType)) {
                sql = MessageFormat.format(ORACLE_SQL, sqlParam);
            } else if (DATABSE_TYPE_SQLSERVER.equalsIgnoreCase(databaseType)) {
                sqlParam[0] = sql.substring(SqlUtil.getAfterSelectInsertPoint(sql));
                sql = MessageFormat.format(SQLSERVER_SQL, sqlParam);
            }
        }
        return sql;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    public static String getAllTableSql(String dbType, String ... param) {
        if (oConvertUtils.isNotEmpty((Object)dbType)) {
            if (DATABSE_TYPE_MYSQL.equals(dbType)) {
                return MessageFormat.format(MYSQL_ALLTABLES_SQL, param);
            }
            if (DATABSE_TYPE_ORACLE.equals(dbType)) {
                return ORACLE__ALLTABLES_SQL;
            }
            if (DATABSE_TYPE_POSTGRE.equals(dbType)) {
                return POSTGRE__ALLTABLES_SQL;
            }
            if (DATABSE_TYPE_SQLSERVER.equals(dbType)) {
                return SQLSERVER__ALLTABLES_SQL;
            }
        }
        return null;
    }

    public static String getAllCloumnSql(String dbType, String ... param) {
        if (oConvertUtils.isNotEmpty((Object)dbType)) {
            if (DATABSE_TYPE_MYSQL.equals(dbType)) {
                return MessageFormat.format(MYSQL_ALLCOLUMNS_SQL, param);
            }
            if (DATABSE_TYPE_ORACLE.equals(dbType)) {
                return MessageFormat.format(ORACLE_ALLCOLUMNS_SQL, param);
            }
            if (DATABSE_TYPE_POSTGRE.equals(dbType)) {
                return MessageFormat.format(POSTGRE_ALLCOLUMNS_SQL, param);
            }
            if (DATABSE_TYPE_SQLSERVER.equals(dbType)) {
                return MessageFormat.format(SQLSERVER_ALLCOLUMNS_SQL, param);
            }
        }
        return null;
    }

    public static String getSql(String sql) {
        String whereParam;
        String regex = "\\$\\{\\w+\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            whereParam = m.group();
            sql = sql.replace(whereParam, "'' or 1=1 or 1=''");
            sql = sql.replace("'''", "''");
        }
        regex = "\\{\\w+\\}";
        p = Pattern.compile(regex);
        m = p.matcher(sql);
        while (m.find()) {
            whereParam = m.group();
            sql = sql.replace(whereParam, " 1=1 ");
        }
        return sql;
    }

    public static Map<String, Object> getParameterMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Iterator entries = properties.entrySet().iterator();
        String name = "";
        String value = "";
        Object valueObj = null;
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            valueObj = entry.getValue();
            if ("_t".equals(name) || null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }
}

