/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgreport.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgReportQueryParamUtil {
    private static final Logger log = LoggerFactory.getLogger(CgReportQueryParamUtil.class);

    public static void loadQueryParams(HttpServletRequest request, Map<String, Object> item, Map<String, Object> pageSearchFields, Map<String, Object> paramData) {
        String filedName = (String)item.get("field_name");
        String queryMode = (String)item.get("search_mode");
        String filedType = (String)item.get("field_type");
        if ("single".equals(queryMode)) {
            String value = request.getParameter(filedName.toLowerCase());
            try {
                if (oConvertUtils.isEmpty((Object)value)) {
                    return;
                }
                String uri = request.getQueryString();
                if (uri.contains(filedName + "=")) {
                    String contiansChinesevalue;
                    value = contiansChinesevalue = new String(value.getBytes("ISO-8859-1"), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), (Throwable)e);
                return;
            }
            if (oConvertUtils.isNotEmpty((Object)value)) {
                if (value.contains("*")) {
                    value = value.replaceAll("\\*", "%");
                    pageSearchFields.put(filedName, " LIKE :" + filedName);
                } else {
                    pageSearchFields.put(filedName, " = :" + filedName);
                }
            }
            paramData.put(filedName, CgReportQueryParamUtil.covertData(filedType, value, true));
        } else if ("group".equals(queryMode)) {
            String re;
            String begin = request.getParameter(filedName.toLowerCase() + "_begin");
            String end = request.getParameter(filedName.toLowerCase() + "_end");
            if (oConvertUtils.isNotEmpty((Object)begin)) {
                re = " >= :" + filedName + "_begin";
                pageSearchFields.put(filedName, re);
                paramData.put(filedName + "_begin", CgReportQueryParamUtil.covertData(filedType, begin, true));
            }
            if (oConvertUtils.isNotEmpty((Object)end)) {
                re = " <= :" + filedName + "_end";
                pageSearchFields.put(new String(filedName), re);
                paramData.put(filedName + "_end", CgReportQueryParamUtil.covertData(filedType, end, false));
            }
        }
    }

    private static Object covertData(String fieldType, String value, boolean isBegin) {
        Object obj = null;
        if (oConvertUtils.isNotEmpty((Object)value)) {
            if ("String".equalsIgnoreCase(fieldType)) {
                obj = value;
            } else if ("Date".equalsIgnoreCase(fieldType)) {
                if (value.length() != 19 && value.length() == 10) {
                    value = isBegin ? value + " 00:00:00" : value + " 23:59:59";
                }
                SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                obj = DateUtils.str2Date((String)value, (SimpleDateFormat)datetimeFormat);
            } else {
                obj = "Double".equalsIgnoreCase(fieldType) ? value : ("Integer".equalsIgnoreCase(fieldType) ? value : value);
            }
        }
        return obj;
    }

    public static String getJson(List<Map<String, Object>> result, Long size) {
        JSONObject main = new JSONObject();
        JSONArray rows = new JSONArray();
        main.put("total", (Object)size);
        if (result != null) {
            for (Map<String, Object> m : result) {
                JSONObject item = new JSONObject();
                for (String key : m.keySet()) {
                    String value = String.valueOf(m.get(key));
                    if ((key = key.toLowerCase()).contains("time") || key.contains("date")) {
                        value = CgReportQueryParamUtil.datatimeFormat(value);
                    }
                    item.put(key, (Object)value);
                }
                rows.add((Object)item);
            }
        }
        main.put("rows", (Object)rows);
        return main.toString();
    }

    public static String getJson(List<Map<String, Object>> result) {
        JSONArray rows = new JSONArray();
        for (Map<String, Object> m : result) {
            JSONObject item = new JSONObject();
            for (String key : m.keySet()) {
                String value = String.valueOf(m.get(key));
                if ((key = key.toLowerCase()).contains("time") || key.contains("date")) {
                    value = CgReportQueryParamUtil.datatimeFormat(value);
                }
                item.put(key, (Object)value);
            }
            rows.add((Object)item);
        }
        return rows.toString();
    }

    public static String datatimeFormat(String datetime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        SimpleDateFormat dateFormatTo = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d = null;
        try {
            d = dateFormat.parse(datetime);
            return dateFormatTo.format(d);
        }
        catch (Exception e) {
            return datetime;
        }
    }

    public static String getListQueryConditionSql(List<OnlCgreportItem> fieldList, Map<String, Object> params, String alias) {
        StringBuffer sb = new StringBuffer();
        for (OnlCgreportItem item : fieldList) {
            Object value_end;
            String field = item.getFieldName();
            String dbtype = item.getFieldType();
            if (1 != item.getIsSearch()) continue;
            if ("single".equals(item.getSearchMode())) {
                Object value = params.get(field);
                if (value == null) continue;
                String temp = QueryGenerator.getSingleQueryConditionSql((String)field, (String)alias, (Object)value, (!"Long".equals(dbtype) && !"Integer".equals(dbtype) ? 1 : 0) != 0);
                sb.append(" and " + temp);
                continue;
            }
            Object value_begin = params.get(field + "_begin");
            if (value_begin != null) {
                sb.append(" and " + alias + field + " >= ");
                if ("Long".equals(dbtype) || "Integer".equals(dbtype)) {
                    sb.append(value_begin.toString());
                } else {
                    sb.append("'" + value_begin.toString() + "'");
                }
            }
            if ((value_end = params.get(field + "_end")) == null) continue;
            sb.append(" and " + alias + field + " <= ");
            if ("Long".equals(dbtype) || "Integer".equals(dbtype)) {
                sb.append(value_end.toString());
                continue;
            }
            sb.append("'" + value_end.toString() + "'");
        }
        return sb.toString();
    }
}

