/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgreport.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgform.util.CgformUtil;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportHead;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportItem;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportParam;
import org.jeecg.modules.online.cgreport.mapper.OnlCgreportHeadMapper;
import org.jeecg.modules.online.cgreport.model.OnlCgreportModel;
import org.jeecg.modules.online.cgreport.service.IOnlCgreportHeadService;
import org.jeecg.modules.online.cgreport.service.IOnlCgreportItemService;
import org.jeecg.modules.online.cgreport.service.IOnlCgreportParamService;
import org.jeecg.modules.online.cgreport.util.CgReportQueryParamUtil;
import org.jeecg.modules.online.cgreport.util.SqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OnlCgreportHeadServiceImpl
extends ServiceImpl<OnlCgreportHeadMapper, OnlCgreportHead>
implements IOnlCgreportHeadService {
    private static final Logger log = LoggerFactory.getLogger(OnlCgreportHeadServiceImpl.class);
    @Autowired
    private IOnlCgreportParamService onlCgreportParamService;
    @Autowired
    private IOnlCgreportItemService onlCgreportItemService;
    @Autowired
    OnlCgreportHeadMapper mapper;

    @Override
    public Map<String, Object> executeSelectSql(String sql, Map<String, Object> params) {
        LambdaQueryWrapper paramQuery = new LambdaQueryWrapper();
        paramQuery.eq(OnlCgreportParam::getCgrheadId, (Object)params.get("onlCgreportHeadId").toString());
        List paramList = this.onlCgreportParamService.list((Wrapper)paramQuery);
        if (paramList != null && paramList.size() > 0) {
            for (OnlCgreportParam p : paramList) {
                Object value = params.get("self_" + p.getParamName());
                String valueStr = "";
                if (value != null) {
                    valueStr = value.toString();
                } else if (value == null && oConvertUtils.isNotEmpty((Object)p.getParamValue())) {
                    valueStr = p.getParamValue();
                }
                sql = sql.replace("${" + p.getParamName() + "}", valueStr);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Integer pageSize = oConvertUtils.getInt((Object)params.get("pageSize"), (int)10);
        Integer pageNo = oConvertUtils.getInt((Object)params.get("pageNo"), (int)1);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgreportItem::getCgrheadId, (Object)params.get("onlCgreportHeadId").toString());
        query.eq(OnlCgreportItem::getIsSearch, (Object)1);
        List fieldList = this.onlCgreportItemService.list((Wrapper)query);
        String alias = "jeecg_rp_temp.";
        String condition = CgReportQueryParamUtil.getListQueryConditionSql(fieldList, params, alias);
        String querySql = "select * from (" + sql + ") jeecg_rp_temp  where 1=1 " + condition;
        Object orderColumn = params.get("column");
        if (orderColumn != null) {
            querySql = querySql + " order by jeecg_rp_temp." + orderColumn.toString() + " " + params.get("order").toString();
        }
        log.info("\u62a5\u8868\u67e5\u8be2sql=>\r\n" + querySql);
        IPage<Map<String, Object>> pageList = this.mapper.selectPageBySql((Page<Map<String, Object>>)page, querySql);
        result.put("total", pageList.getTotal());
        result.put("records", CgformUtil.toLowerCasePageList(pageList.getRecords()));
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<?> editAll(OnlCgreportModel values) {
        OnlCgreportHead head = values.getHead();
        OnlCgreportHead onlCgreportHeadEntity = (OnlCgreportHead)super.getById((Serializable)((Object)head.getId()));
        if (onlCgreportHeadEntity == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        super.updateById((Object)head);
        List<OnlCgreportParam> params = values.getParams();
        List<OnlCgreportItem> items = values.getItems();
        ArrayList<OnlCgreportParam> addParam = new ArrayList<OnlCgreportParam>();
        ArrayList<OnlCgreportParam> editParam = new ArrayList<OnlCgreportParam>();
        for (OnlCgreportParam param : params) {
            String id = String.valueOf(param.getId());
            if (id.length() == 32) {
                editParam.add(param);
                continue;
            }
            param.setId(null);
            param.setCgrheadId(head.getId());
            addParam.add(param);
        }
        this.onlCgreportParamService.saveBatch(addParam);
        for (OnlCgreportParam edit : editParam) {
            this.onlCgreportParamService.updateById(edit);
        }
        ArrayList<OnlCgreportItem> addItem = new ArrayList<OnlCgreportItem>();
        ArrayList<OnlCgreportItem> editItem = new ArrayList<OnlCgreportItem>();
        for (OnlCgreportItem item : items) {
            String id = String.valueOf(item.getId());
            if (id.length() == 32) {
                editItem.add(item);
                continue;
            }
            item.setId(null);
            item.setCgrheadId(head.getId());
            addItem.add(item);
        }
        this.onlCgreportItemService.saveBatch(addItem);
        for (OnlCgreportItem edit : editItem) {
            this.onlCgreportItemService.updateById(edit);
        }
        this.onlCgreportParamService.removeByIds(values.getDeleteParamIdList());
        this.onlCgreportItemService.removeByIds(values.getDeleteItemIdList());
        return Result.ok((String)"\u5168\u90e8\u4fee\u6539\u6210\u529f");
    }

    @Override
    public List<String> getSqlFields(String sql, String dbKey) {
        List<String> fields = null;
        sql = SqlUtil.getSql(sql);
        fields = StringUtils.isNotBlank((String)dbKey) ? this.parseSql(sql, dbKey) : this.parseSql(sql, null);
        return fields;
    }

    @Override
    public List<String> getSqlParams(String sql) {
        if (oConvertUtils.isEmpty((Object)sql)) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        String regex = "\\$\\{\\w+\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            String whereParam = m.group();
            params.add(whereParam.substring(whereParam.indexOf("{") + 1, whereParam.indexOf("}")));
        }
        return params;
    }

    private List<String> parseSql(String sql, String dbKey) {
        if (oConvertUtils.isEmpty((Object)sql)) {
            return null;
        }
        int pageNo = 1;
        int pageSize = 1;
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage<Map<String, Object>> pageList = this.mapper.selectPageBySql((Page<Map<String, Object>>)page, sql);
        List result = pageList.getRecords();
        if (result.size() < 1) {
            throw new JeecgBootException("\u8be5\u62a5\u8868sql\u6ca1\u6709\u6570\u636e");
        }
        Set fieldsSet = ((Map)result.get(0)).keySet();
        ArrayList<String> fileds = new ArrayList<String>();
        for (String f : fieldsSet) {
            fileds.add(f.toLowerCase());
        }
        return fileds;
    }

    @Override
    public Map<String, Object> queryCgReportConfig(String reportId) {
        HashMap<String, Object> cgReportM = new HashMap<String, Object>(0);
        Map<String, Object> mainM = this.mapper.queryCgReportMainConfig(reportId);
        List<Map<String, Object>> itemsM = this.mapper.queryCgReportItems(reportId);
        List<String> params = this.mapper.queryCgReportParams(reportId);
        cgReportM.put("main", mainM);
        cgReportM.put("items", itemsM);
        cgReportM.put("params", params);
        return cgReportM;
    }

    @Override
    public List<Map<?, ?>> queryByCgReportSql(String sql, Map params, Map paramData, int pageNo, int pageSize) {
        String querySql = SqlUtil.getFullSql(sql, params);
        List<Map<?, ?>> result = null;
        if (paramData != null && paramData.size() == 0) {
            paramData = null;
        }
        if (pageNo == -1 && pageSize == -1) {
            result = this.mapper.executeSelete(querySql);
        } else {
            Page page = new Page((long)pageNo, (long)pageSize);
            IPage<Map<String, Object>> pageList = this.mapper.selectPageBySql((Page<Map<String, Object>>)page, querySql);
            if (pageList.getRecords() != null && pageList.getRecords().size() > 0) {
                result.addAll(pageList.getRecords());
            }
        }
        return result;
    }
}

