/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgreport.service.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.jeecg.modules.online.cgreport.service.CgReportExcelServiceI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cgReportExcelService")
public class CgReportExcelServiceImpl
implements CgReportExcelServiceI {
    private static final Logger log = LoggerFactory.getLogger(CgReportExcelServiceImpl.class);

    @Override
    public HSSFWorkbook exportExcel(String title, Collection<?> titleSet, Collection<?> dataSet) {
        HSSFWorkbook workbook = null;
        try {
            if (titleSet == null || titleSet.size() == 0) {
                throw new Exception("\u8bfb\u53d6\u8868\u5934\u5931\u8d25\uff01");
            }
            if (title == null) {
                title = "";
            }
            workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(title);
            int rindex = 0;
            int cindex = 0;
            Row row = sheet.createRow(rindex);
            row.setHeight((short)450);
            HSSFCellStyle titleStyle = this.getTitleStyle(workbook);
            List titleList = (List)titleSet;
            Iterator<?> itData = dataSet.iterator();
            for (Map titleM : titleList) {
                String titleContent = (String)titleM.get("field_txt");
                Cell cell = row.createCell(cindex);
                HSSFRichTextString text = new HSSFRichTextString(titleContent);
                cell.setCellValue((RichTextString)text);
                cell.setCellStyle((CellStyle)titleStyle);
                ++cindex;
            }
            HSSFCellStyle bodyStyle = this.getOneStyle(workbook);
            while (itData.hasNext()) {
                cindex = 0;
                row = sheet.createRow(++rindex);
                Map dataM = (Map)itData.next();
                for (Map titleM : titleList) {
                    String field = (String)titleM.get("field_name");
                    String content = dataM.get(field) == null ? "" : dataM.get(field).toString();
                    Cell cell = row.createCell(cindex);
                    HSSFRichTextString text = new HSSFRichTextString(content);
                    cell.setCellStyle((CellStyle)bodyStyle);
                    cell.setCellValue((RichTextString)text);
                    ++cindex;
                }
            }
            for (int i = 0; i < titleList.size(); ++i) {
                sheet.autoSizeColumn(i);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return workbook;
    }

    private HSSFCellStyle getTitleStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setBorderLeft((short)1);
        titleStyle.setBorderRight((short)1);
        titleStyle.setBorderBottom((short)1);
        titleStyle.setBorderTop((short)1);
        titleStyle.setAlignment((short)2);
        titleStyle.setFillForegroundColor((short)22);
        titleStyle.setFillPattern((short)1);
        return titleStyle;
    }

    private void setBlankRows(int rows, int columns, HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheetAt(0);
        HSSFCellStyle cellStyle = this.getOneStyle(workbook);
        for (int i = 1; i <= rows; ++i) {
            Row row = sheet.createRow(i);
            for (int j = 0; j < columns; ++j) {
                row.createCell(j).setCellStyle((CellStyle)cellStyle);
            }
        }
    }

    private HSSFCellStyle getTwoStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setFillForegroundColor((short)41);
        style.setFillPattern((short)1);
        return style;
    }

    private HSSFCellStyle getOneStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        return style;
    }
}

