/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgreport.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportHead;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportItem;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportParam;
import org.jeecg.modules.online.cgreport.model.OnlCgreportModel;
import org.jeecg.modules.online.cgreport.service.IOnlCgreportHeadService;
import org.jeecg.modules.online.cgreport.service.IOnlCgreportItemService;
import org.jeecg.modules.online.cgreport.service.IOnlCgreportParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/online/cgreport/head"})
public class OnlCgreportHeadController {
    private static final Logger log = LoggerFactory.getLogger(OnlCgreportHeadController.class);
    @Autowired
    private IOnlCgreportHeadService onlCgreportHeadService;
    @Autowired
    private IOnlCgreportParamService onlCgreportParamService;
    @Autowired
    private IOnlCgreportItemService onlCgreportItemService;

    @GetMapping(value={"/parseSql"})
    public Result<?> parseSql(@RequestParam(name="sql", required=true) String sql) {
        HashMap resultJson = new HashMap();
        ArrayList<OnlCgreportItem> onlCgreportItemList = new ArrayList<OnlCgreportItem>();
        ArrayList<OnlCgreportParam> onlCgreportParamList = new ArrayList<OnlCgreportParam>();
        List<String> fields = null;
        List<String> params = null;
        String dbKey = null;
        try {
            fields = this.onlCgreportHeadService.getSqlFields(sql, dbKey);
            params = this.onlCgreportHeadService.getSqlParams(sql);
            int i = 1;
            for (String f : fields) {
                OnlCgreportItem t = new OnlCgreportItem();
                t.setFieldName(f);
                t.setFieldTxt(f);
                t.setIsShow(1);
                t.setOrderNum(i);
                t.setId(i + "_" + System.currentTimeMillis());
                t.setFieldType("String");
                onlCgreportItemList.add(t);
                ++i;
            }
            for (String p : params) {
                OnlCgreportParam param = new OnlCgreportParam();
                param.setParamName(p);
                param.setParamTxt(p);
                onlCgreportParamList.add(param);
            }
            resultJson.put("fields", onlCgreportItemList);
            resultJson.put("params", onlCgreportParamList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String msg = "\u89e3\u6790\u5931\u8d25!<br><br>\u5931\u8d25\u539f\u56e0\uff1a";
            int i = e.getMessage().indexOf("Connection refused: connect");
            msg = i != -1 ? msg + "\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25." : msg + "SQL\u8bed\u6cd5\u9519\u8bef.";
            Result.error((String)msg);
        }
        return Result.ok(resultJson);
    }

    @GetMapping(value={"/list"})
    public Result<IPage<OnlCgreportHead>> queryPageList(OnlCgreportHead onlCgreportHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)onlCgreportHead, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.onlCgreportHeadService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody OnlCgreportModel values) {
        Result result = new Result();
        try {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            OnlCgreportHead head = values.getHead();
            List<OnlCgreportParam> params = values.getParams();
            List<OnlCgreportItem> items = values.getItems();
            head.setId(uuid);
            for (OnlCgreportParam param : params) {
                param.setId(null);
                param.setCgrheadId(uuid);
            }
            for (OnlCgreportItem item : items) {
                item.setId(null);
                item.setCgrheadId(uuid);
            }
            this.onlCgreportHeadService.save(head);
            this.onlCgreportParamService.saveBatch(params);
            this.onlCgreportItemService.saveBatch(items);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @PutMapping(value={"/editAll"})
    public Result<?> editAll(@RequestBody OnlCgreportModel values) {
        try {
            return this.onlCgreportHeadService.editAll(values);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @PutMapping(value={"/edit"})
    public Result<OnlCgreportHead> edit(@RequestBody OnlCgreportHead onlCgreportHead) {
        Result result = new Result();
        OnlCgreportHead onlCgreportHeadEntity = (OnlCgreportHead)this.onlCgreportHeadService.getById((Serializable)((Object)onlCgreportHead.getId()));
        if (onlCgreportHeadEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.onlCgreportHeadService.updateById(onlCgreportHead);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/delete"})
    public Result<OnlCgreportHead> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        OnlCgreportHead onlCgreportHead = (OnlCgreportHead)this.onlCgreportHeadService.getById((Serializable)((Object)id));
        if (onlCgreportHead == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.onlCgreportHeadService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<OnlCgreportHead> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.onlCgreportHeadService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @GetMapping(value={"/queryById"})
    public Result<OnlCgreportHead> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        OnlCgreportHead onlCgreportHead = (OnlCgreportHead)this.onlCgreportHeadService.getById((Serializable)((Object)id));
        if (onlCgreportHead == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)onlCgreportHead);
            result.setSuccess(true);
        }
        return result;
    }
}

