/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgreport.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.util.BrowserUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportHead;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportItem;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportParam;
import org.jeecg.modules.online.cgreport.service.IOnlCgreportHeadService;
import org.jeecg.modules.online.cgreport.service.IOnlCgreportItemService;
import org.jeecg.modules.online.cgreport.service.IOnlCgreportParamService;
import org.jeecg.modules.online.cgreport.util.CgReportQueryParamUtil;
import org.jeecg.modules.online.cgreport.util.SqlUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/online/cgreport/api"})
public class OnlCgreportAPI {
    private static final Logger log = LoggerFactory.getLogger(OnlCgreportAPI.class);
    @Autowired
    private IOnlCgreportHeadService onlCgreportHeadService;
    @Autowired
    private IOnlCgreportItemService onlCgreportItemService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private IOnlCgreportParamService onlCgreportParamService;

    @GetMapping(value={"/getColumns/{code}"})
    public Result<?> getColumns(@PathVariable(value="code") String code) {
        OnlCgreportHead head = (OnlCgreportHead)this.onlCgreportHeadService.getById((Serializable)((Object)code));
        if (head == null) {
            return Result.error((String)"\u5b9e\u4f53\u4e0d\u5b58\u5728");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"cgrhead_id", (Object)code);
        queryWrapper.eq((Object)"is_show", (Object)1);
        queryWrapper.orderByAsc((Object[])new String[]{"order_num"});
        List list = this.onlCgreportItemService.list((Wrapper)queryWrapper);
        ArrayList array = new ArrayList();
        HashMap<String, List> dictOptions = new HashMap<String, List>();
        for (OnlCgreportItem item : list) {
            HashMap<String, String> column = new HashMap<String, String>(3);
            column.put("title", item.getFieldTxt());
            column.put("dataIndex", item.getFieldName());
            column.put("align", "center");
            column.put("sorter", "true");
            array.add(column);
            String dictCode = item.getDictCode();
            if (!oConvertUtils.isNotEmpty((Object)dictCode)) continue;
            List ls = this.sysBaseAPI.queryDictItemsByCode(dictCode);
            dictOptions.put(item.getFieldName(), ls);
            column.put("customRender", item.getFieldName());
        }
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("columns", array);
        result.put("dictOptions", dictOptions);
        result.put("cgreportHeadName", head.getName());
        return Result.ok(result);
    }

    @GetMapping(value={"/getData/{code}"})
    public Result<?> getData(@PathVariable(value="code") String code, HttpServletRequest request) {
        OnlCgreportHead head = (OnlCgreportHead)this.onlCgreportHeadService.getById((Serializable)((Object)code));
        if (head == null) {
            return Result.error((String)"\u5b9e\u4f53\u4e0d\u5b58\u5728");
        }
        String sql = head.getCgrSql();
        try {
            Map<String, Object> params = SqlUtil.getParameterMap(request);
            params.put("onlCgreportHeadId", head.getId());
            Map<String, Object> reslutMap = this.onlCgreportHeadService.executeSelectSql(sql, params);
            return Result.ok(reslutMap);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("SQL\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @GetMapping(value={"/getQueryInfo/{code}"})
    public Result<?> getQueryInfo(@PathVariable(value="code") String cgrheadId) {
        try {
            List<Map<String, String>> list = this.onlCgreportItemService.getAutoListQueryInfo(cgrheadId);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @GetMapping(value={"/getParamsInfo/{code}"})
    public Result<?> getParamsInfo(@PathVariable(value="code") String cgrheadId) {
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(OnlCgreportParam::getCgrheadId, (Object)cgrheadId);
            List list = this.onlCgreportParamService.list((Wrapper)query);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/exportXls/{reportId}"})
    public void exportXls(@PathVariable(value="reportId") String reportId, HttpServletRequest request, HttpServletResponse response) {
        String codedFileName = "\u62a5\u8868";
        String sheetName = "\u5bfc\u51fa\u4fe1\u606f";
        if (oConvertUtils.isNotEmpty((Object)reportId)) {
            Map<String, Object> cgReportMap = null;
            try {
                cgReportMap = this.onlCgreportHeadService.queryCgReportConfig(reportId);
            }
            catch (Exception e) {
                throw new JeecgBootException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
            }
            List fieldList = (List)cgReportMap.get("items");
            Map configM = (Map)cgReportMap.get("main");
            codedFileName = configM.get("name") + codedFileName;
            String querySql = (String)configM.get("cgreport_sql");
            List items = (List)cgReportMap.get("items");
            List paramList = (List)cgReportMap.get("params");
            LinkedHashMap<String, Object> pageSearchFields = new LinkedHashMap<String, Object>();
            HashMap<String, Object> paramData = new HashMap<String, Object>();
            if (paramList != null && paramList.size() > 0) {
                for (String param : paramList) {
                    String value = request.getParameter(param);
                    value = value == null ? "" : value;
                    querySql = querySql.replace("'${" + param + "}'", ":" + param);
                    querySql = querySql.replace("${" + param + "}", ":" + param);
                    paramData.put(param, value);
                }
            }
            for (Map item : items) {
                String isQuery = item.get("search_flag").toString();
                if (!"Y".equalsIgnoreCase(isQuery)) continue;
                CgReportQueryParamUtil.loadQueryParams(request, item, pageSearchFields, paramData);
            }
            String dbKey = (String)configM.get("db_source");
            List<Map<?, ?>> result = null;
            if (oConvertUtils.isNotEmpty((Object)dbKey)) {
                if (paramData != null && paramData.size() > 0) {
                    // empty if block
                }
            } else {
                result = this.onlCgreportHeadService.queryByCgReportSql(querySql, pageSearchFields, paramData, -1, -1);
            }
            ArrayList<ExcelExportEntity> entityList = new ArrayList<ExcelExportEntity>();
            for (int i = 0; i < fieldList.size(); ++i) {
                Object replace_val;
                if (!"1".equals(oConvertUtils.getString(((Map)fieldList.get(i)).get("is_show")))) continue;
                ExcelExportEntity expEntity = new ExcelExportEntity(((Map)fieldList.get(i)).get("field_txt").toString(), ((Map)fieldList.get(i)).get("field_name"), 15);
                Object dictCode = ((Map)fieldList.get(i)).get("dict_code");
                if (oConvertUtils.isNotEmpty(dictCode)) {
                    ArrayList<String> dictReplaces = new ArrayList<String>();
                    List dictList = this.sysBaseAPI.queryDictItemsByCode(dictCode.toString());
                    for (DictModel d : dictList) {
                        dictReplaces.add(d.getText() + "_" + d.getValue());
                    }
                    expEntity.setReplace(dictReplaces.toArray(new String[dictReplaces.size()]));
                }
                if (oConvertUtils.isNotEmpty(replace_val = ((Map)fieldList.get(i)).get("replace_val"))) {
                    expEntity.setReplace(replace_val.toString().split(","));
                }
                entityList.add(expEntity);
            }
            response.setContentType("application/vnd.ms-excel");
            OutputStream fOut = null;
            try {
                String browse = BrowserUtils.checkBrowse((HttpServletRequest)request);
                if ("MSIE".equalsIgnoreCase(browse.substring(0, 4))) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(null, sheetName), entityList, result);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (Exception exception) {}
            }
        } else {
            throw new JeecgBootException("\u53c2\u6570\u9519\u8bef");
        }
    }

    @GetMapping(value={"/getRpColumns/{code}"})
    public Result<?> getRpColumns(@PathVariable(value="code") String code) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgreportHead::getCode, (Object)code);
        OnlCgreportHead head = (OnlCgreportHead)this.onlCgreportHeadService.getOne((Wrapper)query);
        if (head == null) {
            return Result.error((String)"\u5b9e\u4f53\u4e0d\u5b58\u5728");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"cgrhead_id", (Object)head.getId());
        queryWrapper.eq((Object)"is_show", (Object)1);
        queryWrapper.orderByAsc((Object[])new String[]{"order_num"});
        List list = this.onlCgreportItemService.list((Wrapper)queryWrapper);
        ArrayList array = new ArrayList();
        HashMap<String, List> dictOptions = new HashMap<String, List>();
        for (OnlCgreportItem item : list) {
            String dictCode;
            HashMap<String, String> column = new HashMap<String, String>(3);
            column.put("title", item.getFieldTxt());
            column.put("dataIndex", item.getFieldName());
            column.put("align", "center");
            String dbtype = item.getFieldType();
            if ("Integer".equals(dbtype) || "Date".equals(dbtype) || "Long".equals(dbtype)) {
                column.put("sorter", "true");
            }
            if (oConvertUtils.isNotEmpty((Object)(dictCode = item.getDictCode()))) {
                List ls = this.sysBaseAPI.queryDictItemsByCode(dictCode);
                dictOptions.put(item.getFieldName(), ls);
                column.put("customRender", item.getFieldName());
            }
            array.add(column);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("columns", array);
        result.put("dictOptions", dictOptions);
        result.put("cgRpConfigId", head.getId());
        result.put("cgRpConfigName", head.getName());
        return Result.ok(result);
    }
}

