/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgform.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Map;
import org.jeecg.modules.online.cgform.entity.OnlCgformField;

public class OnlineDbHandler {
    public static final String NUM_TYPE_INT = "int";
    public static final String NUM_TYPE_INTEGER = "Integer";
    public static final String NUM_TYPE_DOUBLE = "double";
    public static final String NUM_TYPE_DECIMAL = "BigDecimal";
    public static final String DATE_TYPE = "Date";

    public static boolean isNumField(String dbtype) {
        return NUM_TYPE_INT.equals(dbtype) || NUM_TYPE_DOUBLE.equals(dbtype) || NUM_TYPE_DECIMAL.equals(dbtype) || NUM_TYPE_INTEGER.equals(dbtype);
    }

    public static String initMybatisValueWithJdbcType(String dataBase, OnlCgformField item, JSONObject json, Map<String, Object> params) {
        String dbType = item.getDbType();
        String field = item.getDbFieldName();
        String pageType = item.getFieldShowType();
        if (NUM_TYPE_INT.equals(dbType)) {
            params.put(field, json.getIntValue(field));
            return "#{" + field + ",jdbcType=INTEGER}";
        }
        if (NUM_TYPE_DOUBLE.equals(dbType)) {
            params.put(field, json.getDoubleValue(field));
            return "#{" + field + ",jdbcType=DOUBLE}";
        }
        if (NUM_TYPE_DECIMAL.equals(dbType)) {
            params.put(field, new BigDecimal(json.getString(field)));
            return "#{" + field + ",jdbcType=DECIMAL}";
        }
        if (DATE_TYPE.equals(dbType)) {
            String fieldVal = json.getString(field);
            if ("ORACLE".equals(dataBase)) {
                if ("date".equals(pageType)) {
                    params.put(field, fieldVal.length() > 10 ? fieldVal.substring(0, 10) : fieldVal);
                    return "to_date(#{" + field + "},'yyyy-MM-dd')";
                }
                params.put(field, fieldVal.length() == 10 ? json.getString(field) + " 00:00:00" : fieldVal);
                return "to_date(#{" + field + "},'yyyy-MM-dd HH24:mi:ss')";
            }
            params.put(field, json.getString(field));
            return "#{" + field + "}";
        }
        params.put(field, json.getString(field));
        return "#{" + field + ",jdbcType=VARCHAR}";
    }
}

