/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgform.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.jsonschema.JsonSchemaDescrip;
import org.jeecg.common.util.jsonschema.JsonschemaUtil;
import org.jeecg.common.util.jsonschema.validate.DictProperty;
import org.jeecg.common.util.jsonschema.validate.NumberProperty;
import org.jeecg.common.util.jsonschema.validate.PopupProperty;
import org.jeecg.common.util.jsonschema.validate.StringProperty;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgform.entity.OnlCgformButton;
import org.jeecg.modules.online.cgform.entity.OnlCgformEnhanceJava;
import org.jeecg.modules.online.cgform.entity.OnlCgformEnhanceJs;
import org.jeecg.modules.online.cgform.entity.OnlCgformField;
import org.jeecg.modules.online.cgform.entity.OnlCgformHead;
import org.jeecg.modules.online.cgform.entity.OnlCgformIndex;
import org.jeecg.modules.online.cgform.util.OnlineDbHandler;
import org.jeecg.modules.online.config.exception.DBException;
import org.jeecg.modules.online.config.util.DbTableUtil;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgformUtil {
    private static final Logger log = LoggerFactory.getLogger(CgformUtil.class);
    public static final String SQL_SELECT = "SELECT ";
    public static final String SQL_FROM = " FROM ";
    public static final String SQL_AND = " AND ";
    public static final String SQL_COUNT = " COUNT(*) ";
    public static final String SQL_WHERE_TRUE = " where 1=1  ";
    public static final String SQL_ORDER = " ORDER BY ";
    public static final String SQL_ASC = "asc";
    public static final String SQL_DESC = "desc";
    public static final String SQL_EQ = "=";
    public static final String SQL_GE = ">=";
    public static final String SQL_LE = "<=";
    public static final String CREATE_TIME = "CREATE_TIME";
    public static final String CREATE_BY = "CREATE_BY";
    public static final String UPDATE_TIME = "UPDATE_TIME";
    public static final String UPDATE_BY = "UPDATE_BY";
    public static final String SYS_ORG_CODE = "SYS_ORG_CODE";
    public static final int QUERY_FIELD_SHOW_NUM = 2;
    public static final String SQL_SQ = "'";
    public static final String SQL_COMMA = ",";
    public static final String QUERY_MODE_SINGLE = "single";
    public static final String P_KEY = "id";
    public static final String YES = "1";
    public static final String SYNC_FORCE = "force";
    public static final String SYNC_NORMAL = "normal";
    private static final String enhanceJsButtonCode = "beforeAdd,beforeEdit,afterAdd,afterEdit,beforeDelete,afterDelete,mounted,created";

    public static void getAutoListBaseSql(String tbname, List<OnlCgformField> fieldList, StringBuffer sb) {
        sb.append(SQL_SELECT);
        int size = fieldList.size();
        boolean has = false;
        for (int i = 0; i < size; ++i) {
            OnlCgformField item = fieldList.get(i);
            if (P_KEY.equals(item.getDbFieldName())) {
                has = true;
            }
            if (i == size - 1) {
                sb.append(item.getDbFieldName() + " ");
                continue;
            }
            sb.append(item.getDbFieldName() + SQL_COMMA);
        }
        if (!has) {
            sb.append(",id");
        }
        sb.append(SQL_FROM + tbname);
    }

    public static String getAutoListConditionSql(List<OnlCgformField> fieldList, Map<String, Object> params) {
        StringBuffer sb = new StringBuffer();
        String dataBase = "";
        try {
            dataBase = DbTableUtil.getDatabaseType();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        Map ruleMap = QueryGenerator.getRuleMap();
        for (String c : ruleMap.keySet()) {
            if (!oConvertUtils.isNotEmpty((Object)c) || !c.startsWith("SQL_RULES_COLUMN")) continue;
            sb.append(" AND (" + QueryGenerator.getSqlRuleValue((String)((SysPermissionDataRule)ruleMap.get(c)).getRuleValue()) + ")");
        }
        for (OnlCgformField item : fieldList) {
            Object value_end;
            String field = item.getDbFieldName();
            String dbtype = item.getDbType();
            if (ruleMap.containsKey(field)) {
                CgformUtil.addRuleToStringBuffer((SysPermissionDataRule)ruleMap.get(field), field, dbtype, sb);
            }
            if (ruleMap.containsKey(oConvertUtils.camelNames((String)field))) {
                CgformUtil.addRuleToStringBuffer((SysPermissionDataRule)ruleMap.get(field), field, dbtype, sb);
            }
            if (1 != item.getIsQuery()) continue;
            if (QUERY_MODE_SINGLE.equals(item.getQueryMode())) {
                Object value = params.get(field);
                if (value == null) continue;
                if ("ORACLE".equals(dataBase)) {
                    sb.append(SQL_AND + field + SQL_EQ + " to_date('" + value.toString() + "','yyyy-MM-dd HH24:mi:ss')");
                    continue;
                }
                boolean isString = !OnlineDbHandler.isNumField(dbtype);
                String fieldCondition = QueryGenerator.getSingleQueryConditionSql((String)field, (String)"", (Object)value, (boolean)isString);
                sb.append(SQL_AND + fieldCondition);
                continue;
            }
            Object value_begin = params.get(field + "_begin");
            if (value_begin != null) {
                sb.append(SQL_AND + field + SQL_GE);
                if (OnlineDbHandler.isNumField(dbtype)) {
                    sb.append(value_begin.toString());
                } else if ("ORACLE".equals(dataBase)) {
                    sb.append(" to_date('" + value_begin.toString() + "','yyyy-MM-dd HH24:mi:ss')");
                } else {
                    sb.append(SQL_SQ + value_begin.toString() + SQL_SQ);
                }
            }
            if ((value_end = params.get(field + "_end")) == null) continue;
            sb.append(SQL_AND + field + SQL_LE);
            if (OnlineDbHandler.isNumField(dbtype)) {
                sb.append(value_end.toString());
                continue;
            }
            if ("ORACLE".equals(dataBase)) {
                sb.append(" to_date('" + value_end.toString() + "','yyyy-MM-dd HH24:mi:ss')");
                continue;
            }
            sb.append(SQL_SQ + value_end.toString() + SQL_SQ);
        }
        return sb.toString();
    }

    public static Map<String, Object> getParameterMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Iterator entries = properties.entrySet().iterator();
        String name = "";
        String value = "";
        Object valueObj = null;
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            valueObj = entry.getValue();
            if ("_t".equals(name) || null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + SQL_COMMA;
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }

    public static JSONObject getJsonSchemaByCgformFieldList(List<OnlCgformField> fieldList, List<String> disabledFieldNameList) {
        JsonSchemaDescrip descrip;
        JSONObject json = new JSONObject();
        ArrayList<String> required = new ArrayList<String>();
        ArrayList<NumberProperty> props = new ArrayList<NumberProperty>();
        ISysBaseAPI sysBaseAPI = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        for (OnlCgformField item : fieldList) {
            String field = item.getDbFieldName();
            if (P_KEY.equals(field)) continue;
            String title = item.getDbFieldTxt();
            if (YES.equals(item.getFieldMustInput())) {
                required.add(field);
            }
            String filedShowType = item.getFieldShowType();
            Object prop = null;
            if (OnlineDbHandler.isNumField(item.getDbType())) {
                prop = new NumberProperty(field, title, "number");
            } else if ("list,radio,checkbox,list_multi".indexOf(filedShowType) >= 0) {
                List include = new ArrayList();
                if (oConvertUtils.isNotEmpty((Object)item.getDictTable())) {
                    include = sysBaseAPI.queryTableDictItemsByCode(item.getDictTable(), item.getDictText(), item.getDictField());
                } else if ("sel_search".equals(filedShowType)) {
                    prop = new DictProperty(field, title, item.getDictTable(), item.getDictField(), item.getDictText());
                } else if (oConvertUtils.isNotEmpty((Object)item.getDictField())) {
                    include = sysBaseAPI.queryDictItemsByCode(item.getDictField());
                }
                prop = new StringProperty(field, title, filedShowType, item.getDbLength(), include);
            } else {
                prop = "popup".equals(filedShowType) ? new PopupProperty(field, title, item.getDictTable(), item.getDictText(), item.getDictField()) : new StringProperty(field, title, filedShowType, item.getDbLength());
            }
            if (disabledFieldNameList.indexOf(field) >= 0) {
                prop.setDisabled(true);
            }
            prop.setOrder(item.getOrderNum());
            props.add((NumberProperty)prop);
        }
        if (required.size() > 0) {
            descrip = new JsonSchemaDescrip(required);
            json = JsonschemaUtil.getJsonSchema((JsonSchemaDescrip)descrip, props);
        } else {
            descrip = new JsonSchemaDescrip();
            json = JsonschemaUtil.getJsonSchema((JsonSchemaDescrip)descrip, props);
        }
        return json;
    }

    public static JSONObject getSubJsonSchemaByCgformFieldList(String entityDescrib, List<OnlCgformField> fieldList) {
        JSONObject json = new JSONObject();
        ArrayList<String> required = new ArrayList<String>();
        ArrayList<NumberProperty> props = new ArrayList<NumberProperty>();
        ISysBaseAPI sysBaseAPI = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        for (OnlCgformField item : fieldList) {
            String field = item.getDbFieldName();
            if (P_KEY.equals(field)) continue;
            String title = item.getDbFieldTxt();
            if (YES.equals(item.getFieldMustInput())) {
                required.add(field);
            }
            String filedShowType = item.getFieldShowType();
            String dictCode = item.getDictField();
            NumberProperty prop = null;
            if (OnlineDbHandler.isNumField(item.getDbType())) {
                prop = new NumberProperty(field, title, "number");
            } else if ("list,radio,checkbox,list_multi".indexOf(filedShowType) >= 0) {
                List include = sysBaseAPI.queryDictItemsByCode(dictCode);
                prop = new StringProperty(field, title, filedShowType, item.getDbLength(), include);
            } else {
                prop = new StringProperty(field, title, filedShowType, item.getDbLength());
            }
            prop.setOrder(item.getOrderNum());
            props.add(prop);
        }
        json = JsonschemaUtil.getSubJsonSchema((String)entityDescrib, required, props);
        return json;
    }

    public static Map<String, Object> getFormDataSaveSql(String tbname, List<OnlCgformField> fieldList, JSONObject json) {
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        String dataBase = "";
        try {
            dataBase = DbTableUtil.getDatabaseType();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean hasKey = false;
        String keyFieldValue = null;
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser == null) {
            throw new JeecgBootException("online\u4fdd\u5b58\u8868\u5355\u6570\u636e\u5f02\u5e38:\u7cfb\u7edf\u672a\u627e\u5230\u5f53\u524d\u767b\u9646\u7528\u6237\u4fe1\u606f");
        }
        for (OnlCgformField item : fieldList) {
            String dbType;
            String key = item.getDbFieldName();
            if (null == key) {
                log.info("--------online\u4fdd\u5b58\u8868\u5355\u6570\u636e\u9047\u89c1\u7a7a\u540d\u79f0\u7684\u5b57\u6bb5------->>" + item.getId());
                continue;
            }
            CgformUtil.initSystemFileds(item, sysUser, json, CREATE_BY, CREATE_TIME, SYS_ORG_CODE);
            if (item.getIsShowForm() != 1 && oConvertUtils.isEmpty((Object)item.getMainField()) || json.get((Object)key) == null || "".equals(json.get((Object)key)) && (OnlineDbHandler.isNumField(dbType = item.getDbType()) || dbType.toLowerCase().indexOf("date") >= 0)) continue;
            if (P_KEY.equals(key.toLowerCase())) {
                hasKey = true;
                keyFieldValue = json.getString(key);
                continue;
            }
            sb1.append(SQL_COMMA + key);
            String sqlValue = OnlineDbHandler.initMybatisValueWithJdbcType(dataBase, item, json, params);
            sb2.append(SQL_COMMA + sqlValue);
        }
        if (hasKey) {
            if (oConvertUtils.isEmpty(keyFieldValue)) {
                keyFieldValue = UUIDGenerator.generate();
            }
        } else {
            keyFieldValue = UUIDGenerator.generate();
        }
        String sql = "insert into " + tbname + "(" + P_KEY + sb1.toString() + ") values(" + SQL_SQ + keyFieldValue + SQL_SQ + sb2.toString() + ")";
        params.put("execute_sql_string", sql);
        log.info("--\u52a8\u6001\u8868\u5355\u4fdd\u5b58sql-->" + sql);
        return params;
    }

    public static Map<String, Object> getFormDataEditSql(String tbname, List<OnlCgformField> fieldList, JSONObject json) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String dataBase = "";
        try {
            dataBase = DbTableUtil.getDatabaseType();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser == null) {
            throw new JeecgBootException("online\u4fee\u6539\u8868\u5355\u6570\u636e\u5f02\u5e38:\u7cfb\u7edf\u672a\u627e\u5230\u5f53\u524d\u767b\u9646\u7528\u6237\u4fe1\u606f");
        }
        for (OnlCgformField item : fieldList) {
            String dbType;
            String key = item.getDbFieldName();
            if (null == key) {
                log.info("--------online\u4fee\u6539\u8868\u5355\u6570\u636e\u9047\u89c1\u7a7a\u540d\u79f0\u7684\u5b57\u6bb5------->>" + item.getId());
                continue;
            }
            CgformUtil.initSystemFileds(item, sysUser, json, UPDATE_BY, UPDATE_TIME, SYS_ORG_CODE);
            if (item.getIsShowForm() != 1 || P_KEY.equals(key) || "".equals(json.get((Object)key)) && (OnlineDbHandler.isNumField(dbType = item.getDbType()) || dbType.toLowerCase().indexOf("date") >= 0)) continue;
            String sqlValue = OnlineDbHandler.initMybatisValueWithJdbcType(dataBase, item, json, params);
            sb.append(key + SQL_EQ + sqlValue + SQL_COMMA);
        }
        String condition = sb.toString();
        if (condition.endsWith(SQL_COMMA)) {
            condition = condition.substring(0, condition.length() - 1);
        }
        String sql = "update " + tbname + " set " + condition + SQL_WHERE_TRUE + SQL_AND + P_KEY + SQL_EQ + SQL_SQ + json.getString(P_KEY) + SQL_SQ;
        log.info("--\u52a8\u6001\u8868\u5355\u7f16\u8f91sql-->" + sql);
        params.put("execute_sql_string", sql);
        return params;
    }

    public static String getSelectFormSql(String tbname, List<OnlCgformField> fieldList, String id) {
        return CgformUtil.getSelectSubFormSql(tbname, fieldList, P_KEY, id);
    }

    public static String getSelectSubFormSql(String tbname, List<OnlCgformField> fieldList, String linkField, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append(SQL_SELECT);
        int size = fieldList.size();
        boolean has = false;
        for (int i = 0; i < size; ++i) {
            String key = fieldList.get(i).getDbFieldName();
            if (P_KEY.equals(key)) {
                has = true;
            }
            sb.append(key);
            if (size <= i + 1) continue;
            sb.append(SQL_COMMA);
        }
        if (!has) {
            sb.append(",id");
        }
        sb.append(SQL_FROM + tbname + SQL_WHERE_TRUE + SQL_AND + linkField + SQL_EQ + SQL_SQ + value + SQL_SQ);
        return sb.toString();
    }

    public static void initSystemFileds(OnlCgformField item, LoginUser sysUser, JSONObject json, String ... systemFields) {
        String key = item.getDbFieldName();
        boolean need = false;
        for (String field : systemFields) {
            if (!key.toUpperCase().equals(field)) continue;
            if (item.getIsShowForm() == 1) {
                if (json.get((Object)key) == null) {
                    need = true;
                }
            } else {
                item.setIsShowForm(1);
                need = true;
            }
            if (!need) break;
            switch (field) {
                case "CREATE_BY": {
                    json.put(key, (Object)sysUser.getUsername());
                    break;
                }
                case "CREATE_TIME": {
                    item.setFieldShowType("datetime");
                    json.put(key, (Object)DateUtils.formatDateTime());
                    break;
                }
                case "UPDATE_BY": {
                    json.put(key, (Object)sysUser.getUsername());
                    break;
                }
                case "UPDATE_TIME": {
                    item.setFieldShowType("datetime");
                    json.put(key, (Object)DateUtils.formatDateTime());
                    break;
                }
                case "SYS_ORG_CODE": {
                    json.put(key, (Object)sysUser.getOrgCode());
                    break;
                }
            }
            break;
        }
    }

    public static boolean compareValue(Object oldvalue, Object newvalue) {
        if (oConvertUtils.isEmpty((Object)oldvalue) && oConvertUtils.isEmpty((Object)newvalue)) {
            return true;
        }
        return oldvalue.equals(newvalue);
    }

    public static boolean databaseFieldIsChange(OnlCgformField oldColumn, OnlCgformField newColumn) {
        return !CgformUtil.compareValue(oldColumn.getDbFieldName(), newColumn.getDbFieldName()) || !CgformUtil.compareValue(oldColumn.getDbFieldTxt(), newColumn.getDbFieldTxt()) || !CgformUtil.compareValue(oldColumn.getDbLength(), newColumn.getDbLength()) || !CgformUtil.compareValue(oldColumn.getDbPointLength(), newColumn.getDbPointLength()) || !CgformUtil.compareValue(oldColumn.getDbType(), newColumn.getDbType()) || !CgformUtil.compareValue(oldColumn.getDbIsNull(), newColumn.getDbIsNull()) || !CgformUtil.compareValue(oldColumn.getDbIsKey(), newColumn.getDbIsKey()) || !CgformUtil.compareValue(oldColumn.getMainTable(), newColumn.getMainTable()) || !CgformUtil.compareValue(oldColumn.getMainField(), newColumn.getMainField()) || !CgformUtil.compareValue(oldColumn.getDbDefaultVal(), newColumn.getDbDefaultVal());
    }

    public static boolean databaseIndexIsChange(OnlCgformIndex oldIndex, OnlCgformIndex newIndex) {
        return !CgformUtil.compareValue(oldIndex.getIndexName(), newIndex.getIndexName()) || !CgformUtil.compareValue(oldIndex.getIndexField(), newIndex.getIndexField()) || !CgformUtil.compareValue(oldIndex.getIndexType(), newIndex.getIndexType());
    }

    public static boolean databaseTableIsChange(OnlCgformHead oldTable, OnlCgformHead newTable) {
        return !CgformUtil.compareValue(oldTable.getTableName(), newTable.getTableName()) || !CgformUtil.compareValue(oldTable.getTableTxt(), newTable.getTableTxt());
    }

    public static String getQueryListDataCondition(String tbname, List<OnlCgformField> fieldList, Map<String, Object> params) {
        StringBuffer sb = new StringBuffer();
        StringBuffer selectField = new StringBuffer();
        for (OnlCgformField item : fieldList) {
            Object endVal;
            String fieldCondition;
            boolean isString;
            String field = item.getDbFieldName();
            String dbtype = item.getDbType();
            if (item.getIsShowList() == 1) {
                selectField.append(SQL_COMMA + field);
            }
            if (oConvertUtils.isNotEmpty((Object)item.getMainField())) {
                isString = !OnlineDbHandler.isNumField(dbtype);
                fieldCondition = QueryGenerator.getSingleQueryConditionSql((String)field, (String)"", (Object)params.get(field), (boolean)isString);
                if (!"".equals(fieldCondition)) {
                    sb.append(SQL_AND + fieldCondition);
                }
            }
            if (item.getIsQuery() != 1) continue;
            if (QUERY_MODE_SINGLE.equals(item.getQueryMode())) {
                if (params.get(field) == null) continue;
                isString = !OnlineDbHandler.isNumField(dbtype);
                fieldCondition = QueryGenerator.getSingleQueryConditionSql((String)field, (String)"", (Object)params.get(field), (boolean)isString);
                if ("".equals(fieldCondition)) continue;
                sb.append(SQL_AND + fieldCondition);
                continue;
            }
            Object beginVal = params.get(field + "_begin");
            if (beginVal != null) {
                sb.append(SQL_AND + field + SQL_GE);
                if (OnlineDbHandler.isNumField(dbtype)) {
                    sb.append(beginVal.toString());
                } else {
                    sb.append(SQL_SQ + beginVal.toString() + SQL_SQ);
                }
            }
            if ((endVal = params.get(field + "_end")) == null) continue;
            sb.append(SQL_AND + field + SQL_GE);
            if (OnlineDbHandler.isNumField(dbtype)) {
                sb.append(endVal.toString());
                continue;
            }
            sb.append(SQL_SQ + endVal.toString() + SQL_SQ);
        }
        return "SELECT id" + selectField.toString() + SQL_FROM + tbname + SQL_WHERE_TRUE + sb.toString();
    }

    public static List<ExcelExportEntity> convertToExportEntity(List<OnlCgformField> lists, String pkField) {
        ArrayList<ExcelExportEntity> entityList = new ArrayList<ExcelExportEntity>();
        for (int i = 0; i < lists.size(); ++i) {
            int columnWidth;
            if (null != pkField && pkField.equals(lists.get(i).getDbFieldName()) || lists.get(i).getIsShowList() != 1) continue;
            ExcelExportEntity entity = new ExcelExportEntity(lists.get(i).getDbFieldTxt(), (Object)lists.get(i).getDbFieldName());
            int n = lists.get(i).getDbLength() == 0 ? 12 : (columnWidth = lists.get(i).getDbLength() > 30 ? 30 : lists.get(i).getDbLength());
            if (lists.get(i).getFieldShowType().equals("date")) {
                entity.setFormat("yyyy-MM-dd");
            } else if (lists.get(i).getFieldShowType().equals("datetime")) {
                entity.setFormat("yyyy-MM-dd HH:mm:ss");
            }
            entity.setWidth((double)columnWidth);
            entityList.add(entity);
        }
        return entityList;
    }

    public static boolean checkClassOrSpringBeanIsExist(OnlCgformEnhanceJava onlCgformEnhanceJava) {
        String cgJavaType = onlCgformEnhanceJava.getCgJavaType();
        String cgJavaValue = onlCgformEnhanceJava.getCgJavaValue();
        if (oConvertUtils.isNotEmpty((Object)cgJavaValue)) {
            try {
                Object obj;
                Class<?> clazz;
                if ("class".equals(cgJavaType) && ((clazz = Class.forName(cgJavaValue)) == null || clazz.newInstance() == null)) {
                    return false;
                }
                if ("spring".equals(cgJavaType) && (obj = SpringContextUtils.getBean((String)cgJavaValue)) == null) {
                    return false;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static void sortStringList(List<String> list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null || o2 == null) {
                    return -1;
                }
                if (o1.compareTo(o2) > 0) {
                    return 1;
                }
                if (o1.compareTo(o2) < 0) {
                    return -1;
                }
                if (o1.compareTo(o2) == 0) {
                    return 0;
                }
                return 0;
            }
        });
    }

    public static void sortStringList2(List<String> list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null || o2 == null) {
                    return -1;
                }
                if (o1.length() > o2.length()) {
                    return 1;
                }
                if (o1.length() < o2.length()) {
                    return -1;
                }
                if (o1.compareTo(o2) > 0) {
                    return 1;
                }
                if (o1.compareTo(o2) < 0) {
                    return -1;
                }
                if (o1.compareTo(o2) == 0) {
                    return 0;
                }
                return 0;
            }
        });
    }

    private static String converRuleValue(String value, boolean flag) {
        if (flag) {
            return SQL_SQ + QueryGenerator.converRuleValue((String)value) + SQL_SQ;
        }
        return QueryGenerator.converRuleValue((String)value);
    }

    private static void addRuleToStringBuffer(SysPermissionDataRule dataRule, String field, String dbtype, StringBuffer sb) {
        QueryRuleEnum rule = QueryRuleEnum.getByValue((String)dataRule.getRuleConditions());
        boolean isSq = !OnlineDbHandler.isNumField(dbtype);
        String value = CgformUtil.converRuleValue(dataRule.getRuleValue(), isSq);
        if (value == null || rule == null) {
            return;
        }
        switch (rule) {
            case GT: {
                sb.append(SQL_AND + field + " > " + value);
                break;
            }
            case GE: {
                sb.append(SQL_AND + field + SQL_GE + value);
                break;
            }
            case LT: {
                sb.append(SQL_AND + field + " > " + value);
                break;
            }
            case LE: {
                sb.append(SQL_AND + field + SQL_LE + value);
                break;
            }
            case EQ: {
                sb.append(SQL_AND + field + SQL_EQ + value);
                break;
            }
            case NE: {
                sb.append(SQL_AND + field + " <> " + value);
                break;
            }
            case IN: {
                sb.append(SQL_AND + field + " IN " + QueryGenerator.converRuleValue((String)value));
                break;
            }
            case LIKE: {
                sb.append(SQL_AND + field + " LIKE '%" + QueryGenerator.converRuleValue((String)value) + "%'");
                break;
            }
            case LEFT_LIKE: {
                sb.append(SQL_AND + field + " LIKE '%" + QueryGenerator.converRuleValue((String)value) + SQL_SQ);
                break;
            }
            case RIGHT_LIKE: {
                sb.append(SQL_AND + field + " LIKE '" + QueryGenerator.converRuleValue((String)value) + "%'");
                break;
            }
            default: {
                log.info("--\u67e5\u8be2\u89c4\u5219\u672a\u5339\u914d\u5230---");
            }
        }
    }

    public static String formateSQl(String sql, JSONObject json) {
        if (json == null) {
            return sql;
        }
        sql = sql.replace("#{UUID}", UUIDGenerator.generate());
        Set varParams = QueryGenerator.getSqlRuleParams((String)sql);
        for (String key : varParams) {
            sql = sql.replace("#{" + key + "}", json.getString(key));
        }
        return sql;
    }

    public static String overwriteJs(String enhanceJs, List<OnlCgformButton> cgButtonList) {
        enhanceJs = CgformUtil.overwriteJsByButtonStyle(enhanceJs, cgButtonList);
        for (String temp : enhanceJsButtonCode.split(SQL_COMMA)) {
            Matcher m;
            Pattern p;
            if ("beforeAdd,afterAdd,mounted,created".indexOf(temp) >= 0) {
                p = Pattern.compile("(" + temp + "\\s*\\(\\)\\s*\\{)");
                m = p.matcher(enhanceJs);
                if (!m.find()) continue;
                enhanceJs = enhanceJs.replace(m.group(0), temp + "(that){const getAction=this._getAction,postAction=this._postAction,deleteAction=this._deleteAction;");
                continue;
            }
            p = Pattern.compile("(" + temp + "\\s*\\(row\\)\\s*\\{)");
            m = p.matcher(enhanceJs);
            if (m.find()) {
                enhanceJs = enhanceJs.replace(m.group(0), temp + "(that,row){const getAction=this._getAction,postAction=this._postAction,deleteAction=this._deleteAction;");
                continue;
            }
            Pattern p2 = Pattern.compile("(" + temp + "\\s*\\(\\)\\s*\\{)");
            Matcher m2 = p2.matcher(enhanceJs);
            if (!m2.find()) continue;
            enhanceJs = enhanceJs.replace(m2.group(0), temp + "(that){const getAction=this._getAction,postAction=this._postAction,deleteAction=this._deleteAction;");
        }
        return CgformUtil.returnEnhanceJsClass(enhanceJs);
    }

    public static void overwriteJs(OnlCgformEnhanceJs onlCgformEnhanceJs, String tbname, List<OnlCgformField> fieldList) {
        if (onlCgformEnhanceJs == null || oConvertUtils.isEmpty((Object)onlCgformEnhanceJs.getCgJs())) {
            return;
        }
        String enhanceJs = onlCgformEnhanceJs.getCgJs();
        String onlChange = "onlChange";
        Pattern p = Pattern.compile("(" + tbname + "_" + onlChange + "\\s*\\(\\)\\s*\\{)");
        Matcher m = p.matcher(enhanceJs);
        if (m.find()) {
            enhanceJs = enhanceJs.replace(m.group(0), tbname + "_" + onlChange + "(){const getAction=this._getAction,postAction=this._postAction,deleteAction=this._deleteAction;");
            for (OnlCgformField field : fieldList) {
                Pattern p1 = Pattern.compile("(" + field.getDbFieldName() + "\\s*\\(\\))");
                Matcher m1 = p1.matcher(enhanceJs);
                if (!m1.find()) continue;
                enhanceJs = enhanceJs.replace(m1.group(0), field.getDbFieldName() + "(that,event)");
            }
        }
        onlCgformEnhanceJs.setCgJs(enhanceJs);
    }

    public static void overwriteJs(OnlCgformEnhanceJs onlCgformEnhanceJs, String tbname, List<OnlCgformField> fieldList, boolean isMain) {
        if (onlCgformEnhanceJs == null || oConvertUtils.isEmpty((Object)onlCgformEnhanceJs.getCgJs())) {
            return;
        }
        String enhanceJs = onlCgformEnhanceJs.getCgJs();
        String onlChange = "onlChange";
        Pattern p = Pattern.compile("([^_]" + onlChange + "\\s*\\(\\)\\s*\\{)");
        Matcher m = p.matcher(enhanceJs);
        if (m.find()) {
            enhanceJs = enhanceJs.replace(m.group(0), onlChange + "(){const getAction=this._getAction,postAction=this._postAction,deleteAction=this._deleteAction;");
            for (OnlCgformField field : fieldList) {
                Pattern p1 = Pattern.compile("(" + field.getDbFieldName() + "\\s*\\(\\))");
                Matcher m1 = p1.matcher(enhanceJs);
                if (!m1.find()) continue;
                enhanceJs = enhanceJs.replace(m1.group(0), field.getDbFieldName() + "(that,event)");
            }
        }
        onlCgformEnhanceJs.setCgJs(enhanceJs);
        CgformUtil.overwriteJs(onlCgformEnhanceJs, tbname, fieldList);
    }

    public static String returnEnhanceJsClass(String enhanceJs) {
        log.info("\u6700\u7ec8\u7684\u589e\u5f3aJS", (Object)enhanceJs);
        return "class OnlineEnhanceJs{constructor(getAction,postAction,deleteAction){this._getAction=getAction;this._postAction=postAction;this._deleteAction=deleteAction;}" + enhanceJs + "}";
    }

    public static String overwriteJsByButtonStyle(String enhanceJs, List<OnlCgformButton> cgButtonList) {
        if (cgButtonList != null) {
            for (OnlCgformButton button : cgButtonList) {
                Matcher m;
                Pattern p;
                String temp = button.getButtonCode();
                if ("link".equals(button.getButtonStyle())) {
                    p = Pattern.compile("(" + temp + "\\s*\\(row\\)\\s*\\{)");
                    m = p.matcher(enhanceJs);
                    if (m.find()) {
                        enhanceJs = enhanceJs.replace(m.group(0), temp + "(that,row){const getAction=this._getAction,postAction=this._postAction,deleteAction=this._deleteAction;");
                        continue;
                    }
                    Pattern p2 = Pattern.compile("(" + temp + "\\s*\\(\\)\\s*\\{)");
                    Matcher m2 = p2.matcher(enhanceJs);
                    if (!m2.find()) continue;
                    enhanceJs = enhanceJs.replace(m2.group(0), temp + "(that){const getAction=this._getAction,postAction=this._postAction,deleteAction=this._deleteAction;");
                    continue;
                }
                if (!"button".equals(button.getButtonStyle()) && !"form".equals(button.getButtonStyle()) || !(m = (p = Pattern.compile("(" + temp + "\\s*\\(\\)\\s*\\{)")).matcher(enhanceJs)).find()) continue;
                enhanceJs = enhanceJs.replace(m.group(0), temp + "(that){const getAction=this._getAction,postAction=this._postAction,deleteAction=this._deleteAction;");
            }
        }
        return enhanceJs;
    }

    public static JSONArray getJEditableTableColumnsJson(List<OnlCgformField> fieldList) {
        JSONArray array = new JSONArray();
        ISysBaseAPI sysBaseAPI = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        for (OnlCgformField item : fieldList) {
            String field = item.getDbFieldName();
            if (P_KEY.equals(field)) continue;
            JSONObject obj = new JSONObject();
            obj.put("title", (Object)item.getDbFieldTxt());
            obj.put("key", (Object)field);
            obj.put("width", (Object)"186px");
            obj.put("type", (Object)CgformUtil.getJEditableTableColumnsType(item));
            obj.put("defaultValue", (Object)item.getDbDefaultVal());
            obj.put("placeholder", (Object)("\u8bf7\u8f93\u5165" + item.getDbFieldTxt()));
            obj.put("validateRules", (Object)CgformUtil.getValidateRules(item));
            if ("list".equals(item.getFieldShowType())) {
                List include = new ArrayList();
                if (oConvertUtils.isNotEmpty((Object)item.getDictTable())) {
                    include = sysBaseAPI.queryTableDictItemsByCode(item.getDictTable(), item.getDictText(), item.getDictField());
                } else if (oConvertUtils.isNotEmpty((Object)item.getDictField())) {
                    include = sysBaseAPI.queryDictItemsByCode(item.getDictField());
                }
                obj.put("options", include);
            }
            array.add((Object)obj);
        }
        return array;
    }

    private static JSONArray getValidateRules(OnlCgformField item) {
        JSONArray array = new JSONArray();
        if (item.getDbIsNull() == 0 || YES.equals(item.getFieldMustInput())) {
            JSONObject json = new JSONObject();
            json.put("required", (Object)true);
            json.put("message", (Object)(item.getDbFieldTxt() + "\u4e0d\u80fd\u4e3a\u7a7a!"));
            array.add((Object)json);
        }
        if (oConvertUtils.isNotEmpty((Object)item.getFieldValidType())) {
            JSONObject json2 = new JSONObject();
            json2.put("pattern", (Object)item.getFieldValidType());
            json2.put("message", (Object)(item.getDbFieldTxt() + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
            array.add((Object)json2);
        }
        return array;
    }

    public static Map<String, Object> transLowerCaseMapKey(Map<String, Object> orgMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (orgMap == null || orgMap.isEmpty()) {
            return resultMap;
        }
        Set<String> keySet = orgMap.keySet();
        for (String key : keySet) {
            String newKey = key.toLowerCase();
            resultMap.put(newKey, orgMap.get(key));
        }
        return resultMap;
    }

    public static List<Map<String, Object>> toLowerCasePageList(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> select = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : list) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            Set<String> keySet = row.keySet();
            for (String key : keySet) {
                String newKey = key.toLowerCase();
                resultMap.put(newKey, row.get(key));
            }
            select.add(resultMap);
        }
        return select;
    }

    private static String getJEditableTableColumnsType(OnlCgformField item) {
        if ("checkbox".equals(item.getFieldShowType())) {
            return "checkbox";
        }
        if ("list".equals(item.getFieldShowType())) {
            return "select";
        }
        if ("datetime".equals(item.getFieldShowType())) {
            return "datetime";
        }
        if ("date".equals(item.getFieldShowType())) {
            return "date";
        }
        if ("int".equals(item.getDbType()) || "double".equals(item.getDbType()) || "BigDecimal".equals(item.getDbType())) {
            return "inputNumber";
        }
        return "input";
    }
}

