/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgform.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.hibernate.HibernateException;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.util.MyClassLoader;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgform.enhance.CgformEnhanceJavaInter;
import org.jeecg.modules.online.cgform.entity.OnlCgformButton;
import org.jeecg.modules.online.cgform.entity.OnlCgformEnhanceJava;
import org.jeecg.modules.online.cgform.entity.OnlCgformEnhanceJs;
import org.jeecg.modules.online.cgform.entity.OnlCgformEnhanceSql;
import org.jeecg.modules.online.cgform.entity.OnlCgformField;
import org.jeecg.modules.online.cgform.entity.OnlCgformHead;
import org.jeecg.modules.online.cgform.entity.OnlCgformIndex;
import org.jeecg.modules.online.cgform.mapper.OnlCgformButtonMapper;
import org.jeecg.modules.online.cgform.mapper.OnlCgformEnhanceJavaMapper;
import org.jeecg.modules.online.cgform.mapper.OnlCgformEnhanceJsMapper;
import org.jeecg.modules.online.cgform.mapper.OnlCgformEnhanceSqlMapper;
import org.jeecg.modules.online.cgform.mapper.OnlCgformHeadMapper;
import org.jeecg.modules.online.cgform.model.OnlCgformModel;
import org.jeecg.modules.online.cgform.model.OnlGenerateModel;
import org.jeecg.modules.online.cgform.service.IOnlCgformFieldService;
import org.jeecg.modules.online.cgform.service.IOnlCgformHeadService;
import org.jeecg.modules.online.cgform.service.IOnlCgformIndexService;
import org.jeecg.modules.online.cgform.util.CgformUtil;
import org.jeecg.modules.online.config.exception.BusinessException;
import org.jeecg.modules.online.config.exception.DBException;
import org.jeecg.modules.online.config.model.CgformConfigModel;
import org.jeecg.modules.online.config.model.DataBaseConfig;
import org.jeecg.modules.online.config.service.DbTableHandleI;
import org.jeecg.modules.online.config.util.DbTableProcess;
import org.jeecg.modules.online.config.util.DbTableUtil;
import org.jeecgframework.codegenerate.database.DbReadTableUtil;
import org.jeecgframework.codegenerate.generate.impl.CodeGenerateOne;
import org.jeecgframework.codegenerate.generate.impl.CodeGenerateOneToMany;
import org.jeecgframework.codegenerate.generate.pojo.ColumnVo;
import org.jeecgframework.codegenerate.generate.pojo.TableVo;
import org.jeecgframework.codegenerate.generate.pojo.onetomany.MainTableVo;
import org.jeecgframework.codegenerate.generate.pojo.onetomany.SubTableVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OnlCgformHeadServiceImpl
extends ServiceImpl<OnlCgformHeadMapper, OnlCgformHead>
implements IOnlCgformHeadService {
    private static final Logger log = LoggerFactory.getLogger(OnlCgformHeadServiceImpl.class);
    @Autowired
    private IOnlCgformFieldService fieldService;
    @Autowired
    private IOnlCgformIndexService indexService;
    @Resource
    private OnlCgformEnhanceJsMapper onlCgformEnhanceJsMapper;
    @Resource
    private OnlCgformButtonMapper onlCgformButtonMapper;
    @Resource
    private OnlCgformEnhanceJavaMapper onlCgformEnhanceJavaMapper;
    @Resource
    private OnlCgformEnhanceSqlMapper onlCgformEnhanceSqlMapper;
    @Autowired
    private DataBaseConfig dataBaseConfig;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<?> addAll(OnlCgformModel model) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        OnlCgformHead head = model.getHead();
        List<OnlCgformField> fields = model.getFields();
        List<OnlCgformIndex> indexs = model.getIndexs();
        head.setId(uuid);
        for (int i = 0; i < fields.size(); ++i) {
            OnlCgformField field = fields.get(i);
            field.setId(null);
            field.setCgformHeadId(uuid);
            if (field.getOrderNum() != null) continue;
            field.setOrderNum(i);
        }
        for (OnlCgformIndex index : indexs) {
            index.setId(null);
            index.setCgformHeadId(uuid);
        }
        head.setIsDbSynch("N");
        head.setTableVersion(1);
        super.save((Object)head);
        this.fieldService.saveBatch(fields);
        this.indexService.saveBatch(indexs);
        this.handleMainTableInfo(head, fields);
        return Result.ok((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<?> editAll(OnlCgformModel model) {
        Integer version;
        OnlCgformHead head = model.getHead();
        OnlCgformHead headEntity = (OnlCgformHead)super.getById((Serializable)((Object)head.getId()));
        if (headEntity == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        String isDbSync = headEntity.getIsDbSynch();
        if (CgformUtil.databaseTableIsChange(headEntity, head)) {
            isDbSync = "N";
        }
        if ((version = headEntity.getTableVersion()) == null) {
            version = 1;
        }
        version = version + 1;
        head.setTableVersion(version);
        List<OnlCgformField> fields = model.getFields();
        List<OnlCgformIndex> indexs = model.getIndexs();
        ArrayList<OnlCgformField> addFields = new ArrayList<OnlCgformField>();
        ArrayList<OnlCgformField> editFields = new ArrayList<OnlCgformField>();
        for (OnlCgformField onlCgformField : fields) {
            String string = String.valueOf(onlCgformField.getId());
            if (string.length() == 32) {
                editFields.add(onlCgformField);
                continue;
            }
            String primaryKey = "_pk";
            if (primaryKey.equals(string)) continue;
            onlCgformField.setId(null);
            onlCgformField.setCgformHeadId(head.getId());
            addFields.add(onlCgformField);
        }
        if (addFields.size() > 0) {
            isDbSync = "N";
        }
        int maxOrderNum = 0;
        for (OnlCgformField onlCgformField : editFields) {
            OnlCgformField dbField = (OnlCgformField)this.fieldService.getById((Serializable)((Object)onlCgformField.getId()));
            boolean ischange = CgformUtil.databaseFieldIsChange(dbField, onlCgformField);
            if (ischange) {
                isDbSync = "N";
            }
            if ((dbField.getOrderNum() == null ? 0 : dbField.getOrderNum()) > maxOrderNum) {
                maxOrderNum = dbField.getOrderNum();
            }
            this.fieldService.updateById(onlCgformField);
        }
        for (OnlCgformField onlCgformField : addFields) {
            if (onlCgformField.getOrderNum() == null) {
                onlCgformField.setOrderNum(++maxOrderNum);
            }
            this.fieldService.save(onlCgformField);
        }
        ArrayList<OnlCgformIndex> arrayList = new ArrayList<OnlCgformIndex>();
        ArrayList<OnlCgformIndex> arrayList2 = new ArrayList<OnlCgformIndex>();
        for (OnlCgformIndex index : indexs) {
            String id = String.valueOf(index.getId());
            if (id.length() == 32) {
                arrayList2.add(index);
                continue;
            }
            index.setId(null);
            index.setCgformHeadId(head.getId());
            arrayList.add(index);
        }
        if (arrayList.size() > 0) {
            isDbSync = "N";
        }
        this.indexService.saveBatch(arrayList);
        for (OnlCgformIndex index : arrayList2) {
            OnlCgformIndex dbIndex = (OnlCgformIndex)this.indexService.getById((Serializable)((Object)index.getId()));
            boolean ischange = CgformUtil.databaseIndexIsChange(dbIndex, index);
            if (ischange) {
                isDbSync = "N";
            }
            this.indexService.updateById(index);
        }
        if (model.getDeleteFieldIds().size() > 0) {
            this.fieldService.removeByIds(model.getDeleteFieldIds());
        }
        if (model.getDeleteIndexIds().size() > 0) {
            this.indexService.removeByIds(model.getDeleteIndexIds());
        }
        head.setIsDbSynch(isDbSync);
        super.updateById((Object)head);
        this.handleMainTableInfo(head, fields);
        return Result.ok((String)"\u5168\u90e8\u4fee\u6539\u6210\u529f");
    }

    @Override
    public void doDbSynch(String code, String synMethod) throws HibernateException, IOException, TemplateException, SQLException, DBException {
        OnlCgformHead onlCgformHead = (OnlCgformHead)this.getById((Serializable)((Object)code));
        if (onlCgformHead == null) {
            throw new DBException("\u5b9e\u4f53\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        String tbname = onlCgformHead.getTableName();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)code);
        query.orderByAsc((Object[])new SFunction[]{OnlCgformField::getOrderNum});
        List fieldList = this.fieldService.list((Wrapper)query);
        CgformConfigModel model = new CgformConfigModel();
        model.setTableName(tbname);
        model.setJformPkType(onlCgformHead.getIdType());
        model.setJformPkSequence(onlCgformHead.getIdSequence());
        model.setContent(onlCgformHead.getTableTxt());
        model.setColumns(fieldList);
        model.setDbConfig(this.dataBaseConfig);
        if ("normal".equals(synMethod)) {
            boolean isExist = DbTableUtil.judgeTableIsExit(tbname);
            if (isExist) {
                DbTableProcess process = new DbTableProcess();
                List<String> list = process.updateTable(model);
                for (String sql : list) {
                    if (oConvertUtils.isEmpty((Object)sql) || oConvertUtils.isEmpty((Object)sql.trim())) continue;
                    ((OnlCgformHeadMapper)this.baseMapper).executeDDL(sql);
                }
                List configIndexList = this.indexService.list((Wrapper)new LambdaQueryWrapper().eq(OnlCgformIndex::getCgformHeadId, (Object)code));
                for (OnlCgformIndex configIndex : configIndexList) {
                    String delIndexSql = process.dropIndex(configIndex.getIndexName(), tbname);
                    ((OnlCgformHeadMapper)this.baseMapper).executeDDL(delIndexSql);
                }
            } else {
                DbTableProcess.createTable(model);
            }
        } else if ("force".equals(synMethod)) {
            DbTableHandleI handler = DbTableUtil.getTableHandle();
            String sql = handler.dropTableSQL(tbname);
            ((OnlCgformHeadMapper)this.baseMapper).executeDDL(sql);
            DbTableProcess.createTable(model);
        }
        this.indexService.createIndex(code, DbTableUtil.getDatabaseType(), tbname);
        onlCgformHead.setIsDbSynch("Y");
        this.updateById(onlCgformHead);
    }

    @Override
    public void deleteRecordAndTable(String id) throws DBException, SQLException {
        OnlCgformHead onlCgformHead = (OnlCgformHead)this.getById((Serializable)((Object)id));
        if (onlCgformHead == null) {
            throw new DBException("\u5b9e\u4f53\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        String sql = DbTableUtil.getTableHandle().dropTableSQL(onlCgformHead.getTableName());
        ((OnlCgformHeadMapper)this.baseMapper).executeDDL(sql);
        ((OnlCgformHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public List<Map<String, Object>> queryListData(String sql) {
        return ((OnlCgformHeadMapper)this.baseMapper).queryList(sql);
    }

    @Override
    public void saveEnhance(OnlCgformEnhanceJs onlCgformEnhanceJs) {
        this.onlCgformEnhanceJsMapper.insert(onlCgformEnhanceJs);
    }

    @Override
    public OnlCgformEnhanceJs queryEnhance(String code, String type) {
        return (OnlCgformEnhanceJs)this.onlCgformEnhanceJsMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OnlCgformEnhanceJs::getCgJsType, (Object)type)).eq(OnlCgformEnhanceJs::getCgformHeadId, (Object)code));
    }

    @Override
    public void editEnhance(OnlCgformEnhanceJs onlCgformEnhanceJs) {
        this.onlCgformEnhanceJsMapper.updateById(onlCgformEnhanceJs);
    }

    @Override
    public OnlCgformEnhanceSql queryEnhanceSql(String formId, String buttonCode) {
        return (OnlCgformEnhanceSql)this.onlCgformEnhanceSqlMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OnlCgformEnhanceSql::getCgformHeadId, (Object)formId)).eq(OnlCgformEnhanceSql::getButtonCode, (Object)buttonCode));
    }

    @Override
    public void saveEnhance(OnlCgformEnhanceSql onlCgformEnhanceSql) {
        this.onlCgformEnhanceSqlMapper.insert(onlCgformEnhanceSql);
    }

    @Override
    public void editEnhance(OnlCgformEnhanceSql onlCgformEnhanceSql) {
        this.onlCgformEnhanceSqlMapper.updateById(onlCgformEnhanceSql);
    }

    @Override
    public OnlCgformEnhanceJava queryEnhanceJava(OnlCgformEnhanceJava onlCgformEnhanceJava) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformEnhanceJava::getButtonCode, (Object)onlCgformEnhanceJava.getButtonCode());
        query.eq(OnlCgformEnhanceJava::getCgformHeadId, (Object)onlCgformEnhanceJava.getCgformHeadId());
        query.eq(OnlCgformEnhanceJava::getCgJavaType, (Object)onlCgformEnhanceJava.getCgJavaType());
        query.eq(OnlCgformEnhanceJava::getEvent, (Object)onlCgformEnhanceJava.getEvent());
        return (OnlCgformEnhanceJava)this.onlCgformEnhanceJavaMapper.selectOne((Wrapper)query);
    }

    @Override
    public void saveEnhance(OnlCgformEnhanceJava onlCgformEnhanceJava) {
        this.onlCgformEnhanceJavaMapper.insert(onlCgformEnhanceJava);
    }

    @Override
    public void editEnhance(OnlCgformEnhanceJava onlCgformEnhanceJava) {
        this.onlCgformEnhanceJavaMapper.updateById(onlCgformEnhanceJava);
    }

    @Override
    public List<OnlCgformButton> queryButtonList(String code, boolean isListButton) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformButton::getButtonStatus, (Object)"1");
        query.eq(OnlCgformButton::getCgformHeadId, (Object)code);
        if (isListButton) {
            query.in(OnlCgformButton::getButtonStyle, new Object[]{"link", "button"});
        } else {
            query.eq(OnlCgformButton::getButtonStyle, (Object)"form");
        }
        query.orderByAsc((Object[])new SFunction[]{OnlCgformButton::getOrderNum});
        return this.onlCgformButtonMapper.selectList((Wrapper)query);
    }

    @Override
    public List<OnlCgformButton> queryButtonList(String code) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformButton::getButtonStatus, (Object)"1");
        query.eq(OnlCgformButton::getCgformHeadId, (Object)code);
        query.orderByAsc((Object[])new SFunction[]{OnlCgformButton::getOrderNum});
        return this.onlCgformButtonMapper.selectList((Wrapper)query);
    }

    @Override
    public boolean checkOnlyEnhance(OnlCgformEnhanceJava onlCgformEnhanceJava) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformEnhanceJava::getButtonCode, (Object)onlCgformEnhanceJava.getButtonCode());
        query.eq(OnlCgformEnhanceJava::getCgformHeadId, (Object)onlCgformEnhanceJava.getCgformHeadId());
        query.eq(OnlCgformEnhanceJava::getCgJavaType, (Object)onlCgformEnhanceJava.getCgJavaType());
        query.eq(OnlCgformEnhanceJava::getEvent, (Object)onlCgformEnhanceJava.getEvent());
        Integer count = this.onlCgformEnhanceJavaMapper.selectCount((Wrapper)query);
        if (count != null) {
            if (count == 1 && oConvertUtils.isEmpty((Object)onlCgformEnhanceJava.getId())) {
                return false;
            }
            if (count == 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> queryOnlinetables() {
        return ((OnlCgformHeadMapper)this.baseMapper).queryOnlinetables();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDbTable2Online(String tbname) {
        OnlCgformHead cgFormHead = new OnlCgformHead();
        cgFormHead.setTableType(1);
        cgFormHead.setIsCheckbox("Y");
        cgFormHead.setIsDbSynch("Y");
        cgFormHead.setIsTree("N");
        cgFormHead.setIsPage("Y");
        cgFormHead.setQueryMode("group");
        cgFormHead.setTableName(tbname.toLowerCase());
        cgFormHead.setTableTxt(tbname);
        cgFormHead.setTableVersion(1);
        cgFormHead.setFormTemplate("1");
        String cgFormId = UUIDGenerator.generate();
        cgFormHead.setId(cgFormId);
        ArrayList<OnlCgformField> columnsList = new ArrayList<OnlCgformField>();
        try {
            List list = DbReadTableUtil.b((String)tbname);
            for (int k = 0; k < list.size(); ++k) {
                ColumnVo columnt = (ColumnVo)list.get(k);
                log.info("  columnt : " + columnt.toString());
                String fieldName = columnt.getFieldDbName();
                OnlCgformField cgFormField = new OnlCgformField();
                cgFormField.setCgformHeadId(cgFormId);
                cgFormField.setDbFieldNameOld(columnt.getFieldDbName().toLowerCase());
                cgFormField.setDbFieldName(columnt.getFieldDbName().toLowerCase());
                if (oConvertUtils.isNotEmpty((Object)columnt.getFiledComment())) {
                    cgFormField.setDbFieldTxt(columnt.getFiledComment());
                } else {
                    cgFormField.setDbFieldTxt(columnt.getFieldName());
                }
                cgFormField.setDbIsKey(0);
                cgFormField.setIsShowForm(1);
                cgFormField.setIsQuery(0);
                cgFormField.setFieldMustInput("0");
                cgFormField.setIsShowList(1);
                cgFormField.setOrderNum(k + 1);
                cgFormField.setQueryMode("group");
                cgFormField.setDbLength(oConvertUtils.getInt((String)columnt.getPrecision()));
                cgFormField.setFieldLength(120);
                cgFormField.setDbPointLength(oConvertUtils.getInt((String)columnt.getScale()));
                cgFormField.setFieldShowType("text");
                cgFormField.setDbIsNull("Y".equals(columnt.getNullable()) ? 1 : 0);
                if ("id".equalsIgnoreCase(fieldName)) {
                    String[] pkTypeArr = new String[]{"java.lang.Integer", "java.lang.Long"};
                    String idFiledType = columnt.getFieldType();
                    if (Arrays.asList(pkTypeArr).contains(idFiledType)) {
                        cgFormHead.setIdType("NATIVE");
                    } else {
                        cgFormHead.setIdType("UUID");
                    }
                    cgFormField.setDbIsKey(1);
                    cgFormField.setIsShowForm(0);
                    cgFormField.setIsShowList(0);
                }
                if ("java.lang.Integer".equalsIgnoreCase(columnt.getFieldType())) {
                    cgFormField.setDbType("int");
                } else if ("java.lang.Long".equalsIgnoreCase(columnt.getFieldType())) {
                    cgFormField.setDbType("int");
                } else if ("java.util.Date".equalsIgnoreCase(columnt.getFieldType())) {
                    cgFormField.setDbType("Date");
                    cgFormField.setFieldShowType("date");
                } else if ("java.lang.Double".equalsIgnoreCase(columnt.getFieldType()) || "java.lang.Float".equalsIgnoreCase(columnt.getFieldType())) {
                    cgFormField.setDbType("double");
                } else if ("java.math.BigDecimal".equalsIgnoreCase(columnt.getFieldType()) || "BigDecimal".equalsIgnoreCase(columnt.getFieldType())) {
                    cgFormField.setDbType("BigDecimal");
                } else if ("byte[]".equalsIgnoreCase(columnt.getFieldType()) || columnt.getFieldType().contains("blob")) {
                    cgFormField.setDbType("Blob");
                    columnt.setCharmaxLength(null);
                } else {
                    cgFormField.setDbType("string");
                }
                if (oConvertUtils.isEmpty((Object)columnt.getPrecision()) && oConvertUtils.isNotEmpty((Object)columnt.getCharmaxLength())) {
                    if (Long.valueOf(columnt.getCharmaxLength()) >= 3000L) {
                        cgFormField.setDbType("Text");
                        cgFormField.setFieldShowType("textarea");
                        try {
                            cgFormField.setDbLength(Integer.valueOf(columnt.getCharmaxLength()));
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        cgFormField.setDbLength(Integer.valueOf(columnt.getCharmaxLength()));
                    }
                } else {
                    if (oConvertUtils.isNotEmpty((Object)columnt.getPrecision())) {
                        cgFormField.setDbLength(Integer.valueOf(columnt.getPrecision()));
                    } else if (cgFormField.getDbType().equals("int")) {
                        cgFormField.setDbLength(10);
                    }
                    if (oConvertUtils.isNotEmpty((Object)columnt.getScale())) {
                        cgFormField.setDbPointLength(Integer.valueOf(columnt.getScale()));
                    }
                }
                columnsList.add(cgFormField);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (oConvertUtils.isEmpty((Object)cgFormHead.getFormCategory())) {
            cgFormHead.setFormCategory("bdfl_include");
        }
        this.save(cgFormHead);
        this.fieldService.saveBatch(columnsList);
    }

    private void handleMainTableInfo(OnlCgformHead head, List<OnlCgformField> fields) {
        if (head.getTableType() == 3) {
            head = (OnlCgformHead)((OnlCgformHeadMapper)this.baseMapper).selectById((Serializable)((Object)head.getId()));
            for (int i = 0; i < fields.size(); ++i) {
                OnlCgformHead mainTable;
                OnlCgformField field = fields.get(i);
                String tbName = field.getMainTable();
                if (oConvertUtils.isEmpty((Object)tbName) || (mainTable = (OnlCgformHead)((OnlCgformHeadMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)tbName))) == null) continue;
                String allSubTable = mainTable.getSubTableStr();
                if (oConvertUtils.isEmpty((Object)allSubTable)) {
                    allSubTable = head.getTableName();
                } else if (allSubTable.indexOf(head.getTableName()) < 0) {
                    ArrayList<String> arr = new ArrayList<String>(Arrays.asList(allSubTable.split(",")));
                    for (int k = 0; k < arr.size(); ++k) {
                        String tempTbname = (String)arr.get(k);
                        OnlCgformHead tempTable = (OnlCgformHead)((OnlCgformHeadMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)tempTbname));
                        if (tempTable == null || head.getTabOrderNum() >= tempTable.getTabOrderNum()) continue;
                        arr.add(k, head.getTableName());
                        break;
                    }
                    if (arr.indexOf(head.getTableName()) < 0) {
                        arr.add(head.getTableName());
                    }
                    allSubTable = String.join((CharSequence)",", arr);
                }
                mainTable.setSubTableStr(allSubTable);
                ((OnlCgformHeadMapper)this.baseMapper).updateById(mainTable);
                break;
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveManyFormData(String code, JSONObject json) throws DBException, BusinessException {
        OnlCgformHead head = (OnlCgformHead)this.getById((Serializable)((Object)code));
        if (head == null) {
            throw new DBException("\u6570\u636e\u5e93\u4e3b\u8868ID[" + code + "]\u4e0d\u5b58\u5728");
        }
        String currButtonCode = "add";
        this.executeEnhanceJava(currButtonCode, "start", head, json);
        json.put("id", (Object)UUIDGenerator.generate());
        String tbname = head.getTableName();
        if (head.getTableType() == 2) {
            String[] arr;
            String subTables = head.getSubTableStr();
            for (String tb : arr = subTables.split(",")) {
                OnlCgformHead temp;
                JSONArray jsonArray = json.getJSONArray(tb);
                if (jsonArray == null || jsonArray.size() == 0 || (temp = (OnlCgformHead)((OnlCgformHeadMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)tb))) == null) continue;
                List subFieldList = this.fieldService.list((Wrapper)new LambdaQueryWrapper().eq(OnlCgformField::getCgformHeadId, (Object)temp.getId()));
                String sublinkField = "";
                String subLinkValue = null;
                for (OnlCgformField field : subFieldList) {
                    if (oConvertUtils.isEmpty((Object)field.getMainField())) continue;
                    sublinkField = field.getDbFieldName();
                    String mainField = field.getMainField();
                    subLinkValue = json.getString(mainField);
                }
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if (subLinkValue != null) {
                        jsonObject.put(sublinkField, subLinkValue);
                    }
                    this.fieldService.saveFormData(subFieldList, tb, jsonObject);
                }
            }
        }
        this.fieldService.saveFormData(code, tbname, json);
        this.executeEnhanceSql(currButtonCode, code, json);
        this.executeEnhanceJava(currButtonCode, "end", head, json);
    }

    @Override
    public Map<String, Object> queryManyFormData(String code, String id) throws DBException {
        OnlCgformHead head = (OnlCgformHead)this.getById((Serializable)((Object)code));
        if (head == null) {
            throw new DBException("\u6570\u636e\u5e93\u4e3b\u8868ID[" + code + "]\u4e0d\u5b58\u5728");
        }
        List<OnlCgformField> fieldList = this.fieldService.queryFormFields(code, true);
        Map<String, Object> map = this.fieldService.queryFormData(fieldList, head.getTableName(), id);
        if (head.getTableType() == 2) {
            String[] arr;
            String subTables = head.getSubTableStr();
            for (String tb : arr = subTables.split(",")) {
                OnlCgformHead temp = (OnlCgformHead)((OnlCgformHeadMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)tb));
                if (temp == null) continue;
                List<OnlCgformField> subFieldList = this.fieldService.queryFormFields(temp.getId(), false);
                String sublinkField = "";
                String subLinkValue = null;
                for (OnlCgformField field : subFieldList) {
                    if (oConvertUtils.isEmpty((Object)field.getMainField())) continue;
                    sublinkField = field.getDbFieldName();
                    String mainField = field.getMainField();
                    subLinkValue = map.get(mainField).toString();
                }
                List<Map<String, Object>> subList = this.fieldService.querySubFormData(subFieldList, tb, sublinkField, subLinkValue);
                if (subList == null || subList.size() == 0) {
                    map.put(tb, new String[0]);
                    continue;
                }
                map.put(tb, subList);
            }
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editManyFormData(String code, JSONObject json) throws DBException, BusinessException {
        OnlCgformHead head = (OnlCgformHead)this.getById((Serializable)((Object)code));
        if (head == null) {
            throw new DBException("\u6570\u636e\u5e93\u4e3b\u8868ID[" + code + "]\u4e0d\u5b58\u5728");
        }
        String currButtonCode = "edit";
        this.executeEnhanceJava(currButtonCode, "start", head, json);
        String tbname = head.getTableName();
        this.fieldService.editFormData(code, tbname, json);
        if (head.getTableType() == 2) {
            String[] arr;
            String subTables = head.getSubTableStr();
            for (String tb : arr = subTables.split(",")) {
                OnlCgformHead temp = (OnlCgformHead)((OnlCgformHeadMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)tb));
                if (temp == null) continue;
                List subFieldList = this.fieldService.list((Wrapper)new LambdaQueryWrapper().eq(OnlCgformField::getCgformHeadId, (Object)temp.getId()));
                String sublinkField = "";
                String subLinkValue = null;
                for (OnlCgformField field : subFieldList) {
                    if (oConvertUtils.isEmpty((Object)field.getMainField())) continue;
                    sublinkField = field.getDbFieldName();
                    String mainField = field.getMainField();
                    subLinkValue = json.getString(mainField);
                }
                if (oConvertUtils.isEmpty(subLinkValue)) continue;
                this.fieldService.deleteAutoList(tb, sublinkField, subLinkValue);
                JSONArray jsonArray = json.getJSONArray(tb);
                if (jsonArray == null || jsonArray.size() == 0) continue;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if (subLinkValue != null) {
                        jsonObject.put(sublinkField, (Object)subLinkValue);
                    }
                    this.fieldService.saveFormData(subFieldList, tb, jsonObject);
                }
            }
        }
        this.executeEnhanceJava(currButtonCode, "end", head, json);
        this.executeEnhanceSql(currButtonCode, code, json);
    }

    @Override
    public void executeEnhanceJava(String buttonCode, String eventType, OnlCgformHead head, JSONObject json) throws BusinessException {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformEnhanceJava::getActiveStatus, (Object)"1");
        query.eq(OnlCgformEnhanceJava::getButtonCode, (Object)buttonCode);
        query.eq(OnlCgformEnhanceJava::getCgformHeadId, (Object)head.getId());
        query.eq(OnlCgformEnhanceJava::getEvent, (Object)eventType);
        OnlCgformEnhanceJava enhance = (OnlCgformEnhanceJava)this.onlCgformEnhanceJavaMapper.selectOne((Wrapper)query);
        if (enhance != null) {
            String javaType = enhance.getCgJavaType();
            String javaValue = enhance.getCgJavaValue();
            if (oConvertUtils.isNotEmpty((Object)javaValue)) {
                Object obj = null;
                if ("class".equals(javaType)) {
                    try {
                        obj = MyClassLoader.getClassByScn((String)javaValue).newInstance();
                    }
                    catch (InstantiationException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                } else if ("spring".equals(javaType)) {
                    obj = SpringContextUtils.getBean((String)javaValue);
                }
                if (obj instanceof CgformEnhanceJavaInter) {
                    CgformEnhanceJavaInter javaInter = (CgformEnhanceJavaInter)obj;
                    javaInter.execute(head.getTableName(), json);
                }
            }
        }
    }

    @Override
    public void executeEnhanceSql(String buttonCode, String formId, JSONObject json) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformEnhanceSql::getButtonCode, (Object)buttonCode);
        query.eq(OnlCgformEnhanceSql::getCgformHeadId, (Object)formId);
        OnlCgformEnhanceSql enhance = (OnlCgformEnhanceSql)this.onlCgformEnhanceSqlMapper.selectOne((Wrapper)query);
        if (enhance != null) {
            String[] arr;
            String sqls = CgformUtil.formateSQl(enhance.getCgbSql(), json);
            for (String sql : arr = sqls.split(";")) {
                if (sql == null || sql.toLowerCase().trim().equals("")) continue;
                ((OnlCgformHeadMapper)this.baseMapper).executeDDL(sql);
            }
        }
    }

    @Override
    public void executeCustomerButton(String buttonCode, String formId, String dataId) throws BusinessException {
        OnlCgformHead head = (OnlCgformHead)this.getById((Serializable)((Object)formId));
        if (head == null) {
            throw new BusinessException("\u672a\u627e\u5230\u8868\u914d\u7f6e\u4fe1\u606f");
        }
        Map<String, Object> data = ((OnlCgformHeadMapper)this.baseMapper).queryOneByTableNameAndId(head.getTableName(), dataId);
        JSONObject json = JSONObject.parseObject((String)JSON.toJSONString(data));
        this.executeEnhanceJava(buttonCode, "start", head, json);
        this.executeEnhanceSql(buttonCode, formId, json);
        this.executeEnhanceJava(buttonCode, "end", head, json);
    }

    @Override
    public List<OnlCgformButton> queryValidButtonList(String headId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformButton::getCgformHeadId, (Object)headId);
        query.eq(OnlCgformButton::getButtonStatus, (Object)"1");
        query.orderByAsc((Object[])new SFunction[]{OnlCgformButton::getOrderNum});
        return this.onlCgformButtonMapper.selectList((Wrapper)query);
    }

    @Override
    public OnlCgformEnhanceJs queryEnhanceJs(String formId, String cgJsType) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformEnhanceJs::getCgformHeadId, (Object)formId);
        query.eq(OnlCgformEnhanceJs::getCgJsType, (Object)cgJsType);
        return (OnlCgformEnhanceJs)this.onlCgformEnhanceJsMapper.selectOne((Wrapper)query);
    }

    @Override
    public void deleteOneTableInfo(String formId, String dataId) throws BusinessException {
        OnlCgformHead head = (OnlCgformHead)this.getById((Serializable)((Object)formId));
        if (head == null) {
            throw new BusinessException("\u672a\u627e\u5230\u8868\u914d\u7f6e\u4fe1\u606f");
        }
        Map<String, Object> record = ((OnlCgformHeadMapper)this.baseMapper).queryOneByTableNameAndId(head.getTableName(), dataId);
        if (record == null) {
            throw new BusinessException("\u672a\u627e\u5230\u6570\u636e\u4fe1\u606f");
        }
        String buttonCode = "delete";
        JSONObject json = JSONObject.parseObject((String)JSON.toJSONString(record));
        this.executeEnhanceJava(buttonCode, "start", head, json);
        String sql = "delete from " + head.getTableName() + " where id = '" + dataId + "'";
        ((OnlCgformHeadMapper)this.baseMapper).deleteOne(sql);
        this.executeEnhanceSql(buttonCode, formId, json);
        this.executeEnhanceJava(buttonCode, "end", head, json);
    }

    @Override
    public JSONObject queryFormItem(OnlCgformHead head) {
        String subStr;
        List<OnlCgformField> fieldList = this.fieldService.queryAvailableFields(head.getId(), head.getTableName(), false);
        List<String> disabledFieldNameList = this.fieldService.queryDisabledFields(head.getTableName());
        JSONObject schema = CgformUtil.getJsonSchemaByCgformFieldList(fieldList, disabledFieldNameList);
        if (head.getTableType() == 2 && oConvertUtils.isNotEmpty((Object)(subStr = head.getSubTableStr()))) {
            for (String tbname : subStr.split(",")) {
                OnlCgformHead tempTable = (OnlCgformHead)((OnlCgformHeadMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)tbname));
                if (tempTable == null) continue;
                List<OnlCgformField> subFieldList = this.fieldService.queryAvailableFields(tempTable.getId(), tempTable.getTableName(), false);
                JSONObject subJson = new JSONObject();
                subJson.put("columns", (Object)CgformUtil.getJEditableTableColumnsJson(subFieldList));
                subJson.put("describe", (Object)tempTable.getTableTxt());
                subJson.put("key", (Object)tempTable.getTableName());
                subJson.put("view", (Object)"tab");
                schema.getJSONObject("properties").put(tempTable.getTableName(), (Object)subJson);
            }
        }
        return schema;
    }

    @Override
    public void generateCode(OnlGenerateModel model) {
        TableVo tableVo = new TableVo();
        tableVo.setEntityName(model.getEntityName());
        tableVo.setEntityPackage(model.getEntityPackage());
        tableVo.setFtlDescription(model.getFtlDescription());
        tableVo.setTableName(model.getTableName());
        tableVo.setSearchFieldNum(Integer.valueOf(-1));
        ArrayList<ColumnVo> columns = new ArrayList<ColumnVo>();
        ArrayList<ColumnVo> originalColumns = new ArrayList<ColumnVo>();
        this.initColumnVoList(model.getCode(), columns, originalColumns);
        new CodeGenerateOne(tableVo, columns, originalColumns).generateCodeFile(model.getProjectPath());
    }

    @Override
    public void generateOneToMany(OnlGenerateModel model) {
        MainTableVo mainTableVo = new MainTableVo();
        mainTableVo.setEntityName(model.getEntityName());
        mainTableVo.setEntityPackage(model.getEntityPackage());
        mainTableVo.setFtlDescription(model.getFtlDescription());
        mainTableVo.setTableName(model.getTableName());
        ArrayList<ColumnVo> mainColums = new ArrayList<ColumnVo>();
        ArrayList<ColumnVo> originalMainColumns = new ArrayList<ColumnVo>();
        this.initColumnVoList(model.getCode(), mainColums, originalMainColumns);
        List<OnlGenerateModel> subList = model.getSubList();
        ArrayList<SubTableVo> subTables = new ArrayList<SubTableVo>();
        for (OnlGenerateModel sub : subList) {
            OnlCgformHead subTableConfig = (OnlCgformHead)((OnlCgformHeadMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)sub.getTableName()));
            if (subTableConfig == null) continue;
            SubTableVo subVo = new SubTableVo();
            subVo.setEntityName(sub.getEntityName());
            subVo.setEntityPackage(model.getEntityPackage());
            subVo.setTableName(sub.getTableName());
            subVo.setFtlDescription(sub.getFtlDescription());
            Integer manyOrone = subTableConfig.getRelationType();
            subVo.setForeignRelationType(manyOrone == 1 ? "1" : "0");
            ArrayList<ColumnVo> columns = new ArrayList<ColumnVo>();
            ArrayList<ColumnVo> originalColumns = new ArrayList<ColumnVo>();
            OnlCgformField foreignKeys = this.initColumnVoList(subTableConfig.getId(), columns, originalColumns);
            if (foreignKeys == null) continue;
            subVo.setOriginalForeignKeys(new String[]{foreignKeys.getDbFieldName()});
            subVo.setForeignKeys(new String[]{foreignKeys.getDbFieldName()});
            subVo.setColums(columns);
            subVo.setOriginalColumns(originalColumns);
            subTables.add(subVo);
        }
        new CodeGenerateOneToMany(mainTableVo, mainColums, originalMainColumns, subTables).generateCodeFile(model.getProjectPath());
    }

    private OnlCgformField initColumnVoList(String cgConfigId, List<ColumnVo> columns, List<ColumnVo> originalColumns) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)cgConfigId);
        query.orderByAsc((Object[])new SFunction[]{OnlCgformField::getOrderNum});
        List fieldList = this.fieldService.list((Wrapper)query);
        OnlCgformField foreignKeys = null;
        for (OnlCgformField f : fieldList) {
            if (oConvertUtils.isNotEmpty((Object)f.getMainTable())) {
                foreignKeys = f;
            }
            ColumnVo vo = new ColumnVo();
            vo.setFieldLength(f.getFieldLength());
            vo.setFieldHref(f.getFieldHref());
            vo.setFieldValidType(f.getFieldValidType());
            vo.setFieldDefault(f.getDbDefaultVal());
            vo.setFieldShowType(f.getFieldShowType());
            vo.setFieldOrderNum(f.getOrderNum());
            vo.setIsKey(f.getDbIsKey() == 1 ? "Y" : "N");
            vo.setIsShow(f.getIsShowForm() == 1 ? "Y" : "N");
            vo.setIsShowList(f.getIsShowList() == 1 ? "Y" : "N");
            vo.setIsQuery(f.getIsQuery() == 1 ? "Y" : "N");
            vo.setQueryMode(f.getQueryMode());
            vo.setDictField(f.getDictField());
            vo.setDictTable(f.getDictTable());
            vo.setDictText(f.getDictText());
            vo.setFieldDbName(f.getDbFieldName());
            vo.setFieldName(oConvertUtils.camelName((String)f.getDbFieldName()));
            vo.setFiledComment(f.getDbFieldTxt());
            vo.setFieldDbType(f.getDbType());
            vo.setFieldType(this.getFiledType(f.getDbType()));
            vo.setClassType(f.getFieldShowType());
            vo.setClassType_row(f.getFieldShowType());
            vo.setNullable(f.getDbIsNull() == 1 ? "Y" : "N");
            originalColumns.add(vo);
            if (f.getIsShowForm() != 1 && f.getIsShowList() != 1) continue;
            columns.add(vo);
        }
        return foreignKeys;
    }

    private String getFiledType(String dbType) {
        if ((dbType = dbType.toLowerCase()).indexOf("int") >= 0) {
            return "java.lang.Integer";
        }
        if (dbType.indexOf("double") >= 0) {
            return "java.lang.Double";
        }
        if (dbType.indexOf("decimal") >= 0) {
            return "java.math.BigDecimal";
        }
        if (dbType.indexOf("date") >= 0) {
            return "java.util.Date";
        }
        return "java.lang.String";
    }
}

