/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgform.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgform.entity.OnlCgformField;
import org.jeecg.modules.online.cgform.mapper.OnlCgformFieldMapper;
import org.jeecg.modules.online.cgform.service.IOnlCgformFieldService;
import org.jeecg.modules.online.cgform.util.CgformUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OnlCgformFieldServiceImpl
extends ServiceImpl<OnlCgformFieldMapper, OnlCgformField>
implements IOnlCgformFieldService {
    private static final Logger log = LoggerFactory.getLogger(OnlCgformFieldServiceImpl.class);
    @Resource
    private OnlCgformFieldMapper onlCgformFieldMapper;

    @Override
    public Map<String, Object> queryAutolistPage(String tbname, String headId, Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)headId);
        List allFieldList = this.list((Wrapper)query);
        List<OnlCgformField> fieldList = this.queryAvailableFields(tbname, true, allFieldList);
        StringBuffer sb = new StringBuffer();
        CgformUtil.getAutoListBaseSql(tbname, fieldList, sb);
        String conditionSql = CgformUtil.getAutoListConditionSql(allFieldList, params);
        sb.append(" where 1=1  " + conditionSql);
        String order = params.get("order").toString();
        String column = params.get("column").toString();
        if (this.hasField(column, allFieldList)) {
            sb.append(" ORDER BY " + oConvertUtils.camelToUnderline((String)column));
            if ("asc".equals(order)) {
                sb.append(" asc");
            } else {
                sb.append(" desc");
            }
        }
        Integer pageSize = params.get("pageSize") == null ? 10 : Integer.parseInt(params.get("pageSize").toString());
        Integer pageNo = params.get("pageNo") == null ? 1 : Integer.parseInt(params.get("pageNo").toString());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        log.info("---Online\u67e5\u8be2sql:>>" + sb.toString());
        IPage<Map<String, Object>> pageList = this.onlCgformFieldMapper.selectPageBySql((Page<Map<String, Object>>)page, sb.toString());
        result.put("total", pageList.getTotal());
        result.put("records", CgformUtil.toLowerCasePageList(pageList.getRecords()));
        return result;
    }

    @Override
    public void saveFormData(String code, String tbname, JSONObject json) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)code);
        List fieldList = this.list((Wrapper)query);
        Map<String, Object> params = CgformUtil.getFormDataSaveSql(tbname, fieldList, json);
        ((OnlCgformFieldMapper)this.baseMapper).executeInsertSQL(params);
    }

    @Override
    public void saveFormData(List<OnlCgformField> fieldList, String tbname, JSONObject json) {
        Map<String, Object> params = CgformUtil.getFormDataSaveSql(tbname, fieldList, json);
        ((OnlCgformFieldMapper)this.baseMapper).executeInsertSQL(params);
    }

    @Override
    public void editFormData(String code, String tbname, JSONObject json) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)code);
        List fieldList = this.list((Wrapper)query);
        Map<String, Object> params = CgformUtil.getFormDataEditSql(tbname, fieldList, json);
        ((OnlCgformFieldMapper)this.baseMapper).executeUpdatetSQL(params);
    }

    @Override
    public Map<String, Object> queryFormData(String code, String tbname, String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)code);
        query.eq(OnlCgformField::getIsShowForm, (Object)1);
        List fieldList = this.list((Wrapper)query);
        String sql = CgformUtil.getSelectFormSql(tbname, fieldList, id);
        return this.onlCgformFieldMapper.queryFormData(sql);
    }

    @Override
    public void deleteAutoList(String tbname, String id) {
        this.deleteAutoList(tbname, "id", id);
    }

    @Override
    public void deleteAutoList(String tbname, String linkField, String linkValue) {
        String[] arr = linkValue.split(",");
        StringBuffer sb = new StringBuffer();
        for (String str : arr) {
            if (str == null || "".equals(str)) continue;
            sb.append("'" + str + "',");
        }
        String temp = sb.toString();
        String sql = "DELETE FROM " + tbname + " where " + linkField + " in(" + temp.substring(0, temp.length() - 1) + ")";
        log.info("--\u5220\u9664sql-->" + sql);
        this.onlCgformFieldMapper.deleteAutoList(sql);
    }

    @Override
    public List<Map<String, String>> getAutoListQueryInfo(String code) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)code);
        query.eq(OnlCgformField::getIsQuery, (Object)1);
        List fieldList = this.list((Wrapper)query);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        int i = 0;
        for (OnlCgformField item : fieldList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("label", item.getDbFieldTxt());
            map.put("view", item.getFieldShowType());
            map.put("mode", item.getQueryMode());
            map.put("field", item.getDbFieldName());
            if (++i > 2) {
                map.put("hidden", "1");
            }
            list.add(map);
        }
        return list;
    }

    @Override
    public List<OnlCgformField> queryFormFields(String code, boolean isform) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)code);
        if (isform) {
            query.eq(OnlCgformField::getIsShowForm, (Object)1);
        }
        return this.list((Wrapper)query);
    }

    @Override
    public Map<String, Object> queryFormData(List<OnlCgformField> fieldList, String tbname, String id) {
        String sql = CgformUtil.getSelectFormSql(tbname, fieldList, id);
        return this.onlCgformFieldMapper.queryFormData(sql);
    }

    @Override
    public List<Map<String, Object>> querySubFormData(List<OnlCgformField> fieldList, String tbname, String linkField, String value) {
        String sql = CgformUtil.getSelectSubFormSql(tbname, fieldList, linkField, value);
        return this.onlCgformFieldMapper.queryListData(sql);
    }

    @Override
    public IPage<Map<String, Object>> selectPageBySql(Page<Map<String, Object>> page, String sql) {
        return ((OnlCgformFieldMapper)this.baseMapper).selectPageBySql(page, sql);
    }

    @Override
    public List<String> selectOnlineHideColumns(String tbname) {
        String onlineTbname = "online:" + tbname + "%";
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        List<String> list = ((OnlCgformFieldMapper)this.baseMapper).selectOnlineHideColumns(userId, onlineTbname);
        ArrayList<String> result = new ArrayList<String>();
        if (list == null || list.size() == 0 || list.get(0) == null) {
            return result;
        }
        for (String combineStr : list) {
            String field;
            if (oConvertUtils.isEmpty((Object)combineStr) || oConvertUtils.isEmpty((Object)(field = combineStr.substring(combineStr.lastIndexOf(":") + 1)))) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public List<OnlCgformField> queryAvailableFields(String cgFormId, String tbname, boolean isList) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)cgFormId);
        if (isList) {
            query.eq(OnlCgformField::getIsShowList, (Object)1);
        } else {
            query.eq(OnlCgformField::getIsShowForm, (Object)1);
        }
        query.orderByAsc((Object[])new SFunction[]{OnlCgformField::getOrderNum});
        List fieldList = this.list((Wrapper)query);
        String onlineTbname = "online:" + tbname + "%";
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        List<String> hideColumns = ((OnlCgformFieldMapper)this.baseMapper).selectOnlineHideColumns(userId, onlineTbname);
        if (hideColumns == null || hideColumns.size() == 0 || hideColumns.get(0) == null) {
            return fieldList;
        }
        ArrayList<OnlCgformField> result = new ArrayList<OnlCgformField>();
        for (int i = 0; i < fieldList.size(); ++i) {
            boolean show = true;
            OnlCgformField field = (OnlCgformField)fieldList.get(i);
            String name = field.getDbFieldName();
            for (int j = 0; j < hideColumns.size(); ++j) {
                String hideField;
                String combineStr = hideColumns.get(j);
                if (oConvertUtils.isEmpty((Object)combineStr) || oConvertUtils.isEmpty((Object)(hideField = combineStr.substring(combineStr.lastIndexOf(":") + 1))) || !hideField.equals(name)) continue;
                show = false;
            }
            if (!show) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public List<String> queryDisabledFields(String tbname) {
        String onlineTbname = "online:" + tbname + "%";
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        ArrayList<String> result = new ArrayList<String>();
        List<String> disabledColumns = ((OnlCgformFieldMapper)this.baseMapper).selectOnlineDisabledColumns(userId, onlineTbname);
        if (disabledColumns == null || disabledColumns.size() == 0 || disabledColumns.get(0) == null) {
            return result;
        }
        for (String combineStr : disabledColumns) {
            String disabledField;
            if (oConvertUtils.isEmpty((Object)combineStr) || oConvertUtils.isEmpty((Object)(disabledField = combineStr.substring(combineStr.lastIndexOf(":") + 1)))) continue;
            result.add(disabledField);
        }
        return result;
    }

    public List<OnlCgformField> queryAvailableFields(String tbname, boolean isList, List<OnlCgformField> List2) {
        ArrayList<OnlCgformField> result = new ArrayList<OnlCgformField>();
        String onlineTbname = "online:" + tbname + "%";
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        List<String> hideColumns = ((OnlCgformFieldMapper)this.baseMapper).selectOnlineHideColumns(userId, onlineTbname);
        boolean hasConfig = true;
        if (hideColumns == null || hideColumns.size() == 0 || hideColumns.get(0) == null) {
            hasConfig = false;
        }
        for (OnlCgformField item : List2) {
            if (!isList ? item.getIsShowForm() != 1 : item.getIsShowList() != 1) continue;
            if (hasConfig) {
                boolean show = true;
                String name = item.getDbFieldName();
                for (int j = 0; j < hideColumns.size(); ++j) {
                    String hideField;
                    String combineStr = hideColumns.get(j);
                    if (oConvertUtils.isEmpty((Object)combineStr) || oConvertUtils.isEmpty((Object)(hideField = combineStr.substring(combineStr.lastIndexOf(":") + 1)))) continue;
                    if (hideField.equals(name)) {
                        show = false;
                    }
                    if (!show) continue;
                    result.add(item);
                }
                continue;
            }
            result.add(item);
        }
        return result;
    }

    public boolean hasField(String fieldName, List<OnlCgformField> List2) {
        boolean flag = false;
        for (OnlCgformField field : List2) {
            if (!oConvertUtils.camelToUnderline((String)fieldName).equals(field.getDbFieldName())) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

