/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgform.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.File;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgform.entity.OnlCgformButton;
import org.jeecg.modules.online.cgform.entity.OnlCgformEnhanceJava;
import org.jeecg.modules.online.cgform.entity.OnlCgformEnhanceJs;
import org.jeecg.modules.online.cgform.entity.OnlCgformEnhanceSql;
import org.jeecg.modules.online.cgform.entity.OnlCgformHead;
import org.jeecg.modules.online.cgform.service.IOnlCgformFieldService;
import org.jeecg.modules.online.cgform.service.IOnlCgformHeadService;
import org.jeecg.modules.online.cgform.util.CgformUtil;
import org.jeecg.modules.online.config.exception.DBException;
import org.jeecgframework.codegenerate.a.a;
import org.jeecgframework.codegenerate.database.DbReadTableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/online/cgform/head"})
public class OnlCgformHeadController {
    private static final Logger log = LoggerFactory.getLogger(OnlCgformHeadController.class);
    @Autowired
    private IOnlCgformHeadService onlCgformHeadService;
    @Autowired
    private IOnlCgformFieldService onlCgformFieldService;
    private static String GENERATE_FORM_IDS;

    @GetMapping(value={"/list"})
    public Result<IPage<OnlCgformHead>> queryPageList(OnlCgformHead onlCgformHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)onlCgformHead, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.onlCgformHeadService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @PostMapping(value={"/add"})
    public Result<OnlCgformHead> add(@RequestBody OnlCgformHead onlCgformHead) {
        Result result = new Result();
        try {
            this.onlCgformHeadService.save(onlCgformHead);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @PutMapping(value={"/edit"})
    public Result<OnlCgformHead> edit(@RequestBody OnlCgformHead onlCgformHead) {
        Result result = new Result();
        OnlCgformHead onlCgformHeadEntity = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)onlCgformHead.getId()));
        if (onlCgformHeadEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.onlCgformHeadService.updateById(onlCgformHead);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        try {
            this.onlCgformHeadService.deleteRecordAndTable(id);
        }
        catch (DBException e) {
            return Result.error((String)("\u5220\u9664\u5931\u8d25" + e.getMessage()));
        }
        catch (SQLException e) {
            return Result.error((String)("\u5220\u9664\u5931\u8d25" + e.getMessage()));
        }
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @DeleteMapping(value={"/removeRecord"})
    public Result<OnlCgformHead> removeRecord(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        OnlCgformHead onlCgformHead = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)id));
        if (onlCgformHead == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.onlCgformHeadService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<OnlCgformHead> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.onlCgformHeadService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @GetMapping(value={"/queryById"})
    public Result<OnlCgformHead> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        OnlCgformHead onlCgformHead = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)id));
        if (onlCgformHead == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)onlCgformHead);
            result.setSuccess(true);
        }
        return result;
    }

    @PostMapping(value={"/enhanceJs/{code}"})
    public Result<?> saveEnhanceJs(@PathVariable(value="code") String code, @RequestBody OnlCgformEnhanceJs onlCgformEnhanceJs) {
        try {
            onlCgformEnhanceJs.setCgformHeadId(code);
            this.onlCgformHeadService.saveEnhance(onlCgformEnhanceJs);
            return Result.ok((String)"\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    @GetMapping(value={"/enhanceJs/{code}"})
    public Result<?> getenhanceJs(@PathVariable(value="code") String code, HttpServletRequest req) {
        try {
            String type = req.getParameter("type");
            OnlCgformEnhanceJs obj = this.onlCgformHeadService.queryEnhance(code, type);
            if (obj == null) {
                return Result.error((String)"\u67e5\u8be2\u4e3a\u7a7a");
            }
            return Result.ok((Object)obj);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u67e5\u8be2\u5931\u8d25!");
        }
    }

    @PutMapping(value={"/enhanceJs/{code}"})
    public Result<?> editEnhanceJs(@PathVariable(value="code") String code, @RequestBody OnlCgformEnhanceJs onlCgformEnhanceJs) {
        try {
            onlCgformEnhanceJs.setCgformHeadId(code);
            this.onlCgformHeadService.editEnhance(onlCgformEnhanceJs);
            return Result.ok((String)"\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    @GetMapping(value={"/enhanceButton/{formId}"})
    public Result<?> enhanceButton(@PathVariable(value="formId") String formId, HttpServletRequest req) {
        try {
            List<OnlCgformButton> list = this.onlCgformHeadService.queryButtonList(formId);
            if (list == null || list.size() == 0) {
                return Result.error((String)"\u67e5\u8be2\u4e3a\u7a7a");
            }
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u67e5\u8be2\u5931\u8d25!");
        }
    }

    @PostMapping(value={"/enhanceSql/{formId}"})
    public Result<?> enhanceSql(@PathVariable(value="formId") String formId, @RequestBody OnlCgformEnhanceSql onlCgformEnhanceSql) {
        try {
            onlCgformEnhanceSql.setCgformHeadId(formId);
            this.onlCgformHeadService.saveEnhance(onlCgformEnhanceSql);
            return Result.ok((String)"\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    @GetMapping(value={"/enhanceSql/{formId}"})
    public Result<?> getEnhanceSql(@PathVariable(value="formId") String formId, HttpServletRequest req) {
        try {
            String buttonCode = req.getParameter("buttonCode");
            OnlCgformEnhanceSql obj = this.onlCgformHeadService.queryEnhanceSql(formId, buttonCode);
            if (obj == null) {
                return Result.error((String)"\u67e5\u8be2\u4e3a\u7a7a");
            }
            return Result.ok((Object)obj);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u67e5\u8be2\u5931\u8d25!");
        }
    }

    @PutMapping(value={"/enhanceSql/{formId}"})
    public Result<?> editEnhanceSql(@PathVariable(value="formId") String formId, @RequestBody OnlCgformEnhanceSql onlCgformEnhanceSql) {
        try {
            onlCgformEnhanceSql.setCgformHeadId(formId);
            this.onlCgformHeadService.editEnhance(onlCgformEnhanceSql);
            return Result.ok((String)"\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    @PostMapping(value={"/enhanceJava/{formId}"})
    public Result<?> enhanceJava(@PathVariable(value="formId") String formId, @RequestBody OnlCgformEnhanceJava onlCgformEnhanceJava) {
        try {
            if (!CgformUtil.checkClassOrSpringBeanIsExist(onlCgformEnhanceJava)) {
                return Result.error((String)"\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!");
            }
            onlCgformEnhanceJava.setCgformHeadId(formId);
            if (this.onlCgformHeadService.checkOnlyEnhance(onlCgformEnhanceJava)) {
                this.onlCgformHeadService.saveEnhance(onlCgformEnhanceJava);
                return Result.ok((String)"\u4fdd\u5b58\u6210\u529f!");
            }
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25,\u6570\u636e\u4e0d\u552f\u4e00!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    @GetMapping(value={"/enhanceJava/{formId}"})
    public Result<?> getEnhanceJava(@PathVariable(value="formId") String formId, OnlCgformEnhanceJava onlCgformEnhanceJava) {
        try {
            onlCgformEnhanceJava.setCgformHeadId(formId);
            OnlCgformEnhanceJava obj = this.onlCgformHeadService.queryEnhanceJava(onlCgformEnhanceJava);
            if (obj == null) {
                return Result.error((String)"\u67e5\u8be2\u4e3a\u7a7a");
            }
            return Result.ok((Object)obj);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u67e5\u8be2\u5931\u8d25!");
        }
    }

    @PutMapping(value={"/enhanceJava/{formId}"})
    public Result<?> editEnhanceJava(@PathVariable(value="formId") String formId, @RequestBody OnlCgformEnhanceJava onlCgformEnhanceJava) {
        try {
            if (!CgformUtil.checkClassOrSpringBeanIsExist(onlCgformEnhanceJava)) {
                return Result.error((String)"\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!");
            }
            onlCgformEnhanceJava.setCgformHeadId(formId);
            if (this.onlCgformHeadService.checkOnlyEnhance(onlCgformEnhanceJava)) {
                this.onlCgformHeadService.editEnhance(onlCgformEnhanceJava);
                return Result.ok((String)"\u4fdd\u5b58\u6210\u529f!");
            }
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25,\u6570\u636e\u4e0d\u552f\u4e00!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    @GetMapping(value={"/queryTables"})
    public Result<?> queryTables(HttpServletRequest req) {
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)req);
        if (!"admin".equals(username)) {
            return Result.error((String)"noadminauth");
        }
        ArrayList<String> list = new ArrayList();
        try {
            list = DbReadTableUtil.a();
        }
        catch (SQLException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
            return Result.error((String)"\u540c\u6b65\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u6570\u636e\u5e93\u8868\u4fe1\u606f");
        }
        CgformUtil.sortStringList(list);
        List<String> onlineTables = this.onlCgformHeadService.queryOnlinetables();
        list.removeAll(onlineTables);
        ArrayList result = new ArrayList();
        for (String str : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", str);
            result.add(map);
        }
        return Result.ok(result);
    }

    @PostMapping(value={"/transTables/{tbnames}"})
    @RequiresRoles(value={"admin"})
    public Result<?> transTables(@PathVariable(value="tbnames") String tbnames, HttpServletRequest req) {
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)req);
        if (!"admin".equals(username)) {
            return Result.error((String)"noadminauth");
        }
        if (oConvertUtils.isEmpty((Object)tbnames)) {
            return Result.error((String)"\u672a\u8bc6\u522b\u7684\u8868\u540d\u4fe1\u606f");
        }
        if (GENERATE_FORM_IDS != null && GENERATE_FORM_IDS.equals(tbnames)) {
            return Result.error((String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210!");
        }
        GENERATE_FORM_IDS = tbnames;
        String[] arr = tbnames.split(",");
        for (int i = 0; i < arr.length; ++i) {
            int count;
            if (!oConvertUtils.isNotEmpty((Object)arr[i]) || (count = this.onlCgformHeadService.count((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)arr[i]))) > 0) continue;
            log.info("[IP] [online\u6570\u636e\u5e93\u5bfc\u5165\u8868]   --\u8868\u540d\uff1a" + arr[i]);
            this.onlCgformHeadService.saveDbTable2Online(arr[i]);
        }
        GENERATE_FORM_IDS = null;
        return Result.ok((String)"\u540c\u6b65\u5b8c\u6210!");
    }

    @GetMapping(value={"/rootFile"})
    public Result<?> rootFile() {
        File[] roots;
        JSONArray array = new JSONArray();
        for (File f : roots = File.listRoots()) {
            JSONObject item = new JSONObject();
            if (f.isDirectory()) {
                System.out.println(f.getPath());
                item.put("key", (Object)f.getAbsolutePath());
                item.put("title", (Object)f.getPath());
                item.put("opened", (Object)false);
                JSONObject scopedSlots = new JSONObject();
                scopedSlots.put("icon", (Object)"custom");
                item.put("scopedSlots", (Object)scopedSlots);
                item.put("isLeaf", (Object)(f.listFiles() == null || f.listFiles().length == 0 ? 1 : 0));
            }
            array.add((Object)item);
        }
        return Result.ok((Object)array);
    }

    @GetMapping(value={"/fileTree"})
    public Result<?> fileTree(@RequestParam(name="parentPath", required=true) String parentPath) {
        File[] roots;
        JSONArray array = new JSONArray();
        File file = new File(parentPath);
        for (File f : roots = file.listFiles()) {
            if (!f.isDirectory() || !oConvertUtils.isNotEmpty((Object)f.getPath())) continue;
            JSONObject item = new JSONObject();
            System.out.println(f.getPath());
            item.put("key", (Object)f.getAbsolutePath());
            item.put("title", (Object)f.getPath().substring(f.getPath().lastIndexOf(File.separator) + 1));
            item.put("isLeaf", (Object)(f.listFiles() == null || f.listFiles().length == 0 ? 1 : 0));
            item.put("opened", (Object)false);
            JSONObject scopedSlots = new JSONObject();
            scopedSlots.put("icon", (Object)"custom");
            item.put("scopedSlots", (Object)scopedSlots);
            array.add((Object)item);
        }
        return Result.ok((Object)array);
    }

    @GetMapping(value={"/tableInfo"})
    public Result<?> tableInfo(@RequestParam(name="code", required=true) String code) {
        String subtable;
        OnlCgformHead onlCgformHead = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)code));
        if (onlCgformHead == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("main", onlCgformHead);
        if (onlCgformHead.getTableType() == 2 && oConvertUtils.isNotEmpty((Object)(subtable = onlCgformHead.getSubTableStr()))) {
            String[] arr;
            ArrayList<OnlCgformHead> subList = new ArrayList<OnlCgformHead>();
            for (String string : arr = subtable.split(",")) {
                LambdaQueryWrapper query = new LambdaQueryWrapper();
                query.eq(OnlCgformHead::getTableName, (Object)string);
                OnlCgformHead sub = (OnlCgformHead)this.onlCgformHeadService.getOne((Wrapper)query);
                subList.add(sub);
            }
            map.put("sub", subList);
        }
        map.put("projectPath", a.m());
        return Result.ok(map);
    }
}

