/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.cgform.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.PermissionData;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.util.BrowserUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgform.entity.OnlCgformButton;
import org.jeecg.modules.online.cgform.entity.OnlCgformEnhanceJs;
import org.jeecg.modules.online.cgform.entity.OnlCgformField;
import org.jeecg.modules.online.cgform.entity.OnlCgformHead;
import org.jeecg.modules.online.cgform.model.OnlCgformModel;
import org.jeecg.modules.online.cgform.model.OnlGenerateModel;
import org.jeecg.modules.online.cgform.service.IOnlCgformFieldService;
import org.jeecg.modules.online.cgform.service.IOnlCgformHeadService;
import org.jeecg.modules.online.cgform.util.CgFormExcelHandler;
import org.jeecg.modules.online.cgform.util.CgformUtil;
import org.jeecg.modules.online.config.exception.DBException;
import org.jeecg.modules.online.config.util.DbTableUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.handler.inter.IExcelDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.support.incrementer.OracleSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.PostgreSQLSequenceMaxValueIncrementer;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/online/cgform/api"})
public class OnlCgformApiController {
    private static final Logger log = LoggerFactory.getLogger(OnlCgformApiController.class);
    @Autowired
    private IOnlCgformHeadService onlCgformHeadService;
    @Autowired
    private IOnlCgformFieldService onlCgformFieldService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    @PostMapping(value={"/addAll"})
    public Result<?> addAll(@RequestBody OnlCgformModel model) {
        try {
            String tbname = model.getHead().getTableName();
            if (DbTableUtil.judgeTableIsExit(tbname).booleanValue()) {
                return Result.error((String)("\u6570\u636e\u5e93\u8868[" + tbname + "]\u5df2\u5b58\u5728,\u8bf7\u4ece\u6570\u636e\u5e93\u5bfc\u5165\u8868\u5355"));
            }
            return this.onlCgformHeadService.addAll(model);
        }
        catch (Exception e) {
            log.error("OnlCgformApiController.addAll()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            return Result.error((String)"\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @PutMapping(value={"/editAll"})
    public Result<?> editAll(@RequestBody OnlCgformModel model) {
        try {
            return this.onlCgformHeadService.editAll(model);
        }
        catch (Exception e) {
            log.error("OnlCgformApiController.editAll()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            return Result.error((String)"\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @GetMapping(value={"/getColumns/{code}"})
    public Result<Map<String, Object>> getColumns(@PathVariable(value="code") String code) {
        Result result = new Result();
        OnlCgformHead head = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)code));
        if (head == null) {
            result.error500("\u5b9e\u4f53\u4e0d\u5b58\u5728");
            return result;
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)code);
        query.eq(OnlCgformField::getIsShowList, (Object)1);
        query.orderByAsc((Object[])new SFunction[]{OnlCgformField::getOrderNum});
        List fieldList = this.onlCgformFieldService.list((Wrapper)query);
        List<String> list = this.onlCgformFieldService.selectOnlineHideColumns(head.getTableName());
        ArrayList<Object> columns = new ArrayList<Object>();
        HashMap dictOptions = new HashMap();
        for (OnlCgformField item : fieldList) {
            JSONObject scopedSlots;
            String view;
            List ls;
            String dbFieldName = item.getDbFieldName();
            if ("id".equals(dbFieldName) || list.contains(dbFieldName)) continue;
            HashMap<String, String> column = new HashMap<String, String>(3);
            column.put("title", item.getDbFieldTxt());
            column.put("dataIndex", dbFieldName);
            column.put("align", "center");
            String dictCode = item.getDictField();
            if (oConvertUtils.isNotEmpty((Object)dictCode) && !"popup".equals(item.getFieldShowType())) {
                ls = new ArrayList();
                if (oConvertUtils.isNotEmpty((Object)item.getDictTable())) {
                    ls = this.sysBaseAPI.queryTableDictItemsByCode(item.getDictTable(), item.getDictText(), dictCode);
                } else if (oConvertUtils.isNotEmpty((Object)item.getDictField())) {
                    ls = this.sysBaseAPI.queryDictItemsByCode(dictCode);
                }
                dictOptions.put(dbFieldName, ls);
                column.put("customRender", dbFieldName);
            }
            if ("sel_depart".equals(item.getFieldShowType())) {
                ls = this.sysBaseAPI.queryAllDepartBackDictModel();
                dictOptions.put(dbFieldName, ls);
                column.put("customRender", dbFieldName);
            }
            if ((view = item.getFieldShowType()).indexOf("file") >= 0) {
                scopedSlots = new JSONObject();
                scopedSlots.put("customRender", (Object)"fileSlot");
                column.put("scopedSlots", (String)scopedSlots);
            } else if (view.indexOf("image") >= 0) {
                scopedSlots = new JSONObject();
                scopedSlots.put("customRender", (Object)"imgSlot");
                column.put("scopedSlots", (String)scopedSlots);
            } else if (view.indexOf("editor") >= 0) {
                scopedSlots = new JSONObject();
                scopedSlots.put("customRender", (Object)"htmlSlot");
                column.put("scopedSlots", (String)scopedSlots);
            } else if ("date".equals(view)) {
                scopedSlots = new JSONObject();
                scopedSlots.put("customRender", (Object)"dateSlot");
                column.put("scopedSlots", (String)scopedSlots);
            }
            String dbtype = item.getDbType();
            if ("int".equals(dbtype) || "double".equals(dbtype) || "BigDecimal".equals(dbtype) || "Date".equals(dbtype)) {
                column.put("sorter", (String)((Object)Boolean.valueOf(true)));
            }
            columns.add(column);
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("columns", columns);
        info.put("dictOptions", dictOptions);
        info.put("formTemplate", head.getFormTemplate());
        info.put("description", head.getTableTxt());
        info.put("currentTableName", head.getTableName());
        List<OnlCgformButton> cgButtonList = this.onlCgformHeadService.queryButtonList(code, true);
        ArrayList<OnlCgformButton> cgFinalBtnList = new ArrayList<OnlCgformButton>();
        for (OnlCgformButton onlCgformButton : cgButtonList) {
            if (list.contains(onlCgformButton.getButtonCode())) continue;
            cgFinalBtnList.add(onlCgformButton);
        }
        info.put("cgButtonList", cgFinalBtnList);
        OnlCgformEnhanceJs enhanceJs = this.onlCgformHeadService.queryEnhanceJs(code, "list");
        if (enhanceJs != null && oConvertUtils.isNotEmpty((Object)enhanceJs.getCgJs())) {
            info.put("enhanceJs", CgformUtil.overwriteJs(enhanceJs.getCgJs(), cgButtonList));
        }
        info.put("hideColumns", list);
        result.setResult(info);
        return result;
    }

    @GetMapping(value={"/getData/{code}"})
    @PermissionData
    public Result<Map<String, Object>> getData(@PathVariable(value="code") String code, HttpServletRequest request) {
        Result result = new Result();
        OnlCgformHead head = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)code));
        if (head == null) {
            result.error500("\u5b9e\u4f53\u4e0d\u5b58\u5728");
            return result;
        }
        try {
            String tbname = head.getTableName();
            Map<String, Object> params = CgformUtil.getParameterMap(request);
            Map<String, Object> page = this.onlCgformFieldService.queryAutolistPage(tbname, code, params);
            result.setResult(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u6570\u636e\u5e93\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        return result;
    }

    @GetMapping(value={"/getFormItem/{code}"})
    public Result<?> getFormItem(@PathVariable(value="code") String code, HttpServletRequest request) {
        String subStr;
        OnlCgformHead head = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)code));
        if (head == null) {
            Result.error((String)"\u8868\u4e0d\u5b58\u5728");
        }
        Result result = new Result();
        JSONObject obj = new JSONObject();
        OnlCgformEnhanceJs onlCgformEnhanceJs = this.onlCgformHeadService.queryEnhanceJs(code, "form");
        List<OnlCgformField> fieldList = this.onlCgformFieldService.queryAvailableFields(head.getId(), head.getTableName(), false);
        List<String> disabledFieldNameList = this.onlCgformFieldService.queryDisabledFields(head.getTableName());
        CgformUtil.overwriteJs(onlCgformEnhanceJs, head.getTableName(), fieldList, true);
        JSONObject schema = CgformUtil.getJsonSchemaByCgformFieldList(fieldList, disabledFieldNameList);
        if (head.getTableType() == 2 && oConvertUtils.isNotEmpty((Object)(subStr = head.getSubTableStr()))) {
            for (String tbname : subStr.split(",")) {
                OnlCgformHead tempTable = (OnlCgformHead)this.onlCgformHeadService.getOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)tbname));
                if (tempTable == null) continue;
                List<OnlCgformField> subFieldList = this.onlCgformFieldService.queryAvailableFields(tempTable.getId(), tempTable.getTableName(), false);
                CgformUtil.overwriteJs(onlCgformEnhanceJs, tempTable.getTableName(), subFieldList);
                JSONObject subJson = new JSONObject();
                subJson.put("columns", (Object)CgformUtil.getJEditableTableColumnsJson(subFieldList));
                subJson.put("describe", (Object)tempTable.getTableTxt());
                subJson.put("key", (Object)tempTable.getTableName());
                subJson.put("view", (Object)"tab");
                schema.getJSONObject("properties").put(tempTable.getTableName(), (Object)subJson);
            }
        }
        obj.put("schema", (Object)schema);
        obj.put("head", (Object)head);
        List<OnlCgformButton> cgButtonList = this.onlCgformHeadService.queryButtonList(code, false);
        if (cgButtonList != null && cgButtonList.size() > 0) {
            obj.put("cgButtonList", cgButtonList);
        }
        if (onlCgformEnhanceJs != null && oConvertUtils.isNotEmpty((Object)onlCgformEnhanceJs.getCgJs())) {
            obj.put("enhanceJs", (Object)CgformUtil.returnEnhanceJsClass(CgformUtil.overwriteJsByButtonStyle(onlCgformEnhanceJs.getCgJs(), cgButtonList)));
        }
        result.setResult((Object)obj);
        return result;
    }

    @GetMapping(value={"/getFormItemBytbname/{table}"})
    public Result<?> getFormItemBytbname(@PathVariable(value="table") String table) {
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformHead::getTableName, (Object)table);
        OnlCgformHead head = (OnlCgformHead)this.onlCgformHeadService.getOne((Wrapper)query);
        if (head == null) {
            Result.error((String)"\u8868\u4e0d\u5b58\u5728");
        }
        JSONObject obj = new JSONObject();
        obj.put("schema", (Object)this.onlCgformHeadService.queryFormItem(head));
        obj.put("head", (Object)head);
        result.setResult((Object)obj);
        return result;
    }

    @GetMapping(value={"/getEnhanceJs/{code}"})
    public Result<?> getEnhanceJs(@PathVariable(value="code") String code, HttpServletRequest request) {
        String enhanceJsStr = "";
        OnlCgformEnhanceJs enhanceJs = this.onlCgformHeadService.queryEnhanceJs(code, "form");
        if (enhanceJs != null && oConvertUtils.isNotEmpty((Object)enhanceJs.getCgJs())) {
            enhanceJsStr = CgformUtil.overwriteJs(enhanceJs.getCgJs(), null);
        }
        return Result.ok((String)enhanceJsStr);
    }

    @GetMapping(value={"/form/{code}/{id}"})
    public Result<?> getFormData(@PathVariable(value="code") String code, @PathVariable(value="id") String id) {
        try {
            Map<String, Object> map = this.onlCgformHeadService.queryManyFormData(code, id);
            return Result.ok(CgformUtil.transLowerCaseMapKey(map));
        }
        catch (Exception e) {
            log.error("Online\u8868\u5355\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @PostMapping(value={"/form/{code}"})
    public Result<?> formAdd(@PathVariable(value="code") String code, @RequestBody JSONObject jsonObject) {
        try {
            this.onlCgformHeadService.saveManyFormData(code, jsonObject);
        }
        catch (Exception e) {
            log.error("OnlCgformApiController.formAdd()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return Result.ok((String)"\u4fdd\u5b58\u6210\u529f!");
    }

    @PutMapping(value={"/form/{code}"})
    public Result<?> formEdit(@PathVariable(value="code") String code, @RequestBody JSONObject jsonObject) {
        try {
            this.onlCgformHeadService.editManyFormData(code, jsonObject);
        }
        catch (Exception e) {
            log.error("OnlCgformApiController.formEdit()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            return Result.error((String)"\u4fee\u6539\u5931\u8d25");
        }
        return Result.ok((String)"\u4fee\u6539\u6210\u529f!");
    }

    @DeleteMapping(value={"/form/{code}/{id}"})
    public Result<?> formEdit(@PathVariable(value="code") String code, @PathVariable(value="id") String id) {
        try {
            if (id.indexOf(",") > 0) {
                OnlCgformHead head = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)code));
                if (head == null) {
                    return Result.error((String)"\u5b9e\u4f53\u4e0d\u5b58\u5728");
                }
                String tbname = head.getTableName();
                this.onlCgformFieldService.deleteAutoList(tbname, id);
            } else {
                this.onlCgformHeadService.deleteOneTableInfo(code, id);
            }
        }
        catch (Exception e) {
            log.error("OnlCgformApiController.formEdit()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            return Result.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @GetMapping(value={"/getQueryInfo/{code}"})
    public Result<?> getQueryInfo(@PathVariable(value="code") String code) {
        try {
            List<Map<String, String>> list = this.onlCgformFieldService.getAutoListQueryInfo(code);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error("OnlCgformApiController.getQueryInfo()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            return Result.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @PostMapping(value={"/doDbSynch/{code}/{synMethod}"})
    public Result<?> doDbSynch(@PathVariable(value="code") String code, @PathVariable(value="synMethod") String synMethod) {
        try {
            this.onlCgformHeadService.doDbSynch(code, synMethod);
        }
        catch (Exception e) {
            log.error("OnlCgformApiController.doDbSynch()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            return Result.error((String)"\u540c\u6b65\u6570\u636e\u5e93\u5931\u8d25");
        }
        return Result.ok((String)"\u540c\u6b65\u6570\u636e\u5e93\u6210\u529f!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/exportXls/{code}"})
    public void exportXls(@PathVariable(value="code") String code, HttpServletRequest request, HttpServletResponse response) {
        String subTableStr;
        String selections;
        OnlCgformHead head = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)code));
        if (head == null) {
            return;
        }
        String sheetName = head.getTableTxt();
        String paramsStr = request.getParameter("paramsStr");
        HashMap<String, Object> params = new HashMap();
        String deString = null;
        if (oConvertUtils.isNotEmpty((Object)paramsStr)) {
            try {
                deString = URLDecoder.decode(paramsStr, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (deString != null) {
                params = (Map)JSONObject.parseObject((String)deString, Map.class);
            }
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)code);
        query.orderByAsc((Object[])new SFunction[]{OnlCgformField::getOrderNum});
        List fieldList = this.onlCgformFieldService.list((Wrapper)query);
        String sql = CgformUtil.getQueryListDataCondition(head.getTableName(), fieldList, params);
        log.info("-----------\u52a8\u6001\u5217\u8868\u67e5\u8be2sql\u300b\u300b" + sql);
        List<Map<String, Object>> data = this.onlCgformHeadService.queryListData(sql);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String string = selections = params.get("selections") == null ? null : params.get("selections").toString();
        if (oConvertUtils.isNotEmpty((Object)selections)) {
            List<String> selectionList = Arrays.asList(selections.split(","));
            result = data.stream().filter(item -> selectionList.contains(item.get("id"))).collect(Collectors.toList());
        } else {
            result.addAll(data);
        }
        List<ExcelExportEntity> entityList = this.convertToExportEntity(fieldList, "id");
        if (head.getTableType() == 2 && oConvertUtils.isNotEmpty((Object)(subTableStr = head.getSubTableStr()))) {
            String[] subTables;
            for (String subTable : subTables = subTableStr.split(",")) {
                this.addAllSubTableDate(subTable, params, result, entityList);
            }
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(null, sheetName), entityList, result);
        OutputStream outputStream = null;
        try {
            response.setContentType("application/x-msdownload;charset=utf-8");
            String browse = BrowserUtils.checkBrowse((HttpServletRequest)request);
            String codedFileName = head.getTableTxt() + "-v" + head.getTableVersion();
            if ("MSIE".equalsIgnoreCase(browse.substring(0, 4))) {
                response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
            } else {
                String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
            }
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            response.flushBuffer();
        }
        catch (Exception e) {
            log.error("--\u901a\u8fc7\u6d41\u7684\u65b9\u5f0f\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38--" + e.getMessage());
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @PostMapping(value={"/importXls/{code}"})
    public Result<?> importXls(@PathVariable(value="code") String code, HttpServletRequest request, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        String message = "";
        try {
            OnlCgformHead head = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)code));
            if (head == null) {
                return Result.error((String)"\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8be5\u8868\u8bb0\u5f55");
            }
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(OnlCgformField::getCgformHeadId, (Object)code);
            List fieldList = this.onlCgformFieldService.list((Wrapper)query);
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
            String databaseType = DbTableUtil.getDatabaseType(dataSource);
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile file = (MultipartFile)entity.getValue();
                ImportParams params = new ImportParams();
                params.setDataHanlder((IExcelDataHandler)new CgFormExcelHandler(fieldList));
                List listDate = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), Map.class, (ImportParams)params);
                if (listDate == null) {
                    message = "\u8bc6\u522b\u6a21\u7248\u6570\u636e\u9519\u8bef";
                    log.error(message);
                    continue;
                }
                Object mainId = "";
                for (Map map : listDate) {
                    boolean isMainData = false;
                    Set keySet = map.keySet();
                    HashMap mainData = new HashMap();
                    for (String key : keySet) {
                        if (key.indexOf("$subTable$") != -1) continue;
                        if (key.indexOf("$mainTable$") != -1 && oConvertUtils.isNotEmpty((Object)map.get(key).toString())) {
                            isMainData = true;
                            mainId = this.getPkValue(head, dataSource, databaseType);
                        }
                        mainData.put(key.replace("$mainTable$", ""), map.get(key));
                    }
                    if (isMainData) {
                        this.dealDicForImport(mainData, fieldList);
                        mainData.put("id", mainId);
                        String jsonStr = JSON.toJSONString(mainData);
                        this.onlCgformFieldService.saveFormData(fieldList, head.getTableName(), JSONObject.parseObject((String)jsonStr));
                        mainId = mainData.get("id");
                    }
                    map.put("$mainTable$id", mainId);
                }
                if (head.getTableType() == 2 && oConvertUtils.isNotEmpty((Object)head.getSubTableStr())) {
                    for (String tbname : head.getSubTableStr().split(",")) {
                        OnlCgformHead subTable = (OnlCgformHead)this.onlCgformHeadService.getOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)tbname));
                        if (subTable == null) continue;
                        LambdaQueryWrapper subFieldQuery = new LambdaQueryWrapper();
                        subFieldQuery.eq(OnlCgformField::getCgformHeadId, (Object)subTable.getId());
                        List subLists = this.onlCgformFieldService.list((Wrapper)subFieldQuery);
                        String configName = subTable.getTableTxt();
                        for (Map map : listDate) {
                            boolean isSubData = false;
                            HashMap<String, Object> subData = new HashMap<String, Object>();
                            for (OnlCgformField fieldEntity : subLists) {
                                Object subObj;
                                String mainTab = fieldEntity.getMainTable();
                                String mainField = fieldEntity.getMainField();
                                boolean isForeignKey = head.getTableName().equals(mainTab) && oConvertUtils.isNotEmpty((Object)mainField);
                                String tempKey = configName + "_" + fieldEntity.getDbFieldTxt();
                                if (isForeignKey) {
                                    subData.put(fieldEntity.getDbFieldName(), map.get("$mainTable$" + mainField));
                                }
                                if (null == (subObj = map.get("$subTable$" + tempKey)) || !oConvertUtils.isNotEmpty((Object)subObj.toString())) continue;
                                isSubData = true;
                                subData.put(fieldEntity.getDbFieldName(), subObj);
                            }
                            if (!isSubData) continue;
                            this.dealDicForImport(subData, subLists);
                            subData.put("id", this.getPkValue(subTable, dataSource, databaseType));
                            String subJsonStr = JSON.toJSONString(subData);
                            this.onlCgformFieldService.saveFormData(subLists, subTable.getTableName(), JSONObject.parseObject((String)subJsonStr));
                        }
                    }
                }
                message = "\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01";
            }
            result.setSuccess(true);
            result.setMessage("\u5bfc\u5165\u6210\u529f!");
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("=====online\u5bfc\u5165\u6570\u636e\u5b8c\u6210,\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2=====");
        return result;
    }

    @PostMapping(value={"/doButton"})
    public Result<?> doButton(@RequestBody JSONObject json) {
        String formId = json.getString("formId");
        String dataId = json.getString("dataId");
        String buttonCode = json.getString("buttonCode");
        try {
            this.onlCgformHeadService.executeCustomerButton(buttonCode, formId, dataId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u6267\u884c\u5931\u8d25!");
        }
        return Result.ok((String)"\u6267\u884c\u6210\u529f!");
    }

    public Object getPkValue(OnlCgformHead cghead, DataSource dataSource, String dbType) throws SQLException, DBException {
        Object pkValue = null;
        String pkType = cghead.getIdType();
        String pkSequence = cghead.getIdSequence();
        if (oConvertUtils.isNotEmpty((Object)pkType) && "UUID".equalsIgnoreCase(pkType)) {
            pkValue = UUIDGenerator.generate();
        } else if (oConvertUtils.isNotEmpty((Object)pkType) && "NATIVE".equalsIgnoreCase(pkType)) {
            if (oConvertUtils.isNotEmpty((Object)dbType) && "oracle".equalsIgnoreCase(dbType)) {
                OracleSequenceMaxValueIncrementer incr = new OracleSequenceMaxValueIncrementer(dataSource, "HIBERNATE_SEQUENCE");
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else if (oConvertUtils.isNotEmpty((Object)dbType) && "postgres".equalsIgnoreCase(dbType)) {
                PostgreSQLSequenceMaxValueIncrementer incr = new PostgreSQLSequenceMaxValueIncrementer(dataSource, "HIBERNATE_SEQUENCE");
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                pkValue = null;
            }
        } else if (oConvertUtils.isNotEmpty((Object)pkType) && "SEQUENCE".equalsIgnoreCase(pkType)) {
            if (oConvertUtils.isNotEmpty((Object)dbType) && "oracle".equalsIgnoreCase(dbType)) {
                OracleSequenceMaxValueIncrementer incr = new OracleSequenceMaxValueIncrementer(dataSource, pkSequence);
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else if (oConvertUtils.isNotEmpty((Object)dbType) && "postgres".equalsIgnoreCase(dbType)) {
                PostgreSQLSequenceMaxValueIncrementer incr = new PostgreSQLSequenceMaxValueIncrementer(dataSource, pkSequence);
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                pkValue = null;
            }
        } else {
            pkValue = UUIDGenerator.generate();
        }
        return pkValue;
    }

    private void dealDicForImport(Map result, List<OnlCgformField> beans) {
        for (OnlCgformField bean : beans) {
            String dicTable = bean.getDictTable();
            String dicCode = bean.getDictField();
            String dicText = bean.getDictText();
            if (oConvertUtils.isEmpty((Object)dicTable) && oConvertUtils.isEmpty((Object)dicCode) || "popup".equals(bean.getFieldShowType())) continue;
            String value = String.valueOf(result.get(bean.getDbFieldName()));
            List dicDataList = oConvertUtils.isEmpty((Object)dicTable) ? this.sysBaseAPI.queryDictItemsByCode(dicCode) : this.sysBaseAPI.queryTableDictItemsByCode(dicTable, dicText, dicCode);
            for (DictModel item : dicDataList) {
                if (!value.equals(item.getText())) continue;
                result.put(bean.getDbFieldName(), item.getValue());
            }
        }
    }

    private List<ExcelExportEntity> convertToExportEntity(List<OnlCgformField> lists, String pkField) {
        ArrayList<ExcelExportEntity> entityList = new ArrayList<ExcelExportEntity>();
        for (int i = 0; i < lists.size(); ++i) {
            int columnWidth;
            if (null != pkField && pkField.equals(lists.get(i).getDbFieldName()) || lists.get(i).getIsShowList() != 1) continue;
            ExcelExportEntity entity = new ExcelExportEntity(lists.get(i).getDbFieldTxt(), (Object)lists.get(i).getDbFieldName());
            int n = lists.get(i).getDbLength() == 0 ? 12 : (columnWidth = lists.get(i).getDbLength() > 30 ? 30 : lists.get(i).getDbLength());
            if (lists.get(i).getFieldShowType().equals("date")) {
                entity.setFormat("yyyy-MM-dd");
            } else if (lists.get(i).getFieldShowType().equals("datetime")) {
                entity.setFormat("yyyy-MM-dd HH:mm:ss");
            }
            entity.setWidth((double)columnWidth);
            String dictCode = lists.get(i).getDictField();
            if (oConvertUtils.isNotEmpty((Object)dictCode)) {
                ArrayList<String> dictReplaces = new ArrayList<String>();
                List dictList = this.sysBaseAPI.queryDictItemsByCode(dictCode);
                for (DictModel d : dictList) {
                    dictReplaces.add(d.getText() + "_" + d.getValue());
                }
                entity.setReplace(dictReplaces.toArray(new String[dictReplaces.size()]));
            }
            entityList.add(entity);
        }
        return entityList;
    }

    private void addAllSubTableDate(String subTable, Map<String, Object> params, List<Map<String, Object>> result, List<ExcelExportEntity> entityList) {
        OnlCgformHead head = (OnlCgformHead)this.onlCgformHeadService.getOne((Wrapper)new LambdaQueryWrapper().eq(OnlCgformHead::getTableName, (Object)subTable));
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(OnlCgformField::getCgformHeadId, (Object)head.getId());
        query.orderByAsc((Object[])new SFunction[]{OnlCgformField::getOrderNum});
        List fieldList = this.onlCgformFieldService.list((Wrapper)query);
        String mainField = "";
        String linkField = "";
        for (OnlCgformField onlCgformField : fieldList) {
            if (!oConvertUtils.isNotEmpty((Object)onlCgformField.getMainField())) continue;
            mainField = onlCgformField.getMainField();
            linkField = onlCgformField.getDbFieldName();
            break;
        }
        ExcelExportEntity tableEntity = new ExcelExportEntity(head.getTableTxt(), (Object)subTable);
        tableEntity.setList(this.convertToExportEntity(fieldList, "id"));
        entityList.add(tableEntity);
        for (int i = 0; i < result.size(); ++i) {
            params.put(linkField, result.get(i).get(mainField));
            String sql = CgformUtil.getQueryListDataCondition(head.getTableName(), fieldList, params);
            log.info("-----------\u52a8\u6001\u5217\u8868\u67e5\u8be2\u5b50\u8868sql\u300b\u300b" + sql);
            List<Map<String, Object>> subResult = this.onlCgformHeadService.queryListData(sql);
            result.get(i).put(subTable, subResult);
        }
    }

    @GetMapping(value={"/checkOnlyTable"})
    public Result<?> checkOnlyTable(@RequestParam(value="tbname") String tbname, @RequestParam(value="id") String id) {
        OnlCgformHead head;
        if (oConvertUtils.isEmpty((Object)id) ? DbTableUtil.judgeTableIsExit(tbname) != false : !tbname.equals((head = (OnlCgformHead)this.onlCgformHeadService.getById((Serializable)((Object)id))).getTableName()) && DbTableUtil.judgeTableIsExit(tbname) != false) {
            return Result.ok((Object)-1);
        }
        return Result.ok((Object)1);
    }

    @PostMapping(value={"/codeGenerate"})
    public Result<?> codeGenerate(@RequestBody JSONObject json) {
        OnlGenerateModel model = (OnlGenerateModel)JSONObject.parseObject((String)json.toJSONString(), OnlGenerateModel.class);
        if ("1".equals(model.getJformType())) {
            this.onlCgformHeadService.generateCode(model);
        } else {
            this.onlCgformHeadService.generateOneToMany(model);
        }
        return Result.ok((Object)1);
    }
}

