/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.web.back;

import com.jeecg.p3.paycenter.entity.PaycenterRoute;
import com.jeecg.p3.paycenter.enums.PayTypeEnum;
import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.service.PaycenterRouteService;
import com.jeecg.p3.paycenter.util.JSONHelper;
import com.jeecg.p3.paycenter.vo.WeixinPayDto;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.oConvertUtils;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/paycenter/back/paycenterRoute"})
public class PaycenterRouteController
extends BaseController {
    @Autowired
    private PaycenterRouteService paycenterRouteService;

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute PaycenterRoute query, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        try {
            PageQuery pageQuery = new PageQuery();
            pageQuery.setPageNo(pageNo);
            pageQuery.setPageSize(pageSize);
            String jwid = (String)request.getSession().getAttribute("jwid");
            if (oConvertUtils.isEmpty((Object)jwid)) {
                throw new BusinessException("\u5fae\u4fe1\u516c\u4f17\u53f7\u83b7\u53d6\u5931\u8d25");
            }
            query.setJwid(jwid);
            pageQuery.setQuery((Object)query);
            velocityContext.put("paycenterRoute", (Object)query);
            velocityContext.put("payTypeEnums", (Object)PayTypeEnum.values());
            velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.paycenterRouteService.queryPageList((PageQuery<PaycenterRoute>)pageQuery)));
        }
        catch (Exception e) {
            this.LOG.info(e.getMessage());
        }
        String viewName = "paycenter/back/paycenterRoute-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void paycenterRouteDetail(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "paycenter/back/paycenterRoute-detail.vm";
        PaycenterRoute paycenterRoute = this.paycenterRouteService.queryById(id);
        velocityContext.put("paycenterRoute", (Object)paycenterRoute);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "paycenter/back/paycenterRoute-add.vm";
        velocityContext.put("payTypeEnums", (Object)PayTypeEnum.values());
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(HttpServletRequest request, @ModelAttribute PaycenterRoute paycenterRoute, @ModelAttribute WeixinPayDto weixinPayDto) {
        AjaxJson j = new AjaxJson();
        try {
            String jwid = (String)request.getSession().getAttribute("jwid");
            if (oConvertUtils.isEmpty((Object)jwid)) {
                throw new BusinessException("\u5fae\u4fe1\u516c\u4f17\u53f7\u83b7\u53d6\u5931\u8d25");
            }
            String payType = request.getParameter("payType");
            if (PayTypeEnum.weixinpay.getCode().equals(payType)) {
                LinkedHashMap<String, String> payPojoMap = new LinkedHashMap<String, String>();
                payPojoMap.put("appid", weixinPayDto.getAppid());
                payPojoMap.put("mch_id", weixinPayDto.getMch_id());
                payPojoMap.put("key", weixinPayDto.getKey());
                payPojoMap.put("certFileName", weixinPayDto.getCertFileName());
                String payJson = JSONHelper.map2json(payPojoMap);
                paycenterRoute.setPayJson(payJson);
            } else if (PayTypeEnum.alipay.getCode().equals(payType)) {
                String partner = request.getParameter("partner");
                String md5_key = request.getParameter("md5_key");
                LinkedHashMap<String, String> payPojoMap = new LinkedHashMap<String, String>();
                payPojoMap.put("partner", partner);
                payPojoMap.put("key", md5_key);
                String payJson = JSONHelper.map2json(payPojoMap);
                paycenterRoute.setJwid(partner);
                paycenterRoute.setPayJson(payJson);
            }
            this.paycenterRouteService.doAdd(paycenterRoute);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25,\u68c0\u67e5\u8be5\u516c\u4f17\u53f7\u662f\u5426\u5df2\u914d\u7f6e");
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        PaycenterRoute paycenterRoute = this.paycenterRouteService.queryById(id);
        velocityContext.put("paycenterRoute", (Object)paycenterRoute);
        velocityContext.put("payTypeEnums", (Object)PayTypeEnum.values());
        String viewName = "paycenter/back/paycenterRoute-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(HttpServletRequest request, @ModelAttribute PaycenterRoute paycenterRoute, @ModelAttribute WeixinPayDto weixinPayDto) {
        AjaxJson j = new AjaxJson();
        try {
            String payType = request.getParameter("payType");
            if (PayTypeEnum.weixinpay.getCode().equals(payType)) {
                LinkedHashMap<String, String> payPojoMap = new LinkedHashMap<String, String>();
                payPojoMap.put("appid", weixinPayDto.getAppid());
                payPojoMap.put("mch_id", weixinPayDto.getMch_id());
                payPojoMap.put("key", weixinPayDto.getKey());
                payPojoMap.put("certFileName", weixinPayDto.getCertFileName());
                String payJson = JSONHelper.map2json(payPojoMap);
                paycenterRoute.setPayJson(payJson);
            } else if (PayTypeEnum.alipay.getCode().equals(payType)) {
                String partner = request.getParameter("partner");
                String md5_key = request.getParameter("md5_key");
                LinkedHashMap<String, String> payPojoMap = new LinkedHashMap<String, String>();
                payPojoMap.put("partner", partner);
                payPojoMap.put("key", md5_key);
                String payJson = JSONHelper.map2json(payPojoMap);
                paycenterRoute.setJwid(partner);
                paycenterRoute.setPayJson(payJson);
            }
            this.paycenterRouteService.doEdit(paycenterRoute);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            this.paycenterRouteService.doDelete(id);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }
}

