/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.web;

import com.jeecg.p3.paycenter.entity.PaycenterConfig;
import com.jeecg.p3.paycenter.entity.PaycenterRedpackOrder;
import com.jeecg.p3.paycenter.entity.PaycenterRoute;
import com.jeecg.p3.paycenter.enums.PayTypeEnum;
import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.service.PayCenterRedPackService;
import com.jeecg.p3.paycenter.service.PaycenterConfigService;
import com.jeecg.p3.paycenter.service.PaycenterRedpackOrderService;
import com.jeecg.p3.paycenter.service.PaycenterRouteService;
import com.jeecg.p3.paycenter.util.JSONHelper;
import com.jeecg.p3.paycenter.util.RedPackUtil;
import com.jeecg.p3.paycenter.util.XMLParseUtil;
import com.jeecg.p3.paycenter.util.XMLUtil;
import com.jeecg.p3.paycenter.vo.RedPackInfoBaseVo;
import com.jeecg.p3.paycenter.vo.RedPackInfoResponse;
import com.jeecg.p3.paycenter.vo.SendRedPackBaseVo;
import com.jeecg.p3.paycenter.vo.WeixinPayDto;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/paycenter/redpack"})
public class PaycenterRedPackController
extends BaseController {
    public static final Logger log = LoggerFactory.getLogger(PaycenterRedPackController.class);
    private static final String REDPACKURL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack";
    private static final String REDPACK_INFOURL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gethbinfo";
    @Autowired
    private PaycenterConfigService paycenterConfigService;
    @Autowired
    private PaycenterRouteService paycenterRouteService;
    @Autowired
    private PayCenterRedPackService payCenterRedPackService;
    @Autowired
    private PaycenterRedpackOrderService paycenterRedpackOrderService;

    @RequestMapping(value={"/sendRedPack"})
    public void sendRedPack(SendRedPackBaseVo sendRedPackBaseVo, HttpServletRequest request, HttpServletResponse response) {
        log.info("[sendRedPack] \u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e param sendRedPackBaseVo = " + sendRedPackBaseVo);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            RedPackUtil.validateSendRedPackParam(sendRedPackBaseVo);
            PaycenterConfig paycenterConfig = this.paycenterConfigService.queryBySysCode(sendRedPackBaseVo.getSysCode());
            if (paycenterConfig == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            RedPackUtil.validateSendRedPackSign(sendRedPackBaseVo, paycenterConfig.getSignKey());
            PaycenterRoute route = this.paycenterRouteService.queryByJwidAndPayType(sendRedPackBaseVo.getJwid(), PayTypeEnum.weixinpay.getCode());
            if (route == null) {
                throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u672a\u5f00\u901a");
            }
            if (route.getIsUsed() == null || route.getIsUsed() != 1) {
                throw new BusinessException("\u5fae\u4fe1\u652f\u4ed8\u901a\u9053\u6682\u672a\u542f\u7528");
            }
            WeixinPayDto weixinPayDto = JSONHelper.fromJsonToObject(route.getPayJson(), WeixinPayDto.class);
            PaycenterRedpackOrder paycenterRedpackOrder = this.paycenterRedpackOrderService.queryByReqNoAndSysCode(sendRedPackBaseVo.getRequestNo(), sendRedPackBaseVo.getSysCode());
            if (paycenterRedpackOrder == null) {
                paycenterRedpackOrder = this.payCenterRedPackService.preTransOrderRedPack(weixinPayDto, sendRedPackBaseVo);
            } else if ("2".equals(paycenterRedpackOrder.getStatus())) {
                resultMap.put("success", "true");
                resultMap.put("sysCode", paycenterRedpackOrder.getSysCode());
                resultMap.put("requestNo", paycenterRedpackOrder.getRequestNo());
                resultMap.put("mchBillno", paycenterRedpackOrder.getMchBillno());
                resultMap.put("return_msg", "\u53d1\u653e\u6210\u529f");
                log.info("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u6210\u529f\uff1a" + ((Object)resultMap).toString());
                RedPackUtil.outResultMap(resultMap, response);
                return;
            }
            String paramXml = RedPackUtil.populationSendRedPackXml(weixinPayDto, paycenterRedpackOrder);
            log.info("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u8bf7\u6c42\uff1a" + paramXml);
            String xmlStr = RedPackUtil.sslResquest(REDPACKURL, paramXml, weixinPayDto);
            Map resMap = XMLUtil.doXMLParse(xmlStr);
            log.info("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u54cd\u5e94\uff1a" + resMap.toString());
            String return_code = (String)resMap.get("return_code");
            String return_msg = (String)resMap.get("return_msg");
            if ("SUCCESS".equals(return_code)) {
                String result_code = (String)resMap.get("result_code");
                if ("SUCCESS".equals(result_code)) {
                    String send_time = (String)resMap.get("send_time");
                    String send_listid = (String)resMap.get("send_listid");
                    paycenterRedpackOrder.setStatus("2");
                    paycenterRedpackOrder.setReturnCode(return_code);
                    paycenterRedpackOrder.setReturnMsg(return_msg);
                    paycenterRedpackOrder.setResultCode(result_code);
                    paycenterRedpackOrder.setSendTime(send_time);
                    paycenterRedpackOrder.setSendListid(send_listid);
                    paycenterRedpackOrder.setFinishTime(new Date());
                    this.payCenterRedPackService.postTransOrderRedPack(paycenterRedpackOrder);
                    resultMap.put("success", "true");
                    resultMap.put("sysCode", paycenterRedpackOrder.getSysCode());
                    resultMap.put("requestNo", paycenterRedpackOrder.getRequestNo());
                    resultMap.put("mchBillno", paycenterRedpackOrder.getMchBillno());
                    resultMap.put("return_msg", "\u53d1\u653e\u6210\u529f");
                    log.info("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u6210\u529f\uff1a" + ((Object)resultMap).toString());
                    RedPackUtil.outResultMap(resultMap, response);
                    return;
                }
                String err_code = (String)resMap.get("err_code");
                String err_code_des = (String)resMap.get("err_code_des");
                paycenterRedpackOrder.setStatus("3");
                paycenterRedpackOrder.setReturnCode(return_code);
                paycenterRedpackOrder.setResultCode(result_code);
                paycenterRedpackOrder.setErrCode(err_code);
                this.payCenterRedPackService.postTransOrderRedPack(paycenterRedpackOrder);
                resultMap.put("success", "false");
                resultMap.put("return_msg", err_code_des);
                log.info("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u5931\u8d25\uff1a" + ((Object)resultMap).toString());
                RedPackUtil.outResultMap(resultMap, response);
                return;
            }
            paycenterRedpackOrder.setStatus("3");
            paycenterRedpackOrder.setReturnCode(return_code);
            paycenterRedpackOrder.setReturnMsg(return_msg);
            this.payCenterRedPackService.postTransOrderRedPack(paycenterRedpackOrder);
            resultMap.put("success", "false");
            resultMap.put("return_msg", return_msg);
            log.info("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u5931\u8d25\uff1a" + ((Object)resultMap).toString());
            RedPackUtil.outResultMap(resultMap, response);
            return;
        }
        catch (BusinessException e) {
            resultMap.put("success", "false");
            resultMap.put("return_msg", e.getMessage());
            log.info("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u5931\u8d25\uff1a" + ((Object)resultMap).toString());
            RedPackUtil.outResultMap(resultMap, response);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap.put("success", "false");
            resultMap.put("return_msg", e.getMessage());
            log.info("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u7cfb\u7edf\u5f02\u5e38\uff1a" + ((Object)resultMap).toString());
            RedPackUtil.outResultMap(resultMap, response);
            return;
        }
    }

    @RequestMapping(value={"/queryRedPackinfo"})
    public void queryRedPackinfo(RedPackInfoBaseVo redPackInfoBaseVo, HttpServletRequest request, HttpServletResponse response) {
        log.info("[sendRedPack] \u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2 param redPackInfoBaseVo = " + redPackInfoBaseVo);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            RedPackUtil.validateRedPackInfoParam(redPackInfoBaseVo);
            PaycenterConfig paycenterConfig = this.paycenterConfigService.queryBySysCode(redPackInfoBaseVo.getSysCode());
            if (paycenterConfig == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            RedPackUtil.validateQueryRedPackInfoSign(redPackInfoBaseVo, paycenterConfig.getSignKey());
            PaycenterRoute route = this.paycenterRouteService.queryByJwidAndPayType(redPackInfoBaseVo.getJwid(), PayTypeEnum.weixinpay.getCode());
            if (route == null) {
                throw new BusinessException("\u5fae\u4fe1\u652f\u4ed8\u65b9\u5f0f\u6682\u672a\u5f00\u901a");
            }
            if (route.getIsUsed() == null || route.getIsUsed() != 1) {
                throw new BusinessException("\u5fae\u4fe1\u652f\u4ed8\u901a\u9053\u6682\u672a\u542f\u7528");
            }
            WeixinPayDto weixinPayDto = JSONHelper.fromJsonToObject(route.getPayJson(), WeixinPayDto.class);
            PaycenterRedpackOrder paycenterRedpackOrder = this.paycenterRedpackOrderService.queryByReqNoAndSysCode(redPackInfoBaseVo.getRequestNo(), redPackInfoBaseVo.getSysCode());
            if (paycenterRedpackOrder == null) {
                throw new BusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u7ed3\u679c");
            }
            if ("RECEIVED".equals(paycenterRedpackOrder.getHbStatus()) || "REFUND".equals(paycenterRedpackOrder.getHbStatus())) {
                resultMap.put("success", "true");
                resultMap.put("return_msg", "\u67e5\u8be2\u6210\u529f");
                RedPackInfoResponse res = RedPackUtil.populationRedPackInfoResponse(paycenterRedpackOrder);
                resultMap.put("hbinfo", res);
                log.info("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u6210\u529f\uff1a" + ((Object)resultMap).toString());
                RedPackUtil.outResultMap(resultMap, response);
                return;
            }
            String paramXml = RedPackUtil.populationRedPackInfoXml(weixinPayDto, paycenterRedpackOrder);
            log.info("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u8bf7\u6c42\uff1a" + paramXml);
            String xmlStr = RedPackUtil.sslResquest(REDPACK_INFOURL, paramXml, weixinPayDto);
            Map<String, Object> resMap = XMLParseUtil.xml2map(xmlStr);
            RedPackInfoResponse res = XMLParseUtil.getRedPackInfoResponse(resMap);
            res.setSysCode(redPackInfoBaseVo.getSysCode());
            res.setRequestNo(redPackInfoBaseVo.getRequestNo());
            log.info("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u54cd\u5e94\uff1a" + res.toString());
            paycenterRedpackOrder.setHbStatus(res.getHbStatus());
            paycenterRedpackOrder.setRefundAmount(res.getRefundAmount() != null ? Integer.valueOf(res.getRefundAmount()) : null);
            paycenterRedpackOrder.setRefundTime(res.getRefundTime());
            paycenterRedpackOrder.setSendTimeStr(res.getSendTime());
            paycenterRedpackOrder.setAmount(res.getAmount() != null ? Integer.valueOf(res.getAmount()) : null);
            paycenterRedpackOrder.setRcvTime(res.getRcvTime());
            paycenterRedpackOrder.setReason(res.getReason());
            this.payCenterRedPackService.postTransOrderRedPack(paycenterRedpackOrder);
            resultMap.put("success", "true");
            resultMap.put("return_msg", "\u67e5\u8be2\u6210\u529f");
            resultMap.put("hbinfo", res);
            log.info("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u6210\u529f\uff1a" + ((Object)resultMap).toString());
            RedPackUtil.outResultMap(resultMap, response);
            return;
        }
        catch (BusinessException e) {
            e.printStackTrace();
            resultMap.put("success", "false");
            resultMap.put("return_msg", e.getMessage());
            log.info("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u5931\u8d25\uff1a" + ((Object)resultMap).toString());
            RedPackUtil.outResultMap(resultMap, response);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap.put("success", "false");
            resultMap.put("return_msg", e.getMessage());
            log.info("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u5f02\u5e38\uff1a" + ((Object)resultMap).toString());
            RedPackUtil.outResultMap(resultMap, response);
            return;
        }
    }
}

