/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.web;

import com.jeecg.p3.paycenter.entity.PaycenterConfig;
import com.jeecg.p3.paycenter.entity.PaycenterRoute;
import com.jeecg.p3.paycenter.entity.PaycenterTransOrder;
import com.jeecg.p3.paycenter.enums.PayTypeEnum;
import com.jeecg.p3.paycenter.enums.RefundStatusEnum;
import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.service.PayCenterWeixinPayService;
import com.jeecg.p3.paycenter.service.PaycenterConfigService;
import com.jeecg.p3.paycenter.service.PaycenterRouteService;
import com.jeecg.p3.paycenter.service.PaycenterTransOrderService;
import com.jeecg.p3.paycenter.util.EncryptionUtil;
import com.jeecg.p3.paycenter.util.PayValidateUtil;
import com.jeecg.p3.paycenter.vo.PayBaseVo;
import com.jeecg.p3.paycenter.vo.PayVo;
import com.jeecg.p3.paycenter.vo.RefundBaseVo;
import com.jeecg.p3.paycenter.vo.RefundResponse;
import com.jeecg.p3.paycenter.vo.TransOrderRequest;
import com.jeecg.p3.paycenter.vo.TransOrderResponse;
import com.jeecg.p3.paycenter.vo.WeixinpayVo;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/paycenter/weixinpay"})
public class PaycenterController
extends BaseController {
    public static final Logger log = LoggerFactory.getLogger(PaycenterController.class);
    @Autowired
    private PaycenterConfigService paycenterConfigService;
    @Autowired
    private PaycenterRouteService paycenterRouteService;
    @Autowired
    private PayCenterWeixinPayService payCenterWeixinPayService;
    @Autowired
    private PaycenterTransOrderService paycenterTransOrderService;

    @RequestMapping(value={"/toPay"})
    public String toPay(HttpServletRequest request, HttpServletResponse response, PayVo payVo) {
        String modelViewStr = "";
        try {
            log.info("[TOPAY]", "\u8df3\u8f6c\u652f\u4ed8\u9875\u9762\u52a0\u5bc6\u53c2\u6570\uff1a{}", new Object[]{payVo});
            PayValidateUtil.validatePayParam(payVo);
            PaycenterConfig paycenterConfig = this.paycenterConfigService.queryBySysCode(payVo.getSysCode());
            if (paycenterConfig == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            String encryptKey = paycenterConfig.getEncrypKey();
            String json = EncryptionUtil.aesDecrypt(payVo.getData(), encryptKey);
            log.info("[TOPAY]", "\u89e3\u7801\u540e\u7684json\uff1a{}", new Object[]{payVo});
            PayBaseVo payBaseVo = PayValidateUtil.populatePayBaseVo(json);
            log.info("[TOPAY]", "\u89e3\u7801\u540e\u7684PayBaseVo\uff1a{}", new Object[]{payBaseVo});
            PayValidateUtil.validatePayBaseParam(payBaseVo);
            PayValidateUtil.checkSign(payBaseVo, paycenterConfig.getSignKey());
            PayTypeEnum payType = PayTypeEnum.toEnum(payBaseVo.getPayType());
            if (payType == null) {
                throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u4e0d\u652f\u6301");
            }
            if (!PayTypeEnum.weixinpay.getCode().equals(payType.getCode())) {
                throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u4e0d\u652f\u6301");
            }
            PaycenterRoute route = this.paycenterRouteService.queryByJwidAndPayType(payBaseVo.getJwid(), payType.getCode());
            if (route == null) {
                throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u672a\u5f00\u901a");
            }
            if (route.getIsUsed() == null || route.getIsUsed() != 1) {
                throw new BusinessException("\u5fae\u4fe1\u652f\u4ed8\u901a\u9053\u6682\u672a\u542f\u7528");
            }
            modelViewStr = this.payCenterWeixinPayService.weixinpay(request, payBaseVo, route);
            log.info("[TOPAY]", "\u652f\u4ed8\u8bf7\u6c42\uff1a{}", new Object[]{modelViewStr});
            return modelViewStr;
        }
        catch (BusinessException e) {
            log.info(e.getMessage());
            try {
                VelocityContext velocityContext = new VelocityContext();
                velocityContext.put("msg", (Object)e.getMessage());
                String viewName = "paycenter/weixinpay/vm/payerror.vm";
                ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.getMessage());
            try {
                VelocityContext velocityContext = new VelocityContext();
                velocityContext.put("msg", (Object)"\u7cfb\u7edf\u5f02\u5e38\uff01");
                String viewName = "paycenter/weixinpay/vm/payerror.vm";
                ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return null;
        }
    }

    @RequestMapping(value={"/pay"}, params={"redirectWeixinpay"})
    public void redirectWeixinpay(HttpServletRequest request, HttpServletResponse response, WeixinpayVo weixinpayVo) {
        try {
            log.info("\u5fae\u4fe1\u652f\u4ed8\u53c2\u6570\u4e3a\uff1a" + weixinpayVo);
            String preCallUrl = weixinpayVo.getPreCallUrl();
            try {
                if (StringUtils.isNotEmpty((String)preCallUrl)) {
                    preCallUrl = URLDecoder.decode(preCallUrl, "UTF-8");
                    weixinpayVo.setPreCallUrl(preCallUrl);
                }
            }
            catch (Exception e) {
                log.info("\u56de\u8c03\u5730\u5740\u89e3\u7801\u5f02\u5e38\uff1a" + e.getMessage());
            }
            String transOrderNo = weixinpayVo.getTransOrderNo();
            PaycenterTransOrder transOrder = this.paycenterTransOrderService.queryById(transOrderNo);
            HashMap<String, Object> transOrderMap = new HashMap<String, Object>();
            transOrderMap.put("goodsDesc", transOrder.getGoodsDesc());
            transOrderMap.put("payTotalPrice", transOrder.getPayTotalPrice().divide(new BigDecimal("100")));
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("weixinpayVo", (Object)weixinpayVo);
            velocityContext.put("transOrder", transOrderMap);
            String viewName = "paycenter/weixinpay/vm/weixinpay.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/paysuccess"})
    public void paysuccess(HttpServletRequest request, HttpServletResponse response) {
        try {
            VelocityContext velocityContext = new VelocityContext();
            String viewName = "paycenter/weixinpay/vm/paysuccess.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/notify/{payType}/{jwid}"})
    @ResponseBody
    public void notify(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="payType") String payType, @PathVariable(value="jwid") String jwid) {
        log.info("\u652f\u4ed8\u901a\u77e5\uff0c\u901a\u77e5\u7c7b\u578b\uff1a" + payType);
        log.info("\u652f\u4ed8\u901a\u77e5\uff0c\u5fae\u4fe1\u539f\u59cbID jwid\uff1a" + jwid);
        try {
            this.payCenterWeixinPayService.doNotify(request, jwid, payType);
            response.getWriter().write(this.outPutXML("SUCCESS", "OK"));
        }
        catch (Exception e) {
            try {
                log.info("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\u5f02\u5e38:" + e.getMessage());
                response.getWriter().write(this.outPutXML("FAIL", "\u51fa\u73b0\u5f02\u5e38:" + e.getMessage()));
            }
            catch (IOException e1) {
                log.info("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5IO\u5f02\u5e38");
            }
        }
    }

    private String outPutXML(String return_code, String return_msg) {
        return "<xml><return_code><![CDATA[" + return_code + "]]></return_code><return_msg><![CDATA[" + return_msg + "]]></return_msg></xml>";
    }

    @RequestMapping(value={"/queryTransOrder"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public TransOrderResponse queryTransOrder(HttpServletRequest req, TransOrderRequest transOrderRequest) {
        TransOrderResponse transOrderResponse = new TransOrderResponse();
        try {
            log.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355request==>" + transOrderRequest);
            PayValidateUtil.validateQueryRequest(transOrderRequest);
            PaycenterConfig paycenterConfig = this.paycenterConfigService.queryBySysCode(transOrderRequest.getSysCode());
            if (paycenterConfig == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            PayValidateUtil.checkQueryOrderSign(transOrderRequest, paycenterConfig.getSignKey());
            PaycenterTransOrder transOrder = null;
            if (StringUtils.isNotEmpty((String)transOrderRequest.getTransOrderNo())) {
                transOrder = this.paycenterTransOrderService.queryById(transOrderRequest.getTransOrderNo());
            } else if (StringUtils.isNotEmpty((String)transOrderRequest.getRequestNo())) {
                transOrder = this.paycenterTransOrderService.queryTransOrderByReqNoSysCode(transOrderRequest.getRequestNo(), transOrderRequest.getSysCode());
            }
            log.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355==>" + transOrder);
            HashMap<String, Object> transOrderMap = new HashMap<String, Object>();
            transOrderMap.put("sysCode", transOrder.getSysCode());
            transOrderMap.put("requestNo", transOrder.getRequestNo());
            transOrderMap.put("orderNo", transOrder.getOrderNo());
            transOrderMap.put("payType", transOrder.getPayType());
            transOrderMap.put("payTotalPrice", transOrder.getPayTotalPrice());
            transOrderMap.put("jwid", transOrder.getJwid());
            transOrderMap.put("openid", transOrder.getOpenid());
            transOrderMap.put("status", transOrder.getStatus());
            transOrderMap.put("refundStatus", transOrder.getRefundApplyFlag());
            transOrderMap.put("returnMsg", transOrder.getResultMsg());
            transOrderResponse.setSuccess(true);
            transOrderResponse.setMsg("\u67e5\u8be2\u6210\u529f");
            transOrderResponse.setTransOrder(transOrderMap);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355\u5f02\u5e38==>" + e.getMessage());
            transOrderResponse.setSuccess(false);
            transOrderResponse.setMsg("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        return transOrderResponse;
    }

    @RequestMapping(value={"/refund"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public RefundResponse refund(HttpServletRequest request, HttpServletResponse response, RefundBaseVo refundBaseVo) {
        log.info("\u7533\u8bf7\u9000\u6b3e\u53c2\u6570==>" + refundBaseVo);
        RefundResponse res = new RefundResponse();
        try {
            res.setSysCode(refundBaseVo.getSysCode());
            res.setRequestNo(refundBaseVo.getRequestNo());
            res.setTransOrderNo(refundBaseVo.getTransOrderNo());
            res.setRefundTotal(refundBaseVo.getRefundTotal());
            PayValidateUtil.validateRefundParam(refundBaseVo);
            PaycenterConfig paycenterConfig = this.paycenterConfigService.queryBySysCode(refundBaseVo.getSysCode());
            if (paycenterConfig == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            PayValidateUtil.checkRefundSign(refundBaseVo, paycenterConfig.getSignKey());
            this.payCenterWeixinPayService.refund(request, refundBaseVo, res);
        }
        catch (BusinessException e) {
            res.setReturnCode(RefundStatusEnum.FAILED.getCode());
            res.setReturnMsg(e.getMessage());
        }
        catch (Exception e) {
            res.setReturnCode(RefundStatusEnum.FAILED.getCode());
            res.setReturnMsg("\u7cfb\u7edf\u5f02\u5e38");
        }
        log.info("\u7533\u8bf7\u9000\u6b3e\u7ed3\u679c==>" + res);
        return res;
    }
}

