/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.web;

import com.jeecg.p3.paycenter.entity.PaycenterConfig;
import com.jeecg.p3.paycenter.entity.PaycenterRoute;
import com.jeecg.p3.paycenter.entity.PaycenterTransOrder;
import com.jeecg.p3.paycenter.enums.PayTypeEnum;
import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.service.PayCenterAlipayService;
import com.jeecg.p3.paycenter.service.PaycenterConfigService;
import com.jeecg.p3.paycenter.service.PaycenterRouteService;
import com.jeecg.p3.paycenter.service.PaycenterTransOrderService;
import com.jeecg.p3.paycenter.util.EncryptionUtil;
import com.jeecg.p3.paycenter.util.alipay.AlipayValidateUtil;
import com.jeecg.p3.paycenter.vo.PayVo;
import com.jeecg.p3.paycenter.vo.RefundBaseVo;
import com.jeecg.p3.paycenter.vo.TransOrderRequest;
import com.jeecg.p3.paycenter.vo.TransOrderResponse;
import com.jeecg.p3.paycenter.vo.alipay.AlipayBaseVo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/paycenter/alipay"})
public class PaycenterAlipayController
extends BaseController {
    public static final Logger log = LoggerFactory.getLogger(PaycenterAlipayController.class);
    @Autowired
    private PaycenterConfigService paycenterConfigService;
    @Autowired
    private PaycenterRouteService paycenterRouteService;
    @Autowired
    private PayCenterAlipayService payCenterAlipayService;
    @Autowired
    private PaycenterTransOrderService paycenterTransOrderService;

    @RequestMapping(value={"/toPay"})
    public void toPay(HttpServletRequest request, HttpServletResponse response, PayVo payVo) {
        VelocityContext velocityContext = new VelocityContext();
        try {
            log.info("[TOPAY]", "\u8df3\u8f6c\u652f\u4ed8\u9875\u9762\u52a0\u5bc6\u53c2\u6570\uff1a{}", new Object[]{payVo});
            AlipayValidateUtil.validatePayParam(payVo);
            PaycenterConfig paycenterConfig = this.paycenterConfigService.queryBySysCode(payVo.getSysCode());
            if (paycenterConfig == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            String encryptKey = paycenterConfig.getEncrypKey();
            String json = EncryptionUtil.aesDecrypt(payVo.getData(), encryptKey);
            log.info("[TOPAY]", "\u89e3\u7801\u540e\u7684json\uff1a{}", new Object[]{payVo});
            AlipayBaseVo payBaseVo = AlipayValidateUtil.populateAlipayBaseVo(json);
            log.info("[TOPAY]", "\u89e3\u7801\u540e\u7684AlipayBaseVo\uff1a{}", new Object[]{payBaseVo});
            AlipayValidateUtil.validatePayBaseParam(payBaseVo);
            AlipayValidateUtil.checkSign(payBaseVo, paycenterConfig.getSignKey());
            PayTypeEnum payType = PayTypeEnum.toEnum(payBaseVo.getPayType());
            if (payType == null) {
                throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u4e0d\u652f\u6301");
            }
            if (!PayTypeEnum.alipay.getCode().equals(payType.getCode())) {
                throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u4e0d\u652f\u6301");
            }
            PaycenterRoute route = this.paycenterRouteService.queryByJwidAndPayType(payBaseVo.getJwid(), payType.getCode());
            if (route == null) {
                throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u672a\u5f00\u901a");
            }
            if (route.getIsUsed() == null || route.getIsUsed() != 1) {
                throw new BusinessException("\u652f\u4ed8\u5b9d\u652f\u4ed8\u901a\u9053\u6682\u672a\u542f\u7528");
            }
            String sHtmlText = this.payCenterAlipayService.alipay(request, payBaseVo, route);
            log.info("[TOPAY]", "\u652f\u4ed8\u8bf7\u6c42\uff1a{}", new Object[]{sHtmlText});
            velocityContext.put("sHtmlText", (Object)sHtmlText);
            String viewName = "paycenter/alipay/vm/alipay.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (BusinessException e) {
            log.info(e.getMessage());
            try {
                velocityContext.put("msg", (Object)e.getMessage());
                String viewName = "paycenter/alipay/vm/payerror.vm";
                ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.getMessage());
            try {
                velocityContext.put("msg", (Object)"\u7cfb\u7edf\u5f02\u5e38\uff01");
                String viewName = "paycenter/alipay/vm/payerror.vm";
                ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/paysuccess"})
    public void paysuccess(HttpServletRequest request, HttpServletResponse response) {
        try {
            VelocityContext velocityContext = new VelocityContext();
            String viewName = "paycenter/alipay/vm/paysuccess.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/notify/{payType}/{jwid}"})
    @ResponseBody
    public void notify(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="payType") String payType, @PathVariable(value="jwid") String jwid) {
        log.info("\u652f\u4ed8\u901a\u77e5\uff0c\u901a\u77e5\u7c7b\u578b\uff1a" + payType);
        log.info("\u652f\u4ed8\u901a\u77e5\uff0c\u652f\u4ed8\u5b9d\u5408\u4f5c\u8eab\u4efd\u8005ID jwid\uff1a" + jwid);
        try {
            Map<String, String> resMap = this.payCenterAlipayService.doNotify(request, jwid, payType);
            response.getWriter().write(resMap.get("status"));
        }
        catch (Exception e) {
            try {
                log.info("\u652f\u4ed8\u5b9d\u652f\u4ed8\u901a\u77e5\u5f02\u5e38:" + e.getMessage());
                response.getWriter().write("fail");
            }
            catch (IOException e1) {
                log.info("\u652f\u4ed8\u5b9d\u652f\u4ed8\u901a\u77e5IO\u5f02\u5e38");
            }
        }
    }

    @RequestMapping(value={"/prenotify/{payType}/{jwid}"})
    public String prenotify(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="payType") String payType, @PathVariable(value="jwid") String jwid) {
        log.info("\u652f\u4ed8\u901a\u77e5\uff0c\u901a\u77e5\u7c7b\u578b\uff1a" + payType);
        log.info("\u652f\u4ed8\u901a\u77e5\uff0c\u652f\u4ed8\u5b9d\u5408\u4f5c\u8eab\u4efd\u8005ID jwid\uff1a" + jwid);
        try {
            VelocityContext velocityContext = new VelocityContext();
            String viewName = "paycenter/alipay/vm/payerror.vm";
            try {
                Map<String, String> resMap = this.payCenterAlipayService.doNotify(request, jwid, payType);
                if ("success".equals(resMap.get("status"))) {
                    if (StringUtils.isNotEmpty((String)resMap.get("preCallUrl"))) {
                        String redirectUrl = "redirect:" + resMap.get("preCallUrl");
                        return redirectUrl;
                    }
                    velocityContext.put("msg", (Object)"\u652f\u4ed8\u5b9d\u652f\u4ed8\u6210\u529f");
                    viewName = "paycenter/alipay/vm/paysuccess.vm";
                } else {
                    velocityContext.put("msg", (Object)"\u652f\u4ed8\u5b9d\u652f\u4ed8\u9875\u9762\u8df3\u8f6c\u901a\u77e5\u5931\u8d25");
                }
            }
            catch (Exception e) {
                log.info("\u652f\u4ed8\u5b9d\u652f\u4ed8\u901a\u77e5\u5f02\u5e38:" + e.getMessage());
            }
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @RequestMapping(value={"/refundnotify/{payType}/{jwid}"})
    @ResponseBody
    public void refundnotify(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="payType") String payType, @PathVariable(value="jwid") String jwid) {
        log.info("\u652f\u4ed8\u901a\u77e5\uff0c\u901a\u77e5\u7c7b\u578b\uff1a" + payType);
        log.info("\u652f\u4ed8\u901a\u77e5\uff0c\u652f\u4ed8\u5b9d\u5408\u4f5c\u8eab\u4efd\u8005ID jwid\uff1a" + jwid);
        try {
            Map<String, String> resMap = this.payCenterAlipayService.doRefundNotify(request, jwid, payType);
            log.info("\u652f\u4ed8\u901a\u77e5\uff0c\u901a\u77e5\u7ed3\u679c\uff1a" + resMap.get("status"));
            response.getWriter().write(resMap.get("status"));
        }
        catch (Exception e) {
            try {
                log.info("\u652f\u4ed8\u5b9d\u652f\u4ed8\u901a\u77e5\u5f02\u5e38:" + e.getMessage());
                response.getWriter().write("fail");
            }
            catch (IOException e1) {
                log.info("\u652f\u4ed8\u5b9d\u652f\u4ed8\u901a\u77e5IO\u5f02\u5e38");
            }
        }
    }

    @RequestMapping(value={"/queryTransOrder"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public TransOrderResponse queryTransOrder(HttpServletRequest req, TransOrderRequest transOrderRequest) {
        TransOrderResponse transOrderResponse = new TransOrderResponse();
        try {
            log.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355request==>" + transOrderRequest);
            AlipayValidateUtil.validateQueryRequest(transOrderRequest);
            PaycenterConfig paycenterConfig = this.paycenterConfigService.queryBySysCode(transOrderRequest.getSysCode());
            if (paycenterConfig == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            AlipayValidateUtil.checkQueryOrderSign(transOrderRequest, paycenterConfig.getSignKey());
            PaycenterTransOrder transOrder = null;
            if (StringUtils.isNotEmpty((String)transOrderRequest.getTransOrderNo())) {
                transOrder = this.paycenterTransOrderService.queryById(transOrderRequest.getTransOrderNo());
            } else if (StringUtils.isNotEmpty((String)transOrderRequest.getRequestNo())) {
                transOrder = this.paycenterTransOrderService.queryTransOrderByReqNoSysCode(transOrderRequest.getRequestNo(), transOrderRequest.getSysCode());
            }
            log.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355==>" + transOrder);
            HashMap<String, Object> transOrderMap = new HashMap<String, Object>();
            transOrderMap.put("sysCode", transOrder.getSysCode());
            transOrderMap.put("requestNo", transOrder.getRequestNo());
            transOrderMap.put("orderNo", transOrder.getOrderNo());
            transOrderMap.put("payType", transOrder.getPayType());
            transOrderMap.put("payTotalPrice", transOrder.getPayTotalPrice());
            transOrderMap.put("jwid", transOrder.getJwid());
            transOrderMap.put("openid", transOrder.getOpenid());
            transOrderMap.put("status", transOrder.getStatus());
            transOrderMap.put("refundStatus", transOrder.getRefundApplyFlag());
            transOrderMap.put("returnMsg", transOrder.getResultMsg());
            transOrderResponse.setSuccess(true);
            transOrderResponse.setMsg("\u67e5\u8be2\u6210\u529f");
            transOrderResponse.setTransOrder(transOrderMap);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355\u5f02\u5e38==>" + e.getMessage());
            transOrderResponse.setSuccess(false);
            transOrderResponse.setMsg("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        return transOrderResponse;
    }

    @RequestMapping(value={"/refund"}, method={RequestMethod.GET, RequestMethod.POST})
    public void refund(HttpServletRequest request, HttpServletResponse response, RefundBaseVo refundBaseVo) {
        log.info("\u7533\u8bf7\u9000\u6b3e\u53c2\u6570==>" + refundBaseVo);
        VelocityContext velocityContext = new VelocityContext();
        try {
            AlipayValidateUtil.validateRefundParam(refundBaseVo);
            PaycenterConfig paycenterConfig = this.paycenterConfigService.queryBySysCode(refundBaseVo.getSysCode());
            if (paycenterConfig == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            AlipayValidateUtil.checkRefundSign(refundBaseVo, paycenterConfig.getSignKey());
            String sHtmlText = this.payCenterAlipayService.refund(request, refundBaseVo);
            log.info("[TOPAY]", "\u9000\u6b3e\u8bf7\u6c42\uff1a{}", new Object[]{sHtmlText});
            velocityContext.put("sHtmlText", (Object)sHtmlText);
            String viewName = "paycenter/alipay/vm/refund.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (BusinessException e) {
            try {
                log.info("\u9000\u6b3e\u5f02\u5e38==>" + e.getMessage());
                velocityContext.put("msg", (Object)e.getMessage());
                String viewName = "paycenter/alipay/vm/payerror.vm";
                ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            try {
                log.info("\u9000\u6b3e\u5f02\u5e38==>" + e.getMessage());
                velocityContext.put("msg", (Object)"\u7cfb\u7edf\u5f02\u5e38");
                String viewName = "paycenter/alipay/vm/payerror.vm";
                ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

