/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.util.alipay;

import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.util.SignatureUtil;
import com.jeecg.p3.paycenter.vo.PayVo;
import com.jeecg.p3.paycenter.vo.RefundBaseVo;
import com.jeecg.p3.paycenter.vo.TransOrderRequest;
import com.jeecg.p3.paycenter.vo.alipay.AlipayBaseVo;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.p3.core.common.utils.StringUtil;

public class AlipayValidateUtil {
    public static void validatePayParam(PayVo payVo) {
        if (StringUtil.isEmpty((String)payVo.getSysCode())) {
            throw new BusinessException("\u5f00\u53d1\u8005\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payVo.getData())) {
            throw new BusinessException("\u52a0\u5bc6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static AlipayBaseVo populateAlipayBaseVo(String json) {
        AlipayBaseVo payBaseVo = new AlipayBaseVo();
        JSONObject obj = JSONObject.fromObject((Object)json);
        payBaseVo.setBackCallUrl(AlipayValidateUtil.getJsonValue(obj, "backCallUrl"));
        payBaseVo.setDesc(AlipayValidateUtil.getJsonValue(obj, "desc"));
        payBaseVo.setJwid(AlipayValidateUtil.getJsonValue(obj, "jwid"));
        payBaseVo.setOrderNo(AlipayValidateUtil.getJsonValue(obj, "orderNo"));
        payBaseVo.setPayType(AlipayValidateUtil.getJsonValue(obj, "payType"));
        payBaseVo.setPreCallUrl(AlipayValidateUtil.getJsonValue(obj, "preCallUrl"));
        payBaseVo.setRequestNo(AlipayValidateUtil.getJsonValue(obj, "requestNo"));
        payBaseVo.setSign(AlipayValidateUtil.getJsonValue(obj, "sign"));
        payBaseVo.setSysCode(AlipayValidateUtil.getJsonValue(obj, "sysCode"));
        payBaseVo.setTotalMoney(AlipayValidateUtil.getJsonValue(obj, "totalMoney"));
        payBaseVo.setSubject(AlipayValidateUtil.getJsonValue(obj, "subject"));
        payBaseVo.setShowUrl(AlipayValidateUtil.getJsonValue(obj, "showUrl"));
        return payBaseVo;
    }

    private static String getJsonValue(JSONObject obj, String key) {
        if (obj != null && obj.containsKey((Object)key)) {
            return obj.getString(key);
        }
        return null;
    }

    public static void validatePayBaseParam(AlipayBaseVo payBaseVo) {
        if (StringUtil.isEmpty((String)payBaseVo.getSysCode())) {
            throw new BusinessException("\u5f00\u53d1\u8005\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getRequestNo())) {
            throw new BusinessException("\u652f\u4ed8\u8bf7\u6c42\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getOrderNo())) {
            throw new BusinessException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getSubject())) {
            throw new BusinessException("\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getJwid())) {
            throw new BusinessException("\u652f\u4ed8\u5b9d\u5408\u4f5c\u8eab\u4efd\u8005ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getTotalMoney())) {
            throw new BusinessException("\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getPayType())) {
            throw new BusinessException("\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getShowUrl())) {
            throw new BusinessException("\u5546\u54c1\u5c55\u793a\u7f51\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getBackCallUrl())) {
            throw new BusinessException("\u652f\u4ed8\u56de\u8c03\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void checkSign(AlipayBaseVo payBaseVo, String signKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("backCallUrl", payBaseVo.getBackCallUrl());
        paramMap.put("desc", payBaseVo.getDesc());
        paramMap.put("jwid", payBaseVo.getJwid());
        paramMap.put("orderNo", payBaseVo.getOrderNo());
        paramMap.put("payType", payBaseVo.getPayType());
        paramMap.put("preCallUrl", payBaseVo.getPreCallUrl());
        paramMap.put("requestNo", payBaseVo.getRequestNo());
        paramMap.put("sysCode", payBaseVo.getSysCode());
        paramMap.put("totalMoney", payBaseVo.getTotalMoney());
        paramMap.put("subject", payBaseVo.getSubject());
        paramMap.put("showUrl", payBaseVo.getShowUrl());
        if (!SignatureUtil.checkSign(paramMap, signKey, payBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static void validateRefundParam(RefundBaseVo refundBaseVo) {
        if (StringUtil.isEmpty((String)refundBaseVo.getSysCode())) {
            throw new BusinessException("\u5f00\u53d1\u8005\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)refundBaseVo.getRequestNo())) {
            throw new BusinessException("\u9000\u6b3e\u8bf7\u6c42\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)refundBaseVo.getTransOrderNo())) {
            throw new BusinessException("\u4ea4\u6613\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (refundBaseVo.getRefundTotal() == null) {
            throw new BusinessException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (refundBaseVo.getBackCallUrl() == null) {
            throw new BusinessException("\u670d\u52a1\u5668\u901a\u77e5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)refundBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void validateQueryRequest(TransOrderRequest requert) {
        if (StringUtil.isEmpty((String)requert.getSysCode())) {
            throw new BusinessException("\u7b2c\u4e09\u65b9\u5f00\u53d1\u8005\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)requert.getRequestNo()) && StringUtil.isEmpty((String)requert.getTransOrderNo())) {
            throw new BusinessException("\u652f\u4ed8\u8bf7\u6c42\u53f7\u6216\u8005\u4ea4\u6613\u8ba2\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)requert.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void checkQueryOrderSign(TransOrderRequest requert, String signKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sysCode", requert.getSysCode());
        paramMap.put("requestNo", requert.getRequestNo());
        paramMap.put("transOrderNo", requert.getTransOrderNo());
        if (!SignatureUtil.checkSign(paramMap, signKey, requert.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static void checkRefundSign(RefundBaseVo refundBaseVo, String signKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sysCode", refundBaseVo.getSysCode());
        paramMap.put("requestNo", refundBaseVo.getRequestNo());
        paramMap.put("transOrderNo", refundBaseVo.getTransOrderNo());
        paramMap.put("backCallUrl", refundBaseVo.getBackCallUrl());
        paramMap.put("refundTotal", refundBaseVo.getRefundTotal().toString());
        if (!SignatureUtil.checkSign(paramMap, signKey, refundBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }
}

