/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.util.alipay;

import com.jeecg.p3.paycenter.util.alipay.AlipayConfig;
import com.jeecg.p3.paycenter.util.alipay.AlipayCore;
import com.jeecg.p3.paycenter.util.alipay.MD5;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class AlipayNotify {
    private static final String HTTPS_VERIFY_URL = "https://mapi.alipay.com/gateway.do?service=notify_verify&";

    public static boolean verify(Map<String, String> params, String partner, String key) {
        boolean isSign;
        String responseTxt = "false";
        if (params.get("notify_id") != null) {
            String notify_id = params.get("notify_id");
            responseTxt = AlipayNotify.verifyResponse(notify_id, partner);
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return (isSign = AlipayNotify.getSignVeryfy(params, key, sign)) && responseTxt.equals("true");
    }

    private static boolean getSignVeryfy(Map<String, String> Params, String key, String sign) {
        Map<String, String> sParaNew = AlipayCore.paraFilter(Params);
        String preSignStr = AlipayCore.createLinkString(sParaNew);
        boolean isSign = false;
        if (AlipayConfig.sign_type.equals("MD5")) {
            isSign = MD5.verify(preSignStr, sign, key, AlipayConfig.input_charset);
        }
        return isSign;
    }

    private static String verifyResponse(String notify_id, String partner) {
        String veryfy_url = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner=" + partner + "&notify_id=" + notify_id;
        return AlipayNotify.checkUrl(veryfy_url);
    }

    private static String checkUrl(String urlvalue) {
        String inputLine = "";
        try {
            URL url = new URL(urlvalue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            inputLine = in.readLine().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            inputLine = "";
        }
        return inputLine;
    }
}

