/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.util;

import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.util.MD5Util;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureUtil.class);

    public static String sign(Map<String, String> paramMap, String key) {
        if (key == null) {
            throw new BusinessException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sign = SignatureUtil.createSign(paramMap, key);
        return sign;
    }

    private static String createSign(Map<String, String> paramMap, String key) {
        StringBuffer sb = new StringBuffer();
        TreeMap<String, String> sort = new TreeMap<String, String>(paramMap);
        Set es = sort.entrySet();
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if (v == null || "".equals(v) || "null".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(String.valueOf(k) + "=" + v + "&");
        }
        sb.append("key=" + key);
        LOG.info("HMAC source:{}", new Object[]{sb.toString()});
        String sign = MD5Util.MD5Encode(sb.toString(), "UTF-8").toUpperCase();
        LOG.info("HMAC:{}", new Object[]{sign});
        return sign;
    }

    public static boolean checkSign(Map<String, String> paramMap, String key, String sign) {
        if (key == null) {
            throw new BusinessException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (sign == null) {
            throw new BusinessException("\u9700\u8981\u9a8c\u7b7e\u7684\u5b57\u7b26\u4e3a\u7a7a");
        }
        return sign.equals(SignatureUtil.sign(paramMap, key));
    }

    public static Map<String, String> getSignMap(HttpServletRequest request) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Map map = request.getParameterMap();
        Set es = map.entrySet();
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            Object ov = entry.getValue();
            String v = "";
            if (ov instanceof String[]) {
                String[] value = (String[])ov;
                v = value[0];
            } else {
                v = ov.toString();
            }
            paramMap.put(k, v);
        }
        return paramMap;
    }

    public static Map<String, String> getSignMap(String url) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        url = url.substring(url.indexOf("?") + 1);
        String[] params = url.split("&");
        int i = 0;
        while (i < params.length) {
            String[] values;
            String param = params[i];
            if (param.indexOf("=") != -1 && (values = param.split("=")) != null && values.length == 2) {
                if ("nickname".equals(values[0])) {
                    paramMap.put(values[0], URLDecoder.decode(values[1]));
                } else {
                    paramMap.put(values[0], values[1]);
                }
            }
            ++i;
        }
        return paramMap;
    }

    public static void main(String[] args) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("requestNo", "refund8157b7ea480157d6f28ffd0004");
        paramMap.put("sysCode", "jwmall");
        paramMap.put("transOrderNo", "4028138158f10f0e0158f10f0e650000");
        paramMap.put("refundTotal", "0.01");
        paramMap.put("backCallUrl", "http://localhost/weixinShopDealController.do?refundNotify");
        String sign = SignatureUtil.sign(paramMap, "C47B1912B6C47B1912B6CAED6F72780372E839C53FCAED6F72780372E839C53F");
        String refundUrl = "http://fly1206.xicp.net/P3-Web/paycenter/alipay/refund.do?requestNo=" + (String)paramMap.get("requestNo") + "&sysCode=" + (String)paramMap.get("sysCode") + "&transOrderNo=" + (String)paramMap.get("transOrderNo") + "&refundTotal=" + (String)paramMap.get("refundTotal") + "&backCallUrl=" + (String)paramMap.get("backCallUrl") + "&sign=" + sign;
        System.out.println(refundUrl);
    }
}

