/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.util;

import com.alibaba.fastjson.JSONObject;
import com.jeecg.p3.paycenter.entity.PaycenterRedpackOrder;
import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.util.DateUtils;
import com.jeecg.p3.paycenter.util.MD5Util;
import com.jeecg.p3.paycenter.util.MyBeanUtils;
import com.jeecg.p3.paycenter.util.SignatureUtil;
import com.jeecg.p3.paycenter.util.XMLUtil;
import com.jeecg.p3.paycenter.vo.RedPackInfoBaseVo;
import com.jeecg.p3.paycenter.vo.RedPackInfoResponse;
import com.jeecg.p3.paycenter.vo.SendRedPackBaseVo;
import com.jeecg.p3.paycenter.vo.WeixinPayDto;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jeecgframework.p3.core.common.utils.StringUtil;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.PropertiesUtil;
import org.jeecgframework.p3.core.util.UUIDGenerator;

public class RedPackUtil {
    public static final Logger log = LoggerFactory.getLogger(RedPackUtil.class);

    public static void validateSendRedPackParam(SendRedPackBaseVo sendRedPackBaseVo) {
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getSysCode())) {
            throw new BusinessException("\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getRequestNo())) {
            throw new BusinessException("\u8bf7\u6c42\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getJwid())) {
            throw new BusinessException("\u5fae\u4fe1\u539f\u59cbID\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getOrderNo())) {
            throw new BusinessException("\u4e1a\u52a1\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getSendName())) {
            throw new BusinessException("\u5546\u6237\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getOpenid())) {
            throw new BusinessException("openid\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getActName())) {
            throw new BusinessException("\u6d3b\u52a8\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getRemark())) {
            throw new BusinessException("\u6d3b\u52a8\u5907\u6ce8\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getWishing())) {
            throw new BusinessException("\u7ea2\u5305\u795d\u798f\u8bed\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getTotalAmount())) {
            throw new BusinessException("\u53d1\u653e\u7ea2\u5305\u91d1\u989d\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getTotalNum())) {
            throw new BusinessException("\u7ea2\u5305\u53d1\u653e\u603b\u4eba\u6570\u4e3a\u7a7a");
        }
        if (Integer.valueOf(sendRedPackBaseVo.getTotalAmount()) > 20000 || Integer.valueOf(sendRedPackBaseVo.getTotalAmount()) < 100) {
            throw new BusinessException("\u6bcf\u4e2a\u7ea2\u5305\u91d1\u989d\u5fc5\u987b\u5927\u4e8e1\u5143\uff0c\u5c0f\u4e8e200\u5143");
        }
        if (Integer.valueOf(sendRedPackBaseVo.getTotalNum()) != 1) {
            throw new BusinessException("\u7ea2\u5305\u53d1\u653e\u603b\u4eba\u6570\u5e94\u4e3a1");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e3a\u7a7a");
        }
    }

    public static String populationSendRedPackXml(WeixinPayDto weixinPayDto, PaycenterRedpackOrder paycenterRedpackOrder) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("nonce_str", UUIDGenerator.generate());
        params.put("mch_billno", paycenterRedpackOrder.getMchBillno());
        params.put("mch_id", paycenterRedpackOrder.getMchId());
        params.put("wxappid", paycenterRedpackOrder.getWxappid());
        params.put("send_name", paycenterRedpackOrder.getSendName());
        params.put("re_openid", paycenterRedpackOrder.getReOpenid());
        params.put("total_amount", paycenterRedpackOrder.getTotalAmount().toString());
        params.put("total_num", paycenterRedpackOrder.getTotalNum().toString());
        params.put("wishing", paycenterRedpackOrder.getWishing());
        params.put("client_ip", paycenterRedpackOrder.getClientIp());
        params.put("act_name", paycenterRedpackOrder.getActName());
        params.put("remark", paycenterRedpackOrder.getRemark());
        String sign = RedPackUtil.createSign(params, weixinPayDto.getKey());
        params.put("sign", sign);
        String paramXml = XMLUtil.converterWeixinpayXML(params);
        return paramXml;
    }

    private static String createSign(Map<String, String> params, String key) {
        StringBuffer sb = new StringBuffer("");
        Set<Map.Entry<String, String>> es = params.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (v == null || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(String.valueOf(k) + "=" + v + "&");
        }
        sb.append("key=" + key);
        log.info(sb.toString());
        String sign = MD5Util.MD5Encode(sb.toString(), "UTF-8").toUpperCase();
        log.info("sign=" + sign);
        return sign;
    }

    public static String sslResquest(String url, String arrayToXml, WeixinPayDto weixinPayDto) throws Exception {
        String xmlStr;
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        PropertiesUtil p = new PropertiesUtil("paycenter.properties");
        String PKCS12_Base = p.readProperty("PKCS12_Base");
        String absoluteFileName = String.valueOf(PKCS12_Base) + File.separator + weixinPayDto.getMch_id() + File.separator + weixinPayDto.getCertFileName();
        FileInputStream instream = new FileInputStream(new File(absoluteFileName));
        try {
            keyStore.load(instream, weixinPayDto.getMch_id().toCharArray());
        }
        finally {
            instream.close();
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, weixinPayDto.getMch_id().toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(arrayToXml, "UTF-8"));
            log.info("executing request " + httpPost.getRequestLine());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            xmlStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            log.info("\u8fd4\u56de\u7684XML\u6570\u636e\u4e3a" + xmlStr);
            response.close();
        }
        finally {
            httpclient.close();
        }
        return xmlStr;
    }

    public static void validateSendGroupRedPackParam(SendRedPackBaseVo sendRedPackBaseVo) {
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getSysCode())) {
            throw new BusinessException("\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getRequestNo())) {
            throw new BusinessException("\u8bf7\u6c42\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getJwid())) {
            throw new BusinessException("\u5fae\u4fe1\u539f\u59cbID\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getOrderNo())) {
            throw new BusinessException("\u4e1a\u52a1\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getSendName())) {
            throw new BusinessException("\u5546\u6237\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getOpenid())) {
            throw new BusinessException("openid\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getActName())) {
            throw new BusinessException("\u6d3b\u52a8\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getRemark())) {
            throw new BusinessException("\u6d3b\u52a8\u5907\u6ce8\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getWishing())) {
            throw new BusinessException("\u7ea2\u5305\u795d\u798f\u8bed\u4e3a\u7a7a");
        }
        if (sendRedPackBaseVo.getTotalAmount() == null) {
            throw new BusinessException("\u53d1\u653e\u7ea2\u5305\u91d1\u989d\u4e3a\u7a7a");
        }
        if (sendRedPackBaseVo.getTotalNum() == null) {
            throw new BusinessException("\u7ea2\u5305\u53d1\u653e\u603b\u4eba\u6570\u4e3a\u7a7a");
        }
        if (Integer.valueOf(sendRedPackBaseVo.getTotalAmount()) > 499900 || Integer.valueOf(sendRedPackBaseVo.getTotalAmount()) < 100) {
            throw new BusinessException("\u6bcf\u4e2a\u7ea2\u5305\u91d1\u989d\u5fc5\u987b\u5927\u4e8e1\u5143\uff0c\u5c0f\u4e8e\u7b49\u4e8e4999\u5143");
        }
        if (Integer.valueOf(sendRedPackBaseVo.getTotalNum()) > 10000) {
            throw new BusinessException("\u7ea2\u5305\u53d1\u653e\u7ea2\u5305\u6570\u91cf\u4e0d\u5927\u4e8e10000\u4e2a");
        }
        if (StringUtil.isEmpty((String)sendRedPackBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e3a\u7a7a");
        }
    }

    private static String generateNum(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        int i = 0;
        while (i < length) {
            sb.append(random.nextInt(10));
            ++i;
        }
        return sb.toString();
    }

    public static synchronized String generatorMchBillno(String mchId) {
        StringBuilder sb = new StringBuilder(mchId);
        String date = DateUtils.date2SStr();
        sb.append(date);
        String num = RedPackUtil.generateNum(10);
        sb.append(num);
        return sb.toString();
    }

    public static void validateRedPackInfoParam(RedPackInfoBaseVo redPackInfoBaseVo) {
        if (StringUtil.isEmpty((String)redPackInfoBaseVo.getSysCode())) {
            throw new BusinessException("\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)redPackInfoBaseVo.getRequestNo())) {
            throw new BusinessException("\u8bf7\u6c42\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)redPackInfoBaseVo.getJwid())) {
            throw new BusinessException("\u5fae\u4fe1\u539f\u59cbID\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)redPackInfoBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e3a\u7a7a");
        }
    }

    public static String populationRedPackInfoXml(WeixinPayDto weixinPayDto, PaycenterRedpackOrder paycenterRedpackOrder) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("nonce_str", UUIDGenerator.generate());
        params.put("mch_billno", paycenterRedpackOrder.getMchBillno());
        params.put("mch_id", paycenterRedpackOrder.getMchId());
        params.put("appid", paycenterRedpackOrder.getWxappid());
        params.put("bill_type", "MCHT");
        String sign = RedPackUtil.createSign(params, weixinPayDto.getKey());
        params.put("sign", sign);
        String paramXml = XMLUtil.converterWeixinpayXML(params);
        return paramXml;
    }

    public static RedPackInfoResponse populationRedPackInfoResponse(PaycenterRedpackOrder paycenterRedpackOrder) {
        RedPackInfoResponse res = new RedPackInfoResponse();
        res.setMchBillno(paycenterRedpackOrder.getMchBillno());
        res.setHbStatus(paycenterRedpackOrder.getHbStatus());
        res.setReason(paycenterRedpackOrder.getReason());
        Integer refundAmount = paycenterRedpackOrder.getRefundAmount();
        res.setRefundAmount(refundAmount != null ? refundAmount.toString() : null);
        res.setRefundTime(paycenterRedpackOrder.getRefundTime());
        res.setSendTime(paycenterRedpackOrder.getSendTimeStr());
        res.setTotalAmount(paycenterRedpackOrder.getTotalAmount().toString());
        res.setTotalNum(paycenterRedpackOrder.getTotalNum().toString());
        res.setOpenid(paycenterRedpackOrder.getReOpenid());
        res.setRcvTime(paycenterRedpackOrder.getRcvTime());
        Integer amount = paycenterRedpackOrder.getAmount();
        res.setAmount(amount != null ? amount.toString() : null);
        return res;
    }

    public static void validateSendRedPackSign(SendRedPackBaseVo sendRedPackBaseVo, String signKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        MyBeanUtils.copyBean2Map(paramMap, sendRedPackBaseVo);
        if (!SignatureUtil.checkSign(paramMap, signKey, sendRedPackBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static void outResultMap(Map<String, Object> resultMap, HttpServletResponse response) {
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        PrintWriter pw = null;
        try {
            try {
                response.setContentType("application/json");
                response.setHeader("Cache-Control", "no-store");
                pw = response.getWriter();
                pw.write(JSONObject.toJSONString(resultMap));
                pw.flush();
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void validateQueryRedPackInfoSign(RedPackInfoBaseVo redPackInfoBaseVo, String signKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        MyBeanUtils.copyBean2Map(paramMap, redPackInfoBaseVo);
        if (!SignatureUtil.checkSign(paramMap, signKey, redPackInfoBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }
}

