/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.util;

import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.util.SignatureUtil;
import com.jeecg.p3.paycenter.vo.PayBaseVo;
import com.jeecg.p3.paycenter.vo.PayVo;
import com.jeecg.p3.paycenter.vo.RefundBaseVo;
import com.jeecg.p3.paycenter.vo.TransOrderRequest;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.p3.core.common.utils.StringUtil;

public class PayValidateUtil {
    public static void validatePayParam(PayVo payVo) {
        if (StringUtil.isEmpty((String)payVo.getSysCode())) {
            throw new BusinessException("\u5f00\u53d1\u8005\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payVo.getData())) {
            throw new BusinessException("\u52a0\u5bc6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static PayBaseVo populatePayBaseVo(String json) {
        PayBaseVo payBaseVo = new PayBaseVo();
        JSONObject obj = JSONObject.fromObject((Object)json);
        payBaseVo.setBackCallUrl(PayValidateUtil.getJsonValue(obj, "backCallUrl"));
        payBaseVo.setDesc(PayValidateUtil.getJsonValue(obj, "desc"));
        payBaseVo.setJwid(PayValidateUtil.getJsonValue(obj, "jwid"));
        payBaseVo.setOpenid(PayValidateUtil.getJsonValue(obj, "openid"));
        payBaseVo.setOrderNo(PayValidateUtil.getJsonValue(obj, "orderNo"));
        payBaseVo.setPayType(PayValidateUtil.getJsonValue(obj, "payType"));
        payBaseVo.setPreCallUrl(PayValidateUtil.getJsonValue(obj, "preCallUrl"));
        payBaseVo.setRequestNo(PayValidateUtil.getJsonValue(obj, "requestNo"));
        payBaseVo.setSign(PayValidateUtil.getJsonValue(obj, "sign"));
        payBaseVo.setSysCode(PayValidateUtil.getJsonValue(obj, "sysCode"));
        payBaseVo.setTotal_money(PayValidateUtil.getJsonValue(obj, "total_money"));
        return payBaseVo;
    }

    private static String getJsonValue(JSONObject obj, String key) {
        if (obj != null && obj.containsKey((Object)key)) {
            return obj.getString(key);
        }
        return null;
    }

    public static void validatePayBaseParam(PayBaseVo payBaseVo) {
        if (StringUtil.isEmpty((String)payBaseVo.getSysCode())) {
            throw new BusinessException("\u5f00\u53d1\u8005\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getRequestNo())) {
            throw new BusinessException("\u652f\u4ed8\u8bf7\u6c42\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getOrderNo())) {
            throw new BusinessException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getJwid())) {
            throw new BusinessException("\u5fae\u4fe1\u539f\u59cbID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getOpenid())) {
            throw new BusinessException("\u5fae\u4fe1openid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getTotal_money())) {
            throw new BusinessException("\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getPayType())) {
            throw new BusinessException("\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getBackCallUrl())) {
            throw new BusinessException("\u652f\u4ed8\u56de\u8c03\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)payBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void checkSign(PayBaseVo payBaseVo, String signKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("backCallUrl", payBaseVo.getBackCallUrl());
        paramMap.put("desc", payBaseVo.getDesc());
        paramMap.put("jwid", payBaseVo.getJwid());
        paramMap.put("openid", payBaseVo.getOpenid());
        paramMap.put("orderNo", payBaseVo.getOrderNo());
        paramMap.put("payType", payBaseVo.getPayType());
        paramMap.put("preCallUrl", payBaseVo.getPreCallUrl());
        paramMap.put("requestNo", payBaseVo.getRequestNo());
        paramMap.put("sysCode", payBaseVo.getSysCode());
        paramMap.put("total_money", payBaseVo.getTotal_money());
        if (!SignatureUtil.checkSign(paramMap, signKey, payBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static void validateRefundParam(RefundBaseVo refundBaseVo) {
        if (StringUtil.isEmpty((String)refundBaseVo.getSysCode())) {
            throw new BusinessException("\u5f00\u53d1\u8005\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)refundBaseVo.getTransOrderNo())) {
            throw new BusinessException("\u4ea4\u6613\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (refundBaseVo.getRefundTotal() == null) {
            throw new BusinessException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)refundBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void validateQueryRequest(TransOrderRequest requert) {
        if (StringUtil.isEmpty((String)requert.getSysCode())) {
            throw new BusinessException("\u7b2c\u4e09\u65b9\u5f00\u53d1\u8005\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)requert.getRequestNo()) && StringUtil.isEmpty((String)requert.getTransOrderNo())) {
            throw new BusinessException("\u652f\u4ed8\u8bf7\u6c42\u53f7\u6216\u8005\u4ea4\u6613\u8ba2\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)requert.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void checkQueryOrderSign(TransOrderRequest requert, String signKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sysCode", requert.getSysCode());
        paramMap.put("requestNo", requert.getRequestNo());
        paramMap.put("transOrderNo", requert.getTransOrderNo());
        if (!SignatureUtil.checkSign(paramMap, signKey, requert.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static void checkRefundSign(RefundBaseVo refundBaseVo, String signKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sysCode", refundBaseVo.getSysCode());
        paramMap.put("requestNo", refundBaseVo.getRequestNo());
        paramMap.put("transOrderNo", refundBaseVo.getTransOrderNo());
        paramMap.put("refundTotal", refundBaseVo.getRefundTotal().toString());
        if (!SignatureUtil.checkSign(paramMap, signKey, refundBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }
}

