/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;

public class MyBeanUtils
extends BeanUtils {
    private static void convert(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            int i = 0;
            while (i < origDescriptors.length) {
                String name = origDescriptors[i].getName();
                if (PropertyUtils.isWriteable((Object)dest, (String)name)) {
                    Object value2 = ((DynaBean)orig).get(name);
                    try {
                        MyBeanUtils.copyProperty((Object)dest, (String)name, (Object)value2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        } else if (orig instanceof Map) {
            for (String name : ((Map)orig).keySet()) {
                if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                Object value = ((Map)orig).get(name);
                try {
                    MyBeanUtils.copyProperty((Object)dest, (String)name, value);
                }
                catch (Exception value2) {
                    // empty catch block
                }
            }
        } else {
            PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)orig);
            int i = 0;
            while (i < origDescriptors.length) {
                String name = origDescriptors[i].getName();
                if (!"class".equals(name) && PropertyUtils.isReadable((Object)orig, (String)name) && PropertyUtils.isWriteable((Object)dest, (String)name)) {
                    try {
                        Object value = PropertyUtils.getSimpleProperty((Object)orig, (String)name);
                        MyBeanUtils.copyProperty((Object)dest, (String)name, (Object)value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static void copyBeanNotNull2Bean(Object databean, Object tobean) throws Exception {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)databean);
        int i = 0;
        while (i < origDescriptors.length) {
            String name = origDescriptors[i].getName();
            if (!"class".equals(name) && PropertyUtils.isReadable((Object)databean, (String)name) && PropertyUtils.isWriteable((Object)tobean, (String)name)) {
                try {
                    Object value = PropertyUtils.getSimpleProperty((Object)databean, (String)name);
                    if (value != null) {
                        PropertyUtils.setProperty((Object)tobean, (String)name, (Object)value);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static void copyBean2Bean(Object dest, Object orig) throws Exception {
        MyBeanUtils.convert(dest, orig);
    }

    public static void copyBean2Map(Map map, Object bean) {
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
        int i = 0;
        while (i < pds.length) {
            PropertyDescriptor pd = pds[i];
            String propname = pd.getName();
            if (!"class".equals(propname)) {
                try {
                    Object propvalue = PropertyUtils.getSimpleProperty((Object)bean, (String)propname);
                    map.put(propname, propvalue);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static void copyMap2Bean(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)name);
                if (clazz == null || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals(""))) continue;
                MyBeanUtils.setProperty((Object)bean, (String)name, value);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static void copyMap2Bean_Nobig(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                Class clazz;
                if (value == null || (clazz = PropertyUtils.getPropertyType((Object)bean, (String)name)) == null) continue;
                String className = clazz.getName();
                if (className.equalsIgnoreCase("java.util.Date")) {
                    value = new Date(((Timestamp)value).getTime());
                }
                MyBeanUtils.setProperty((Object)bean, (String)name, value);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static void copyMap2Bean(Object bean, Map properties, String defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)name);
                if (clazz == null || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals(""))) continue;
                if (className.equalsIgnoreCase("java.lang.String") && value == null) {
                    value = defaultValue;
                }
                MyBeanUtils.setProperty((Object)bean, (String)name, value);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

