/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.util;

import com.jeecg.p3.paycenter.util.JSONHelper;
import com.jeecg.p3.paycenter.util.SignatureUtil;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.jeecgframework.p3.core.common.utils.StringUtil;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public abstract class EncryptionUtil {
    public static final String CHARSET_UTF8 = "UTF-8";

    private static String base64Encode(byte[] bytes) {
        return new BASE64Encoder().encode(bytes);
    }

    private static byte[] base64Decode(String base64Code) throws Exception {
        return StringUtil.isEmpty((String)base64Code) ? null : new BASE64Decoder().decodeBuffer(base64Code);
    }

    private static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(encryptKey.getBytes());
        kgen.init(128, secureRandom);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, new SecretKeySpec(kgen.generateKey().getEncoded(), "AES"));
        return cipher.doFinal(content.getBytes());
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return EncryptionUtil.base64Encode(EncryptionUtil.aesEncryptToBytes(content, encryptKey));
    }

    private static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(decryptKey.getBytes());
        kgen.init(128, secureRandom);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, new SecretKeySpec(kgen.generateKey().getEncoded(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtil.isEmpty((String)encryptStr) ? null : EncryptionUtil.aesDecryptByBytes(EncryptionUtil.base64Decode(encryptStr), decryptKey);
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("requestNo", "RN501813815128999401512899941c0005");
        paramMap.put("sysCode", "jwmall");
        paramMap.put("payType", "weixinpay");
        paramMap.put("jwid", "gh_aee88273a8f5");
        paramMap.put("openid", "oSmm-vgQTwTVM6NHtBwlEtxrgg-0");
        paramMap.put("orderNo", "02100353192186160005");
        paramMap.put("desc", "\u5fae\u4fe1\u652f\u4ed8\u6d4b\u8bd5");
        paramMap.put("total_money", "0.01");
        paramMap.put("backCallUrl", "http://localhost/weixinShopDealController.do?payCallBackNotify");
        String sign = SignatureUtil.sign(paramMap, "372E839C53FCAED6F72780372E839C53FC47B1912B6C47B1912B6CAED6F72780");
        System.out.println("sign:" + sign);
        paramMap.put("sign", sign);
        String content = JSONHelper.map2json(paramMap);
        String key = "C47B1912B6C49C53FCAED6F72780372E839C53F7B1912B6CAED6F72780372E83";
        String encrypt = EncryptionUtil.aesEncrypt(content, key);
        String payUrl = "http://pay.jeewx.com/paycenter/weixinpay/toPay.do?sysCode=jwmall&data=" + URLEncoder.encode(encrypt);
        System.out.println(payUrl);
    }
}

