/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.task;

import com.jeecg.p3.paycenter.dao.PaycenterConfigDao;
import com.jeecg.p3.paycenter.entity.PaycenterConfig;
import com.jeecg.p3.paycenter.entity.PaycenterTransOrder;
import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.task.ThreadTask;
import com.jeecg.p3.paycenter.util.EncryptionUtil;
import com.jeecg.p3.paycenter.util.JSONHelper;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jeecgframework.p3.core.common.utils.StringUtil;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.SignatureUtil;

public class MerCallBackThreadTask
implements ThreadTask {
    private static final long serialVersionUID = 5253700279807396631L;
    public static final Logger log = LoggerFactory.getLogger(MerCallBackThreadTask.class);
    private PaycenterTransOrder transOrder;
    private PaycenterConfigDao paycenterConfigDao;

    public MerCallBackThreadTask(PaycenterTransOrder transOrder, PaycenterConfigDao paycenterConfigDao) {
        this.transOrder = transOrder;
        this.paycenterConfigDao = paycenterConfigDao;
    }

    @Override
    public void run() {
        int i = 0;
        this.notifyMerchant(i);
    }

    private String callBackMerchant(PaycenterTransOrder transOrder) {
        StringBuilder sb = new StringBuilder("");
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("requestNo", transOrder.getRequestNo());
            map.put("transOrderNo", transOrder.getId());
            map.put("orderNo", transOrder.getOrderNo());
            map.put("payType", transOrder.getPayType());
            map.put("payTotal", transOrder.getPayTotalPrice().toString());
            map.put("jwid", transOrder.getJwid());
            map.put("openid", transOrder.getOpenid());
            map.put("status", transOrder.getStatus());
            map.put("returnMsg", transOrder.getResultMsg());
            PaycenterConfig paycenterConfig = this.paycenterConfigDao.queryBySysCode(transOrder.getSysCode());
            if (paycenterConfig == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            String encryptKey = paycenterConfig.getEncrypKey();
            String signKey = paycenterConfig.getSignKey();
            String sign = SignatureUtil.sign(map, (String)signKey);
            map.put("sign", sign);
            String data = JSONHelper.map2json(map);
            data = EncryptionUtil.aesEncrypt(data, encryptKey);
            sb.append(transOrder.getBackCallUrl());
            sb.append("&sysCode=").append(transOrder.getSysCode());
            sb.append("&data=").append(URLEncoder.encode(data));
        }
        catch (Exception e) {
            return "";
        }
        return sb.toString();
    }

    public void notifyMerchant(int i) {
        HttpClient client = new HttpClient();
        GetMethod method = null;
        try {
            log.info("\u540e\u53f0\u7ebf\u7a0b\u901a\u77e5\u5546\u5bb6\u63a5\u53e3\u5f00\u59cb");
            String backUrl = this.callBackMerchant(this.transOrder);
            method = new GetMethod(backUrl);
            log.info("\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f\uff0c\u540e\u53f0\u56de\u8c03\u5730\u5740========" + backUrl);
            if (StringUtil.isEmpty((String)backUrl)) {
                return;
            }
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode == 200 && method.getResponseBodyAsString().indexOf("success") != -1) {
                    log.info("\u540e\u53f0\u901a\u77e5\u63a5\u53e3\uff0c\u56de\u8c03\u5546\u5bb6\u6210\u529f\uff0c\u5546\u5bb6jwid===" + this.transOrder.getJwid() + ",\u5546\u5bb6\u8ba2\u5355===" + this.transOrder.getOrderNo());
                    method.releaseConnection();
                } else {
                    Thread.sleep(3000L);
                    if (i < 3) {
                        log.info("\u540e\u53f0\u901a\u77e5\u63a5\u53e3\uff0c\u56de\u8c03\u5546\u5bb6\u7b2c" + (i + 1) + "\u6b21\u5931\u8d25\uff0c\u5546\u5bb6jwid===" + this.transOrder.getJwid() + ",\u5546\u5bb6\u8ba2\u5355===" + this.transOrder.getOrderNo());
                        this.notifyMerchant(++i);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u540e\u53f0\u901a\u77e5\u63a5\u53e3,\u53d1\u751f\u5f02\u5e38=======" + e.getMessage());
                try {
                    Thread.sleep(3000L);
                    if (i < 3) {
                        log.info("\u540e\u53f0\u901a\u77e5\u63a5\u53e3\uff0c\u56de\u8c03\u5546\u5bb6\u7b2c" + (i + 1) + "\u6b21\u5931\u8d25\uff0c\u5546\u5bb6jwid===" + this.transOrder.getJwid() + ",\u5546\u5bb6\u8ba2\u5355===" + this.transOrder.getOrderNo());
                        this.notifyMerchant(++i);
                    }
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

