/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.service.impl;

import com.jeecg.p3.paycenter.dao.PaycenterConfigDao;
import com.jeecg.p3.paycenter.dao.PaycenterRefundOrderDao;
import com.jeecg.p3.paycenter.dao.PaycenterRouteDao;
import com.jeecg.p3.paycenter.dao.PaycenterTransOrderDao;
import com.jeecg.p3.paycenter.entity.PaycenterRefundOrder;
import com.jeecg.p3.paycenter.entity.PaycenterRoute;
import com.jeecg.p3.paycenter.entity.PaycenterTransOrder;
import com.jeecg.p3.paycenter.enums.PayTypeEnum;
import com.jeecg.p3.paycenter.enums.RefundStatusEnum;
import com.jeecg.p3.paycenter.enums.TransStatusEnum;
import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.service.PayCenterWeixinPayService;
import com.jeecg.p3.paycenter.task.MerCallBackThreadTask;
import com.jeecg.p3.paycenter.util.ConvertUtils;
import com.jeecg.p3.paycenter.util.DateUtils;
import com.jeecg.p3.paycenter.util.HttpRequester;
import com.jeecg.p3.paycenter.util.HttpRespons;
import com.jeecg.p3.paycenter.util.JSONHelper;
import com.jeecg.p3.paycenter.util.MD5Util;
import com.jeecg.p3.paycenter.util.PayUtil;
import com.jeecg.p3.paycenter.util.XMLUtil;
import com.jeecg.p3.paycenter.vo.PayBaseVo;
import com.jeecg.p3.paycenter.vo.RefundBaseVo;
import com.jeecg.p3.paycenter.vo.RefundResponse;
import com.jeecg.p3.paycenter.vo.WeixinPayDto;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jdom.JDOMException;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.PropertiesUtil;
import org.jeecgframework.p3.core.util.UUIDGenerator;
import org.springframework.stereotype.Service;

@Service(value="payCenterWeixinPayService")
public class PayCenterWeixinPayServiceImpl
implements PayCenterWeixinPayService {
    public static final Logger log = LoggerFactory.getLogger(PayCenterWeixinPayServiceImpl.class);
    @Resource
    private PaycenterTransOrderDao paycenterTransOrderDao;
    @Resource
    private PaycenterConfigDao paycenterConfigDao;
    @Resource
    private PaycenterRouteDao paycenterRouteDao;
    @Resource
    private PaycenterRefundOrderDao paycenterRefundOrderDao;
    private static final String ApplyPayURL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String ApplyRefundURL = "https://api.mch.weixin.qq.com/secapi/pay/refund";

    @Override
    public String weixinpay(HttpServletRequest req, PayBaseVo payBaseVo, PaycenterRoute route) {
        String preCallUrl;
        Map<String, String> rebulidMap;
        PaycenterTransOrder transOrder = this.paycenterTransOrderDao.queryTransOrderByReqNoSysCode(payBaseVo.getRequestNo(), payBaseVo.getSysCode());
        if (transOrder == null) {
            transOrder = new PaycenterTransOrder();
            transOrder.setId(UUIDGenerator.generate());
            transOrder.setSysCode(payBaseVo.getSysCode());
            transOrder.setRequestNo(payBaseVo.getRequestNo());
            transOrder.setJwid(payBaseVo.getJwid());
            transOrder.setOpenid(payBaseVo.getOpenid());
            transOrder.setPayType(payBaseVo.getPayType());
            BigDecimal payTotalPrice = new BigDecimal(payBaseVo.getTotal_money()).multiply(new BigDecimal("100")).setScale(0);
            transOrder.setPayTotalPrice(payTotalPrice);
            transOrder.setOrderNo(payBaseVo.getOrderNo());
            transOrder.setGoodsDesc(payBaseVo.getDesc());
            transOrder.setBackCallUrl(payBaseVo.getBackCallUrl());
            transOrder.setPreCallUrl(payBaseVo.getPreCallUrl());
            transOrder.setStatus(TransStatusEnum.INIT.getCode());
            transOrder.setCreateDate(new Date());
            this.paycenterTransOrderDao.add(transOrder);
        } else if (TransStatusEnum.SUCCESS.getCode().equals(transOrder.getStatus())) {
            new Thread(new MerCallBackThreadTask(transOrder, this.paycenterConfigDao)).start();
            throw new BusinessException("\u8be5\u8ba2\u5355\u5df2\u652f\u4ed8\u6210\u529f");
        }
        WeixinPayDto weixinPayDto = JSONHelper.fromJsonToObject(route.getPayJson(), WeixinPayDto.class);
        StringBuilder redirectURI = new StringBuilder("redirect:pay.do?redirectWeixinpay");
        if (StringUtils.isEmpty((String)transOrder.getPrepayId())) {
            Map weixinPrepayMap = new HashMap();
            String openid = payBaseVo.getOpenid();
            try {
                weixinPrepayMap = this.obtainPrepay(req, openid, payBaseVo, weixinPayDto, transOrder.getId());
            }
            catch (Exception e) {
                throw new BusinessException(e);
            }
            String prepay_id = (String)weixinPrepayMap.get("prepay_id");
            log.info("\u53d6\u5f97\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u7684prepay_id=" + prepay_id);
            if (StringUtils.isEmpty((String)prepay_id)) {
                throw new BusinessException("prepay_id\u672a\u751f\u6210\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\uff1a" + (String)weixinPrepayMap.get("err_code_des"));
            }
            transOrder.setPrepayId(prepay_id);
            this.paycenterTransOrderDao.update(transOrder);
        }
        if ((rebulidMap = this.rebuildWeixinPayMap(weixinPayDto, transOrder.getPrepayId())) != null && rebulidMap.size() > 0) {
            Set<String> keys = rebulidMap.keySet();
            for (String key : keys) {
                if ("package".equalsIgnoreCase(key)) {
                    key = "packageValue";
                    redirectURI.append("&").append(key).append("=").append(rebulidMap.get("package"));
                    continue;
                }
                redirectURI.append("&").append(key).append("=").append(rebulidMap.get(key));
            }
        }
        if (StringUtils.isNotEmpty((String)(preCallUrl = payBaseVo.getPreCallUrl()))) {
            preCallUrl = URLEncoder.encode(preCallUrl);
            redirectURI.append("&preCallUrl=" + preCallUrl);
        }
        String transOrderNo = transOrder.getId();
        redirectURI.append("&transOrderNo=" + transOrderNo);
        redirectURI.append("&showwxpaytitle=1");
        return redirectURI.toString();
    }

    private Map<String, String> rebuildWeixinPayMap(Map weixinPrepayMap, WeixinPayDto weixinPayDto) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appId", ConvertUtils.getString(weixinPrepayMap.get("appid")));
        params.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("nonceStr", ConvertUtils.getString(weixinPrepayMap.get("nonce_str"), UUIDGenerator.generate()));
        params.put("package", "prepay_id=" + ConvertUtils.getString(weixinPrepayMap.get("prepay_id")));
        params.put("signType", "MD5");
        String paySign = this.createSign(params, weixinPayDto.getKey());
        params.put("paySign", paySign);
        return params;
    }

    private Map<String, String> rebuildWeixinPayMap(WeixinPayDto weixinPayDto, String prepayId) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appId", weixinPayDto.getAppid());
        params.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("nonceStr", UUIDGenerator.generate());
        params.put("package", "prepay_id=" + prepayId);
        params.put("signType", "MD5");
        String paySign = this.createSign(params, weixinPayDto.getKey());
        params.put("paySign", paySign);
        return params;
    }

    private Map obtainPrepay(HttpServletRequest req, String openid, PayBaseVo payBaseVo, WeixinPayDto weixinPayDto, String tradeNo) throws JDOMException, IOException {
        HttpRespons hr;
        HttpRequester request = new HttpRequester();
        TreeMap<String, String> params = new TreeMap<String, String>();
        String total_fee = String.valueOf(new BigDecimal(payBaseVo.getTotal_money()).multiply(new BigDecimal(100)).intValue());
        String ip = ConvertUtils.getIpAddrByRequest(req);
        if (StringUtils.isEmpty((String)ip)) {
            ip = "8.8.8.8";
        }
        params.put("appid", weixinPayDto.getAppid());
        params.put("mch_id", weixinPayDto.getMch_id());
        params.put("nonce_str", UUIDGenerator.generate());
        params.put("body", payBaseVo.getDesc());
        params.put("detail", payBaseVo.getDesc());
        params.put("out_trade_no", tradeNo);
        params.put("total_fee", total_fee);
        params.put("fee_type", "CNY");
        params.put("spbill_create_ip", ip);
        params.put("notify_url", this.getPayNotifyUrl(payBaseVo.getJwid()));
        params.put("trade_type", "JSAPI");
        params.put("openid", openid);
        String sign = this.createSign(params, weixinPayDto.getKey());
        params.put("sign", sign);
        String converterPayXML = XMLUtil.converterWeixinpayXML(params);
        log.info(converterPayXML);
        try {
            hr = request.sendPost(ApplyPayURL, converterPayXML);
        }
        catch (IOException e) {
            throw new BusinessException("\u7531\u4e8e\u7f51\u7edc\u8fde\u63a5\uff0c\u751f\u6210\u9884\u652f\u4ed8\u8ba2\u5355\u65f6\u51fa\u9519", e);
        }
        log.info("*************\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f_\u5f00\u59cb***************");
        log.info(hr.getUrlString());
        log.info(hr.getProtocol());
        log.info(hr.getHost());
        log.info(String.valueOf(hr.getPort()));
        log.info(hr.getContentEncoding());
        log.info(hr.getMethod());
        log.info(hr.getContent());
        log.info(hr.getContentEncoding());
        log.info("\u8fd4\u56de\u7684\u5185\u5bb9\uff1a" + hr.getContent());
        log.info("*************\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f_\u7ed3\u675f***************");
        return XMLUtil.doXMLParse(hr.getContent());
    }

    private String createSign(Map<String, String> params, String key) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = params.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (v == null || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(String.valueOf(k) + "=" + v + "&");
        }
        sb.append("key=" + key);
        log.info(sb.toString());
        String sign = MD5Util.MD5Encode(sb.toString(), "UTF-8").toUpperCase();
        log.info("sign=" + sign);
        return sign;
    }

    private String getPayNotifyUrl(String jwid) {
        PropertiesUtil p = new PropertiesUtil("paycenter.properties");
        String notifyUrl = String.valueOf(p.readProperty("pay_domain")) + "/paycenter/weixinpay/notify/";
        return String.valueOf(notifyUrl) + "weixinpay/" + jwid;
    }

    @Override
    public void doNotify(HttpServletRequest request, String jwid, String payType) {
        String return_msg;
        PaycenterRoute route = this.paycenterRouteDao.queryByJwidAndPayType(jwid, payType);
        if (route == null) {
            throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u672a\u5f00\u901a");
        }
        WeixinPayDto weixinPayDto = JSONHelper.fromJsonToObject(route.getPayJson(), WeixinPayDto.class);
        log.info("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\u5f00\u59cb:{}", new Object[]{weixinPayDto});
        String result = this.getNotifyInfo(request);
        if (StringUtils.isEmpty((String)result)) {
            throw new BusinessException("\u901a\u77e5\u5185\u5bb9\u4e3a\u7a7a");
        }
        Map map = XMLUtil.doXMLParse(result);
        for (String keyValue : map.keySet()) {
            log.info(String.valueOf(keyValue) + "=" + (String)map.get(keyValue));
        }
        String sign = map.get("sign") == null ? "" : ((String)map.get("sign")).toString();
        TreeMap<String, String> sort = new TreeMap<String, String>(map);
        if (!this.checkWxSign(sort, weixinPayDto.getKey(), sign)) {
            throw new BusinessException("\u9a8c\u7b7e\u5931\u8d25");
        }
        String tradeNo = (String)map.get("out_trade_no");
        PaycenterTransOrder transOrder = (PaycenterTransOrder)this.paycenterTransOrderDao.get((Serializable)((Object)tradeNo));
        transOrder.setTransactionId((String)map.get("transaction_id"));
        String result_code = map.get("result_code") == null ? "" : ((String)map.get("result_code")).toString();
        String string = return_msg = map.get("return_msg") == null ? "" : ((String)map.get("return_msg")).toString();
        if ("SUCCESS".equalsIgnoreCase(result_code)) {
            transOrder.setResultCode("SUCCESS");
            transOrder.setResultMsg("OK");
            transOrder.setStatus(TransStatusEnum.SUCCESS.getCode());
            String finishTime = (String)map.get("time_end");
            transOrder.setTransFinishTime(DateUtils.parseDate(finishTime, "yyyyMMddHHmmss"));
        } else {
            transOrder.setResultCode(result_code);
            transOrder.setResultMsg(return_msg);
            transOrder.setStatus(TransStatusEnum.FAILED.getCode());
        }
        this.paycenterTransOrderDao.update(transOrder);
        new Thread(new MerCallBackThreadTask(transOrder, this.paycenterConfigDao)).start();
    }

    private String getNotifyInfo(HttpServletRequest request) {
        String result = "";
        ServletInputStream inStream = null;
        ByteArrayOutputStream outSteam = null;
        try {
            try {
                inStream = request.getInputStream();
                outSteam = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = inStream.read(buffer)) != -1) {
                    outSteam.write(buffer, 0, len);
                }
                outSteam.close();
                inStream.close();
                result = new String(outSteam.toByteArray(), "utf-8");
                log.info("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\u5185\u5bb9\uff1a" + result);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\u5f02\u5e38:" + e.getMessage());
                try {
                    if (outSteam != null) {
                        outSteam.close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (outSteam != null) {
                    outSteam.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private boolean checkWxSign(Map<String, String> params, String key, String sign) {
        boolean flag = false;
        String localsign = this.createSign(params, key);
        if (sign.equals(localsign)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void refund(HttpServletRequest req, RefundBaseVo refundBaseVo, RefundResponse res) {
        PaycenterTransOrder transOrder = (PaycenterTransOrder)this.paycenterTransOrderDao.get((Serializable)((Object)refundBaseVo.getTransOrderNo()));
        if (transOrder == null) {
            throw new BusinessException("\u672a\u627e\u5230\u4ea4\u6613\u8ba2\u5355");
        }
        PayTypeEnum payType = PayTypeEnum.toEnum(transOrder.getPayType());
        if (payType == null) {
            throw new BusinessException("\u8be5\u652f\u4ed8\u901a\u9053\u6682\u4e0d\u652f\u6301");
        }
        if (!PayTypeEnum.weixinpay.getCode().equals(payType.getCode())) {
            throw new BusinessException("\u8be5\u652f\u4ed8\u901a\u9053\u6682\u4e0d\u652f\u6301");
        }
        BigDecimal diff = transOrder.getPayTotalPrice().subtract(refundBaseVo.getRefundTotal().multiply(new BigDecimal("100")));
        if (diff.intValue() != 0) {
            throw new BusinessException("\u9000\u6b3e\u91d1\u989d\u4e0e\u8ba2\u5355\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        PaycenterRefundOrder refundOrder = this.paycenterRefundOrderDao.queryRefundOrderByReqNoSysCode(refundBaseVo.getRequestNo(), refundBaseVo.getSysCode());
        if (refundOrder == null) {
            refundOrder = new PaycenterRefundOrder();
            refundOrder.setBackCallUrl(refundBaseVo.getBackCallUrl());
            refundOrder.setCreateDate(new Date());
            refundOrder.setGoodsDesc(transOrder.getGoodsDesc());
            refundOrder.setId(UUIDGenerator.generate());
            refundOrder.setJwid(transOrder.getJwid());
            refundOrder.setOpenid(transOrder.getOpenid());
            refundOrder.setOrderNo(transOrder.getOrderNo());
            refundOrder.setPayTotalPrice(transOrder.getPayTotalPrice());
            refundOrder.setPayType(transOrder.getPayType());
            refundOrder.setRefundAmount(refundBaseVo.getRefundTotal().multiply(new BigDecimal("100")));
            refundOrder.setRequestNo(refundBaseVo.getRequestNo());
            refundOrder.setStatus(RefundStatusEnum.DOING.getCode());
            refundOrder.setSysCode(refundBaseVo.getSysCode());
            refundOrder.setSubject(transOrder.getSubject());
            refundOrder.setTransactionId(transOrder.getTransactionId());
            refundOrder.setTransOrderNo(refundBaseVo.getTransOrderNo());
            refundOrder.setBatchNo(PayUtil.generateRefundBatchNo());
            this.paycenterRefundOrderDao.add(refundOrder);
        } else if (RefundStatusEnum.SUCCESS.getCode().equals(refundOrder.getStatus())) {
            res.setReturnCode(RefundStatusEnum.SUCCESS.getCode());
            res.setReturnMsg("\u9000\u6b3e\u5df2\u7533\u8bf7\uff0c\u9000\u6b3e\u6709\u4e00\u5b9a\u5ef6\u65f6\uff0c\u7528\u96f6\u94b1\u652f\u4ed8\u7684\u9000\u6b3e20\u5206\u949f\u5185\u5230\u8d26\uff0c\u94f6\u884c\u5361\u652f\u4ed8\u7684\u9000\u6b3e3\u4e2a\u5de5\u4f5c\u65e5\u540e\u91cd\u65b0\u67e5\u8be2\u9000\u6b3e\u72b6\u6001");
            return;
        }
        if (StringUtils.isEmpty((String)refundOrder.getTransactionId())) {
            throw new BusinessException("\u652f\u4ed8\u4ea4\u6613\u5355\u53f7\u4e3a\u7a7a");
        }
        if (!refundOrder.getTransactionId().equals(transOrder.getTransactionId())) {
            throw new BusinessException("\u9000\u6b3e\u8ba2\u5355\u4e0e\u4ea4\u6613\u8ba2\u5355\u7684\u652f\u4ed8\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4");
        }
        if (!TransStatusEnum.SUCCESS.getCode().equals(transOrder.getStatus())) {
            throw new BusinessException("\u672a\u652f\u4ed8\u6210\u529f\u7684\u4ea4\u6613\u8ba2\u5355\u4e0d\u80fd\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c");
        }
        PaycenterRoute route = this.paycenterRouteDao.queryByJwidAndPayType(transOrder.getJwid(), transOrder.getPayType());
        if (route == null) {
            throw new BusinessException("\u8be5\u652f\u4ed8\u901a\u9053\u672a\u5f00\u901a");
        }
        WeixinPayDto weixinPayDto = JSONHelper.fromJsonToObject(route.getPayJson(), WeixinPayDto.class);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appid", weixinPayDto.getAppid());
        params.put("mch_id", weixinPayDto.getMch_id());
        params.put("device_info", "1");
        params.put("nonce_str", UUIDGenerator.generate());
        params.put("transaction_id", refundOrder.getTransactionId());
        params.put("out_trade_no", refundOrder.getTransOrderNo());
        params.put("out_refund_no", refundOrder.getId());
        params.put("total_fee", refundOrder.getPayTotalPrice().toString());
        params.put("refund_fee", String.valueOf(refundOrder.getRefundAmount().intValue()));
        params.put("refund_fee_type", "CNY");
        params.put("op_user_id", weixinPayDto.getMch_id());
        String sign = this.createSign(params, weixinPayDto.getKey());
        params.put("sign", sign);
        String converterRefundXML = XMLUtil.converterWeixinpayXML(params);
        log.info("\u7533\u8bf7\u9000\u6b3e\u8bf7\u6c42\uff1a" + converterRefundXML);
        try {
            Map<String, String> refundApplayResult = this.sslResquest(ApplyRefundURL, converterRefundXML, weixinPayDto.getMch_id(), weixinPayDto.getCertFileName());
            String return_code = refundApplayResult.get("return_code");
            String result_code = refundApplayResult.get("result_code");
            if ("SUCCESS".equals(return_code)) {
                if ("SUCCESS".equals(result_code)) {
                    refundOrder.setStatus(RefundStatusEnum.SUCCESS.getCode());
                    refundOrder.setResultCode("SUCCESS");
                    refundOrder.setResultMsg("\u9000\u6b3e\u5df2\u7533\u8bf7\uff0c\u9000\u6b3e\u6709\u4e00\u5b9a\u5ef6\u65f6\uff0c\u7528\u96f6\u94b1\u652f\u4ed8\u7684\u9000\u6b3e20\u5206\u949f\u5185\u5230\u8d26\uff0c\u94f6\u884c\u5361\u652f\u4ed8\u7684\u9000\u6b3e3\u4e2a\u5de5\u4f5c\u65e5\u540e\u91cd\u65b0\u67e5\u8be2\u9000\u6b3e\u72b6\u6001");
                    this.paycenterRefundOrderDao.update(refundOrder);
                    transOrder.setRefundApplyFlag(RefundStatusEnum.SUCCESS.getCode());
                    this.paycenterTransOrderDao.update(transOrder);
                    res.setReturnCode(refundOrder.getStatus());
                    res.setReturnMsg(refundOrder.getResultMsg());
                } else {
                    refundOrder.setStatus(RefundStatusEnum.FAILED.getCode());
                    refundOrder.setResultCode(result_code);
                    refundOrder.setResultMsg(String.valueOf(refundApplayResult.get("err_code")) + ";" + refundApplayResult.get("err_code_des"));
                    transOrder.setRefundApplyFlag(RefundStatusEnum.FAILED.getCode());
                    this.paycenterTransOrderDao.update(transOrder);
                    res.setReturnCode(refundOrder.getStatus());
                    res.setReturnMsg(refundOrder.getResultMsg());
                }
            } else {
                refundOrder.setStatus(RefundStatusEnum.FAILED.getCode());
                refundOrder.setResultCode(result_code);
                refundOrder.setResultMsg(refundApplayResult.get("return_msg"));
                transOrder.setRefundApplyFlag(RefundStatusEnum.FAILED.getCode());
                this.paycenterTransOrderDao.update(transOrder);
                transOrder.setRefundApplyFlag(RefundStatusEnum.FAILED.getCode());
                this.paycenterTransOrderDao.update(transOrder);
                res.setReturnCode(RefundStatusEnum.FAILED.getCode());
                res.setReturnMsg(refundOrder.getResultMsg());
            }
        }
        catch (IOException e) {
            throw new BusinessException("\u7531\u4e8e\u7f51\u7edc\u8fde\u63a5\uff0c\u9000\u6b3e\u7533\u8bf7\u65f6\u51fa\u9519", e);
        }
        catch (JDOMException e) {
            throw new BusinessException("\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u9519\u8bef\uff0c\u9000\u6b3e\u7533\u8bf7\u65f6\u51fa\u9519", e);
        }
        catch (Exception e) {
            throw new BusinessException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u9000\u6b3e\u7533\u8bf7\u65f6\u51fa\u9519", e);
        }
    }

    public Map<String, String> sslResquest(String url, String arrayToXml, String mch_id, String certFileName) throws Exception {
        HashMap<String, String> doXMLtoMap = new HashMap();
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        PropertiesUtil p = new PropertiesUtil("paycenter.properties");
        String PKCS12_Base = p.readProperty("PKCS12_Base");
        String absoluteFileName = String.valueOf(PKCS12_Base) + File.separator + mch_id + File.separator + certFileName;
        log.info("cert path\uff1a" + absoluteFileName);
        File certFile = new File(absoluteFileName);
        if (!certFile.exists()) {
            throw new BusinessException("\u8bc1\u4e66\u4e0d\u5b58\u5728");
        }
        FileInputStream instream = new FileInputStream(certFile);
        try {
            keyStore.load(instream, mch_id.toCharArray());
        }
        finally {
            instream.close();
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, mch_id.toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(arrayToXml, "UTF-8"));
            log.info("executing request " + httpPost.getRequestLine());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            String xmlStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            doXMLtoMap = XMLUtil.doXMLParse(xmlStr);
            log.info("\u7533\u8bf7\u9000\u6b3e\u8fd4\u56de\u7684XML\u6570\u636e\u4e3a" + xmlStr);
            response.close();
        }
        finally {
            httpclient.close();
        }
        return doXMLtoMap;
    }
}

