/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.paycenter.service.impl;

import com.jeecg.p3.paycenter.dao.PaycenterConfigDao;
import com.jeecg.p3.paycenter.dao.PaycenterRefundOrderDao;
import com.jeecg.p3.paycenter.dao.PaycenterRouteDao;
import com.jeecg.p3.paycenter.dao.PaycenterTransOrderDao;
import com.jeecg.p3.paycenter.entity.PaycenterRefundOrder;
import com.jeecg.p3.paycenter.entity.PaycenterRoute;
import com.jeecg.p3.paycenter.entity.PaycenterTransOrder;
import com.jeecg.p3.paycenter.enums.PayTypeEnum;
import com.jeecg.p3.paycenter.enums.RefundStatusEnum;
import com.jeecg.p3.paycenter.enums.TransStatusEnum;
import com.jeecg.p3.paycenter.exception.BusinessException;
import com.jeecg.p3.paycenter.service.PayCenterAlipayService;
import com.jeecg.p3.paycenter.task.MerCallBackThreadTask;
import com.jeecg.p3.paycenter.task.MerRefundCallBackThreadTask;
import com.jeecg.p3.paycenter.util.DateUtils;
import com.jeecg.p3.paycenter.util.JSONHelper;
import com.jeecg.p3.paycenter.util.PayUtil;
import com.jeecg.p3.paycenter.util.alipay.AlipayConfig;
import com.jeecg.p3.paycenter.util.alipay.AlipayNotify;
import com.jeecg.p3.paycenter.util.alipay.AlipaySubmit;
import com.jeecg.p3.paycenter.vo.RefundBaseVo;
import com.jeecg.p3.paycenter.vo.alipay.AlipayBaseVo;
import com.jeecg.p3.paycenter.vo.alipay.AlipayDto;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.PropertiesUtil;
import org.jeecgframework.p3.core.util.UUIDGenerator;
import org.springframework.stereotype.Service;

@Service(value="payCenterAlipayService")
public class PayCenterAlipayServiceImpl
implements PayCenterAlipayService {
    public static final Logger log = LoggerFactory.getLogger(PayCenterAlipayServiceImpl.class);
    @Resource
    private PaycenterTransOrderDao paycenterTransOrderDao;
    @Resource
    private PaycenterConfigDao paycenterConfigDao;
    @Resource
    private PaycenterRouteDao paycenterRouteDao;
    @Resource
    private PaycenterRefundOrderDao paycenterRefundOrderDao;

    @Override
    public String alipay(HttpServletRequest req, AlipayBaseVo payBaseVo, PaycenterRoute route) {
        PaycenterTransOrder transOrder = this.paycenterTransOrderDao.queryTransOrderByReqNoSysCode(payBaseVo.getRequestNo(), payBaseVo.getSysCode());
        if (transOrder == null) {
            transOrder = new PaycenterTransOrder();
            transOrder.setId(UUIDGenerator.generate());
            transOrder.setSysCode(payBaseVo.getSysCode());
            transOrder.setRequestNo(payBaseVo.getRequestNo());
            transOrder.setJwid(payBaseVo.getJwid());
            transOrder.setPayType(payBaseVo.getPayType());
            BigDecimal payTotalPrice = new BigDecimal(payBaseVo.getTotalMoney()).multiply(new BigDecimal("100")).setScale(0);
            transOrder.setPayTotalPrice(payTotalPrice);
            transOrder.setOrderNo(payBaseVo.getOrderNo());
            transOrder.setGoodsDesc(payBaseVo.getDesc());
            transOrder.setBackCallUrl(payBaseVo.getBackCallUrl());
            transOrder.setPreCallUrl(payBaseVo.getPreCallUrl());
            transOrder.setStatus(TransStatusEnum.INIT.getCode());
            transOrder.setCreateDate(new Date());
            transOrder.setSubject(payBaseVo.getSubject());
            transOrder.setShowUrl(payBaseVo.getShowUrl());
            this.paycenterTransOrderDao.add(transOrder);
        } else if (TransStatusEnum.SUCCESS.getCode().equals(transOrder.getStatus())) {
            new Thread(new MerCallBackThreadTask(transOrder, this.paycenterConfigDao)).start();
            throw new BusinessException("\u8be5\u8ba2\u5355\u5df2\u652f\u4ed8\u6210\u529f");
        }
        AlipayDto alipayDto = JSONHelper.fromJsonToObject(route.getPayJson(), AlipayDto.class);
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", AlipayConfig.service);
        sParaTemp.put("partner", payBaseVo.getJwid());
        sParaTemp.put("seller_id", payBaseVo.getJwid());
        sParaTemp.put("_input_charset", AlipayConfig.input_charset);
        sParaTemp.put("payment_type", AlipayConfig.payment_type);
        sParaTemp.put("notify_url", this.getPayNotifyUrl(payBaseVo.getJwid()));
        sParaTemp.put("return_url", this.getPayPreNotifyUrl(payBaseVo.getJwid()));
        sParaTemp.put("out_trade_no", transOrder.getId());
        sParaTemp.put("subject", payBaseVo.getSubject());
        sParaTemp.put("total_fee", payBaseVo.getTotalMoney());
        sParaTemp.put("show_url", payBaseVo.getShowUrl());
        sParaTemp.put("app_pay", "Y");
        sParaTemp.put("body", payBaseVo.getDesc());
        String sHtmlText = AlipaySubmit.buildRequest(sParaTemp, alipayDto.getKey(), "get", "\u786e\u8ba4");
        return sHtmlText;
    }

    private String getPayNotifyUrl(String jwid) {
        PropertiesUtil p = new PropertiesUtil("paycenter.properties");
        String notifyUrl = String.valueOf(p.readProperty("pay_domain")) + "/paycenter/alipay/notify/";
        return String.valueOf(notifyUrl) + "alipay/" + jwid + ".do";
    }

    private String getPayPreNotifyUrl(String jwid) {
        PropertiesUtil p = new PropertiesUtil("paycenter.properties");
        String notifyUrl = String.valueOf(p.readProperty("pay_domain")) + "/paycenter/alipay/prenotify/";
        return String.valueOf(notifyUrl) + "alipay/" + jwid + ".do";
    }

    private String getRefundNotifyUrl(String jwid) {
        PropertiesUtil p = new PropertiesUtil("paycenter.properties");
        String notifyUrl = String.valueOf(p.readProperty("pay_domain")) + "/paycenter/alipay/refundnotify/";
        return String.valueOf(notifyUrl) + "alipay/" + jwid + ".do";
    }

    @Override
    public Map<String, String> doNotify(HttpServletRequest request, String jwid, String payType) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        PaycenterRoute route = this.paycenterRouteDao.queryByJwidAndPayType(jwid, payType);
        if (route == null) {
            throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u672a\u5f00\u901a");
        }
        AlipayDto alipayDto = JSONHelper.fromJsonToObject(route.getPayJson(), AlipayDto.class);
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            int i = 0;
            while (i < values.length) {
                valueStr = i == values.length - 1 ? String.valueOf(valueStr) + values[i] : String.valueOf(valueStr) + values[i] + ",";
                ++i;
            }
            params.put(name, valueStr);
        }
        log.info("\u652f\u4ed8\u901a\u77e5\u53c2\u6570\uff1a" + ((Object)params).toString());
        String tradeNo = request.getParameter("out_trade_no");
        PaycenterTransOrder transOrder = (PaycenterTransOrder)this.paycenterTransOrderDao.get((Serializable)((Object)tradeNo));
        resMap.put("preCallUrl", transOrder.getPreCallUrl());
        String trade_no = request.getParameter("trade_no");
        transOrder.setTransactionId(trade_no);
        String trade_status = request.getParameter("trade_status");
        String return_msg = request.getParameter("trade_status");
        if (AlipayNotify.verify(params, alipayDto.getPartner(), alipayDto.getKey())) {
            if (!trade_status.equals("TRADE_FINISHED")) {
                if (trade_status.equals("TRADE_SUCCESS")) {
                    transOrder.setResultCode("SUCCESS");
                    transOrder.setResultMsg("OK");
                    transOrder.setStatus(TransStatusEnum.SUCCESS.getCode());
                    String finishTime = request.getParameter("gmt_payment");
                    transOrder.setTransFinishTime(DateUtils.parseDate(finishTime, "yyyy-MM-dd HH:mm:ss"));
                    this.paycenterTransOrderDao.update(transOrder);
                    new Thread(new MerCallBackThreadTask(transOrder, this.paycenterConfigDao)).start();
                } else if (!(trade_status.equals("WAIT_BUYER_PAY") || trade_status.equals("TRADE_CLOSED") || trade_status.equals("TRADE_PENDING"))) {
                    transOrder.setResultCode(trade_status);
                    transOrder.setResultMsg(return_msg);
                    transOrder.setStatus(TransStatusEnum.FAILED.getCode());
                    this.paycenterTransOrderDao.update(transOrder);
                    new Thread(new MerCallBackThreadTask(transOrder, this.paycenterConfigDao)).start();
                }
            }
            resMap.put("status", "success");
            return resMap;
        }
        throw new BusinessException("\u9a8c\u7b7e\u5931\u8d25");
    }

    @Override
    public String refund(HttpServletRequest req, RefundBaseVo refundBaseVo) {
        PaycenterTransOrder transOrder = (PaycenterTransOrder)this.paycenterTransOrderDao.get((Serializable)((Object)refundBaseVo.getTransOrderNo()));
        if (transOrder == null) {
            throw new BusinessException("\u672a\u627e\u5230\u4ea4\u6613\u8ba2\u5355");
        }
        PayTypeEnum payType = PayTypeEnum.toEnum(transOrder.getPayType());
        if (payType == null) {
            throw new BusinessException("\u8be5\u652f\u4ed8\u901a\u9053\u6682\u4e0d\u652f\u6301");
        }
        if (!PayTypeEnum.alipay.getCode().equals(payType.getCode())) {
            throw new BusinessException("\u8be5\u652f\u4ed8\u901a\u9053\u6682\u4e0d\u652f\u6301");
        }
        BigDecimal diff = transOrder.getPayTotalPrice().subtract(refundBaseVo.getRefundTotal().multiply(new BigDecimal("100")));
        if (diff.intValue() != 0) {
            throw new BusinessException("\u9000\u6b3e\u91d1\u989d\u4e0e\u8ba2\u5355\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        PaycenterRefundOrder refundOrder = this.paycenterRefundOrderDao.queryRefundOrderByReqNoSysCode(refundBaseVo.getRequestNo(), refundBaseVo.getSysCode());
        if (refundOrder == null) {
            refundOrder = new PaycenterRefundOrder();
            refundOrder.setBackCallUrl(refundBaseVo.getBackCallUrl());
            refundOrder.setCreateDate(new Date());
            refundOrder.setGoodsDesc(transOrder.getGoodsDesc());
            refundOrder.setId(UUIDGenerator.generate());
            refundOrder.setJwid(transOrder.getJwid());
            refundOrder.setOrderNo(transOrder.getOrderNo());
            refundOrder.setPayTotalPrice(transOrder.getPayTotalPrice());
            refundOrder.setPayType(transOrder.getPayType());
            refundOrder.setRefundAmount(refundBaseVo.getRefundTotal().multiply(new BigDecimal("100")));
            refundOrder.setRequestNo(refundBaseVo.getRequestNo());
            refundOrder.setStatus(RefundStatusEnum.DOING.getCode());
            refundOrder.setSysCode(refundBaseVo.getSysCode());
            refundOrder.setSubject(transOrder.getSubject());
            refundOrder.setTransactionId(transOrder.getTransactionId());
            refundOrder.setTransOrderNo(refundBaseVo.getTransOrderNo());
            refundOrder.setBatchNo(PayUtil.generateRefundBatchNo());
            this.paycenterRefundOrderDao.add(refundOrder);
        } else if (RefundStatusEnum.SUCCESS.getCode().equals(refundOrder.getStatus())) {
            new Thread(new MerRefundCallBackThreadTask(refundOrder, this.paycenterConfigDao)).start();
            throw new BusinessException("\u8be5\u8ba2\u5355\u5df2\u9000\u6b3e\u6210\u529f");
        }
        if (StringUtils.isEmpty((String)refundOrder.getTransactionId())) {
            throw new BusinessException("\u652f\u4ed8\u4ea4\u6613\u5355\u53f7\u4e3a\u7a7a");
        }
        if (!refundOrder.getTransactionId().equals(transOrder.getTransactionId())) {
            throw new BusinessException("\u9000\u6b3e\u8ba2\u5355\u4e0e\u4ea4\u6613\u8ba2\u5355\u7684\u652f\u4ed8\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4");
        }
        if (!TransStatusEnum.SUCCESS.getCode().equals(transOrder.getStatus())) {
            throw new BusinessException("\u672a\u652f\u4ed8\u6210\u529f\u7684\u4ea4\u6613\u8ba2\u5355\u4e0d\u80fd\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c");
        }
        PaycenterRoute route = this.paycenterRouteDao.queryByJwidAndPayType(transOrder.getJwid(), transOrder.getPayType());
        if (route == null) {
            throw new BusinessException("\u8be5\u652f\u4ed8\u901a\u9053\u672a\u5f00\u901a");
        }
        AlipayDto alipayDto = JSONHelper.fromJsonToObject(route.getPayJson(), AlipayDto.class);
        transOrder.setRefundOrderNo(UUIDGenerator.generate());
        transOrder.setRefundApplyFlag(RefundStatusEnum.APPLY.getCode());
        this.paycenterTransOrderDao.update(transOrder);
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", AlipayConfig.refund_service);
        sParaTemp.put("partner", refundOrder.getJwid());
        sParaTemp.put("seller_user_id", refundOrder.getJwid());
        sParaTemp.put("_input_charset", AlipayConfig.input_charset);
        sParaTemp.put("notify_url", this.getRefundNotifyUrl(refundOrder.getJwid()));
        sParaTemp.put("refund_date", DateUtils.getDate("yyyy-MM-dd HH:mm:ss"));
        sParaTemp.put("batch_no", refundOrder.getBatchNo());
        sParaTemp.put("batch_num", "1");
        String detail_data = String.valueOf(refundOrder.getTransactionId()) + "^" + refundBaseVo.getRefundTotal().toString() + "^" + "\u534f\u5546\u9000\u6b3e";
        sParaTemp.put("detail_data", detail_data);
        String sHtmlText = AlipaySubmit.buildRequest(sParaTemp, alipayDto.getKey(), "get", "\u786e\u8ba4\u9000\u6b3e");
        return sHtmlText;
    }

    @Override
    public Map<String, String> doRefundNotify(HttpServletRequest request, String jwid, String payType) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        PaycenterRoute route = this.paycenterRouteDao.queryByJwidAndPayType(jwid, payType);
        if (route == null) {
            throw new BusinessException("\u8be5\u652f\u4ed8\u65b9\u5f0f\u6682\u672a\u5f00\u901a");
        }
        AlipayDto alipayDto = JSONHelper.fromJsonToObject(route.getPayJson(), AlipayDto.class);
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            int i = 0;
            while (i < values.length) {
                valueStr = i == values.length - 1 ? String.valueOf(valueStr) + values[i] : String.valueOf(valueStr) + values[i] + ",";
                ++i;
            }
            params.put(name, valueStr);
        }
        log.info("\u9000\u6b3e\u901a\u77e5\u53c2\u6570\uff1a" + ((Object)params).toString());
        String batchNo = request.getParameter("batch_no");
        PaycenterRefundOrder refundOrder = this.paycenterRefundOrderDao.queryRefundOrderByBatchNo(batchNo);
        if (refundOrder == null) {
            throw new BusinessException("\u6ca1\u6709\u67e5\u5230\u8be5\u6279\u6b21\u7684\u9000\u6b3e\u8ba2\u5355");
        }
        String success_num = request.getParameter("success_num");
        String result_details = request.getParameter("result_details");
        if (AlipayNotify.verify(params, alipayDto.getPartner(), alipayDto.getKey())) {
            log.info("\u9000\u6b3e\u901a\u77e5\u9a8c\u7b7e\u6210\u529f");
            log.info("\u9000\u6b3e\u6210\u529f\u7b14\u6570\uff1a" + success_num);
            if (Integer.valueOf(success_num) >= 1) {
                String[] details = result_details.split("\\^");
                log.info("\u9000\u6b3edetails.length\uff1a" + details.length);
                if (details.length >= 3 && refundOrder.getTransactionId().equals(details[0])) {
                    log.info("\u9000\u6b3edetails[2]\uff1a" + details[2]);
                    if ("SUCCESS".equals(details[2])) {
                        refundOrder.setStatus(RefundStatusEnum.SUCCESS.getCode());
                        refundOrder.setResultCode("SUCCESS");
                        refundOrder.setResultMsg(result_details);
                        this.paycenterRefundOrderDao.update(refundOrder);
                        PaycenterTransOrder transOrder = new PaycenterTransOrder();
                        transOrder.setId(refundOrder.getTransOrderNo());
                        transOrder.setRefundApplyFlag(RefundStatusEnum.SUCCESS.getCode());
                        this.paycenterTransOrderDao.update(transOrder);
                        new Thread(new MerRefundCallBackThreadTask(refundOrder, this.paycenterConfigDao)).start();
                    } else {
                        refundOrder.setStatus(RefundStatusEnum.FAILED.getCode());
                        refundOrder.setResultCode(details[2]);
                        refundOrder.setResultMsg(result_details);
                        this.paycenterRefundOrderDao.update(refundOrder);
                        PaycenterTransOrder transOrder = new PaycenterTransOrder();
                        transOrder.setId(refundOrder.getTransOrderNo());
                        transOrder.setRefundApplyFlag(RefundStatusEnum.FAILED.getCode());
                        this.paycenterTransOrderDao.update(transOrder);
                        new Thread(new MerRefundCallBackThreadTask(refundOrder, this.paycenterConfigDao)).start();
                    }
                }
            }
            resMap.put("status", "success");
            return resMap;
        }
        throw new BusinessException("\u9a8c\u7b7e\u5931\u8d25");
    }
}

