/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.job;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jeecg.modules.online.desform.constant.b;
import org.jeecg.modules.online.desform.mapper.DesignFormMapper;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class DesignFormDataClearJob
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DesignFormDataClearJob.class);
    private static long MAX_DIFF = 5184000000L;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DesignFormMapper designFormMapper;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info("------------------------\u56de\u6536\u7ad9\u6570\u636e\u6e05\u7a7a \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb---------------------- ");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"del_flag").is((Object)b.ak));
        List formList = this.designFormMapper.selectList((Wrapper)new QueryWrapper());
        List tableNameList = formList.stream().map(i2 -> i2.getDesformCode()).collect(Collectors.toList());
        Set collectionNames = this.mongoTemplate.getCollectionNames();
        for (String table : collectionNames) {
            List dataList;
            List<String> deleteIdList;
            if (tableNameList.indexOf(table) < 0 || (deleteIdList = this.getDeleteIdList(dataList = this.mongoTemplate.find(query, JSONObject.class, table))) == null || deleteIdList.size() == 0) continue;
            log.info("\u83b7\u53d6\u5220\u9664\u8868\uff1a{}, \u5220\u9664ID: {} ", (Object)table, (Object)deleteIdList.toString());
            Query deleteQuery = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(deleteIdList));
            this.mongoTemplate.remove(deleteQuery, table);
        }
        log.info("------------------------\u56de\u6536\u7ad9\u6570\u636e\u6e05\u7a7a \u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f---------------------- ");
    }

    private List<String> getDeleteIdList(List<JSONObject> dataList) {
        if (dataList != null && dataList.size() > 0) {
            long now = System.currentTimeMillis();
            ArrayList<String> deleteIdList = new ArrayList<String>();
            for (JSONObject json : dataList) {
                long diff;
                Long timestamp = json.getLong("delete_time");
                if (timestamp == null || (diff = now - timestamp) <= MAX_DIFF) continue;
                deleteIdList.add(json.getString("_id"));
            }
            return deleteIdList;
        }
        return null;
    }
}

