/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.Generated;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.mongo.model.TreeModel;

public class FieldOption {
    private String field;
    private String type;
    private String dictTable;
    private String dictCode;
    private String dictText;
    private String queryScope;
    private TreeModel treeModel;
    private String groupModeKey;
    private String groupDataConditionKey;
    private String groupOrderKey;
    private String staticOptions;
    private boolean staticShowLabel;
    private Boolean multi;

    public FieldOption() {
    }

    public FieldOption(String field, Boolean multi) {
        this.multi = multi;
        this.field = field;
    }

    public FieldOption(String field, String type) {
        this.type = type;
        this.field = field;
    }

    public static FieldOption getSystemPersonField(String field) {
        FieldOption fieldOption = new FieldOption(field, WidgetTypes.SELECT_USER.getType());
        fieldOption.setDictTable("sys_user");
        fieldOption.setDictCode("username");
        fieldOption.setDictText("realname");
        return fieldOption;
    }

    public static FieldOption getSystemBpmStatusField(String field) {
        FieldOption fieldOption = new FieldOption(field, WidgetTypes.SELECT.getType());
        fieldOption.setDictCode("bpm_status");
        return fieldOption;
    }

    public FieldOption(JSONObject json) {
        this.type = json.getString("type");
        this.field = json.getString("model");
        JSONObject options = json.getJSONObject("options");
        if (WidgetTypes.LINK_RECORD.getType().equals(this.type)) {
            this.dictTable = options.getString("sourceCode");
            this.dictCode = "id";
            this.dictText = options.getString("titleField");
        } else if (WidgetTypes.SWITCH.getType().equals(this.type)) {
            String activeValue = options.getString("activeValue");
            String inactiveValue = options.getString("inactiveValue");
            JSONArray array = new JSONArray();
            array.add((Object)activeValue);
            array.add((Object)inactiveValue);
            this.staticOptions = array.toJSONString();
        } else if (WidgetTypes.SELECT_USER.getType().equals(this.type)) {
            this.dictTable = "SYS_USER";
            this.dictCode = options.getString("customReturnField");
            this.dictText = "REALNAME";
        } else if (WidgetTypes.RADIO.getType().equals(this.type) || WidgetTypes.SELECT.getType().equals(this.type)) {
            String remote = options.getString("remote");
            if ("dict".equals(remote)) {
                this.dictCode = options.getString("dictCode");
            }
            this.staticOptions = options.getString("options");
            this.staticShowLabel = options.getBooleanValue("showLabel");
        } else if (WidgetTypes.TABLE_DICT.getType().equals(this.type)) {
            this.dictTable = options.getString("dictTable");
            this.dictCode = options.getString("dictCode");
            this.dictText = options.getString("dictText");
            this.queryScope = options.getString("queryScope");
        }
        this.initTreeModel(options);
    }

    private void initTreeModel(JSONObject options) {
        if (WidgetTypes.SELECT_TREE.getType().equals(this.getType())) {
            JSONObject conf = options.getJSONObject("conf");
            JSONObject category = conf.getJSONObject("category");
            String code = category.getString("code");
            if (code != null && !"".equals(code)) {
                TreeModel treeModel = TreeModel.getCategoryTree(code);
                this.setTreeModel(treeModel);
            } else {
                JSONObject table = conf.getJSONObject("table");
                TreeModel treeModel = new TreeModel(table);
                this.setTreeModel(treeModel);
            }
        }
    }

    public boolean isList() {
        return WidgetTypes.SELECT.getType().equals(this.type) || WidgetTypes.RADIO.getType().equals(this.type) || WidgetTypes.TABLE_DICT.getType().equals(this.type) || WidgetTypes.LINK_RECORD.getType().equals(this.type);
    }

    public String getOrderType(JSONObject json) {
        String orderType = null;
        orderType = oConvertUtils.isEmpty((Object)this.getGroupOrderKey()) ? "desc" : json.getString(this.getGroupOrderKey());
        if (oConvertUtils.isEmpty((Object)orderType)) {
            orderType = "desc";
        }
        return orderType;
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDictTable() {
        return this.dictTable;
    }

    @Generated
    public String getDictCode() {
        return this.dictCode;
    }

    @Generated
    public String getDictText() {
        return this.dictText;
    }

    @Generated
    public String getQueryScope() {
        return this.queryScope;
    }

    @Generated
    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    @Generated
    public String getGroupModeKey() {
        return this.groupModeKey;
    }

    @Generated
    public String getGroupDataConditionKey() {
        return this.groupDataConditionKey;
    }

    @Generated
    public String getGroupOrderKey() {
        return this.groupOrderKey;
    }

    @Generated
    public String getStaticOptions() {
        return this.staticOptions;
    }

    @Generated
    public boolean isStaticShowLabel() {
        return this.staticShowLabel;
    }

    @Generated
    public Boolean getMulti() {
        return this.multi;
    }

    @Generated
    public void setField(String field) {
        this.field = field;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setDictTable(String dictTable) {
        this.dictTable = dictTable;
    }

    @Generated
    public void setDictCode(String dictCode) {
        this.dictCode = dictCode;
    }

    @Generated
    public void setDictText(String dictText) {
        this.dictText = dictText;
    }

    @Generated
    public void setQueryScope(String queryScope) {
        this.queryScope = queryScope;
    }

    @Generated
    public void setTreeModel(TreeModel treeModel) {
        this.treeModel = treeModel;
    }

    @Generated
    public void setGroupModeKey(String groupModeKey) {
        this.groupModeKey = groupModeKey;
    }

    @Generated
    public void setGroupDataConditionKey(String groupDataConditionKey) {
        this.groupDataConditionKey = groupDataConditionKey;
    }

    @Generated
    public void setGroupOrderKey(String groupOrderKey) {
        this.groupOrderKey = groupOrderKey;
    }

    @Generated
    public void setStaticOptions(String staticOptions) {
        this.staticOptions = staticOptions;
    }

    @Generated
    public void setStaticShowLabel(boolean staticShowLabel) {
        this.staticShowLabel = staticShowLabel;
    }

    @Generated
    public void setMulti(Boolean multi) {
        this.multi = multi;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof FieldOption)) {
            return false;
        }
        FieldOption other = (FieldOption)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStaticShowLabel() != other.isStaticShowLabel()) {
            return false;
        }
        Boolean this$multi = this.getMulti();
        Boolean other$multi = other.getMulti();
        if (this$multi == null ? other$multi != null : !((Object)this$multi).equals(other$multi)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$dictTable = this.getDictTable();
        String other$dictTable = other.getDictTable();
        if (this$dictTable == null ? other$dictTable != null : !this$dictTable.equals(other$dictTable)) {
            return false;
        }
        String this$dictCode = this.getDictCode();
        String other$dictCode = other.getDictCode();
        if (this$dictCode == null ? other$dictCode != null : !this$dictCode.equals(other$dictCode)) {
            return false;
        }
        String this$dictText = this.getDictText();
        String other$dictText = other.getDictText();
        if (this$dictText == null ? other$dictText != null : !this$dictText.equals(other$dictText)) {
            return false;
        }
        String this$queryScope = this.getQueryScope();
        String other$queryScope = other.getQueryScope();
        if (this$queryScope == null ? other$queryScope != null : !this$queryScope.equals(other$queryScope)) {
            return false;
        }
        TreeModel this$treeModel = this.getTreeModel();
        TreeModel other$treeModel = other.getTreeModel();
        if (this$treeModel == null ? other$treeModel != null : !((Object)this$treeModel).equals(other$treeModel)) {
            return false;
        }
        String this$groupModeKey = this.getGroupModeKey();
        String other$groupModeKey = other.getGroupModeKey();
        if (this$groupModeKey == null ? other$groupModeKey != null : !this$groupModeKey.equals(other$groupModeKey)) {
            return false;
        }
        String this$groupDataConditionKey = this.getGroupDataConditionKey();
        String other$groupDataConditionKey = other.getGroupDataConditionKey();
        if (this$groupDataConditionKey == null ? other$groupDataConditionKey != null : !this$groupDataConditionKey.equals(other$groupDataConditionKey)) {
            return false;
        }
        String this$groupOrderKey = this.getGroupOrderKey();
        String other$groupOrderKey = other.getGroupOrderKey();
        if (this$groupOrderKey == null ? other$groupOrderKey != null : !this$groupOrderKey.equals(other$groupOrderKey)) {
            return false;
        }
        String this$staticOptions = this.getStaticOptions();
        String other$staticOptions = other.getStaticOptions();
        return !(this$staticOptions == null ? other$staticOptions != null : !this$staticOptions.equals(other$staticOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FieldOption;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStaticShowLabel() ? 79 : 97);
        Boolean $multi = this.getMulti();
        result = result * 59 + ($multi == null ? 43 : ((Object)$multi).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $dictTable = this.getDictTable();
        result = result * 59 + ($dictTable == null ? 43 : $dictTable.hashCode());
        String $dictCode = this.getDictCode();
        result = result * 59 + ($dictCode == null ? 43 : $dictCode.hashCode());
        String $dictText = this.getDictText();
        result = result * 59 + ($dictText == null ? 43 : $dictText.hashCode());
        String $queryScope = this.getQueryScope();
        result = result * 59 + ($queryScope == null ? 43 : $queryScope.hashCode());
        TreeModel $treeModel = this.getTreeModel();
        result = result * 59 + ($treeModel == null ? 43 : ((Object)$treeModel).hashCode());
        String $groupModeKey = this.getGroupModeKey();
        result = result * 59 + ($groupModeKey == null ? 43 : $groupModeKey.hashCode());
        String $groupDataConditionKey = this.getGroupDataConditionKey();
        result = result * 59 + ($groupDataConditionKey == null ? 43 : $groupDataConditionKey.hashCode());
        String $groupOrderKey = this.getGroupOrderKey();
        result = result * 59 + ($groupOrderKey == null ? 43 : $groupOrderKey.hashCode());
        String $staticOptions = this.getStaticOptions();
        result = result * 59 + ($staticOptions == null ? 43 : $staticOptions.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FieldOption(field=" + this.getField() + ", type=" + this.getType() + ", dictTable=" + this.getDictTable() + ", dictCode=" + this.getDictCode() + ", dictText=" + this.getDictText() + ", queryScope=" + this.getQueryScope() + ", treeModel=" + this.getTreeModel() + ", groupModeKey=" + this.getGroupModeKey() + ", groupDataConditionKey=" + this.getGroupDataConditionKey() + ", groupOrderKey=" + this.getGroupOrderKey() + ", staticOptions=" + this.getStaticOptions() + ", staticShowLabel=" + this.isStaticShowLabel() + ", multi=" + this.getMulti() + ")";
    }
}

