/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.service.a;

import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.online.desform.datafactory.dao.IDesformSuperQueryDao;
import org.jeecg.modules.online.desform.mongo.dao.DesignFormListSuperQueryDao;
import org.jeecg.modules.online.desform.mongo.model.SuperQuery;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListSuperQueryService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service(value="designFormListSuperQueryService")
public class e
implements IDesignFormListSuperQueryService {
    private static final Logger a = LoggerFactory.getLogger(e.class);
    @Autowired
    IDesformSuperQueryDao superQueryDao;
    @Autowired
    private DesignFormListSuperQueryDao designFormListSuperQueryDao;
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public String save(SuperQuery superQuery) {
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (loginUser == null) {
            a.error("\u8868\u5355\u8bbe\u8ba1\u5668\u64cd\u4f5c\u9ad8\u7ea7\u67e5\u8be2\u6570\u636e\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a!");
            return null;
        }
        String string = loginUser.getUsername();
        this.clearSelected(superQuery.getCode(), string);
        superQuery.setCreateBy(string);
        superQuery.setId(UUIDGenerator.generate());
        superQuery = (SuperQuery)this.designFormListSuperQueryDao.save(superQuery);
        return superQuery.getId();
    }

    @Override
    public void update(@NotNull SuperQuery superQuery) {
        SuperQuery superQuery2 = this.designFormListSuperQueryDao.findById(superQuery.getId()).orElse(null);
        if (superQuery2 != null) {
            superQuery2.setTitle(superQuery.getTitle());
            superQuery2.setConditions(superQuery.getConditions());
            superQuery2.setConditionsGroup(superQuery.getConditionsGroup());
            superQuery2.setConditionType(superQuery.getConditionType());
            this.designFormListSuperQueryDao.save(superQuery2);
        }
    }

    @Override
    public void remove(String id) {
        this.designFormListSuperQueryDao.deleteById(id);
    }

    @Override
    public String copy(String id, String title) {
        SuperQuery superQuery = this.designFormListSuperQueryDao.findById(id).orElse(null);
        if (superQuery != null) {
            LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            if (loginUser == null) {
                a.error("\u8868\u5355\u8bbe\u8ba1\u5668\u64cd\u4f5c\u9ad8\u7ea7\u67e5\u8be2\u6570\u636e\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a!");
                return null;
            }
            String string = loginUser.getUsername();
            superQuery.setCreateBy(string);
            superQuery.setTitle(title);
            superQuery.setId(UUIDGenerator.generate());
            superQuery.setSelected(false);
            SuperQuery superQuery2 = (SuperQuery)this.designFormListSuperQueryDao.insert(superQuery);
            return superQuery2.getId();
        }
        return null;
    }

    @Override
    public void rename(String id, String title) {
        SuperQuery superQuery = this.designFormListSuperQueryDao.findById(id).orElse(null);
        if (superQuery != null) {
            superQuery.setTitle(title);
            this.designFormListSuperQueryDao.save(superQuery);
        }
    }

    @Override
    public void updateSelected(SuperQuery superQuery) {
        String string = superQuery.getId();
        SuperQuery superQuery2 = this.designFormListSuperQueryDao.findById(string).orElse(null);
        if (superQuery2 != null) {
            boolean bl = superQuery.isSelected();
            if (bl) {
                String string2 = superQuery.getCode();
                LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                String string3 = loginUser.getUsername();
                this.clearSelected(string2, string3);
            }
            superQuery2.setSelected(bl);
            this.designFormListSuperQueryDao.save(superQuery2);
        }
    }

    @Override
    public void clearSelected(String code, String createBy) {
        Query query = new Query();
        Criteria criteria = new Criteria().and("code").is((Object)code).and("createBy").is((Object)createBy);
        query.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("selected", (Object)false);
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, SuperQuery.class);
    }

    @Override
    public List<SuperQuery> queryList(String code) {
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String string = loginUser.getUsername();
        return this.superQueryDao.selectList(code, string);
    }
}

