/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.vo.transl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.util.f;
import org.jeecg.modules.online.desform.vo.transl.TranslateItem;
import org.jeecg.modules.online.desform.vo.widget.DesformOptions;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;
import org.jeecg.modules.online.desform.vo.widget.options.DesformConfItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateItemCollection {
    private static final Logger log = LoggerFactory.getLogger(TranslateItemCollection.class);
    private JSONObject formConfig = null;
    private List<String> dictCodeList = new ArrayList<String>();
    private List<TranslateItem> dictCodeDataList = new ArrayList<TranslateItem>();
    Map<String, JSONArray> staticDictDataMap = new HashMap<String, JSONArray>();
    List<TranslateItem> userDepartList = new ArrayList<TranslateItem>();
    TranslateItem orgRoleData = null;
    List<TranslateItem> tableDictList1 = new ArrayList<TranslateItem>();
    List<TranslateItem> tableDictList2 = new ArrayList<TranslateItem>();
    TranslateItem selectTreeData1 = null;
    List<TranslateItem> selectTreeList2 = new ArrayList<TranslateItem>();
    List<TranslateItem> switchList = new ArrayList<TranslateItem>();
    List<TranslateItem> areaLinkageList = new ArrayList<TranslateItem>();
    List<TranslateItem> dateList = new ArrayList<TranslateItem>();
    List<TranslateItem> timeList = new ArrayList<TranslateItem>();
    Set<String> locationModelSet = new HashSet<String>();
    List<TranslateItem> linkRecordList = new ArrayList<TranslateItem>();
    List<TranslateItem> numberList = new ArrayList<TranslateItem>();

    public void packageTranslAllData(DesformWidget widget, String data) {
        switch (widget.getType()) {
            case SELECT: 
            case CHECKBOX: 
            case RADIO: {
                this.addDictCode(widget, data);
                break;
            }
            case SELECT_DEPART: 
            case SELECT_USER: {
                this.addUserDepartData(widget, data);
                break;
            }
            case ORG_ROLE: {
                this.addOrgRoleData(widget, data);
                break;
            }
            case TABLE_DICT: {
                this.addTableDictData(widget, data);
                break;
            }
            case SELECT_TREE: {
                this.addSelectTreeData(widget, data);
                break;
            }
            case SWITCH: {
                this.addSwitchData(widget, data);
                break;
            }
            case AREA_LINKAGE: {
                this.addAreaLinkageData(widget, data);
                break;
            }
            case DATE: {
                this.addDateData(widget, data);
                break;
            }
            case TIME: {
                this.addTimeData(widget, data);
                break;
            }
            case LOCATION: {
                this.addLocationData(widget, data);
                break;
            }
            case LINK_RECORD: {
                this.addLinkRecordData(widget, data);
                break;
            }
            case NUMBER: 
            case INTEGER: 
            case MONEY: {
                this.addNumberData(widget, data);
                break;
            }
            default: {
                if (widget.getOptions() == null) break;
                if (WidgetTypes.SELECT_DEPART.getType().equals(widget.getOptions().getFieldType())) {
                    log.info("\u7ffb\u8bd1\u4ed6\u8868\u90e8\u95e8\u63a7\u4ef6, widget\u2014\u2014name\uff1a{} \uff0ckey:{}, model:{}, options fieldType:{}", new Object[]{widget.getName(), widget.getKey(), widget.getModel(), widget.getOptions().getFieldType()});
                    widget.setType(WidgetTypes.SELECT_DEPART.getType());
                    widget.getOptions().setCustomReturnField("id");
                    this.addUserDepartData(widget, data);
                    break;
                }
                if (!WidgetTypes.SELECT_USER.getType().equals(widget.getOptions().getFieldType())) break;
                log.info("\u7ffb\u8bd1\u4ed6\u8868\u7528\u6237\u63a7\u4ef6, widget\u2014\u2014name\uff1a{} \uff0ckey:{}, model:{}, options fieldType:{}", new Object[]{widget.getName(), widget.getKey(), widget.getModel(), widget.getOptions().getFieldType()});
                widget.setType(WidgetTypes.SELECT_USER.getType());
                widget.getOptions().setCustomReturnField("id");
                this.addUserDepartData(widget, data);
            }
        }
    }

    public void addDictCode(DesformWidget widget, String data) {
        String string = widget.getOptions().getRemote();
        String string2 = widget.getOptions().getDictCode();
        if ("dict".equals(string) && oConvertUtils.isNotEmpty((Object)string2)) {
            if (this.dictCodeList.stream().noneMatch(string2::equals)) {
                this.dictCodeList.add(string2);
            }
            TranslateItem translateItem = f.a(widget, data);
            translateItem.setDictCode(string2);
            this.dictCodeDataList.add(translateItem);
        } else {
            boolean bl = Boolean.TRUE.equals(widget.getOptions().getShowLabel());
            boolean bl2 = Boolean.TRUE.equals(widget.getOptions().getUseColor());
            if (bl || bl2) {
                String string3 = widget.getModel();
                JSONArray jSONArray = widget.getOptions().getOptions();
                if (jSONArray != null && jSONArray.size() > 0) {
                    this.staticDictDataMap.computeIfAbsent(string3, k2 -> new JSONArray());
                    JSONArray jSONArray2 = this.staticDictDataMap.get(string3);
                    if (!bl2) {
                        jSONArray.forEach(option -> ((JSONObject)option).remove((Object)"itemColor"));
                    }
                    jSONArray2.addAll((Collection)jSONArray);
                }
            }
        }
    }

    public void addUserDepartData(DesformWidget widget, String data) {
        DesformOptions desformOptions = widget.getOptions();
        List<String> list = Arrays.asList("id", "username", "orgCode");
        if (list.contains(desformOptions.getCustomReturnField())) {
            TranslateItem translateItem = f.a(widget, data);
            translateItem.setCustomReturnField(desformOptions.getCustomReturnField());
            this.userDepartList.add(translateItem);
        }
    }

    public void addOrgRoleData(DesformWidget widget, String data) {
        if (this.orgRoleData == null) {
            this.orgRoleData = f.a(widget);
            this.orgRoleData.setDataMap(new HashMap<String, HashSet<String>>());
        }
        HashSet hashSet = this.orgRoleData.getDataMap().computeIfAbsent(widget.getModel(), k2 -> new HashSet());
        hashSet.addAll(Arrays.asList(data.split(",")));
    }

    public void addTableDictData(DesformWidget widget, String data) {
        DesformOptions desformOptions = widget.getOptions();
        if ("select".equals(desformOptions.getStyle())) {
            String string = desformOptions.getDictTable() + "," + desformOptions.getDictText() + "," + desformOptions.getDictCode();
            switch (desformOptions.getQueryScope()) {
                case "database": {
                    this.addTranslateData(widget, data, this.tableDictList2).setDictCode(string);
                    break;
                }
                default: {
                    this.addTranslateData(widget, data, this.tableDictList1, t -> t.getDictCode().equals(string)).setDictCode(string);
                }
            }
        }
    }

    private TranslateItem addTranslateData(DesformWidget widget, String data, List<TranslateItem> list) {
        return this.addTranslateData(widget, data, list, t -> t.getModel().equals(widget.getModel()));
    }

    private TranslateItem addTranslateData(DesformWidget widget, String data, List<TranslateItem> list, Predicate<TranslateItem> predicate) {
        Optional<TranslateItem> optional = list.stream().filter(predicate).findFirst();
        if (optional.isPresent()) {
            TranslateItem translateItem = optional.get();
            translateItem.setDataList(f.b(translateItem.getDataList(), data));
            return translateItem;
        }
        TranslateItem translateItem = f.a(widget, data);
        list.add(translateItem);
        return translateItem;
    }

    public void addSelectTreeData(DesformWidget widget, String data) {
        String[] stringArray;
        Object object;
        try {
            object = JSONArray.parseArray((String)data, String.class);
            stringArray = object.toArray(new String[object.size()]);
        }
        catch (Exception exception) {
            stringArray = data.split(",");
        }
        object = widget.getOptions();
        switch (((DesformOptions)object).getDataFrom()) {
            case "table": {
                DesformConfItem desformConfItem = ((DesformOptions)object).getConf().getTable();
                String string = desformConfItem.getName() + "," + desformConfItem.getText() + "," + desformConfItem.getCode();
                for (String string2 : stringArray) {
                    this.addTranslateData(widget, string2, this.selectTreeList2).setDictCode(string);
                }
                break;
            }
            default: {
                if (this.selectTreeData1 == null) {
                    this.selectTreeData1 = f.a(widget, data);
                    this.selectTreeData1.setKey("sys_category");
                }
                this.selectTreeData1.getDataList().addAll(Arrays.asList(stringArray));
            }
        }
    }

    public void addSwitchData(DesformWidget widget, String data) {
        this.addTranslateData(widget, data, this.switchList);
    }

    public void addAreaLinkageData(DesformWidget widget, String data) {
        this.addTranslateData(widget, data, this.areaLinkageList);
    }

    public void addDateData(DesformWidget widget, String data) {
        if (!widget.getOptions().getTimestamp().booleanValue()) {
            return;
        }
        this.addTranslateData(widget, data, this.dateList);
    }

    public void addTimeData(DesformWidget widget, String data) {
        if (!widget.getOptions().isRange()) {
            return;
        }
        this.addTranslateData(widget, data, this.timeList);
    }

    public void addLocationData(DesformWidget widget, String data) {
        this.locationModelSet.add(widget.getModel());
    }

    public void addLinkRecordData(DesformWidget widget, String data) {
        if (this.formConfig != null) {
            String string = widget.getModel();
            String string2 = this.formConfig.getString("titleField");
            if (oConvertUtils.isNotEmpty((Object)string2) && string2.equals(string)) {
                this.addTranslateData(widget, data, this.linkRecordList);
            }
        }
    }

    public void addNumberData(DesformWidget widget, String data) {
        DesformOptions desformOptions = widget.getOptions();
        if (desformOptions.getControls().booleanValue()) {
            return;
        }
        if (!desformOptions.getShowPercent().booleanValue() && oConvertUtils.isEmpty((Object)desformOptions.getUnitText())) {
            return;
        }
        this.addTranslateData(widget, data, this.numberList);
    }

    public void setFormConfig(JSONObject formConfig) {
        this.formConfig = formConfig;
    }

    public List<String> getDictCodeList() {
        return this.dictCodeList;
    }

    public List<TranslateItem> getDictCodeDataList() {
        return this.dictCodeDataList;
    }

    public Map<String, JSONArray> getStaticDictDataMap() {
        return this.staticDictDataMap;
    }

    public List<TranslateItem> getUserDepartList() {
        return this.userDepartList;
    }

    public TranslateItem getOrgRoleData() {
        return this.orgRoleData;
    }

    public List<TranslateItem> getTableDictList1() {
        return this.tableDictList1;
    }

    public List<TranslateItem> getTableDictList2() {
        return this.tableDictList2;
    }

    public TranslateItem getSelectTreeData1() {
        return this.selectTreeData1;
    }

    public List<TranslateItem> getSelectTreeList2() {
        return this.selectTreeList2;
    }

    public List<TranslateItem> getSwitchList() {
        return this.switchList;
    }

    public List<TranslateItem> getAreaLinkageList() {
        return this.areaLinkageList;
    }

    public List<TranslateItem> getDateList() {
        return this.dateList;
    }

    public List<TranslateItem> getTimeList() {
        return this.timeList;
    }

    public Set<String> getLocationModelSet() {
        return this.locationModelSet;
    }

    public List<TranslateItem> getLinkRecordList() {
        return this.linkRecordList;
    }

    public List<TranslateItem> getNumberList() {
        return this.numberList;
    }
}

