<script>

  var linkFormEventMap = new Map()

  // 上一次向父级提交的高度
  var lastPostHeight = null

  // 每隔 100ms 向父级提交一次高度
  function postHeightChange() {
    var height = document.body.scrollHeight

    // console.log('postHeightChange: height: ', height );
    // console.log('postHeightChange: lastPostHeight: ', lastPostHeight);

    if (height !== lastPostHeight) {
      lastPostHeight = height
      postEvent('height-change', height, messageId)
    }
  }
  postEvent('dialog-change-reset', 0, messageId, {uni: false})

  // 设置文件预览地址<#--如果没有设置，则返回空字符串 -->
  actions.setFilePreviewDomain('${onlinePreviewDomain!""}')

  // 获取默认的经纬度
  var longitude = getQueryParams('longitude');
  var latitude = getQueryParams('latitude');
  if (longitude && latitude) {
    window['DEF_POS_CFG'] = {
      // 经度
      lng: longitude,
      // 纬度
      lat: latitude,
    };
  }

  /**
   * 定义 VUE_OBJECT 的目的是为了要在 new Vue() 之前处理异步请求的问题
   *
   * jsonData 表单设计JSON
   * editData 表单数据JSON
   */
  var VUE_OBJECT = {
    el: '#app',
    store: store,
    mixins: [DeviceMixins, ExternalMixins],
    data: {
      // 操作动作模式（preview、edit、detail）
      action: "${action}",
      loading: false,
      jsonData: {},
      editData: {},
      desformId: null,
      desformCode: null,
      desformName: null,
      dialogVisible: false,
      showSaveData: false,
      dataId: null,
      // online数据id
      onlineDataId: null,
      remoteFuncs: {
        funcGetToken: function (resolve) {
          request({
            token: token,
            url: '${base}/desform/getQiniuUploadToken',
            method: 'GET',
            success: function (res) {
              if (res.success) {
                resolve(res.message)
              } else {
                console.error('图片token获取失败：', res)
              }
            }, fail: function (res) {
              console.error('图片token获取失败：' + res)
            }
          })
        },
      },
      // 是否是只读模式
      readOnly: false,
      // 当前登录的用户信息
      userInfo: null,
      // 是否显示底部
      showFooter: showFooter,
      // vue3事件模式
      eventDialog: eventDialog,
      // 是否在内部展示对话框
      innerDialog: innerDialog,
      // 是否是关联表单
      isLinkDialog: getQueryParams("isLinkDialog") === "true",
      //【QQYUN-6619】是否是保存表单的同时，提交流程
      isSaveAndSubmitProcess: false,
      // 自定义URL是否请求失败
      customURLFail: false,
      // 下一步路由配置
      nextRouteConfig: (${nextRouteConfig!"null"}),
      // 后台翻译数据
      translData: (${translData!"null"}),
      // 按钮表单配置信息
      buttonFormConfig: (${buttonFormConfig!"null"}),
      // 功能开关配置项
      allowFunc: ${allowFunc!"null"},
      // 应用角色字段权限配置
      fieldAuthByAppRole: ${fieldAuthByAppRole!"null"},
      url: {
        base: '${base}',
        add: function (formKey) {
          if (isExternal) {
            return '${base}/desform/' + formUrlStr + '/' + formKey
          } else {
            return '${base}/desform/data/add'
          }
        },
        edit: function (formKey, dataId) {
          if (isExternal) {
            return '${base}/desform/' + formUrlStr + '/' + formKey + '/' + dataId
          } else {
            return '${base}/desform/data/edit'
          }
        },
        online: '${base}/online/cgform/api/crazyForm'
      }
    },
    created: function () {
      if (!transparent && document.body.style.backgroundColor === 'transparent') {
        document.body.style.backgroundColor = '#FFFFFF'
      }
      window.addEventListener('message', this.handleParentMessage, false);
    },
    mounted: function () {
      this.dialogVisible = true
      postHeightChange()
      setInterval(postHeightChange, 100)
    },
    methods: {
      // 处理父级发送来的消息
      handleParentMessage(event) {
        // 兼容UniApp
        let evtData = event?.detail?.data ?? event?.data?.detail?.data ?? event?.data;
        if (Array.isArray(evtData)) {
          evtData = evtData[0];
        }
        evtData = evtData ?? {};
        let { type, data } = evtData;
          //update-begin---author:scott ---date:2023-09-24  for：【QQYUN-6619】简流流程处理 有必填校验时，只有点表单提交按钮才会校验 点击确认提交流程走下一步时，不会校验--
          if(type && type =='action:save:submitprocess'){
              let { messageSessionId } = evtData;
              let submitProcessEvent = {eventKey: type, nextNode:data, messageSessionId}
              this.handleSubmit(event, submitProcessEvent)
          }
          //update-end---author:scott ---date::2023-09-24  for：【QQYUN-6619】简流流程处理 有必填校验时，只有点表单提交按钮才会校验 点击确认提交流程走下一步时，不会校验--
          
        if (messageId !== evtData.messageId) {
          return;
        }
        switch (type) {
          case 'link-form:success':
            let onChange = linkFormEventMap.get(data.eventKey)
              //执行表单设计器对象中的js方法，Js的apply()使用
            if (onChange) {
              onChange(data.dataId, data.newData || {})
            }
            break;
          // 应用矩形位置信息
          case 'body:useRect':
            this.bodyUseRect(data)
            break;
          // 取消应用矩形位置信息
          case 'body:cancelRect':
            this.bodyCancelRect(data)
            break;
          case 'action:submit':
            this.handleSubmit(data)
            break;
          // 调用打印方法
          case 'action:print':
            let vm = this.$refs.generateForm || this.$refs.generateDialog
            vm.doPrint()
            break;
        }
      },

      onFormLoadingChange(loading) {
        postEvent('form-loading-change', loading, messageId)
      },

      async bodyUseRect(data) {
        const { iframeRect, parentRect, parentScroll, relativeRect, agreedTime } = data;

        let begin  = Date.now()
        // console.warn('[d-c]:render 收到 bodyUseRect:', {
        //   data,
        //   _: Date.now(),
        //   距离约定时间剩余ms: agreedTime - Date.now(),
        // })

        if ((agreedTime - Date.now()) > 10) {
          await new Promise(resolve => setTimeout(resolve, agreedTime - Date.now()));
        }

        // update-begin---author:sunjianlei ---date:20230215 for：修正定位位置
        // 修正top位置
        let topLimit = relativeRect.top - parentScroll.top;
        // 修正滚动条top位置
        if (parentScroll.top <= relativeRect.top) {
          parentRect.height = parentRect.height - relativeRect.top + parentScroll.top;
          parentScroll.top = 0;
        } else {
          parentScroll.top = parentScroll.top - relativeRect.top;
        }
        // 修正滚动条left位置
        if (parentScroll.left <= relativeRect.left) {
          parentScroll.left = 0;
        } else {
          parentScroll.left = parentScroll.left - relativeRect.left;
        }
        // update-end---author:sunjianlei ---date:20230215 for：修正定位位置

        this.bodyStyle = {
          ...this.bodyStyle,
          position: 'fixed',
          top: parentRect.top + (topLimit < 0 ? 0 : topLimit) + 'px',
          left: parentRect.left + relativeRect.left + 'px',
          width: iframeRect.width + 'px',
          height: parentRect.height + 'px',
          overflow: 'hidden',
        };
        await this.$nextTick();
        this.$refs.bodyBox.scrollTop = parentScroll.top;
        this.$refs.bodyBox.scrollLeft = parentScroll.left;
        let diff = parentScroll.top - this.$refs.bodyBox.scrollTop;
        if (diff > 0) {
          this.bodyStyle.height = (parentRect.height - diff) + 'px';
          await this.$nextTick();
          this.$refs.bodyBox.scrollTop = parentScroll.top;
          this.$refs.bodyBox.scrollLeft = parentScroll.left;
        }
        // console.warn('[d-c]:render 结束 bodyUseRect:', { _: Date.now(), diff: Date.now() - begin})
      },
      bodyCancelRect(data) {
        // agreedTime（约定时间），为了同步 iframe 内和外的动画时间，双方在同一约定时间时执行动作，避免因为动画时间不同步导致的闪烁
        const { agreedTime } = data;

        let begin = Date.now()
        // console.warn('[d-c]:render 收到 bodyCancelRect:', { _: Date.now(),距离约定时间剩余ms: agreedTime - Date.now()})
        setTimeout(() => {
          this.$delete(this.bodyStyle, 'position');
          this.$delete(this.bodyStyle, 'top');
          this.$delete(this.bodyStyle, 'left');
          this.$delete(this.bodyStyle, 'width');
          this.$delete(this.bodyStyle, 'height');
          this.$delete(this.bodyStyle, 'overflow');
          this.$nextTick(() => {
            this.$refs.bodyBox.scrollTop = 0;
            this.$refs.bodyBox.scrollLeft = 0;
            // console.warn('[d-c]:render 结束 bodyCancelRect:', { _: Date.now(), diff: Date.now() - begin })
          });
        }, agreedTime - Date.now());
      },

      handleClose: function () {
        postEvent('close', {}, messageId)
      },
      handleSubmit: function (event, submitProcessEvent) {
          //update-begin---author:scott ---date::2023-09-24  for：【QQYUN-6619】简流流程处理 有必填校验时，只有点表单提交按钮才会校验 点击确认提交流程走下一步时，不会校验--
          if(submitProcessEvent && submitProcessEvent.eventKey =='action:save:submitprocess'){
              this.isSaveAndSubmitProcess = true
          }else{
              this.isSaveAndSubmitProcess = false
          }
          //update-end---author:scott ---date::2023-09-24  for：【QQYUN-6619】简流流程处理 有必填校验时，只有点表单提交按钮才会校验 点击确认提交流程走下一步时，不会校验--
          
        if (this.action === 'detail') {
          this.dialogVisible = false
          this.handleClose()
          return
        }
        var _this = this
        var getData = null
        if (this.innerDialog) {
          getData = event.getData
        } else {
          getData = this.$refs.generateForm.getData
        }
        getData({
          getLinkRecordTempData: true,
        }).then(function (data) {
          // 数据校验成功，data 为获取的表单数据

          // 新数据和旧数据合并
          var assign = {}
          for (var dataKey in _this.editData) {
            if (_this.editData.hasOwnProperty(dataKey)) {
              assign[dataKey] = _this.editData[dataKey]
            }
          }
          for (var key in data) {
            if (data.hasOwnProperty(key)) {
              assign[key] = data[key]
            }
          }
          var params = {
            json: assign,
            formConfig: _this.jsonData.config,
            onlineForm: _this.jsonData.config.onlineForm,
            onlineDataId: _this.onlineDataId,
          }


          // 判断是否在内部保存数据
          if (innerRequest) {
            _this.saveAllData(params)
              //update-begin---author:scott ---date::2023-09-24  for：【QQYUN-6619】简流流程处理 有必填校验时，只有点表单提交按钮才会校验 点击确认提交流程走下一步时，不会校验--
              if(_this.isSaveAndSubmitProcess){
                  postEvent('action:save:submitprocess:callback', submitProcessEvent.nextNode, submitProcessEvent.messageSessionId)
              }
              //update-end---author:scott ---date::2023-09-24  for：【QQYUN-6619】简流流程处理 有必填校验时，只有点表单提交按钮才会校验 点击确认提交流程走下一步时，不会校验--
          } else {
            postEvent('save', params, messageId)
          }
        }).catch(function (e) {
          // 数据校验失败
          console.error('数据校验失败: ', e)
            //update-begin---author:scott ---date::2023-09-24  for：【QQYUN-6619】简流流程处理 有必填校验时，只有点表单提交按钮才会校验 点击确认提交流程走下一步时，不会校验--
            if(_this.isSaveAndSubmitProcess){
                postEvent('action:save:submitprocess:error', e, submitProcessEvent.messageSessionId) 
            }
            //update-end---author:scott ---date::2023-09-24  for：【QQYUN-6619】简流流程处理 有必填校验时，只有点表单提交按钮才会校验 点击确认提交流程走下一步时，不会校验--
        })
      },
      saveAllData: function (params) {
        var _this = this

        var formKey = formIsId ? _this.desformId : _this.desformCode
        var url = _this.url.add(formKey), method = 'POST'
        var formData = {
          desformId: _this.desformId,
          desformCode: _this.desformCode,
          desformDataJson: JSON.stringify(params.json),
        }
         //个性化定义是否触发简流
        if(typeof triggerProcess!=="undefined" && triggerProcess!=null && triggerProcess!=""){
           formData.triggerProcess = false;
        }
        if (params.onlineForm) {
          formData['onlineFormCode'] = params.onlineForm
          formData['onlineFormDataId'] = params.onlineDataId
        }

        if (_this.action !== 'add' && _this.dataId != null) {
          url = _this.url.edit(formKey, _this.dataId)
          method = 'PUT'
          formData['id'] = _this.dataId
        }

        _this.loading = true
        try {
          _this.saveStep1(url, method, formData)
        } catch (e) {
          console.error(e)
          _this.showMessage('error', '保存失败，请稍后重试')
          _this.loading = false
        }
      },

      // step.1 如果存在 onlineForm 就首先提交给online表单，获取到 id 后再提交到数据表，再提交到自定义URL
      saveStep1: function (url, method, formData) {
        var _this = this
        request({
          token: token,
          url: url,
          method: method,
          data: formData,
          success: function (res) {
            if (res.success) {
              _this.dataId = res.result.dataId
              _this.customURLFail = res.result.customURLFail
              _this.requestSuccess(_this.dataId, formData)
            } else {
              _this.loading = false
              console.error('保存失败', res)
              _this.showMessage('error', res.message || '保存失败，请稍后重试')
            }
          },
          fail: function (res) {
            _this.loading = false
            console.error('保存失败', res)
            _this.showMessage('error', '保存失败，请稍后重试')
          }
        })
      },
      requestSuccess: function (dataId, formData) {
        this.loading = false
        if (this.customURLFail) {
          this.customURLFail = false
          this.showMessage('warning', '保存成功，但自定义URL请求失败')
        } else if (!this.nextRouteConfig) {
          // 没有下一步路由配置的时候才显示保存成功
          // 不是关联表单才显示保存成功
          if (!this.isLinkDialog && !this.isSaveAndSubmitProcess) {
            this.showMessage('success', '保存成功！')
          }
        }
        // 数据保存成功，如果当前是在外部链接模式，就将已保存的数据放到 LocalStorage 里
        if (isExternal) {
          this.setExternalSaved(dataId);
          // 外部链接无论如何都跳转到成功页面，而不走路由
          var href = '${base}/desform/' + formUrlStr + '/success?dataId=' + dataId;
          if (formIsId) {
            href += '&desformId=' + this.desformId;
          } else {
            href += '&desformCode=' + this.desformCode;
          }
          window.location.href = href;
        } else {
          // 如果是关联表单，则不走下一步路由
          if (this.isLinkDialog) {
            this.editData = JSON.parse(formData.desformDataJson)
            postEvent('success', {
              dataId: dataId,
              newData: JSON.parse(formData.desformDataJson),
            }, messageId)
            return
          }
          // 内部链接需要根据路由配置来决定如何跳转，
          // 如果有路由配置就触发route-jump事件，
          // 没有就触发success事件，
          // 因为route-jump事件已经包含了success事件，无需重复触发。
          this.handleNextRoute(dataId)
        }
      },
      handleNextRoute: function (dataId) {
        var nextRouteConfig = this.nextRouteConfig
        if (nextRouteConfig) {
          // 1. 有路由配置，走路由跳转
          postEvent('route-jump', { nextRouteConfig: nextRouteConfig, dataId: dataId }, messageId)
        } else if (skip && !this.isSaveAndSubmitProcess) {
          // 2. 没有路由配置，skip = true，跳转到成功页面
          window.location.href = '${base}/desform/success.html?messageId=' + messageId
        } else {
          //update-begin--Author:scott  Date:20220114 for：【JTC-981】工单申请中的设计器表单全屏效果不好，弹出选择人效果也不好（success模式下也传递dataId）---
          // 3. 没有路由配置，skip = false，触发success事件
          postEvent('success', { dataId: dataId }, messageId)
          //update-end--Author:scott  Date:20220114 for：【JTC-981】工单申请中的设计器表单全屏效果不好，弹出选择人效果也不好（success模式下也传递dataId）--
        }
      },

      // 打开关联记录
      onOpenLinkForm: function (payload) {
        payload.eventKey = randomString(16)
        // 暂存回调方法
        linkFormEventMap.set(payload.eventKey, payload.onChange)
        // 【关联记录】这里带方法会导致报错，无法打开弹窗
        delete payload.onChange
        postEvent('open-link-form', payload, messageId)
      },

      <#-- 锁定记录状态变化 -->
      onLockedChange(flag) {
        <#-- 是否锁定当前记录，如果锁定了，则强制转为 detail 模式 -->
        if (flag) {
          this.action = 'detail';
          this.readOnly = true;
        }
      },

      showMessage: function (type, message) {
        if (triggerTips) {
          postEvent('show-message', { type: type, message: message }, messageId)
        } else {
          this.$message[type](message)
        }
      },
      handleDialogChange: function (val) {
        // console.warn('[d-c]:render 收到 dialogChange:', { val, _: Date.now() })
        postEvent('dialog-change', {
          value: val,
          time: Date.now(),
        }, messageId)
      },
    }
  }

  /* 实例化VUE之前的前置操作 */

  var requestCount = 0

  // 查询出用户信息
  if (isExternal) {
    VUE_OBJECT.data.userInfo = {}
  } else {
    requestCount++
    request({
      token: token,
      url: '${base}/sys/user/getUserSectionInfoByToken',
      method: 'GET',
      success: function (res) {
        if (res.success) {
          VUE_OBJECT.data.userInfo = res.result
        } else {
          console.error('查询用户信息失败：', res)
        }
        requestCount--
      }, fail: function (res) {
        requestCount--
        console.error('查询用户信息失败：', res)
      }
    })
  }

  /* 将需要用到的数据通过 Freemarker表达式 取出来 */
  var dataSource = {}
  // 设计器构造JSON
  dataSource.jsonData = (${ designForm.desformDesignJson }) || {}
  // 设计器code
  dataSource.desformId = '${ designForm.id }'
  dataSource.desformCode = '${ designForm.desformCode }'
  dataSource.desformName = '${ designForm.desformName }'

  window.desformId = '${ designForm.id }'
  window.desformCode = dataSource.desformCode
  window.desformName = dataSource.desformName

  // 判断是否为只读模式
  // ---- <#if isReadOnly ? exists>
  dataSource.readOnly = true
  // ---- </#if>

  // 判断是否有数据，若有数据则是修改，反之则是新增
  // ---- <#if designFormData ? exists>
  dataSource.dataId = '${ designFormData.id }'
  dataSource.onlineDataId = '${designFormData.onlineFormDataId!}'

  window.desformDataId = dataSource.dataId
  window.onlineDataId = dataSource.onlineDataId

  dataSource.editData = ${ designFormData.desformDataJson }

    /* 判断是否绑定了Online表单，如果绑定了就从online里取数据 */

    <#--// 处理子表数据-->
    <#--function handleSubTableData(key, cgformSubData) {-->
    <#--  var desformSubData = JSON.parse(decodeURIComponent(dataSource.editData[key]))-->
    <#--  //update-begin--Author:zhangdaihao  Date:20191003 for：实现表单的渲染，直接通过online dataid进行渲染，design_form_data无数据--------------------->
    <#--  //如果表单设计data数据与物理表数据不一致，则以物理表数据为准-->
    <#--  if (desformSubData.length < cgformSubData.length) {-->
    <#--    desformSubData = cgformSubData-->
    <#--  }-->
    <#--  //update-end--Author:zhangdaihao  Date:20191003 for：实现表单的渲染，直接通过online dataid进行渲染，design_form_data无数据--------------------->
    <#--  for (var i = 0; i < desformSubData.length; i++) {-->
    <#--    objectAssign(desformSubData[i], cgformSubData[i])-->
    <#--    desformSubData[i].id = undefined-->
    <#--  }-->
    <#--  dataSource.editData[key] = encodeURIComponent(JSON.stringify(desformSubData))-->
    <#--}-->

  // 查询主表
  var codeFromJson = (dataSource.jsonData.config || {}).onlineForm
  var codeFromTable = '${ designForm.cgformCode! }'
  //个性化定义是否触发简流
  var triggerProcess = '${ triggerProcess!'' }'
  
  var tableName = (codeFromJson || codeFromTable)
  <#--if (tableName) {-->
  <#--  // 从online表里查询数据，并和现有的合并-->
  <#--  requestCount++-->
  <#--  request({-->
  <#--    token: token,-->
  <#--    url: '${base}/online/cgform/api/form/table_name/' + tableName + '/' + dataSource.onlineDataId,-->
  <#--    method: 'GET',-->
  <#--    success: function (res) {-->
  <#--      if (res.success) {-->
  <#--        objectAssign(dataSource.editData, res.result)-->
  <#--        dataSource.editData.id = undefined-->

  <#--        // 判断是否存有子表-->
  <#--        for (var key in dataSource.editData) {-->
  <#--          if (dataSource.editData.hasOwnProperty(key)) {-->
  <#--            // var subTable = dataSource.editData[key];-->
  <#--            var split = key.split('sub-table-design_')-->
  <#--            if (split.length === 2 && split[0] === '') {-->
  <#--              var subTableName = split[1]-->
  <#--              // 查询子表（查询主表时已经返回了子表的数据，可以直接取出来处理）-->
  <#--              handleSubTableData(key, dataSource.editData[subTableName])-->
  <#--            }-->
  <#--          }-->
  <#--        }-->
  <#--      } else {-->
  <#--        console.error(res)-->
  <#--      }-->
  <#--      requestCount---->
  <#--    }, fail: function (res) {-->
  <#--      requestCount---->
  <#--      console.error(res)-->
  <#--    }-->
  <#--  })-->
  <#--}-->
  // ---- <#else>
  <#-- else为新增数据，填充默认值 -->
  dataSource.editData = objectAssign(dataSource.editData||{}, defaultFormData||{})
  // ---- </#if>
  // 上一个路由带过来的数据
  window.routeData = (${routeData!'null'})
  dataSource.editData = objectAssign(dataSource.editData||{}, window.routeData||{})

  // 根据用户设定的边距生成style
  var dialogOptions = dataSource.jsonData.config.dialogOptions
  if (dialogOptions) {
    var pd = dialogOptions.padding
    VUE_OBJECT.data['bodyStyle'] = {
      padding: pd.top + 'px ' + pd.right + 'px ' + pd.bottom + 'px ' + pd.left + 'px'
    }
  } else {
    VUE_OBJECT.data['bodyStyle'] = { padding: '25px 25px 30px 25px' }
  }

  /* 表单字段权限 */
  <#if authUserInfoJson ??>
  window['__authUserInfo'] = ${authUserInfoJson}
  </#if>

  <#if authInfoJson ??>
  var authInfo = (${authInfoJson} || [])
  var authsMap = {}
  for (var i = 0; i < authInfo.length; i++) {
    var auth = authInfo[i], temp = authsMap[auth.authComKey]
    if (temp instanceof Array) {
      temp.push(auth)
    } else {
      authsMap[auth.authComKey] = [auth]
    }
  }
  window['__authsMap'] = authsMap
  </#if>

  // console.log('dataSource: ', JSON.parse(JSON.stringify(dataSource)))

  // 检测所有的请求是否都已结束
  var timer = setInterval(function () {
    if (requestCount <= 0) {
      clearInterval(timer)
      //  合并数据
      objectAssign(VUE_OBJECT.data, dataSource)
      // ** 等待所有的前置请求都完成之后才进行实例化VUE操作
      window.$vm = new Vue(VUE_OBJECT)
    }
  }, 10)
</script>